/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;

class DeleteEntityClass
implements ActionListener {
    private LandscapeEditorCore m_ls;
    private EntityClass m_ec;

    public DeleteEntityClass(LandscapeEditorCore ls, EntityClass ec) {
        this.m_ls = ls;
        this.m_ec = ec;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        LandscapeEditorCore ls = this.m_ls;
        EntityClass ec = this.m_ec;
        Diagram diagram = ls.getDiagram();
        String message = null;
        if ((ev.getModifiers() & 4) != 0 && ls.processMetaKeyEvent("Delete Entity Class")) {
            return;
        }
        Enumeration en = diagram.enumEntityClasses();
        while (en.hasMoreElements()) {
            EntityClass ec1 = (EntityClass)en.nextElement();
            if (ec == ec1 || !ec1.directlyInheritsFrom(ec)) continue;
            message = message != null ? String.valueOf(message) + ", " : "";
            message = String.valueOf(message) + ec1.getLabel();
        }
        if (message != null) {
            message = String.valueOf(message) + " inherit from " + ec.getLabel();
        } else {
            EntityInstance rootInstance = diagram.getRootInstance();
            if (rootInstance != null && rootInstance.getEntityClass() == ec) {
                message = "Root instance has class " + ec.getLabel();
            } else {
                diagram.recomputeCounts();
                int cnt = ec.countMembers();
                if (cnt != 0) {
                    message = String.valueOf(ec.getLabel()) + " has " + cnt + " instantiations";
                }
            }
        }
        if (message != null) {
            JOptionPane.showConfirmDialog(null, message, "Can't delete entity class", -1);
            return;
        }
        switch (JOptionPane.showConfirmDialog(null, "Delete class " + ec.getLabel(), "Delete all " + ec.getLabel() + " entities", 1)) {
            case 0: {
                diagram.doUpdateRemoveEntityClass(ec);
                break;
            }
        }
        ls.repaint();
    }
}

