/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;

public class ColorCache {
    private static final int m_initialCapacity = 200;
    private static final float m_loadFactor = 0.75f;
    private static Entry[] m_table = null;
    private static int m_count = 0;
    private static int m_threshold = 150;

    public static int size() {
        return m_count;
    }

    public static boolean isEmpty() {
        return m_count == 0;
    }

    public static void clear() {
        Entry[] tab = m_table;
        if (tab != null) {
            int index = tab.length;
            while (--index >= 0) {
                tab[index] = null;
            }
        }
        m_count = 0;
    }

    protected static void rehash() {
        Entry[] oldMap = m_table;
        int oldCapacity = oldMap.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        m_threshold = (int)((float)newCapacity * 0.75f);
        m_table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.m_next;
                int index = (e.m_value.getRGB() & Integer.MAX_VALUE) % newCapacity;
                e.m_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    protected static void put(Color color, int index) {
        Entry[] table = m_table;
        if (m_count >= m_threshold) {
            ColorCache.rehash();
            table = m_table;
            index = (color.getRGB() & Integer.MAX_VALUE) % table.length;
        }
        table[index] = new Entry(color, table[index]);
        ++m_count;
    }

    public static Color get(int rgba) {
        Color color;
        int index;
        Entry[] tab = m_table;
        if (tab == null) {
            m_table = new Entry[200];
            index = (rgba & Integer.MAX_VALUE) % m_table.length;
        } else {
            index = (rgba & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                color = e.m_value;
                if (color.getRGB() == rgba) {
                    return color;
                }
                e = e.m_next;
            }
        }
        color = new Color(rgba, true);
        ColorCache.put(color, index);
        return color;
    }

    public static Color get(int r, int g, int b, int a) {
        int rgba = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        return ColorCache.get(rgba);
    }

    public static Color get(int r, int g, int b) {
        int rgb = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        return ColorCache.get(rgb);
    }

    public static Color get(float r, float g, float b) {
        return ColorCache.get((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
    }

    public static Color getInverse(int rgb) {
        return ColorCache.get(rgb ^ 0xFFFFFF);
    }

    public static Color getBW(Color c) {
        int darkness = c.getRed() + c.getGreen() + c.getBlue();
        int alpha = c.getAlpha();
        int mode = 0;
        if (darkness > 382) {
            mode = 255;
        }
        return ColorCache.get(mode, mode, mode, alpha);
    }

    static class Entry {
        public Color m_value;
        public Entry m_next;

        protected Entry(Color color, Entry next) {
            this.m_value = color;
            this.m_next = next;
        }
    }
}

