/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Ta;
import lsedit.ToolBarEventHandler;
import lsedit.Util;
import lsedit.Version;

public class ClusterInterface
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int COMMAND = 0;
    protected static final int EXPORT = 1;
    protected static final int IMPORT = 2;
    protected static final String[] m_textfield_tags = new String[]{"clusterinterface:command[", "clusterinterface:export[", "clusterinterface:import["};
    protected static final String[] m_textfield_titles = new String[]{"Command to be executed:", "Exported file used by command:", "Imported file created by command:"};
    protected static final String[] m_textfield_resets = new String[]{"java.exe -classpath . lsedit.LsClusterer", "", ""};
    protected static String[] m_textfield_defaults = new String[]{"java.exe -classpath . lsedit.LsClusterer", "", ""};
    protected static String[] m_textfield_currents = new String[]{"java.exe -classpath . lsedit.LsClusterer", "", ""};
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final String[] m_checkbox_tags = new String[]{"clusterinterface:deleteExport[", "clusterinterface:deleteImport[", "clusterinterface:leaves[", "clusterinterface:feedback["};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback"};
    protected static final boolean[] m_checkbox_resets;
    protected static boolean[] m_checkbox_defaults;
    protected static boolean[] m_checkbox_currents;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles;
    protected static final String[] m_button_tips;
    protected Diagram m_dg;
    private String m_ret;

    static {
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        blArray[3] = true;
        m_checkbox_resets = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[2] = true;
        blArray2[3] = true;
        m_checkbox_defaults = blArray2;
        boolean[] blArray3 = new boolean[4];
        blArray3[2] = true;
        blArray3[3] = true;
        m_checkbox_currents = blArray3;
        String[] stringArray = new String[7];
        stringArray[0] = "Ok";
        stringArray[1] = "Cancel";
        stringArray[2] = "Help";
        stringArray[4] = "Default";
        stringArray[5] = "Set";
        stringArray[6] = "Reset";
        m_button_titles = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[3] = "Enable/disable undo";
        stringArray2[4] = "Use remembered default";
        stringArray2[5] = "Set default to current";
        stringArray2[6] = "Set default to initial";
        m_button_tips = stringArray2;
    }

    protected static String parameterString(int i) {
        return m_textfield_currents[i];
    }

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    @Override
    public String getTag() {
        return "clusterinterface:";
    }

    @Override
    public void reset() {
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        int i = 0;
        while (i < textfield_resets.length) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
            ++i;
        }
        i = 0;
        while (i < checkbox_resets.length) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
            ++i;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        String[] textfield_tags = m_textfield_tags;
        int i = 0;
        while (i < textfield_tags.length) {
            if (attribute.equals(textfield_tags[i])) {
                switch (mode) {
                    case 0: {
                        ClusterInterface.m_textfield_defaults[i] = value;
                    }
                    case 1: {
                        ClusterInterface.m_textfield_currents[i] = value;
                    }
                }
                return;
            }
            ++i;
        }
        String[] checkbox_tags = m_checkbox_tags;
        i = 0;
        while (i < checkbox_tags.length) {
            if (attribute.equals(checkbox_tags[i])) {
                boolean bool = value.charAt(0) == 't';
                switch (mode) {
                    case 0: {
                        ClusterInterface.m_checkbox_defaults[i] = bool;
                    }
                    case 1: {
                        ClusterInterface.m_checkbox_currents[i] = bool;
                    }
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < m_textfield_tags.length) {
            String string = emit_strings[i];
            if (!string.equals(prior_strings[i])) {
                ps.println(String.valueOf(m_textfield_tags[i]) + "=" + string);
            }
            ++i;
        }
        i = 0;
        while (i < m_checkbox_tags.length) {
            boolean bool = emit_booleans[i];
            if (bool != prior_booleans[i]) {
                ps.println(String.valueOf(m_checkbox_tags[i]) + "=" + (bool ? "true" : "false"));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String message) {
        if (ClusterInterface.parameterBoolean(3)) {
            ClusterInterface clusterInterface = this;
            synchronized (clusterInterface) {
                System.err.println(String.valueOf(Util.toLocaleString()) + ": " + message);
            }
        }
    }

    protected String message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
        return string;
    }

    protected void transferNodes(EntityInstance parent, EntityInstance e) {
        EntityInstance e1 = null;
        EntityInstance child = null;
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            if (child == null) {
                e1 = this.m_dg.updateClusterEntity(parent, e);
            }
            child = (EntityInstance)en.nextElement();
            this.transferNodes(e1, child);
        }
        if (child == null) {
            String id = e.getId();
            EntityInstance match = this.m_dg.getCache(id);
            e1 = this.m_dg.updateImportEntity(parent, e, match);
            e1.nandMark(0x4000000);
        }
        parent.nandMark(0x4000000);
    }

    boolean waitFor(Process process) {
        try {
            int ret = process.waitFor();
            this.log("Process returned exit value of " + ret);
        }
        catch (Exception error) {
            this.message("WaitFor failed: " + error.getMessage());
            return false;
        }
        return true;
    }

    ClusterInterface(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Cluster Interface";
    }

    @Override
    public String getMenuLabel() {
        return "Cluster using program";
    }

    @Override
    public boolean doLayout1(Vector masterBoxes, EntityInstance parent) {
        String result;
        Process process;
        EntityInstance e;
        Enumeration en;
        Vector selectedBoxes;
        String exportname = ClusterInterface.parameterString(1);
        String command = ClusterInterface.parameterString(0);
        String importname = ClusterInterface.parameterString(2);
        if (exportname.length() == 0 && command.length() == 0) {
            this.m_ret = this.message("Please specify an export file to write to or command to pipe to");
            return true;
        }
        boolean leaves = ClusterInterface.parameterBoolean(2);
        if (!leaves) {
            selectedBoxes = masterBoxes;
        } else {
            selectedBoxes = new Vector();
            en = masterBoxes.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                e.gatherLeaves(selectedBoxes);
            }
        }
        WriteOutput writeOutput = new WriteOutput(selectedBoxes);
        if (command.length() == 0) {
            writeOutput.write();
            this.m_ret = this.message("Export written to '" + exportname + "'. No command specified");
            return true;
        }
        Ta ta = new Ta(this.m_ls);
        if (importname.length() == 0) {
            new Thread(writeOutput).start();
            process = writeOutput.getProcess();
            if (process == null) {
                return false;
            }
            this.log("Reading subprocess output as our input");
            InputStream is = writeOutput.getInputStream();
            result = ta.loadTA("", is);
            if (result != null) {
                this.m_ret = this.message(result);
                return false;
            }
            this.log("Import loaded");
            if (!this.waitFor(process)) {
                return false;
            }
        } else {
            if (!writeOutput.write()) {
                return false;
            }
            process = writeOutput.getProcess();
            if (process == null) {
                return false;
            }
            if (!this.waitFor(process)) {
                return false;
            }
            this.log("Importing '" + importname);
            result = ta.loadTA(importname, null);
            if (result != null) {
                this.m_ret = this.message(result);
                return false;
            }
            this.log("Import loaded");
            if (ClusterInterface.parameterBoolean(1)) {
                try {
                    File importfile = new File(importname);
                    if (!importfile.delete()) {
                        this.message("Unable to delete '" + importfile + "'");
                    } else {
                        this.message("Deleted " + importfile);
                    }
                }
                catch (Exception error) {
                    this.message("Exception deleting '" + importname + "' " + error.getMessage());
                }
            }
        }
        if (exportname.length() != 0 && ClusterInterface.parameterBoolean(0)) {
            try {
                File exportfile = new File(exportname);
                if (!exportfile.delete()) {
                    this.message("Unable to delete '" + exportfile + "'");
                } else {
                    this.log("Deleted " + exportfile);
                }
            }
            catch (Exception error) {
                this.message("Exception deleting '" + exportname + "' " + error.getMessage());
            }
        }
        this.log("Reclustering");
        if (leaves) {
            en = masterBoxes.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                e.orMark(0x4000000);
            }
        }
        EntityInstance root = ta.getRootInstance();
        en = root.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            this.transferNodes(parent, child);
        }
        en = selectedBoxes.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            e.nandMark(0x4000000);
        }
        if (leaves) {
            this.log("Removing redundant containers");
            en = masterBoxes.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                if (!e.isMarked(0x4000000)) continue;
                this.m_dg.updateCutEntity(e);
            }
        }
        this.m_ret = "Clustering operation complete";
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        this.m_dg = dg;
        Vector masterBoxes = dg.getClusterGroup();
        if (masterBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance parent = this.parentOfSet(masterBoxes);
        if (parent == null) {
            return "Selected items do not have the same parent entity";
        }
        this.m_ret = "Clustering attempt failed";
        ls.doLayout1(this, masterBoxes, parent, false);
        return this.m_ret;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        ClusterInterfaceDialog configure = new ClusterInterfaceDialog();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isLayouter() {
        return false;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        if (!this.configure(this.m_ls)) {
            return;
        }
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class ClusterInterfaceDialog
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        public ClusterInterfaceDialog() {
            super(ClusterInterface.this.m_ls.getFrame(), "Invoke external clustering tool", true);
            LandscapeEditorCore ls = ClusterInterface.this.m_ls;
            this.m_isok = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel = new JPanel();
            JPanel valuePanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(3, 1, 0, 10);
            labelPanel.setLayout(gridLayout);
            gridLayout = new GridLayout(3, 1, 0, 10);
            valuePanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            int i = 0;
            while (i < m_textfield_tags.length) {
                JTextField textfield;
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 60);
                JLabel label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                textfield.setFont(font);
                valuePanel.add(textfield);
                ++i;
            }
            JPanel optionsPanel = new JPanel();
            optionsPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            i = 0;
            while (i < m_checkbox_tags.length) {
                JCheckBox checkbox;
                this.m_checkboxes[i] = checkbox = new JCheckBox(m_checkbox_titles[i], m_checkbox_currents[i]);
                checkbox.setFont(font);
                optionsPanel.add(checkbox);
                ++i;
            }
            topPanel.add("West", labelPanel);
            topPanel.add("East", valuePanel);
            topPanel.add("South", optionsPanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            this.m_message = new JLabel(" ", 0);
            String string = ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            this.m_message.setText(string);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            contentPane.add("Center", this.m_message);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            i = 0;
            while (i < m_button_titles.length) {
                JButton button;
                string = m_button_titles[i];
                if (string == null) {
                    string = ClusterInterface.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
                ++i;
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            int state = -1;
            int i = 0;
            while (i < m_button_titles.length) {
                if (source == this.m_buttons[i]) {
                    state = i;
                    break;
                }
                ++i;
            }
            switch (state) {
                case 6: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        ClusterInterface.m_textfield_defaults[i] = m_textfield_resets[i];
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        ClusterInterface.m_checkbox_defaults[i] = m_checkbox_resets[i];
                        ++i;
                    }
                }
                case 4: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                        ++i;
                    }
                    return;
                }
                case 5: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        ClusterInterface.m_textfield_defaults[i] = this.m_textfields[i].getText();
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        ClusterInterface.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                        ++i;
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore ls = ClusterInterface.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(ClusterInterface.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ClusterInterface.this.m_ls.getFrame(), "To merely export a file for later clustering provide an export filename.\nTo run an external clusterer provide the command that invokes that external tool.\nIf no export file specifying what is to be clustered is provided, this\ninformation will be piped directly to the specified commands standard input.\nThe provided command is expected to write instructions as to how clustering is to\nbe performed to the specified import file.  If no such file is specified it will\nbe presumed that this input is to be read directly from the provided commands\nstandard output stream.  Temporary files that are created may optionally be deleted\nwhen the clustering interface has no further use for them.\n\nThe export file contains TA specifying the nodes to be clustered and the edges\nbetween them considered relevant when performing that clustering.  The import file\nshould contain suitably structured TA showing how these exported nodes are to be\nclustered.  New containment hierarchies in the imported data will be constructed\nand the relevant nodes contained within such imported hierarchies moved into these\nhierarchies.  If sizing and positioning information is provided in the imported data\nthis information will be mirrored in the resulting internal TA.", "Help", 0);
                    return;
                }
                case 0: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        ClusterInterface.m_textfield_currents[i] = this.m_textfields[i].getText();
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        ClusterInterface.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                        ++i;
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }

    class ErrOutput
    implements Runnable {
        InputStream m_inputStream = null;

        ErrOutput(InputStream inputStream) {
            this.m_inputStream = inputStream;
        }

        @Override
        public void run() {
            try {
                String s;
                InputStreamReader isReader = new InputStreamReader(this.m_inputStream);
                BufferedReader reader = new BufferedReader(isReader);
                while ((s = reader.readLine()) != null) {
                    ClusterInterface.this.log(s);
                }
                reader.close();
            }
            catch (Exception error) {
                ClusterInterface.this.log("Syserr input error: " + error.getMessage());
            }
        }
    }

    class WriteOutput
    implements Runnable {
        Process m_process = null;
        InputStream m_inputStream = null;
        boolean m_waiting = true;
        Vector m_selectedBoxes;

        WriteOutput(Vector selectedBoxes) {
            this.m_selectedBoxes = selectedBoxes;
        }

        public synchronized Process getProcess() {
            while (this.m_waiting) {
                try {
                    this.wait(1L);
                }
                catch (Exception error) {
                    ClusterInterface.this.message("wait error: " + error.getMessage());
                }
            }
            return this.m_process;
        }

        public InputStream getInputStream() {
            return this.m_inputStream;
        }

        public Process startCommand(String command) {
            Process process = null;
            ClusterInterface.this.log("Executing [" + command + "]");
            try {
                Runtime runtime = Runtime.getRuntime();
                if (runtime == null) {
                    ClusterInterface.this.message("No runtime available");
                } else {
                    process = runtime.exec(command);
                }
            }
            catch (Exception error) {
                ClusterInterface.this.log("Exception executing [" + command + "] " + error.getMessage());
                process = null;
            }
            if (process != null) {
                ErrOutput errOutput = new ErrOutput(process.getErrorStream());
                new Thread(errOutput).start();
                this.m_inputStream = process.getInputStream();
            }
            this.m_process = process;
            this.m_waiting = false;
            return process;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean write() {
            PrintWriter ps;
            Vector selectedBoxes = this.m_selectedBoxes;
            String exportname = ClusterInterface.parameterString(1);
            String command = ClusterInterface.parameterString(0);
            String importname = ClusterInterface.parameterString(2);
            Diagram dg = ClusterInterface.this.m_ls.getDiagram();
            Process process = null;
            File exportfile = null;
            try {
                OutputStream os;
                if (exportname.length() == 0) {
                    ClusterInterface.this.log("Piping output to subprocess");
                    process = this.startCommand(command);
                    if (process == null) {
                        return false;
                    }
                    os = process.getOutputStream();
                } else {
                    ClusterInterface.this.log("Exporting " + exportname);
                    exportfile = new File(exportname);
                    os = new FileOutputStream(exportfile);
                }
                ps = new PrintWriter(os);
            }
            catch (Exception error) {
                ClusterInterface.this.message("Exception creating output stream " + exportname + ": " + error.getMessage());
                return false;
            }
            boolean leaves = ClusterInterface.parameterBoolean(2);
            try {
                EntityInstance e1;
                RelationInstance ri;
                Enumeration en1;
                EntityInstance e;
                ps.println("// Clusting TA file written by LSEdit " + Version.Number());
                ps.println();
                dg.writeSchemeTuples(ps);
                dg.writeSchemeAttributes(ps);
                ps.println();
                ps.println();
                ps.println("FACT TUPLE :");
                ps.println();
                Enumeration en = selectedBoxes.elements();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    e.writeInstance(ps);
                    e.orMark(0x4000000);
                }
                en = selectedBoxes.elements();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    if (leaves) {
                        en1 = e.srcRelationElements();
                        if (en1 == null) continue;
                        while (en1.hasMoreElements()) {
                            ri = (RelationInstance)en1.nextElement();
                            if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                            ri.writeRelation(ps);
                        }
                        continue;
                    }
                    en1 = e.srcLiftedRelationElements();
                    if (en1 == null) continue;
                    while (en1.hasMoreElements()) {
                        ri = (RelationInstance)en1.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                        ri.writeRelation(ps);
                    }
                }
                ps.println();
                ps.println();
                ps.println("FACT ATTRIBUTE :");
                ps.println();
                RelationClass containsClass = dg.getPrimaryContainsClass();
                en = selectedBoxes.elements();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    e.writeAttribute(ps, containsClass);
                    if (leaves) {
                        en1 = e.srcRelationElements();
                        if (en1 == null) continue;
                        while (en1.hasMoreElements()) {
                            ri = (RelationInstance)en1.nextElement();
                            if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                            ri.writeAttributes(ps);
                        }
                        continue;
                    }
                    en1 = e.srcLiftedRelationElements();
                    if (en1 == null) continue;
                    while (en1.hasMoreElements()) {
                        ri = (RelationInstance)en1.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                        ri.writeAttributes(ps);
                    }
                }
                ps.flush();
                ps.close();
                ClusterInterface.this.log("Export written");
            }
            catch (Exception error) {
                ClusterInterface.this.message("Exception writing output: " + error.getMessage());
                return false;
            }
            return exportname.length() == 0 || command.length() == 0 || (process = this.startCommand(command)) != null;
        }

        @Override
        public void run() {
            this.write();
        }
    }
}

