/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;

public class ClosureConstraints
extends JDialog
implements ActionListener {
    private JButton m_ok = null;

    protected ClosureConstraints(JFrame frame, Diagram diagram, RelationClass rc) {
        super(frame, "Closure of constraints on " + rc.getLabel(), true);
        boolean[][] array = rc.getInheritedRelationArray();
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        int size = diagram.numEntityClasses();
        EntityClass[] ecs = new EntityClass[size];
        int i = 0;
        Enumeration en = diagram.enumEntityClassesInOrder();
        while (en.hasMoreElements()) {
            EntityClass ec;
            ecs[i] = ec = (EntityClass)en.nextElement();
            ++i;
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, size + 1));
        JLabel label = new JLabel("");
        panel.add(label);
        i = 0;
        while (i < size) {
            label = new JLabel(ecs[i].getLabel());
            label.setFont(bold);
            panel.add(label);
            ++i;
        }
        i = 0;
        while (i < size) {
            label = new JLabel(String.valueOf(ecs[i].getLabel()) + " ");
            label.setFont(bold);
            panel.add(label);
            int j = 0;
            while (j < size) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setFont(font);
                checkBox.setToolTipText(String.valueOf(ecs[i].getLabel()) + "->" + ecs[j].getLabel());
                checkBox.setEnabled(false);
                if (array[i][j]) {
                    checkBox.setSelected(true);
                    checkBox.setForeground(Color.RED);
                }
                panel.add(checkBox);
                ++j;
            }
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setVisible(true);
        contentPane.add((Component)scrollPane, "Center");
        panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(bold);
        this.m_ok.addActionListener(this);
        panel.add(this.m_ok);
        contentPane.add((Component)panel, "South");
        this.pack();
        this.setVisible(true);
    }

    public static void create(Diagram diagram, RelationClass rc) {
        LandscapeEditorCore ls = diagram.getLs();
        ClosureConstraints closureConstraints = new ClosureConstraints(ls.getFrame(), diagram, rc);
        closureConstraints.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source != this.m_ok) {
            return;
        }
        this.setVisible(false);
    }
}

