/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;

public class ClassInherits
extends JDialog
implements ActionListener {
    private LandscapeEditorCore m_ls;
    private LandscapeClassObject m_o;
    private JCheckBox[] m_checkboxes;
    private LandscapeClassObject[] m_classes;
    private JButton m_ok;
    JButton m_cancel;
    Vector m_result;

    protected Enumeration inOrder() {
        if (this.m_o instanceof EntityClass) {
            return this.m_ls.enumEntityClassesInOrder();
        }
        return this.m_ls.enumRelationClassesInOrder();
    }

    protected LandscapeClassObject baseClass() {
        Diagram diagram = this.m_ls.getDiagram();
        if (this.m_o instanceof EntityClass) {
            return diagram.m_entityBaseClass;
        }
        return diagram.m_relationBaseClass;
    }

    protected Vector getInheritance() {
        LandscapeClassObject base = this.baseClass();
        if (this.m_o == base) {
            return null;
        }
        Vector<LandscapeClassObject> v = new Vector<LandscapeClassObject>();
        LandscapeClassObject[] classes = this.m_classes;
        JCheckBox[] checkboxes = this.m_checkboxes;
        if (checkboxes != null) {
            int size = checkboxes.length;
            int i = 0;
            while (i < size) {
                JCheckBox checkbox = checkboxes[i];
                if (checkbox.isSelected()) {
                    LandscapeClassObject o = classes[i];
                    int j = 0;
                    while (j < size) {
                        if (j != i && checkboxes[j].isSelected() && classes[j].subclassOf(o)) {
                            o = null;
                            break;
                        }
                        ++j;
                    }
                    if (o != null) {
                        v.add(o);
                    }
                }
                ++i;
            }
        }
        if (v.isEmpty()) {
            v.add(base);
        }
        return v;
    }

    public ClassInherits(LandscapeEditorCore ls, LandscapeClassObject o) {
        super(ls.getFrame(), o.getLabel(), true);
        JLabel label;
        LandscapeClassObject o1;
        this.m_ls = ls;
        this.m_o = o;
        this.m_result = null;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel centerPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setVgap(10);
        centerPanel.setLayout(gridLayout);
        this.m_checkboxes = null;
        this.m_classes = null;
        int size = 0;
        Enumeration en = this.inOrder();
        while (en.hasMoreElements()) {
            o1 = (LandscapeClassObject)en.nextElement();
            if (o == o1 || o1.subclassOf(o)) continue;
            ++size;
        }
        if (size > 0) {
            label = new JLabel(" Inherits from: ");
            label.setFont(bold);
            centerPanel.add(label);
            JCheckBox[] checkboxes = new JCheckBox[size];
            this.m_checkboxes = checkboxes;
            LandscapeClassObject[] classes = new LandscapeClassObject[size];
            this.m_classes = classes;
            int i = 0;
            en = this.inOrder();
            while (en.hasMoreElements()) {
                JCheckBox checkbox;
                o1 = (LandscapeClassObject)en.nextElement();
                if (o == o1 || o1.subclassOf(o)) continue;
                classes[i] = o1;
                checkboxes[i] = checkbox = new JCheckBox(o1.getLabel());
                ++i;
                checkbox.setSelected(o.directlyInheritsFrom(o1));
                centerPanel.add(checkbox);
            }
        }
        boolean flag = false;
        en = this.inOrder();
        while (en.hasMoreElements()) {
            o1 = (LandscapeClassObject)en.nextElement();
            if (o == o1 || !o1.directlyInheritsFrom(o)) continue;
            if (!flag) {
                label = new JLabel(" Inherited by: ");
                label.setFont(bold);
                centerPanel.add(label);
                flag = true;
            }
            label = new JLabel(" " + o1.getLabel());
            label.setForeground(Color.BLUE);
            centerPanel.add(label);
        }
        flag = false;
        en = this.inOrder();
        while (en.hasMoreElements()) {
            o1 = (LandscapeClassObject)en.nextElement();
            if (o == o1 || o1.directlyInheritsFrom(o) || !o1.subclassOf(o)) continue;
            if (!flag) {
                label = new JLabel(" Indirectly by: ");
                label.setFont(bold);
                centerPanel.add(label);
                flag = true;
            }
            label = new JLabel(" " + o1.getLabel());
            label.setForeground(Color.RED);
            centerPanel.add(label);
        }
        JScrollPane scrollPane = new JScrollPane(centerPanel);
        scrollPane.setVisible(true);
        contentPane.add("Center", scrollPane);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(bold);
        bottomPanel.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(bold);
        bottomPanel.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        contentPane.add("South", bottomPanel);
        this.pack();
    }

    public Vector getResult() {
        return this.m_result;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_ok) {
            this.m_result = this.getInheritance();
        } else if (source != this.m_cancel) {
            return;
        }
        this.setVisible(false);
    }
}

