/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import lsedit.ColorCache;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationInstance;

class Cardinal
extends JComponent {
    protected static final int MARGIN = 5;
    protected int m_cnt;
    protected int m_w;
    protected static Font m_font = null;
    public static FontMetrics m_fm = null;
    public static int m_h;

    @Override
    public String toString() {
        return "Cardinal " + this.m_cnt;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.setForeground(ColorCache.getInverse(color.getRGB()));
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setFont(m_font);
        g.setColor(this.getBackground());
        g.fillOval(0, 0, width, height);
        g.setColor(Color.black);
        g.drawOval(0, 0, width - 1, height - 1);
        g.setColor(this.getForeground());
        g.drawString("" + this.m_cnt, 2, m_h - 2);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setSize(0, 0);
    }

    public Cardinal() {
        if (m_font == null) {
            m_font = Options.getTargetFont(5);
        }
        this.setFont(m_font);
    }

    public static void setTextFont(Font font) {
        if (m_font != font) {
            m_font = font;
            m_fm = null;
        }
    }

    public void reset() {
        this.m_cnt = 0;
    }

    public void sum(RelationInstance ri) {
        this.m_cnt += ri.getFrequency();
    }

    public void known() {
        this.setToolTipText("" + this.m_cnt);
    }

    public int getCnt() {
        return this.m_cnt;
    }

    public void setCenterTop(int x, int y, int width, int height, RelationClass rc) {
        double factor = rc.getRelativeIOfactor();
        this.setFont(m_font);
        if (m_fm == null) {
            m_fm = this.getFontMetrics(m_font);
            m_h = m_fm.getAscent();
        }
        x = (int)((double)x + (double)width * factor);
        this.m_w = m_fm.stringWidth("" + this.m_cnt);
        this.setBounds(x - this.m_w / 2 - 2, y += height + 5, this.m_w + 4, m_h + 4);
    }
}

