/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lsedit.Version;

public class BrowserLauncher {
    public static final int JVM_UNKNOWN = -2;
    public static final int OTHER = -1;
    public static final int MRJ_2_0 = 0;
    public static final int MRJ_2_1 = 1;
    public static final int MRJ_3_0 = 3;
    public static final int MRJ_3_1 = 4;
    public static final int WINDOWS_NT = 5;
    public static final int WINDOWS_9x = 6;
    private static int jvm = -2;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static Object linkage;
    private static final String JDirect_MacOSX = "/System/Library/Frameworks/Carbon.framework/Frameworks/HIToolbox.framework/HIToolbox";
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static String errorMessage;

    static {
        if (jvm == -2) {
            block11: {
                jvm = -1;
                loadedWithoutErrors = true;
                String osName = Version.Detail("os.name");
                if (osName.startsWith("Mac OS")) {
                    String mrjVersion = System.getProperty("mrj.version");
                    String majorMRJVersion = mrjVersion.substring(0, 3);
                    try {
                        double version = Double.valueOf(majorMRJVersion);
                        if (version == 2.0) {
                            jvm = 0;
                            break block11;
                        }
                        if (version >= 2.1 && version < 3.0) {
                            jvm = 1;
                            break block11;
                        }
                        if (version == 3.0) {
                            jvm = 3;
                            break block11;
                        }
                        if (version >= 3.1) {
                            jvm = 4;
                            break block11;
                        }
                        loadedWithoutErrors = false;
                        errorMessage = "Unsupported MRJ version: " + version;
                    }
                    catch (NumberFormatException nfe) {
                        loadedWithoutErrors = false;
                        errorMessage = "Invalid MRJ version: " + mrjVersion;
                    }
                } else if (osName.startsWith("Windows")) {
                    jvm = osName.indexOf("9") != -1 ? 6 : 5;
                }
            }
            if (loadedWithoutErrors) {
                loadedWithoutErrors = BrowserLauncher.loadClasses();
            }
        }
    }

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> aeTargetClass = Class.forName("com.apple.MacOS.AETarget");
                    Class<?> osUtilsClass = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> appleEventClass = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> aeClass = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = aeTargetClass.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = appleEventClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, aeTargetClass, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = osUtilsClass.getDeclaredMethod("makeOSType", String.class);
                    putParameter = appleEventClass.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = appleEventClass.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field keyDirectObjectField = aeClass.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)keyDirectObjectField.get(null);
                    Field autoGenerateReturnIDField = appleEventClass.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)autoGenerateReturnIDField.get(null);
                    Field anyTransactionIDField = appleEventClass.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)anyTransactionIDField.get(null);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = systemFolderField.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", File.class);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (SecurityException se) {
                    errorMessage = se.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 3: {
                try {
                    Class<?> linker = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = linker.getConstructor(Class.class);
                    linkage = constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (InvocationTargetException ite) {
                    errorMessage = ite.getMessage();
                    return false;
                }
                catch (InstantiationException ie) {
                    errorMessage = ie.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer finderCreatorCode = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object aeTarget = aeTargetConstructor.newInstance(finderCreatorCode);
                    Integer gurlType = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object appleEvent = appleEventConstructor.newInstance(gurlType, gurlType, aeTarget, kAutoGenerateReturnID, kAnyTransactionID);
                    return appleEvent;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InstantiationException ie) {
                    browser = null;
                    errorMessage = ie.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getMessage();
                    return browser;
                }
            }
            case 1: {
                File systemFolder;
                try {
                    systemFolder = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException iare) {
                    browser = null;
                    errorMessage = iare.getMessage();
                    return browser;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                    return browser;
                }
                String[] systemFolderFiles = systemFolder.list();
                int i = 0;
                while (i < systemFolderFiles.length) {
                    try {
                        Object fileCreator;
                        Object fileType;
                        File file = new File(systemFolder, systemFolderFiles[i]);
                        if (file.isFile() && FINDER_TYPE.equals((fileType = getFileType.invoke(null, file)).toString()) && FINDER_CREATOR.equals((fileCreator = getFileCreator.invoke(null, file)).toString())) {
                            browser = file.toString();
                            return browser;
                        }
                    }
                    catch (IllegalArgumentException iare) {
                        errorMessage = iare.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        browser = null;
                        errorMessage = iae.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException ite) {
                        browser = null;
                        errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                        return browser;
                    }
                    ++i;
                }
                browser = null;
                break;
            }
            case 3: 
            case 4: {
                browser = "";
                break;
            }
            case 5: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String url) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        switch (jvm) {
            case 0: {
                Object aeDesc = null;
                try {
                    try {
                        aeDesc = aeDescConstructor.newInstance(url);
                        putParameter.invoke(browser, keyDirectObject, aeDesc);
                        sendNoReply.invoke(browser, new Object[0]);
                        break;
                    }
                    catch (InvocationTargetException ite) {
                        throw new IOException("InvocationTargetException while creating AEDesc: " + ite.getMessage());
                    }
                    catch (IllegalAccessException iae) {
                        throw new IOException("IllegalAccessException while building AppleEvent: " + iae.getMessage());
                    }
                    catch (InstantiationException ie) {
                        throw new IOException("InstantiationException while creating AEDesc: " + ie.getMessage());
                    }
                }
                finally {
                    aeDesc = null;
                    browser = null;
                }
            }
            case 1: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
                break;
            }
            case 3: {
                int[] instance = new int[1];
                int result = BrowserLauncher.ICStart(instance, 0);
                if (result == 0) {
                    int[] selectionStart = new int[1];
                    byte[] urlBytes = url.getBytes();
                    int[] selectionEnd = new int[]{urlBytes.length};
                    result = BrowserLauncher.ICLaunchURL(instance[0], new byte[1], urlBytes, urlBytes.length, selectionStart, selectionEnd);
                    if (result == 0) {
                        BrowserLauncher.ICStop(instance);
                        break;
                    }
                    throw new IOException("Unable to launch URL: " + result);
                }
                throw new IOException("Unable to create an Internet Config instance: " + result);
            }
            case 4: {
                try {
                    openURL.invoke(null, url);
                    break;
                }
                catch (InvocationTargetException ite) {
                    throw new IOException("InvocationTargetException while calling openURL: " + ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IOException("IllegalAccessException while calling openURL: " + iae.getMessage());
                }
            }
            case 5: 
            case 6: {
                Process process = Runtime.getRuntime().exec(new String[]{(String)browser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, String.valueOf('\"') + url + '\"'});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case -1: {
                Process process = Runtime.getRuntime().exec(new String[]{(String)browser, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + url + NETSCAPE_OPEN_PARAMETER_END});
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)browser, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
            }
        }
    }

    public static int getJVM() {
        return jvm;
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);
}

