/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.Attribute;

public class AttributeCache {
    private static final float m_loadFactor = 0.75f;
    private static Entry[] m_table = null;
    private static int m_count = 0;
    private static int m_mask = 65535;
    private static int m_actual_attributes = 0;
    private static int m_requested_attributes = 0;
    private static int m_threshold = (int)((float)m_mask * 0.75f);

    public static void activate() {
        if (m_table == null) {
            m_table = new Entry[m_mask + 1];
            m_count = 0;
        }
    }

    public static void deactivate() {
        Entry[] tab = m_table;
        if (tab != null) {
            int index = tab.length;
            while (--index >= 0) {
                Entry entry = tab[index];
                while (entry != null) {
                    entry.m_attribute = null;
                    Entry next = entry.m_next;
                    entry.m_next = null;
                    entry = next;
                }
                tab[index] = null;
            }
            m_table = null;
        }
    }

    protected static int hashCode(String id, String value) {
        int hashcode = id.hashCode();
        if (value != null) {
            hashcode ^= value.hashCode();
        }
        return hashcode & m_mask;
    }

    protected static void rehash() {
        Entry[] oldMap = m_table;
        m_mask = m_mask << 1 | 1;
        m_threshold = (int)((float)m_mask * 0.75f);
        Entry[] newMap = new Entry[m_mask + 1];
        m_table = newMap;
        int i = oldMap.length;
        while (--i >= 0) {
            Entry entry = oldMap[i];
            while (entry != null) {
                Attribute attribute = entry.m_attribute;
                Entry next = entry.m_next;
                int index = AttributeCache.hashCode(attribute.m_id, attribute.externalString());
                entry.m_next = newMap[index];
                newMap[index] = entry;
                entry = next;
            }
        }
    }

    public static Attribute get(String id, String value) {
        Attribute attribute;
        Entry[] table = m_table;
        int index = AttributeCache.hashCode(id, value);
        ++m_requested_attributes;
        if (table == null) {
            attribute = new Attribute(id, value);
        } else {
            Entry entry = table[index];
            while (entry != null) {
                attribute = entry.m_attribute;
                if (id.equals(attribute.m_id)) {
                    String value1 = attribute.externalString();
                    if (value == null ? value1 == null : value.equals(value1)) {
                        return attribute;
                    }
                }
                entry = entry.m_next;
            }
            attribute = new Attribute(id, value);
            table[index] = entry = new Entry(attribute, table[index]);
            if (++m_count > m_threshold) {
                AttributeCache.rehash();
            }
        }
        ++m_actual_attributes;
        return attribute;
    }

    public static int requestedAttributes() {
        return m_requested_attributes;
    }

    public static int actualAttributes() {
        return m_actual_attributes;
    }

    static class Entry {
        public Attribute m_attribute;
        public Entry m_next;

        protected Entry(Attribute attribute, Entry next) {
            this.m_attribute = attribute;
            this.m_next = next;
        }
    }
}

