/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.BitSet;
import lsedit.AttributeValue;
import lsedit.ColorCache;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.Ta;
import lsedit.Util;

public class Attribute {
    public static final Integer NULL = new Integer(0);
    public static final Integer INT = new Integer(1);
    public static final Integer DOUBLE = new Integer(2);
    public static final Integer STRING = new Integer(3);
    public static final Integer INT_LIST = new Integer(4);
    public static final Integer DOUBLE_LIST = new Integer(5);
    public static final Integer STRING_LIST = new Integer(6);
    public static final int NULL_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int STRING_TYPE = 3;
    public static final int INT_LIST_TYPE = 4;
    public static final int DOUBLE_LIST_TYPE = 5;
    public static final int STRING_LIST_TYPE = 6;
    public static final int COLOR_TYPE = 7;
    public static final int COLOR_OR_NULL_TYPE = 8;
    public static final int POINT_TYPE = 9;
    public static final int ELISION_TYPE = 10;
    public static final int ATTR_TYPE = 11;
    public static final int TEXT_TYPE = 12;
    public static final int ENTITY_STYLE_TYPE = 13;
    public static final int REL_STYLE_TYPE = 14;
    public static final int ENTITY_CLASS_TYPE = 15;
    public static final int RELATION_CLASS_TYPE = 16;
    public static final int ENTITY_IMAGE_TYPE = 17;
    public static final String indent = " ";
    public String m_id;
    private String m_avi;

    public Attribute(String id, String avi) {
        this.m_id = id;
        this.m_avi = avi;
    }

    public boolean hasId(String id) {
        return this.m_id.equals(id);
    }

    public String externalString() {
        return this.m_avi;
    }

    public static int countValues(String value) {
        if (value == null) {
            return 0;
        }
        if (value.charAt(0) != '(') {
            return 1;
        }
        return AttributeValue.countValues(value);
    }

    public int countValues() {
        return Attribute.countValues(this.m_avi);
    }

    public static String parseStringValue(String value) {
        if (value != null && value.length() != 0) {
            switch (value.charAt(0)) {
                case '\"': 
                case '\'': 
                case '(': {
                    return AttributeValue.parseString(value);
                }
            }
        }
        return value;
    }

    public String parseString() {
        return Attribute.parseStringValue(this.m_avi);
    }

    public static int parseIntValue(String value) {
        if (value == null) {
            return 0;
        }
        return Util.parseInt(value);
    }

    public int parseInt() {
        return Attribute.parseIntValue(this.m_avi);
    }

    public static int parseIntValue(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Util.parseInt(value);
    }

    public int parseInt(int defaultValue) {
        return Attribute.parseIntValue(this.m_avi, defaultValue);
    }

    public static double parseDoubleValue(String value) {
        if (value == null) {
            return 0.0;
        }
        return Util.parseDouble(value);
    }

    public double parseDouble() {
        return Attribute.parseDoubleValue(this.m_avi);
    }

    public static double parseDoubleValue(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Util.parseDouble(value);
    }

    public double parseDouble(double defaultValue) {
        return Attribute.parseDoubleValue(this.m_avi, defaultValue);
    }

    public static Color parseColorValue(String value, LandscapeObject forObject, String forMember) {
        if (value == null) {
            MsgOut.println("parseColor: missing rgb values for " + forObject + indent + forMember);
            return ColorCache.get(0, 0, 0, 255);
        }
        return AttributeValue.parseColor(value, forObject, forMember);
    }

    public Color parseColor(LandscapeObject forObject, String forMember) {
        return Attribute.parseColorValue(this.m_avi, forObject, forMember);
    }

    public static void parseElisionsValue(String value, Ta ta, int type, BitSet bitset) {
        if (value != null) {
            AttributeValue.parseElisions(value, ta, type, bitset);
        }
    }

    public void parseElisions(Ta ta, int type, BitSet bitset) {
        Attribute.parseElisionsValue(this.m_avi, ta, type, bitset);
    }

    public void followLink(LandscapeEditorCore ls, EntityInstance e, boolean mustbeContainer) {
        String avi = this.m_avi;
        if (avi == null) {
            ls.navigateTo(e, mustbeContainer);
            return;
        }
        AttributeValue.followLink(avi, ls, e, mustbeContainer);
    }

    public String writeAttribute(PrintWriter ps, String nodeId, LandscapeObject parentClass, boolean classType) {
        String avi = this.m_avi;
        if (avi == null ? !classType : parentClass != null && parentClass.defaultValue(this.m_id, avi)) {
            return nodeId;
        }
        return LandscapeObject.writeAttribute(ps, nodeId, this.m_id, avi);
    }

    public String toString() {
        String ret = this.m_id;
        if (this.m_avi != null) {
            ret = String.valueOf(ret) + "=" + this.m_avi;
        }
        return ret;
    }
}

