/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import lsedit.Util;

public class Arrow
extends JComponent {
    private int[] m_x;
    private int[] m_y;
    private Color m_headColor;
    private int m_style;
    private int m_width;
    private int m_base;
    private boolean m_invert;

    protected Arrow(int width, int height) {
        Dimension dimension = new Dimension(width, height);
        this.m_x = new int[3];
        this.m_y = new int[3];
        this.m_width = width;
        this.m_base = height / 2;
        this.m_invert = false;
        Util.getArrow(0, this.m_base, width, this.m_base, this.m_x, this.m_y, 1);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.setSize(dimension);
        this.m_style = 0;
    }

    public void setHeadColor(Color color) {
        this.m_headColor = color;
    }

    public void setInvert(boolean value) {
        if (this.m_invert != value) {
            if (value) {
                Util.getArrow(this.m_width, this.m_base, 0, this.m_base, this.m_x, this.m_y, 1);
            } else {
                Util.getArrow(0, this.m_base, this.m_width, this.m_base, this.m_x, this.m_y, 1);
            }
            this.m_invert = value;
        }
        this.repaint();
    }

    public void setStyle(int style) {
        this.m_style = style;
    }

    @Override
    public void paintComponent(Graphics g) {
        int height = this.getHeight() / 2;
        Color color = this.getForeground();
        if (color != null) {
            g.setColor(color);
        }
        Util.drawSegment(g, this.m_style, 0, height, this.getWidth(), height);
        color = this.m_headColor;
        if (color != null) {
            g.setColor(color);
        }
        g.fillPolygon(this.m_x, this.m_y, 3);
    }
}

