/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class ACDCClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final String[] g_pattern = new String[]{"Body/Subgraph/Orphan", "Body/Orphan/Subgraph", "Body/Subgraph", "Body/Orphan", "Body", "Subgraph/Body/Orphan", "Subgraph/Orphan/Body", "Subgraph/Body", "Subgraph/Orphan", "Subgraph", "Orphan/Body/Subgraph", "Orphan/Subgraph/Body", "Orphan/Subgraph", "Orphan/Body", "Orphan"};
    public static final String[] g_patterncode = new String[]{"bso", "bos", "bs", "bo", "b", "sbo", "sob", "sb", "so", "s", "obs", "osb", "os", "ob", "o"};
    public static final String[] g_filter = new String[]{"All", "Files within Modules", "Files"};
    public static final String[] g_debugs = new String[]{"Run Silently", "Minimal output", "Verbose debugging"};
    protected static final int COMMAND = 0;
    protected static final int EXPORT = 1;
    protected static final int IMPORT = 2;
    protected static final int MAXSIZE = 3;
    protected static final int CONTAINER = 4;
    protected static final String[] m_textfield_tags = new String[]{"acdc:command", "acdc:export", "acdc:import", "acdc:maxsize", "acdc:container"};
    protected static final String[] m_textfield_titles = new String[]{"Command to execute ACDC:", "Exported file used by command:", "Imported file created by command:", "Optional maximum cluster size:", "Optional container:"};
    protected static final String[] m_textfield_resets = new String[]{"java.exe -classpath . acdc.ACDC", "junk.ta", "junk.rsf", "", ""};
    protected static String[] m_textfield_defaults = new String[]{"java.exe -classpath . acdc.ACDC", "junk.ta", "junk.rsf", "", ""};
    protected static String[] m_textfield_currents = new String[]{"java.exe -classpath . acdc.ACDC", "junk.ta", "junk.rsf", "", ""};
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final int GUI = 4;
    protected static final String[] m_checkbox_tags = new String[]{"acdc:deleteExport", "acdc:deleteImport", "acdc:leaves", "acdc:feedback", "acdc:gui"};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback", "Popup gui"};
    protected static final boolean[] m_checkbox_resets;
    protected static boolean[] m_checkbox_defaults;
    protected static boolean[] m_checkbox_currents;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles;
    protected static final String[] m_button_tips;
    protected JComboBox m_pattern = new JComboBox<String>(g_pattern);
    protected JComboBox m_filter = new JComboBox<String>(g_filter);
    protected JComboBox m_debug = new JComboBox<String>(g_debugs);
    protected Diagram m_dg;
    protected String m_ret;

    static {
        boolean[] blArray = new boolean[5];
        blArray[2] = true;
        blArray[3] = true;
        m_checkbox_resets = blArray;
        boolean[] blArray2 = new boolean[5];
        blArray2[2] = true;
        blArray2[3] = true;
        m_checkbox_defaults = blArray2;
        boolean[] blArray3 = new boolean[5];
        blArray3[2] = true;
        blArray3[3] = true;
        m_checkbox_currents = blArray3;
        String[] stringArray = new String[7];
        stringArray[0] = "Ok";
        stringArray[1] = "Cancel";
        stringArray[2] = "Help";
        stringArray[4] = "Default";
        stringArray[5] = "Set";
        stringArray[6] = "Reset";
        m_button_titles = stringArray;
        String[] stringArray2 = new String[7];
        stringArray2[3] = "Enable/disable undo";
        stringArray2[4] = "Use remembered default";
        stringArray2[5] = "Set default to current";
        stringArray2[6] = "Set default to initial";
        m_button_tips = stringArray2;
    }

    protected static String parameterString(int i) {
        return m_textfield_currents[i];
    }

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    @Override
    public String getTag() {
        return "acdc:";
    }

    @Override
    public void reset() {
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        int i = 0;
        while (i < textfield_resets.length) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
            ++i;
        }
        i = 0;
        while (i < checkbox_resets.length) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
            ++i;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        String[] textfield_tags = m_textfield_tags;
        int i = 0;
        while (i < textfield_tags.length) {
            if (attribute.equals(textfield_tags[i])) {
                switch (mode) {
                    case 0: {
                        ACDCClusterLayout.m_textfield_defaults[i] = value;
                    }
                    case 1: {
                        ACDCClusterLayout.m_textfield_currents[i] = value;
                    }
                }
                return;
            }
            ++i;
        }
        String[] checkbox_tags = m_checkbox_tags;
        i = 0;
        while (i < checkbox_tags.length) {
            if (attribute.equals(checkbox_tags)) {
                boolean bool = value.charAt(0) == 't';
                switch (mode) {
                    case 0: {
                        ACDCClusterLayout.m_checkbox_defaults[i] = bool;
                    }
                    case 1: {
                        ACDCClusterLayout.m_checkbox_currents[i] = bool;
                    }
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        boolean[] emit_booleans;
        String[] emit_strings;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < m_textfield_tags.length) {
            String string = emit_strings[i];
            if (!string.equals(prior_strings[i])) {
                ps.println(String.valueOf(m_textfield_tags[i]) + "=" + string);
            }
            ++i;
        }
        i = 0;
        while (i < m_checkbox_tags.length) {
            boolean bool = emit_booleans[i];
            if (bool != prior_booleans[i]) {
                ps.println(String.valueOf(m_checkbox_tags[i]) + "=" + (bool ? "true" : "false"));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String message) {
        if (ACDCClusterLayout.parameterBoolean(3)) {
            ACDCClusterLayout aCDCClusterLayout = this;
            synchronized (aCDCClusterLayout) {
                System.err.println(String.valueOf(Util.toLocaleString()) + ": " + message);
            }
        }
    }

    protected void message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
    }

    public ACDCClusterLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
        this.m_debug.setSelectedIndex(1);
    }

    @Override
    public String getName() {
        return "ACDC Cluster";
    }

    @Override
    public String getMenuLabel() {
        return "ACDC Cluster";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore ls, String message) {
        ACDCClusterConfigure configure = new ACDCClusterConfigure(this, message);
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        return this.configure(ls, null);
    }

    protected boolean write(Vector selectedBoxes, String exportname) {
        block10: {
            Diagram dg = this.m_ls.getDiagram();
            PrintWriter ps = null;
            try {
                this.log("Exporting " + exportname);
                File exportfile = new File(exportname);
                FileOutputStream os = new FileOutputStream(exportfile);
                ps = new PrintWriter(os);
            }
            catch (Exception error) {
                this.message("Exception creating export stream " + exportname + ": " + error.getMessage());
                return false;
            }
            boolean leaves = ACDCClusterLayout.parameterBoolean(2);
            try {
                EntityInstance e;
                ps.print("FACT TUPLE :\n");
                Enumeration en = selectedBoxes.elements();
                while (en.hasMoreElements()) {
                    e = (EntityInstance)en.nextElement();
                    e.writeInstance(ps);
                    e.orMark(0x4000000);
                }
                en = selectedBoxes.elements();
                while (en.hasMoreElements()) {
                    EntityInstance e1;
                    RelationInstance ri;
                    Enumeration en1;
                    e = (EntityInstance)en.nextElement();
                    if (leaves) {
                        en1 = e.srcRelationElements();
                        if (en1 == null) continue;
                        while (en1.hasMoreElements()) {
                            ri = (RelationInstance)en1.nextElement();
                            if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                            ri.writeRelation(ps);
                        }
                        continue;
                    }
                    en1 = e.srcLiftedRelationElements();
                    if (en1 == null) continue;
                    while (en1.hasMoreElements()) {
                        ri = (RelationInstance)en1.nextElement();
                        if (!ri.isRelationShown() || !(e1 = ri.getDrawDst()).isMarked(0x4000000)) continue;
                        ri.writeRelation(ps);
                    }
                }
                ps.close();
                if (!ps.checkError()) break block10;
                this.message("An unknown error occurred writing output");
                return false;
            }
            catch (Exception error) {
                this.message("Exception writing output: " + error.getMessage());
                return false;
            }
        }
        this.log("Export written");
        return true;
    }

    boolean waitFor(Process process) {
        try {
            int ret = process.waitFor();
            this.log("Process returned exit value of " + ret);
        }
        catch (Exception error) {
            this.message("WaitFor failed: " + error.getMessage());
            return false;
        }
        return true;
    }

    protected boolean read(String importname, EntityInstance container, boolean collapse) {
        EntityInstance e;
        BufferedReader in;
        Diagram diagram = this.m_ls.getDiagram();
        boolean ok = false;
        Hashtable<String, EntityInstance> clusters = new Hashtable<String, EntityInstance>(20);
        this.log("Importing '" + importname + "'");
        try {
            FileReader fileReader = new FileReader(importname);
            in = new BufferedReader(fileReader);
        }
        catch (Exception error) {
            this.message("Exception opening " + importname + ": " + error.getMessage());
            return false;
        }
        int line = 0;
        String str = "";
        try {
            block6: while ((str = in.readLine()) != null) {
                ++line;
                String keyword = str.substring(0, 8);
                if (!keyword.equals("contain ")) {
                    this.message("Expected to see 'contain ' but saw '" + keyword + "' in " + importname + " at line " + line);
                    break;
                }
                int index = str.indexOf(32, 8);
                if (index < 1) {
                    this.message("First token missing in " + importname + " at line " + line);
                    break;
                }
                String firstToken = str.substring(8, index);
                String secondToken = str.substring(index + 1);
                if (secondToken.length() < 1) {
                    this.message("First token missing in " + importname + " at line " + line);
                    break;
                }
                if (firstToken.equals(secondToken)) continue;
                EntityInstance cluster = (EntityInstance)clusters.get(firstToken);
                if (cluster == null) {
                    cluster = diagram.updateNewEntity(null, container);
                    cluster.setLabel(firstToken);
                    clusters.put(firstToken, cluster);
                }
                if ((e = (EntityInstance)clusters.get(secondToken)) == null) {
                    e = diagram.getCache(secondToken);
                }
                if (e == null) {
                    e = diagram.updateNewEntity(null, cluster);
                    e.setLabel(secondToken);
                    clusters.put(secondToken, e);
                    continue;
                }
                EntityInstance parent = e.getContainedBy();
                diagram.updateMoveEntityContainment(cluster, e);
                if (!collapse) continue;
                while (true) {
                    e = parent;
                    parent = e.getContainedBy();
                    if (e.getFirstChild() != null) continue block6;
                    diagram.updateCutEntity(e);
                }
            }
        }
        catch (Exception error) {
            this.message("Exception reading " + importname + ": " + error.getMessage());
        }
        if (str == null) {
            Enumeration en = clusters.elements();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                diagram.doRelayoutAll(e, false);
            }
            ok = true;
        }
        clusters.clear();
        try {
            in.close();
        }
        catch (Exception error) {
            this.message("Exception closing " + importname + ": " + error.getMessage());
            return false;
        }
        return ok;
    }

    @Override
    public boolean doLayout1(Vector masterBoxes, EntityInstance parent) {
        Runtime runtime;
        Process process;
        String s;
        String importname;
        String exportname;
        boolean leaves;
        block43: {
            int size;
            int imaxsize;
            String command;
            Vector selectedBoxes;
            block42: {
                String string;
                leaves = ACDCClusterLayout.parameterBoolean(2);
                if (!leaves) {
                    selectedBoxes = masterBoxes;
                } else {
                    selectedBoxes = new Vector();
                    Enumeration en = masterBoxes.elements();
                    while (en.hasMoreElements()) {
                        EntityInstance e = (EntityInstance)en.nextElement();
                        e.gatherLeaves(selectedBoxes);
                    }
                }
                do {
                    exportname = ACDCClusterLayout.parameterString(1);
                    command = ACDCClusterLayout.parameterString(0);
                    importname = ACDCClusterLayout.parameterString(2);
                    String maxsize = ACDCClusterLayout.parameterString(3);
                    maxsize = maxsize.trim();
                    imaxsize = 0;
                    string = null;
                    if (exportname.length() == 0) {
                        string = "Please specify an export file to write to";
                    } else if (importname.length() != 0 && command.length() == 0) {
                        string = "Please specify the command to execute ACDC";
                    } else if (command.length() != 0 && importname.length() == 0) {
                        string = "Please specify an import file to read from";
                    } else if (maxsize.length() > 0) {
                        try {
                            imaxsize = Integer.parseInt(maxsize);
                            if (imaxsize < 1) {
                                string = "Maxsize size of a cluster must be positive";
                            }
                        }
                        catch (Throwable exception) {
                            string = "Max cluster size '" + maxsize + "' must be an integer";
                        }
                    }
                    if (string == null) break block42;
                } while (this.configure(this.m_ls, string));
                return true;
            }
            if (!exportname.endsWith(".ta")) {
                exportname = String.valueOf(exportname) + ".ta";
            }
            if (!importname.endsWith(".rsf")) {
                importname = String.valueOf(importname) + ".rsf";
            }
            if ((size = selectedBoxes.size()) < 3) {
                this.m_ret = "Too few entities to reasonably cluster";
                return true;
            }
            this.log("Using ACDC to cluster " + size + " items");
            if (!this.write(selectedBoxes, exportname)) {
                return false;
            }
            if (command.length() == 0) {
                this.m_ret = "ACDC output written to file";
                return true;
            }
            s = String.valueOf(command) + " " + exportname + " " + importname;
            int index = this.m_pattern.getSelectedIndex();
            if (index < 0) {
                index = 0;
            }
            s = String.valueOf(s) + " +" + g_patterncode[index];
            index = this.m_filter.getSelectedIndex();
            switch (index) {
                case 0: {
                    s = String.valueOf(s) + " -a";
                    String s1 = ACDCClusterLayout.parameterString(4);
                    s1 = s1.replaceAll("[ \t\n\r\f]", "");
                    s = String.valueOf(s) + s1;
                    break;
                }
                case 2: {
                    s = String.valueOf(s) + " -u";
                }
            }
            if (imaxsize > 0) {
                s = String.valueOf(s) + " -l" + imaxsize;
            }
            if (ACDCClusterLayout.parameterBoolean(4)) {
                s = String.valueOf(s) + " -t";
            }
            if ((index = this.m_debug.getSelectedIndex()) > 0) {
                s = String.valueOf(s) + " -d" + index;
            }
            process = null;
            this.log("Executing [" + s + "]");
            try {
                runtime = Runtime.getRuntime();
                if (runtime != null) break block43;
                this.message("No runtime available");
                return false;
            }
            catch (Exception error) {
                this.log("Exception executing [" + s + "] " + error.getMessage());
                process = null;
                return false;
            }
        }
        process = runtime.exec(s);
        EchoOutput output = new EchoOutput("ACDC Stdout", process.getInputStream());
        new Thread(output).start();
        output = new EchoOutput("ACDC Stderr", process.getErrorStream());
        new Thread(output).start();
        if (!this.waitFor(process)) {
            return false;
        }
        if (!this.read(importname, parent, leaves)) {
            return false;
        }
        this.log("Import loaded");
        if (ACDCClusterLayout.parameterBoolean(1)) {
            try {
                File importfile = new File(importname);
                if (!importfile.delete()) {
                    this.message("Unable to delete '" + importfile + "'");
                } else {
                    this.log("Deleted " + importfile);
                }
            }
            catch (Exception error) {
                this.message("Exception deleting '" + importname + "' " + error.getMessage());
            }
        }
        if (exportname.length() != 0 && ACDCClusterLayout.parameterBoolean(0)) {
            try {
                File exportfile = new File(exportname);
                if (!exportfile.delete()) {
                    this.message("Unable to delete '" + exportfile + "'");
                } else {
                    this.log("Deleted " + exportfile);
                }
            }
            catch (Exception error) {
                this.message("Exception deleting '" + exportname + "' " + error.getMessage());
            }
        }
        this.m_ret = "Graph redrawn using ACDC Cluster Layout";
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        this.m_dg = dg;
        Vector masterBoxes = dg.getClusterGroup();
        if (masterBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance parent = this.parentOfSet(masterBoxes);
        if (parent == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        this.m_ret = "ACDC Cluster layout aborted";
        ls.doLayout1(this, masterBoxes, parent, false);
        return this.m_ret;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        if (!this.configure(this.m_ls)) {
            return;
        }
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class ACDCClusterConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        public ACDCClusterConfigure(ACDCClusterLayout layout, String message) {
            JLabel label;
            super(layout.getLs().getFrame(), String.valueOf(layout.getName()) + " Configuration", true);
            this.m_isok = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            GridLayout gridLayout = new GridLayout(8, 1, 0, 10);
            labelPanel.setLayout(gridLayout);
            JPanel valuePanel = new JPanel();
            gridLayout = new GridLayout(8, 1, 0, 10);
            valuePanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            int i = 0;
            while (i < m_textfield_tags.length) {
                JTextField textfield;
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 60);
                label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                textfield.setFont(font);
                valuePanel.add(textfield);
                ++i;
            }
            label = new JLabel("Apply patterns:", 4);
            label.setFont(bold);
            labelPanel.add(label);
            ACDCClusterLayout.this.m_pattern.setFont(bold);
            valuePanel.add(ACDCClusterLayout.this.m_pattern);
            label = new JLabel("Emit as output: ", 4);
            label.setFont(bold);
            labelPanel.add(label);
            ACDCClusterLayout.this.m_filter.setFont(bold);
            valuePanel.add(ACDCClusterLayout.this.m_filter);
            label = new JLabel("Tracing within ACDC:", 4);
            label.setFont(bold);
            labelPanel.add(label);
            ACDCClusterLayout.this.m_debug.setFont(bold);
            valuePanel.add(ACDCClusterLayout.this.m_debug);
            topPanel.add("West", labelPanel);
            topPanel.add("East", valuePanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            i = 0;
            while (i < m_checkbox_tags.length) {
                JCheckBox checkbox;
                this.m_checkboxes[i] = checkbox = new JCheckBox(m_checkbox_titles[i], m_checkbox_currents[i]);
                checkbox.setFont(font);
                buttonPanel.add(checkbox);
                ++i;
            }
            topPanel.add("South", buttonPanel);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BorderLayout());
            if (message == null) {
                message = ACDCClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            }
            this.m_message = new JLabel(message, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            i = 0;
            while (i < m_button_titles.length) {
                JButton button;
                String string = m_button_titles[i];
                if (string == null) {
                    string = ACDCClusterLayout.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                buttonPanel.add(button);
                ++i;
            }
            bottomPanel.add("North", this.m_message);
            bottomPanel.add("South", buttonPanel);
            contentPane.add("North", topPanel);
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            int state = -1;
            int i = 0;
            while (i < m_button_titles.length) {
                if (source == this.m_buttons[i]) {
                    state = i;
                    break;
                }
                ++i;
            }
            switch (state) {
                case 6: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        ACDCClusterLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        ACDCClusterLayout.m_checkbox_defaults[i] = m_checkbox_resets[i];
                        ++i;
                    }
                }
                case 4: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                        ++i;
                    }
                    ACDCClusterLayout.this.m_pattern.setSelectedIndex(0);
                    ACDCClusterLayout.this.m_filter.setSelectedIndex(0);
                    ACDCClusterLayout.this.m_debug.setSelectedIndex(1);
                    return;
                }
                case 5: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        ACDCClusterLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        ACDCClusterLayout.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                        ++i;
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore ls = ACDCClusterLayout.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(ACDCClusterLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ACDCClusterLayout.this.m_ls.getFrame(), "The ACDC clustering algorithm attempts to cluster nodes on the basis of software\nengineering patterns observed in how entities are connected by edges.  Patterns\nmay be executed in an arbitrary order.  The body pattern places those nodes\nwhose names end in '.c' or '.h' and which have the same prefix in a common cluster.\nThe subgraph pattern clusters nodes based on their dependencies.  The orphan pattern\nplaces orphans not in any cluster in the cluster containing nodes that most frequently\nreference this orphan.\n\nIt is recommended that 'All' output generated by ACDC be emitted.  When this option is\nselected all clusters generated by ACDC may optionally be placed under the named container.\n\nIf 'files' or 'files within modules' is specified ACDC will produce reduced output in which\nmuch of the clustering information computed by ACDC may be discarded before it generates\nany output. Nodes of type 'File'/'cFile' will be output when either option is specified\nwith these nodes only occurring under nodes of type 'cModule'/'Subsystem'/'cSubSystem'\nwhen modules are also requestd.  These two options will result in ACDC producing an empty\noutput file when none of the nodes to be clustered have such a type.  In such cases\nno clustering will be performed by LSEdit, since it will be provided no instructions on\nhow clustering is to be performed.  Even in cases where ACDC does produce output it is\nstressed that while the output from ACDC might suggest that most of the input used to drive\nACDC should be discarded, LSEdit will merely move documented nodes and all their descendants\ninto the specified containment hierachy documented in this output file.\n\nThe gui checkbox instructs ACDC to show its progress graphically as clustering is performed\nand exists primarily as a debugging aid.", "Help", 0);
                    return;
                }
                case 0: {
                    i = 0;
                    while (i < m_textfield_tags.length) {
                        ACDCClusterLayout.m_textfield_currents[i] = this.m_textfields[i].getText();
                        ++i;
                    }
                    i = 0;
                    while (i < m_checkbox_tags.length) {
                        ACDCClusterLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                        ++i;
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }

    class EchoOutput
    implements Runnable {
        InputStream m_inputStream = null;
        String m_source;

        EchoOutput(String source, InputStream inputStream) {
            this.m_inputStream = inputStream;
            this.m_source = source;
        }

        @Override
        public void run() {
            String source = this.m_source;
            try {
                String s;
                InputStreamReader isReader = new InputStreamReader(this.m_inputStream);
                BufferedReader reader = new BufferedReader(isReader);
                while ((s = reader.readLine()) != null) {
                    ACDCClusterLayout.this.log(String.valueOf(source) + ": " + s);
                }
                reader.close();
            }
            catch (Exception error) {
                ACDCClusterLayout.this.log(String.valueOf(source) + " input error: " + error.getMessage());
            }
        }
    }
}

