/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.ColorChooser;
import lsedit.FontCache;
import lsedit.View;

class ViewName
extends JDialog
implements ActionListener {
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_FOREGROUND = 1;
    protected static final int BUTTON_BACKGROUND = 2;
    protected static final String[] m_button_titles = new String[]{"Ok", "Foreground", "Background"};
    protected static final String[] m_button_tips = new String[]{null, "Change foreground color", "Change background color"};
    protected JFrame m_frame;
    protected View m_view;
    protected JTextField m_name;
    protected JTextField m_description;
    protected JCheckBox m_showSelected;
    protected JButton[] m_buttons;

    private void showColor() {
        View view = this.m_view;
        JButton foreground = this.m_buttons[1];
        JButton background = this.m_buttons[2];
        Color color = view.getForeground();
        foreground.setForeground(color);
        background.setForeground(color);
        color = view.getBackground();
        foreground.setBackground(color);
        background.setBackground(color);
        foreground.repaint();
        background.repaint();
    }

    public ViewName(JFrame frame, View view) {
        super(frame, "Enter View Details", true);
        JCheckBox showSelected;
        JTextField textField;
        this.m_frame = frame;
        this.m_view = view;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel centerPanel1 = new JPanel();
        GridLayout gridLayout = new GridLayout(6, 1);
        gridLayout.setVgap(0);
        centerPanel1.setLayout(gridLayout);
        JLabel label = new JLabel("View Name:");
        label.setFont(bold);
        centerPanel1.add(label);
        this.m_name = textField = new JTextField(view.getText(), 32);
        textField.setFont(font);
        centerPanel1.add(textField);
        label = new JLabel("View Description:");
        label.setFont(bold);
        centerPanel1.add(label);
        this.m_description = textField = new JTextField(view.getToolTipText(), 32);
        textField.setFont(font);
        centerPanel1.add(textField);
        this.m_showSelected = showSelected = new JCheckBox("Show Only Selected", false);
        centerPanel1.add(showSelected);
        contentPane.add("Center", centerPanel1);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_buttons = new JButton[m_button_titles.length];
        for (int i = 0; i < m_button_titles.length; ++i) {
            JButton button;
            this.m_buttons[i] = button = new JButton(m_button_titles[i]);
            button.setFont(bold);
            String tip = m_button_tips[i];
            if (tip != null) {
                button.setToolTipText(tip);
            }
            button.addActionListener(this);
            bottomPanel.add(button);
        }
        this.showColor();
        contentPane.add("South", bottomPanel);
        this.pack();
        this.setLocation(20, 20);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        View view = this.m_view;
        Object source = ev.getSource();
        int state = -1;
        for (int i = 0; i < m_button_titles.length; ++i) {
            if (source != this.m_buttons[i]) continue;
            state = i;
            break;
        }
        switch (state) {
            case 1: 
            case 2: {
                ColorChooser colorChooser = new ColorChooser(this.m_frame, "Pick a color", view.getForeground(), false, false);
                Color color = colorChooser.getColor();
                if (state == 1) {
                    view.setForeground(color);
                } else {
                    view.setBackground(color);
                }
                colorChooser.dispose();
                this.showColor();
                return;
            }
        }
        view.setText(this.m_name.getText());
        view.setDescription(this.m_description.getText());
        view.setShowEntities(this.m_showSelected.isSelected());
        this.setVisible(false);
    }
}

