/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.Util;
import lsedit.View;

class ViewMove
extends JDialog
implements ActionListener {
    protected JFrame m_frame;
    protected View m_view;
    protected JTextField m_move;
    protected int m_direction = 0;
    protected int m_offset = -1;

    public ViewMove(JFrame frame, View view) {
        super(frame, "View Move", true);
        JTextField textField;
        this.m_frame = frame;
        this.m_view = view;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new FlowLayout(1, 15, 15));
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JLabel label = new JLabel("Move [+/-]#: ");
        label.setFont(bold);
        contentPane.add(label);
        this.m_move = textField = new JTextField("", 10);
        textField.setFont(font);
        contentPane.add(textField);
        textField.addActionListener(this);
        this.pack();
        this.setLocation(20, 20);
        this.setVisible(true);
    }

    public int getDirection() {
        return this.m_direction;
    }

    public int getOffset() {
        return this.m_offset;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String text = this.m_move.getText();
        if ((text = text.trim()).length() > 0) {
            switch (text.charAt(0)) {
                case '+': {
                    this.m_direction = 1;
                    text = text.substring(1);
                    break;
                }
                case '-': {
                    this.m_direction = -1;
                    text = text.substring(1);
                }
            }
            this.m_offset = Util.parseInt(text, -1);
        }
        this.setVisible(false);
    }
}

