/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.DeleteView;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MoveView;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RenameView;
import lsedit.Ta;
import lsedit.Util;
import lsedit.ViewBox;
import lsedit.ViewMove;
import lsedit.ViewName;

class View
extends JButton
implements ActionListener,
MouseListener {
    protected Diagram m_diagram;
    protected String m_description;
    protected String m_startEntity;
    protected Vector m_entityClasses;
    protected Vector m_relationClasses;
    protected Vector m_showEntities;
    protected Vector m_redBoxEntities;
    protected Option m_options;
    protected boolean m_backgroundSet = false;
    protected static final String escapeChars = "\t\f\u001b\u007f\\\"";

    @Override
    public String toString() {
        return "View " + this.getText() + " " + this.getBounds();
    }

    public View() {
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_backgroundSet = true;
    }

    public Diagram getDiagram() {
        return this.m_diagram;
    }

    public void rename() {
        Diagram diagram = this.m_diagram;
        LandscapeEditorCore ls = diagram.getLs();
        ViewName viewName = new ViewName(ls.getFrame(), this);
        ViewBox viewBox = ls.getViewBox();
        viewName.dispose();
        viewBox.fill();
    }

    public void move() {
        Diagram diagram = this.m_diagram;
        LandscapeEditorCore ls = diagram.getLs();
        ViewMove viewMove = new ViewMove(ls.getFrame(), this);
        int direction = viewMove.getDirection();
        int offset = viewMove.getOffset();
        viewMove.dispose();
        if (offset > 0) {
            diagram.moveView(this, direction, offset);
        }
    }

    public void setDiagram(Diagram value) {
        this.m_diagram = value;
    }

    public void setStartEntity(String value) {
        this.m_startEntity = value;
    }

    public void setDescription(String value) {
        if (value != null) {
            this.setToolTipText(value);
        }
    }

    public void setShowEntities(boolean value) {
        String id;
        EntityInstance e;
        int i;
        int size;
        Vector v;
        Diagram diagram = this.m_diagram;
        this.m_showEntities = null;
        this.m_redBoxEntities = null;
        if (value && (v = diagram.getGroupedEntities()) != null) {
            Vector<String> showEntities;
            size = v.size();
            this.m_showEntities = showEntities = new Vector<String>(size);
            for (i = 0; i < size; ++i) {
                e = (EntityInstance)v.elementAt(i);
                id = e.getId();
                showEntities.addElement(id);
            }
        }
        if ((v = diagram.getRedboxEntities()) != null) {
            Vector redBoxEntities;
            size = v.size();
            this.m_redBoxEntities = redBoxEntities = new Vector(size);
            for (i = 0; i < size; ++i) {
                e = (EntityInstance)v.elementAt(i);
                id = e.getId();
                if (!e.isMarked(32768)) continue;
                this.m_redBoxEntities.addElement(id);
            }
            if (redBoxEntities.size() == 0) {
                this.m_redBoxEntities = null;
            }
        }
    }

    public void getSchemeSnapshot(Ta ta) {
        Vector<EntityClass> v = this.m_entityClasses;
        if (v == null) {
            this.m_entityClasses = v = new Vector<EntityClass>();
        } else {
            v.clear();
        }
        Enumeration en = ta.enumEntityClasses();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            v.add(ec.getView());
        }
        v = this.m_relationClasses;
        if (v == null) {
            this.m_relationClasses = v = new Vector<EntityClass>();
        } else {
            v.clear();
        }
        en = ta.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            v.add((EntityClass)((Object)rc.getView()));
        }
    }

    public void getSnapshot(Ta ta) {
        Option options = Options.getDiagramOptions();
        this.m_options = new Option("View");
        this.m_options.setTo(options);
        this.m_diagram = ta.getDiagram();
        this.m_startEntity = ta.getDrawRoot().getId();
        this.getSchemeSnapshot(ta);
    }

    public void setSnapshot() {
        EntityInstance e1;
        int size;
        RelationClass[] spanningClasses;
        int i;
        Diagram diagram = this.m_diagram;
        LandscapeEditorCore ls = diagram.getLs();
        boolean ret = false;
        if (this.m_options != null) {
            Option options = Options.getDiagramOptions();
            Option oldOptions = new Option("OptionDialog old");
            Option newOptions = this.m_options;
            oldOptions.setTo(options);
            oldOptions.setFontsTo(options);
            options.setTo(newOptions);
            options.setFontsTo(newOptions);
            options.optionsChanged(ls, oldOptions);
            ls.fontsChanged(oldOptions, options);
        }
        Vector v = this.m_entityClasses;
        for (i = 0; i < v.size(); ++i) {
            EntityClass ec = (EntityClass)v.elementAt(i);
            ec.setView();
        }
        v = this.m_relationClasses;
        for (i = 0; i < v.size(); ++i) {
            RelationClass rc = (RelationClass)v.elementAt(i);
            ret |= rc.setView();
        }
        if (ret && (spanningClasses = diagram.computedContainsClasses()) != null) {
            diagram.updateContainsClasses(spanningClasses);
        }
        EntityInstance e = null;
        if (this.m_startEntity != null) {
            e = diagram.getCache(this.m_startEntity);
        }
        if (e == null) {
            e = diagram.getDrawRoot();
        }
        diagram.invalidateVisibleRelationClasses();
        diagram.navigateTo(e, false);
        v = this.m_showEntities;
        if (v != null) {
            diagram.clearHighlighting(false);
            diagram.clearAllRedBoxFlags();
            size = v.size();
            for (i = 0; i < size; ++i) {
                e1 = diagram.getCache((String)v.elementAt(i));
                if (e1 == null) continue;
                diagram.setTracedFlag(e1);
            }
            diagram.setViewActive();
            diagram.clearDrawEntities();
        }
        if ((v = this.m_redBoxEntities) != null) {
            size = v.size();
            for (i = 0; i < size; ++i) {
                e1 = diagram.getCache((String)v.elementAt(i));
                if (e1 == null) continue;
                diagram.setRedBoxFlag(e1);
            }
        }
        diagram.signalDiagramChanged(diagram, 40);
    }

    private static String escape1(String str) {
        StringBuilder buffer = new StringBuilder(str.length() + 120);
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            block0 : switch (c) {
                case 9: 
                case 12: 
                case 27: 
                case 34: 
                case 92: 
                case 127: {
                    buffer.append('\\');
                    switch (c) {
                        case 9: {
                            c = 116;
                            break block0;
                        }
                        case 12: {
                            c = 102;
                            break block0;
                        }
                        case 27: {
                            c = 101;
                            break block0;
                        }
                        case 127: {
                            c = 100;
                        }
                    }
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private static String escape(String str) {
        if (str != null && str.length() > 0) {
            for (int i = 0; i < escapeChars.length(); ++i) {
                if (str.indexOf(escapeChars.charAt(i)) < 0) continue;
                return View.escape1(str);
            }
        }
        return str;
    }

    private static String unescape(String str) {
        if (0 <= str.indexOf(92)) {
            StringBuilder buffer = new StringBuilder(str.length());
            for (int i = 0; i < str.length(); ++i) {
                int c = str.charAt(i);
                if (c == 92 && (c = str.charAt(++i)) != 92 && c != 34) {
                    --i;
                    c = 92;
                }
                buffer.append((char)c);
            }
            return buffer.toString();
        }
        return str;
    }

    public void write(PrintWriter ps) {
        String id;
        int i;
        Vector v;
        Color color;
        Diagram diagram = this.m_diagram;
        CharArrayWriter charArray = null;
        PrintWriter ps1 = null;
        String viewname = this.getText();
        ps.println("");
        if (viewname != null) {
            ps.println(":NAME:");
            ps.println(View.escape(viewname));
        }
        if (this.m_description != null) {
            ps.println(":DESCRIPTION:");
            ps.println(View.escape(this.m_description));
        }
        if (this.m_startEntity != null) {
            ps.println(":STARTENTITY:");
            ps.println(View.escape(this.m_startEntity));
        }
        if ((color = this.getForeground()) != null) {
            ps.println(":FOREGROUND:");
            ps.println(Util.taColor(color));
        }
        if (this.m_backgroundSet && (color = this.getBackground()) != null) {
            ps.println(":BACKGROUND:");
            ps.println(Util.taColor(color));
        }
        if (this.m_entityClasses != null) {
            charArray = new CharArrayWriter(20000);
            ps1 = new PrintWriter(charArray);
            diagram.writeSchemeTuples(ps1, this.m_entityClasses.elements(), this.m_relationClasses.elements(), this.m_relationClasses.elements());
            diagram.writeSchemeAttributes(ps1, this.m_entityClasses.elements(), this.m_relationClasses.elements());
            ps1.flush();
            ps.println(View.escape(charArray.toString()));
            ps.println("SCHEME END :");
        }
        if ((v = this.m_showEntities) != null) {
            ps.println(":SHOW:");
            for (i = 0; i < v.size(); ++i) {
                id = (String)v.elementAt(i);
                ps.println(View.escape(id));
            }
        }
        if ((v = this.m_redBoxEntities) != null) {
            ps.println(":REDBOX:");
            for (i = 0; i < v.size(); ++i) {
                id = (String)v.elementAt(i);
                ps.println(View.escape(id));
            }
        }
        if (this.m_options != null) {
            if (charArray == null) {
                charArray = new CharArrayWriter(10000);
                ps1 = new PrintWriter(charArray);
            } else {
                charArray.reset();
            }
            ps.println(":OPTIONS:");
            this.m_options.saveOptions(ps1, false);
            ps1.flush();
            ps.println(View.escape(charArray.toString()));
        }
        if (ps1 != null) {
            ps1.close();
        }
    }

    public void load(String attributeId, String image) {
        this.m_description = null;
        this.m_startEntity = null;
        this.m_options = null;
        this.m_showEntities = null;
        Diagram diagram = this.m_diagram;
        if (this.m_entityClasses != null) {
            this.m_entityClasses.clear();
        }
        if (this.m_relationClasses != null) {
            this.m_relationClasses.clear();
        }
        image = View.unescape(image);
        int last = image.length() - 1;
        int newstate = -1;
        int state = -1;
        int newstart = 0;
        int start = 0;
        int i = 0;
        while (true) {
            block44: {
                block43: {
                    block42: {
                        if (i < last) break block42;
                        newstate = -2;
                        break block43;
                    }
                    if (image.charAt(i) != '\n') break block44;
                    switch (image.charAt(i + 1)) {
                        case ':': {
                            if (image.substring(i, i + 8).equals("\n:NAME:\n")) {
                                newstart = i + 8;
                                newstate = 0;
                                break;
                            }
                            if (image.substring(i, i + 15).equals("\n:DESCRIPTION:\n")) {
                                newstart = i + 15;
                                newstate = 1;
                                break;
                            }
                            if (image.substring(i, i + 15).equals("\n:STARTENTITY:\n")) {
                                newstart = i + 15;
                                newstate = 2;
                                break;
                            }
                            if (image.substring(i, i + 14).equals("\n:FOREGROUND:\n")) {
                                newstart = i + 14;
                                newstate = 3;
                                break;
                            }
                            if (image.substring(i, i + 14).equals("\n:BACKGROUND:\n")) {
                                newstart = i + 14;
                                newstate = 4;
                                break;
                            }
                            if (image.substring(i, i + 8).equals("\n:SHOW:\n")) {
                                newstart = i + 8;
                                newstate = 6;
                                break;
                            }
                            if (image.substring(i, i + 10).equals("\n:REDBOX:\n")) {
                                newstart = i + 10;
                                newstate = 7;
                                break;
                            }
                            if (!image.substring(i, i + 11).equals("\n:OPTIONS:\n")) break;
                            newstart = i + 11;
                            newstate = 8;
                            this.m_options = new Option("VIEW");
                            break;
                        }
                        case 'S': {
                            if (!image.substring(i, i + 16).equals("\nSCHEME TUPLE :\n")) break;
                            newstart = i;
                            newstate = 5;
                        }
                    }
                }
                if (state >= 0) {
                    String value;
                    if (state < 6) {
                        if (newstate != -1) {
                            value = image.substring(start, i);
                            switch (state) {
                                case 0: {
                                    this.setText(value);
                                    break;
                                }
                                case 1: {
                                    this.m_description = value;
                                    break;
                                }
                                case 2: {
                                    this.m_startEntity = value;
                                    break;
                                }
                                case 3: {
                                    this.setForeground(Util.colorTa(value));
                                    break;
                                }
                                case 4: {
                                    this.setBackground(Util.colorTa(value));
                                    break;
                                }
                                case 5: {
                                    diagram.LoadSchemaForView(this, attributeId, value);
                                    if (this.m_relationClasses == null) break;
                                    Enumeration en = this.m_relationClasses.elements();
                                    while (en.hasMoreElements()) {
                                        RelationClass rc = (RelationClass)en.nextElement();
                                    }
                                    break;
                                }
                            }
                        }
                    } else if (i > start) {
                        String line = image.substring(start, i);
                        start = i + 1;
                        switch (state) {
                            case 6: {
                                if (this.m_showEntities == null) {
                                    this.m_showEntities = new Vector(20);
                                }
                                this.m_showEntities.addElement(line);
                                break;
                            }
                            case 7: {
                                if (this.m_redBoxEntities == null) {
                                    this.m_redBoxEntities = new Vector(20);
                                }
                                this.m_redBoxEntities.addElement(line);
                                break;
                            }
                            case 8: {
                                int eq = line.indexOf(61);
                                if (eq < 0 || eq + 1 >= line.length()) break;
                                String attribute = line.substring(0, eq);
                                attribute = attribute.trim();
                                value = line.substring(eq + 1);
                                value = value.trim();
                                this.m_options.loadOption(attribute, value);
                            }
                        }
                    }
                }
                switch (newstate) {
                    case -2: {
                        return;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        state = newstate;
                        start = newstart;
                        newstate = -1;
                    }
                }
            }
            ++i;
        }
    }

    protected void doRightPopup(MouseEvent ev) {
        Diagram diagram = this.m_diagram;
        LandscapeEditorCore ls = diagram.getLs();
        int x = ev.getX();
        int y = ev.getY();
        JPopupMenu popupMenu = new JPopupMenu("Options");
        JMenuItem mi = new JMenuItem("Rename");
        mi.addActionListener(new RenameView(this));
        popupMenu.add(mi);
        mi = new JMenuItem("Delete");
        mi.addActionListener(new DeleteView(this));
        popupMenu.add(mi);
        mi = new JMenuItem("Move");
        mi.addActionListener(new MoveView(this));
        popupMenu.add(mi);
        FontCache.setMenuTreeFont(popupMenu);
        this.add(popupMenu);
        popupMenu.show(this, x, y);
        this.remove(popupMenu);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.setSnapshot();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isMetaDown()) {
            this.doRightPopup(ev);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }
}

