/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;

class Vertex {
    private int layer = -1;
    private int inDegree = 0;
    private int outDegree = 0;
    private double width;
    private boolean visited = false;
    private boolean isDummy = false;
    private Vector parents = new Vector();
    private Vector children = new Vector();

    public Vertex(double boxWidth) {
        this.width = boxWidth;
    }

    public void addChild(Integer child) {
        if (this.children.indexOf(child) == -1) {
            this.children.addElement(child);
            ++this.outDegree;
        }
    }

    public boolean removeChild(Integer child) {
        return this.children.removeElement(child);
    }

    public void replaceChild(Integer oldChild, Integer newChild) {
        try {
            this.children.setElementAt(newChild, this.children.indexOf(oldChild));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.exit(-1);
        }
    }

    public void addParent(Integer parent) {
        if (this.parents.indexOf(parent) == -1) {
            this.parents.addElement(parent);
            ++this.inDegree;
        }
    }

    public boolean removeParent(Integer parent) {
        return this.parents.removeElement(parent);
    }

    public void replaceParent(Integer oldParent, Integer newParent) {
        try {
            this.parents.setElementAt(newParent, this.parents.indexOf(oldParent));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("array problem");
            System.exit(-1);
        }
    }

    public void setLayer(int newLayer) {
        this.layer = newLayer;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setDummy() {
        this.isDummy = true;
    }

    public double getWidth() {
        return this.width;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    public void decInDegree() {
        --this.inDegree;
    }

    public void decOutDegree() {
        --this.outDegree;
    }

    public void setVisited() {
        this.visited = true;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public Vector getParents() {
        return this.parents;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void print() {
        System.out.print("Parents: ");
        Enumeration e = this.parents.elements();
        while (e.hasMoreElements()) {
            System.out.print(e.nextElement() + " ");
        }
        System.out.println();
        System.out.print("Children: ");
        e = this.children.elements();
        while (e.hasMoreElements()) {
            System.out.print(e.nextElement() + " ");
        }
        System.out.println();
        System.out.println("Layer " + this.layer);
    }
}

