/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.AttributeCache;
import lsedit.Diagram;

public class Version {
    public static final int MAJOR = 7;
    public static final int MINOR = 4;
    public static final int BUILD = 0;
    public static final String COMPILED = "December 1st, 2011";

    public static String Number() {
        return "7.4.0";
    }

    public static String formatNumber(long l) {
        String val = Long.toString(l);
        String ret = "";
        int lth = val.length();
        int i = 0;
        while (true) {
            ret = ret + val.charAt(i);
            if (++i >= lth) break;
            if ((lth - i) % 3 != 0) continue;
            ret = ret + ',';
        }
        return ret;
    }

    public static int InternalNumber() {
        return 7004000;
    }

    public static String CompileDate() {
        return "Compiled: December 1st, 2011";
    }

    public static String Detail(String property) {
        String result;
        try {
            result = System.getProperty(property);
        }
        catch (Exception e) {
            result = "**Denied**";
            System.out.println("System.getProperty(\"" + property + "\"): " + e.getMessage());
        }
        return result;
    }

    public static String authorsAndCopyright() {
        String result = Version.Number() + "\n\n" + Version.CompileDate() + "\n" + "Developed at the University of Waterloo under the supervision of Prof. Ric Holt\n" + "Original Author: Gary Farmaner (Rewritten in Swing by Ian Davis)\n";
        return result;
    }

    public static String Details(Diagram diagram) {
        String result = Version.authorsAndCopyright() + "\nRight click menu items to request context sensitive help specific to their action.\n\n";
        try {
            result = result + "LSEDIT is part of the Software Landscape tool suite\n licensed to CTBTO by Telepresence Systems, Inc. (www.telepres.com)\n under contact No. 01/2/20/163\n\nRun Time Engine: " + Version.Detail("java.vendor") + " " + Version.Detail("java.version") + "\n" + "Virtual Machine: " + Version.Detail("java.vm.name") + " " + Version.Detail("java.vm.version") + "\n" + "V/M Vendor: " + Version.Detail("java.vm.vendor") + "\n" + "Operating System: '" + Version.Detail("os.name") + "' " + Version.Detail("os.arch") + " " + Version.Detail("os.version") + "\n" + "Patch level: " + Version.Detail("sun.os.patch.level") + "\n" + "User id: " + Version.Detail("user.name") + "\n" + "Directory: " + Version.Detail("user.dir") + "\n";
            Runtime r = Runtime.getRuntime();
            result = result + "Memory: " + Version.formatNumber(r.totalMemory()) + " - Free: " + Version.formatNumber(r.freeMemory()) + " = " + Version.formatNumber(r.totalMemory() - r.freeMemory()) + " Max: " + Version.formatNumber(r.maxMemory()) + "\n";
            r.gc();
            result = result + "Memory: " + Version.formatNumber(r.totalMemory()) + " - Free: " + Version.formatNumber(r.freeMemory()) + " = " + Version.formatNumber(r.totalMemory() - r.freeMemory()) + " Max: " + Version.formatNumber(r.maxMemory()) + "\n";
            if (diagram != null) {
                result = result + "Entities: " + Version.formatNumber(diagram.getNumberEntitiesLoaded()) + " Relations: " + Version.formatNumber(diagram.getNumberRelationsLoaded()) + " Attributes: " + Version.formatNumber(AttributeCache.actualAttributes()) + " (" + Version.formatNumber(AttributeCache.requestedAttributes()) + ")\n";
                result = result + diagram.parameterDetails();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

