/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import lsedit.ColorCache;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LineWalker;
import lsedit.MsgOut;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.ScreenPoint;
import lsedit.StringCache;
import lsedit.Version;

public class Util {
    public static final int LINE_STYLE_NORMAL = 0;
    public static final int LINE_STYLE_DASHED = 1;
    public static final int LINE_STYLE_DOTTED = 2;
    public static final int LINE_STYLE_INSCRIBED = 3;
    public static final int LINE_STYLE_UNDEFINED = 7;
    public static final String[] lineStyleName = new String[]{"Normal", "Dashed", "Dotted", "Inscribed"};
    protected static final int DASH_LEN = 4;
    protected static final int DASH_GAP = 3;
    protected static final int DOT_LEN = 0;
    protected static final int DOT_GAP = 4;
    protected static final int GAP = 5;
    protected static final int INSET = 12;
    protected static final int OUTSET = 5;
    protected static final int DOT_LEN_REG = 0;
    protected static final int DOT_LEN_PRNT = 1;

    public static String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Date date = new Date();
        String ret = dateFormat.format(date);
        date = null;
        return ret;
    }

    public static double degrees(double w, double h) {
        if (h == 0.0) {
            if (w < 0.0) {
                return 180.0;
            }
            return 0.0;
        }
        if (w == 0.0) {
            if (h < 0.0) {
                return 270.0;
            }
            return 90.0;
        }
        double rotate = w >= 0.0 ? (h >= 0.0 ? 0.0 : 360.0) : 180.0;
        return rotate + Math.atan(h / w) * 180.0 / Math.PI;
    }

    public static void beep() {
        System.out.print("\u0007");
        System.out.flush();
    }

    public static String formatFraction(double val) {
        if (val >= 1.0) {
            if (val == 1.0) {
                return "1";
            }
            return "" + val;
        }
        if (val <= 0.0) {
            if (val == 0.0) {
                return "0";
            }
            return "" + val;
        }
        int e1 = (int)(val * 10.0);
        int e2 = (int)(val * 100.0) - e1 * 10;
        if (e2 == 0) {
            return "0." + e1;
        }
        return "0." + e1 + e2;
    }

    public static boolean isBlank(String s) {
        int i = s.length();
        while (i > 0) {
            if (s.charAt(--i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static String formFileName(String dir, String name) {
        if (dir == null || dir.length() == 0) {
            return name;
        }
        String separator = Version.Detail("file.separator");
        if (separator == null || separator.length() == 0) {
            separator = "/";
        }
        return dir + separator + name;
    }

    public static String getLineStyleName(int style) {
        if (style < 0 || style >= lineStyleName.length) {
            return "";
        }
        return lineStyleName[style];
    }

    public static boolean drawStringClipped(Graphics g, String str, double x, double y, double width, double height, boolean centered, boolean underlined, boolean invertBackground) {
        double xpos;
        String dstr;
        int pos;
        FontMetrics fm = g.getFontMetrics();
        int len = str.length();
        if ((double)fm.stringWidth(str) > width) {
            for (pos = len - 1; pos >= 0; --pos) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!((double)fm.stringWidth(stringBuilder.append(str.substring(0, pos)).append("...").toString()) > width)) break;
            }
        }
        if (pos < 0) {
            return false;
        }
        if (pos == len - 1) {
            dstr = str;
            double sw = fm.stringWidth(str);
            xpos = centered ? x + width / 2.0 - sw / 2.0 : x;
        } else {
            dstr = str.substring(0, pos) + "...";
            xpos = x;
        }
        int x1 = (int)(xpos + 0.5);
        int y1 = centered ? (int)(y + height / 2.0 + (double)(fm.getHeight() / 2) + 0.5) : (int)(y + (double)fm.getHeight() + 0.5);
        if (invertBackground) {
            Color color = g.getColor();
            int height1 = fm.getHeight();
            g.setColor(ColorCache.getInverse(color.getRGB()));
            g.fillRect(x1, y1 - height1, fm.stringWidth(dstr), height1);
            g.setColor(color);
        }
        g.drawString(dstr, x1, y1);
        if (underlined) {
            int sw = fm.stringWidth(dstr);
            g.drawLine(x1, y1, x1 + sw, y1);
        }
        return pos == len - 1;
    }

    public static boolean drawStringBottomClipped(Graphics g, String str, double x, double y, double width, double height, boolean centered, boolean underlined, boolean invertBackground) {
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight() + 3;
        return Util.drawStringClipped(g, str, x, y + height - (double)fontHeight, width, fontHeight, centered, underlined, invertBackground);
    }

    protected static int longestSubStr(String str, FontMetrics fm, int width) {
        int pos = str.indexOf(10);
        if (pos > 0) {
            str = str.substring(0, pos);
        }
        if (fm.stringWidth(str) <= width) {
            return str.length();
        }
        int lpos = -1;
        while ((pos = str.indexOf(32, lpos + 1)) >= 0 && fm.stringWidth(str.substring(0, pos)) <= width) {
            lpos = pos;
        }
        if (lpos == -1) {
            return str.length();
        }
        return lpos;
    }

    public static Dimension stringWrappedDim(Graphics g, String str) {
        int h;
        FontMetrics fm = g.getFontMetrics();
        int w = 0;
        int lines = 0;
        int lth = str.length();
        int start = 0;
        while (start < lth) {
            int w1;
            int toend = str.indexOf(10, start);
            if (toend < 0) {
                toend = lth;
            }
            if ((w1 = fm.stringWidth(str.substring(start, toend))) > w) {
                w = w1;
            }
            ++lines;
            start = toend + 1;
        }
        if (lines == 0) {
            h = 0;
        } else {
            int fmh = fm.getHeight();
            h = (3 * lines + 1) * fmh / 4;
        }
        return new Dimension(w, h);
    }

    public static boolean drawStringWrapped(Graphics g, String str, double x, double y, double width, double height, boolean centered, boolean underlined, boolean invertBackground) {
        int y1;
        int x1;
        double xpos;
        String dstr;
        Enumeration en;
        double ypos;
        int pos;
        FontMetrics fm = g.getFontMetrics();
        Vector<String> strs = new Vector<String>();
        if (str.indexOf(32) < 0 && str.indexOf(10) < 0) {
            return Util.drawStringClipped(g, str, x, y, width, height, centered, underlined, invertBackground);
        }
        while (true) {
            pos = Util.longestSubStr(str, fm, (int)width);
            strs.addElement(str.substring(0, pos));
            if (pos == str.length()) break;
            str = str.substring(pos + 1);
        }
        int fh = fm.getHeight() * 3 / 4;
        int ht = strs.size() * fh;
        double d = ypos = centered ? y + (height - (double)ht) / 2.0 + (double)fh : y + (double)fh;
        if (invertBackground) {
            double ypos1 = ypos;
            int miny = Integer.MAX_VALUE;
            int minx = Integer.MAX_VALUE;
            int maxy = 0;
            int maxx = 0;
            en = strs.elements();
            while (en.hasMoreElements()) {
                str = (String)en.nextElement();
                int len = str.length();
                for (pos = len - 1; pos >= 0 && (double)fm.stringWidth(str.substring(0, pos)) > width; --pos) {
                }
                if (pos < 0) continue;
                if (pos == len - 1) {
                    dstr = str;
                    double sw = fm.stringWidth(str);
                    xpos = centered ? x + width / 2.0 - sw / 2.0 : x;
                } else {
                    dstr = str.substring(0, pos);
                    xpos = x;
                }
                x1 = (int)(xpos + 0.5);
                y1 = (int)(ypos1 + 0.5);
                if (x1 < minx) {
                    minx = x1;
                }
                if (y1 < miny) {
                    miny = y1;
                }
                if ((x1 += fm.stringWidth(dstr)) > maxx) {
                    maxx = x1;
                }
                if (y1 > maxy) {
                    maxy = y1;
                }
                ypos1 += (double)fh;
            }
            if (minx <= maxx) {
                Color color = g.getColor();
                g.setColor(ColorCache.getInverse(color.getRGB()));
                g.fillRect(minx, miny -= fh, maxx - minx, maxy - miny);
                g.setColor(color);
            }
        }
        en = strs.elements();
        while (en.hasMoreElements()) {
            str = (String)en.nextElement();
            int len = str.length();
            for (pos = len - 1; pos >= 0 && (double)fm.stringWidth(str.substring(0, pos)) > width; --pos) {
            }
            if (pos < 0) continue;
            if (pos == len - 1) {
                dstr = str;
                double sw = fm.stringWidth(str);
                xpos = centered ? x + width / 2.0 - sw / 2.0 : x;
            } else {
                dstr = str.substring(0, pos);
                xpos = x;
            }
            x1 = (int)(xpos + 0.5);
            y1 = (int)(ypos + 0.5);
            g.drawString(dstr, x1, y1);
            if (underlined) {
                int sw = fm.stringWidth(dstr);
                g.drawLine(x1, y1, x1 + sw, y1);
            }
            ypos += (double)fh;
        }
        return true;
    }

    public static boolean isHTTP(String path) {
        return path.length() > 7 && (path.substring(0, 7).equals("http://") || path.substring(0, 7).equals("HTTP://"));
    }

    public static String prefixOf(String name) {
        int ind = name.lastIndexOf(46);
        if (ind >= 0) {
            return name.substring(0, ind);
        }
        return name;
    }

    public static boolean defined(short val) {
        return val != Short.MIN_VALUE;
    }

    public static short undefined() {
        return Short.MIN_VALUE;
    }

    public static double shortToRelative(short value) {
        if (!Util.defined(value)) {
            return -1.0;
        }
        return 0.5 + (double)value / 65534.0;
    }

    public static short relativeToShort(double value) {
        if (value < 0.0 || value > 1.0) {
            return Util.undefined();
        }
        return (short)((value - 0.5) * 65534.0);
    }

    public static short parseShort(String str) {
        int val;
        try {
            val = Short.parseShort(str);
        }
        catch (Exception e) {
            System.out.println("Can't convert '" + str + "' to a short");
            val = Short.MIN_VALUE;
        }
        return (short)val;
    }

    public static double parseDouble(String str, double default0) {
        double val;
        try {
            val = Double.parseDouble(str);
        }
        catch (Exception e) {
            System.out.println("Can't convert '" + str + "' to a double");
            val = default0;
        }
        return val;
    }

    public static double parseDouble(String str) {
        return Util.parseDouble(str, 0.0);
    }

    public static int parseInt(String str, int default0) {
        int val;
        try {
            val = Integer.parseInt(str);
        }
        catch (Exception e) {
            System.out.println("Can't convert '" + str + "' to an int");
            val = default0;
        }
        return val;
    }

    public static int parseInt(String str) {
        return Util.parseInt(str, 0);
    }

    public static boolean parseBoolean(String str) {
        return str.equals("true");
    }

    public static short parseRelativeValue(String str) {
        if (str.indexOf(46) >= 0) {
            double dval = Util.parseDouble(str, -1.0);
            return Util.relativeToShort(dval);
        }
        return Util.parseShort(str);
    }

    public static String quoted(String str) {
        if (str.indexOf(32) >= 0) {
            return "\"" + str + "\"";
        }
        return str;
    }

    protected static String doExpand(String src, String id, LandscapeEditorCore ls) {
        boolean found;
        String link = "";
        int pos = 0;
        int len = src.length();
        MsgOut.dprintln("Expand: " + src);
        do {
            int ind;
            boolean bl = found = ((ind = src.indexOf(36, pos)) == 0 || ind > 0 && src.charAt(ind - 1) != '\\') && ind + 1 < len;
            if (!found) continue;
            int endInd = src.indexOf(36, ind + 1);
            if (endInd < ind) {
                MsgOut.println("Missing delimitting '$' in expansion variable");
                return null;
            }
            link = link + src.substring(pos, ind);
            String var = src.substring(ind + 1, endInd);
            if (var.equals("ID")) {
                link = link + Util.quoted(id);
            } else if (var.equals("IDPREFIX")) {
                int dind = id.lastIndexOf(46);
                link = dind >= 0 ? link + Util.quoted(id.substring(0, dind)) : link + Util.quoted(id);
            } else if (var.equals("IDSUFFIX")) {
                int dind = id.lastIndexOf(46);
                if (dind >= 0) {
                    link = link + id.substring(dind + 1);
                }
            } else if (var.equals("DGDIR")) {
                String path = ls.getDiagram().getAbsolutePath();
                String dir = Util.dirFromPath(path);
                link = link + dir;
            } else if (var.equals("DGSUFFIX")) {
                String path = ls.getDiagram().getAbsolutePath();
                String name = Util.nameFromPath(path);
                int dind = name.indexOf(46);
                if (dind >= 0) {
                    link = link + name.substring(dind + 1);
                }
            } else {
                String value = ls.getParameter(var);
                if (value != null) {
                    link = link + Util.quoted(value);
                } else {
                    MsgOut.println("Parameter not found: '" + var + "'");
                    return "";
                }
            }
            pos = endInd + 1;
        } while (found && pos < len);
        if (pos < len) {
            link = link + src.substring(pos);
        }
        MsgOut.dprintln("Result: " + link);
        return link;
    }

    public static String expand(String src, String id, LandscapeEditorCore ls) {
        String nstr1;
        String nstr2 = Util.doExpand(src, id, ls);
        while (!(nstr1 = nstr2).equals(nstr2 = Util.doExpand(nstr1, id, ls))) {
        }
        return nstr1;
    }

    public static String expand(String src, LandscapeEditorCore ls) {
        return Util.expand(src, "", ls);
    }

    public static JFrame getFrame(Component c) {
        while (c != null) {
            if (c instanceof JFrame) {
                return (JFrame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static String dirFromPath(String path) {
        int ind2;
        int ind1 = path.lastIndexOf(47);
        if (ind1 > (ind2 = path.lastIndexOf(92))) {
            return path.substring(0, ind1);
        }
        if (ind2 > ind1) {
            return path.substring(0, ind2);
        }
        return "";
    }

    public static String nameFromPath(String path) {
        int ind2;
        int ind1 = path.lastIndexOf(47);
        if (ind1 > (ind2 = path.lastIndexOf(92))) {
            return path.substring(ind1 + 1);
        }
        if (ind2 > ind1) {
            return path.substring(ind2 + 1);
        }
        return path;
    }

    public static boolean isBlack(Color c) {
        if (c == Color.black) {
            return true;
        }
        if (c.getRed() != 0) {
            return false;
        }
        if (c.getGreen() != 0) {
            return false;
        }
        return c.getBlue() == 0;
    }

    protected static void drawLine(Graphics g, LineWalker lw) {
        ScreenPoint p1 = new ScreenPoint(0.0, 0.0);
        ScreenPoint p2 = new ScreenPoint(0.0, 0.0);
        while (lw.morePoints()) {
            lw.nextPoints(p1, p2);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    protected static void drawInscribedLine(Graphics g, int x1, int y1, int x2, int y2) {
        Color cc = g.getColor();
        g.setColor(Color.gray);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(Color.white);
        if (x1 == x2) {
            g.drawLine(x1 + 1, y1, x2 + 1, y2);
        } else {
            g.drawLine(x1, y1 + 1, x2, y2 + 1);
        }
        g.setColor(cc);
    }

    public static void drawTailPoint(Graphics g, int x, int y) {
        int hb = 3;
        g.fillOval(x - hb, y - hb, hb * 2, hb * 2);
    }

    public static void drawOutlineBox(Graphics g, int x, int y, int width, int height) {
        g.drawLine(x, y, x + width, y);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x + 1, y + height - 1);
        g.drawLine(x, y + height, x, y);
        g.setColor(Color.white);
        g.drawLine(x + 1, y + 1, x + width, y + 1);
        g.drawLine(x + width, y + 1, x + width, y + height);
        g.drawLine(x + width, y + height, x + 1, y + height);
        g.drawLine(x + 1, y + height, x + 1, y + 1);
    }

    public static void drawOutlineRedBox(Graphics g, int x, int y, int width, int height) {
        Color color = Color.red.darker();
        Color rev = ColorCache.getInverse(color.getRGB());
        int x1 = x + width;
        int y1 = y + height;
        int xmax = x + 4;
        int ymax = y + 4;
        if (xmax > x1) {
            xmax = x1;
        }
        if (ymax > y1) {
            ymax = y1;
        }
        while (x <= xmax && y <= ymax) {
            g.setColor(color);
            g.drawLine(x, y, x, y1);
            g.drawLine(x1, y, x1, y1);
            g.setColor(rev);
            g.drawLine(x, y, x1, y);
            g.drawLine(x, y1, x1, y1);
            ++x;
            --x1;
            ++y;
            --y1;
        }
    }

    public static void drawGroupBox(Graphics g, int x, int y, int w, int h, String label) {
        g.setFont(EntityInstance.getSmallFont());
        FontMetrics fm = g.getFontMetrics();
        int len = label != null ? fm.stringWidth(label) : 0;
        int ht = fm.getHeight();
        int inset = Math.min(12, w / 12);
        if (w < inset + 5) {
            Util.drawOutlineBox(g, x, y, w, h);
        } else {
            int x2 = len + 10 > w - inset - 5 ? x + w - 5 : x + inset + len + 10;
            g.drawLine(x, y + h, x, y);
            g.drawLine(x, y, x + inset, y);
            g.drawLine(x2, y, x + w, y);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + 1, y + h - 1);
            g.setColor(Color.white);
            g.drawLine(x + 1, y + h, x + 1, y + 1);
            g.drawLine(x + 1, y + 1, x + inset, y + 1);
            g.drawLine(x2, y + 1, x + w, y + 1);
            g.drawLine(x + w, y + 1, x + w, y + h);
            g.drawLine(x + w, y + h, x + 1, y + h);
        }
    }

    public static void drawGroupBoxLabel(Graphics g, int x, int y, int w, String label) {
        Option option = Options.getDiagramOptions();
        g.setFont(EntityInstance.getSmallFont());
        FontMetrics fm = g.getFontMetrics();
        int len = fm.stringWidth(label);
        int ht = fm.getHeight();
        int inset = Math.min(12, w / 12);
        if (w >= inset + 5) {
            int x2 = len + 10 > w - inset - 5 ? x + w - 5 : x + inset + len + 10;
            Util.drawStringClipped(g, label, x + inset + 5, y - ht * 2 / 3, x2 - x - 10, 100.0, false, false, option.isLabelInvertBackground());
        }
    }

    public static String mungeName(String name) {
        String tmp = name.replace(' ', '_');
        tmp = tmp.replace('/', '-');
        tmp = tmp.replace(',', '_');
        return tmp.replace('\\', '-');
    }

    public static String hashEdge(RelationClass rc, EntityInstance src, EntityInstance dst) {
        return src.getId() + rc.getId() + dst.getId();
    }

    public static int round(double val) {
        return (int)(val + 0.5);
    }

    protected static int getDotLen(Graphics g) {
        return 0;
    }

    public static void drawSegment(Graphics g, int style, int x1, int y1, int x2, int y2) {
        int x = 0;
        int y = 0;
        int xshift = 0;
        int yshift = 0;
        int linewidth = Options.getLineWidth();
        for (int i = 0; i < linewidth; ++i) {
            switch (style) {
                case 0: {
                    g.drawLine(x1 + x, y1 + y, x2 + x, y2 + y);
                    break;
                }
                case 2: {
                    LineWalker lw = new LineWalker(x1 + x, y1 + y, x2 + x, y2 + y, Util.getDotLen(g), 4);
                    Util.drawLine(g, lw);
                    break;
                }
                case 1: {
                    LineWalker lw = new LineWalker(x1 + x, y1 + y, x2 + x, y2 + y, 4, 3);
                    Util.drawLine(g, lw);
                    break;
                }
                case 3: {
                    Util.drawInscribedLine(g, x1, y1, x2, y2);
                }
            }
            x = -x;
            y = -y;
            if ((i & 1) != 0) continue;
            if (i == 0) {
                int w = x2 - x1;
                int h = y2 - y1;
                if (w <= 0 && h <= 0) {
                    w = -w;
                    h = -h;
                }
                if (w >= 0 && h >= 0) {
                    if (2 * h >= w) {
                        xshift = 1;
                    }
                    if (2 * w >= h) {
                        yshift = -1;
                    }
                } else {
                    if (w < 0) {
                        w = -w;
                    }
                    if (h < 0) {
                        h = -h;
                    }
                    if (2 * h >= w) {
                        xshift = 1;
                    }
                    if (2 * w >= h) {
                        yshift = 1;
                    }
                }
            }
            x += xshift;
            y += yshift;
        }
    }

    public static double getArrow(int srcX, int srcY, int dstX, int dstY, int[] x, int[] y, int arrowWeight) {
        double len;
        int dx = srcX - dstX;
        int dy = srcY - dstY;
        if (dx == 0 && dy == 0) {
            len = 0.0;
        } else {
            Option option = Options.getDiagramOptions();
            double arrowLength = option.getArrowLength();
            double arrowArc = option.getArrowArc();
            double theta = Math.atan2(dy, dx);
            len = Math.sqrt(dx * dx + dy * dy);
            while (arrowWeight > 1) {
                arrowLength += 4.0;
                arrowWeight >>= 1;
            }
            arrowLength = Math.min(arrowLength, len);
            double ax = (double)dstX + arrowLength * Math.cos(theta - arrowArc);
            double ay = (double)dstY + arrowLength * Math.sin(theta - arrowArc);
            double bx = (double)dstX + arrowLength * Math.cos(theta + arrowArc);
            double by = (double)dstY + arrowLength * Math.sin(theta + arrowArc);
            x[0] = dstX;
            y[0] = dstY;
            x[1] = (int)Math.round(ax);
            y[1] = (int)Math.round(ay);
            x[2] = (int)Math.round(bx);
            y[2] = (int)Math.round(by);
            len = arrowLength / len;
        }
        return len;
    }

    public static double drawArrowHead(Graphics g, int x1, int y1, int x2, int y2, int arrowWeight) {
        int[] x = new int[3];
        int[] y = new int[3];
        double len = Util.getArrow(x1, y1, x2, y2, x, y, arrowWeight);
        if (len != 0.0) {
            Option option = Options.getDiagramOptions();
            if (option.isFillArrowhead()) {
                g.fillPolygon(x, y, 3);
            } else {
                g.drawPolygon(x, y, 3);
            }
        }
        return len;
    }

    public static String encodedURLname(String name) {
        boolean first = true;
        String ret = "";
        int lth = name.length();
        for (int i = 0; i < lth; ++i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!first) {
                    c = (char)(c + 32);
                }
            } else if (c >= 'a' && c <= 'z') {
                if (first) {
                    c = (char)(c - 32);
                }
            } else if (c < '0' || c > '9') {
                first = true;
                continue;
            }
            ret = ret + c;
            first = false;
        }
        return ret;
    }

    public static String taColor(Color color1) {
        int red = color1.getRed();
        int green = color1.getGreen();
        int blue = color1.getBlue();
        int alpha = color1.getAlpha();
        String ret = "(" + red + " " + green + " " + blue;
        if (alpha != 255) {
            ret = ret + " " + alpha;
        }
        ret = ret + ")";
        return StringCache.get(ret);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Color colorTa(String string) {
        int state = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        block25: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '(': {
                            state = 1;
                        }
                        case ' ': {
                            continue block25;
                        }
                    }
                    break;
                }
                case 1: {
                    if (c == ' ') continue block25;
                    if (c < '0' || c > '9') break;
                    state = 2;
                }
                case 2: {
                    if (c >= '0' && c <= '9') {
                        r = r * 10 + (c - 48);
                        continue block25;
                    }
                    if (r > 255) break;
                    state = 3;
                }
                case 3: {
                    if (c == ' ') continue block25;
                    if (c < '0' || c > '9') break;
                    state = 4;
                }
                case 4: {
                    if (c >= '0' && c <= '9') {
                        g = g * 10 + (c - 48);
                        continue block25;
                    }
                    if (g > 255) break;
                    state = 5;
                }
                case 5: {
                    if (c == ' ') continue block25;
                    if (c < '0' || c > '9') break;
                    state = 6;
                }
                case 6: {
                    if (c >= '0' && c <= '9') {
                        b = b * 10 + (c - 48);
                        continue block25;
                    }
                    if (b > 255) break;
                    state = 7;
                }
                case 7: {
                    switch (c) {
                        case ')': {
                            state = 10;
                        }
                        case ' ': {
                            continue block25;
                        }
                        default: {
                            if (c < '0' || c > '9') break block0;
                            a = 0;
                            state = 8;
                        }
                    }
                }
                case 8: {
                    if (c >= '0' && c <= '9') {
                        a = a * 10 + (c - 48);
                        continue block25;
                    }
                    if (a > 255) break;
                    state = 9;
                }
                case 9: {
                    switch (c) {
                        case ')': {
                            state = 10;
                        }
                        case ' ': {
                            continue block25;
                        }
                    }
                    break;
                }
                case 10: {
                    if (c == ' ') continue block25;
                }
            }
            return null;
        }
        if (state == 10) {
            return ColorCache.get(r, g, b, a);
        }
        return null;
    }
}

