/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyCompoundEdit;
import lsedit.MyMenuItem;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;
import lsedit.Options;
import lsedit.TaListener;
import lsedit.TabBox;
import lsedit.ToolBarEventHandler;

public final class UndoBox
extends TabBox
implements ChangeListener,
TaListener,
ToolBarEventHandler,
MouseListener,
MouseMotionListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    public static Dimension m_preferredSize = new Dimension(0, 0);
    public static Dimension m_size = new Dimension(0, 0);
    public static final String m_helpStr = "This box shows the history of updates made in the current diagram.";
    protected int m_style;
    protected int m_over;
    protected static Font m_textFont = null;
    protected static FontMetrics m_fm = null;
    public static int m_fontheight = 0;
    public static int m_baseline = 0;

    @Override
    public void paintComponent(Graphics g) {
        int fontheight = m_fontheight;
        int baseline = m_baseline;
        int height = fontheight;
        Vector v = this.m_ls.getEdits();
        if (v != null) {
            UndoableEdit editToBeRedone = this.m_ls.getEditToBeRedone();
            int at = this.m_over;
            g.setFont(m_textFont);
            g.setColor(Color.BLACK);
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                Color color;
                UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                if (undoableEdit == editToBeRedone) {
                    g.setColor(Color.RED);
                }
                if (at == 0 && this.m_style != 0) {
                    color = g.getColor();
                    g.setColor(Color.BLACK);
                    g.draw3DRect(0, height, UndoBox.m_preferredSize.width - 1, fontheight - 2, this.m_style == 1);
                    g.setColor(color);
                }
                if (undoableEdit instanceof MyPaintableUndoableEdit) {
                    ((MyPaintableUndoableEdit)undoableEdit).paintComponent(g, 5, height);
                } else if (undoableEdit instanceof MyCompoundEdit) {
                    color = g.getColor();
                    g.setColor(Color.WHITE);
                    g.fill3DRect(0, height, UndoBox.m_preferredSize.width - 1, fontheight - 2, at == 0 && this.m_style == 1);
                    g.setColor(color);
                    g.drawString(undoableEdit.getPresentationName(), 5, height + baseline);
                } else {
                    g.drawString(undoableEdit.getPresentationName(), 5, height + baseline);
                }
                height += fontheight;
                --at;
            }
        }
    }

    public UndoBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Undo", m_helpStr);
        Font textFont = m_textFont;
        if (textFont == null) {
            textFont = Options.getTargetFont(13);
            this.textFontChanged(textFont);
        }
        tabbedPane.addChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static void setTextFont(Font font) {
        if (font != m_textFont) {
            m_textFont = font;
            m_fm = null;
        }
    }

    public void textFontChanged(Font font) {
        FontMetrics fm;
        UndoBox.setTextFont(font);
        m_fm = fm = this.getFontMetrics(font);
        m_fontheight = fm.getHeight();
        m_baseline = m_fontheight - fm.getDescent();
        this.fill();
    }

    @Override
    public boolean isPreferredSizeSet() {
        return UndoBox.m_preferredSize.height > 0;
    }

    @Override
    public Dimension getPreferredSize() {
        return m_preferredSize;
    }

    public void fill() {
        if (this.isActive()) {
            this.repaint();
        }
    }

    public void setNewPreferredSize(Vector edits, UndoableEdit lastEdit) {
        int fontheight = m_fontheight;
        int width = 10;
        int height = fontheight + 15;
        if (lastEdit instanceof MyPaintableUndoableEdit) {
            width += ((MyPaintableUndoableEdit)lastEdit).getPreferredWidth();
        } else {
            FontMetrics fm = this.getFontMetrics(m_textFont);
            width += fm.stringWidth(lastEdit.getPresentationName());
        }
        if (width > UndoBox.m_preferredSize.width) {
            UndoBox.m_preferredSize.width = width;
        }
        if ((height += fontheight * edits.size()) > UndoBox.m_preferredSize.height) {
            UndoBox.m_preferredSize.height = height;
        }
        this.m_scrollPane.revalidate();
        this.fill();
    }

    protected void mouseAt(int y) {
        int style;
        int over = y / m_fontheight - 1;
        if (over < 0) {
            style = 0;
            over = -1;
        } else {
            int max = this.m_ls.countEdits();
            if (over >= max) {
                style = 0;
                over = max;
            } else {
                style = 1;
            }
        }
        if (style != this.m_style || over != this.m_over) {
            this.m_style = style;
            this.m_over = over;
            this.repaint();
        }
    }

    public void invertUndo() {
        Diagram diagram = this.m_ls.getDiagram();
        boolean undo = diagram.undoEnabled();
        if (undo && !this.m_ls.clearUndoCache()) {
            return;
        }
        diagram.setUndoEnabled(!undo);
    }

    public void dumpEdits() {
        LandscapeEditorCore ls = this.m_ls;
        String filename = ls.filePrompt("Save Edit History", "LSedits.txt", 2, null);
        if (filename == null || filename.length() == 0) {
            return;
        }
        try {
            File file = new File(filename);
            FileOutputStream os = new FileOutputStream(file);
            PrintWriter ps = new PrintWriter(os);
            Vector v = this.m_ls.getEdits();
            ps.println("SCHEME TUPLE :");
            ps.println("SCHEME ATTRIBUTE :");
            ps.println("FACT TUPLE :");
            ps.println("FACT ATTRIBUTE :");
            if (v != null) {
                UndoableEdit undoableEdit;
                UndoableEdit editToBeRedone = this.m_ls.getEditToBeRedone();
                Enumeration en = v.elements();
                while (en.hasMoreElements() && (undoableEdit = (UndoableEdit)en.nextElement()) != editToBeRedone) {
                    if (undoableEdit instanceof MyCompoundEdit) {
                        Vector v1 = ((MyCompoundEdit)undoableEdit).getEdits();
                        ps.println("//@Start " + undoableEdit.getPresentationName());
                        Enumeration en1 = v1.elements();
                        while (en1.hasMoreElements()) {
                            UndoableEdit undoableEdit1 = (UndoableEdit)en1.nextElement();
                            ((MyUndoableEdit)undoableEdit1).dumpEdit(ps);
                        }
                        ps.println("//@End " + undoableEdit.getPresentationName());
                        continue;
                    }
                    ((MyUndoableEdit)undoableEdit).dumpEdit(ps);
                }
            }
            ps.close();
        }
        catch (IOException e) {
            System.out.println("Can't write edit history to " + filename + ": IOException " + e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fill();
    }

    @Override
    public boolean processMetaKeyEvent(String name) {
        return this.m_ls.processMetaKeyEvent(name);
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        switch (key) {
            case 10: {
                ShowCompoundEdit dialog = new ShowCompoundEdit(this.m_ls, this, (MyCompoundEdit)object);
                dialog.dispose();
                break;
            }
            case 127: {
                this.m_ls.clearUndoCache();
                break;
            }
            case 67: 
            case 99: {
                Diagram diagram = this.m_ls.getDiagram();
                if (diagram == null) break;
                boolean state = diagram.useCompoundEdit();
                diagram.setUseCompoundEdit(!state);
                break;
            }
            case 76: 
            case 108: {
                ShowMaxUndo dialog = new ShowMaxUndo(this.m_ls, this);
                dialog.dispose();
                break;
            }
            case 88: 
            case 120: {
                this.invertUndo();
                break;
            }
            case 68: 
            case 100: {
                this.dumpEdits();
            }
        }
    }

    @Override
    public void showInfo(String msg) {
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
        if (signal == 44) {
            this.fill();
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        this.m_style = 0;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        Vector v;
        int over;
        this.m_over = over = ev.getY() / m_fontheight - 1;
        if (ev.isMetaDown()) {
            JPopupMenu m = new JPopupMenu("Undo options");
            Vector v2 = this.m_ls.getEdits();
            Diagram diagram = this.m_ls.getDiagram();
            if (diagram != null) {
                int max;
                if (v2 != null && (max = v2.size()) > 0) {
                    UndoableEdit undoableEdit;
                    if (over >= 0 && over < max && (undoableEdit = (UndoableEdit)v2.elementAt(over)) instanceof MyCompoundEdit) {
                        MyMenuItem m1 = new MyMenuItem(m, "Show details", this, -1, 10, "Show the details of this edit");
                        m1.setObject(undoableEdit);
                    }
                    new MyMenuItem(m, "Dispose undo", this, -1, 127, "Discard undoable edits");
                }
                new MyMenuItem(m, "Limit", this, -1, 108, "Set the limit on the number of undoable edits");
                if (diagram.useCompoundEdit()) {
                    new MyMenuItem(m, "No Compound Edits", this, -1, 67, "Disallow compound edits");
                } else {
                    new MyMenuItem(m, "Use Compound Edits", this, -1, 67, "Allow compound edits");
                }
                if (diagram.undoEnabled()) {
                    new MyMenuItem(m, "Disable undo feature", this, -1, 88, "Don't incur memory cost of supporting undo/redo operations");
                } else {
                    new MyMenuItem(m, "Enable undo feature", this, -1, 88, "Cache all updates so can be undone (potentially expensive)");
                }
                new MyMenuItem(m, "Dump Edit History", this, -1, 68, "Write all edits to a file for post processing");
                FontCache.setMenuTreeFont(m);
                m.show(this, ev.getX(), ev.getY());
            }
            return;
        }
        this.m_style = 2;
        if (over >= 0 && (v = this.m_ls.getEdits()) != null) {
            UndoableEdit editToBeRedone = this.m_ls.getEditToBeRedone();
            int at = this.m_over;
            boolean redo = false;
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                if (undoableEdit == editToBeRedone) {
                    redo = true;
                }
                if (at == 0) {
                    this.m_ls.massChange(undoableEdit, redo);
                    break;
                }
                --at;
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.m_style = 0;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        this.mouseAt(ev.getY());
    }

    public class ShowMaxUndo
    extends JDialog
    implements ActionListener {
        protected LandscapeEditorCore m_ls;
        protected Diagram m_diagram;
        protected UndoBox m_undoBox;
        protected JTextField m_max;
        protected int m_limit;
        protected JButton m_ok;
        protected JButton m_cancel;

        public ShowMaxUndo(LandscapeEditorCore ls, UndoBox undoBox2) {
            super(ls.getFrame(), "Maximum Undo", true);
            this.m_ls = ls;
            this.m_diagram = ls.getDiagram();
            int x = undoBox2.m_tabbedPane.getX() + 20;
            int y = undoBox2.m_tabbedPane.getY() + 20;
            this.setLocation(x, y);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(FontCache.getDialogFont());
            Container contentPane = this.getContentPane();
            JPanel grid = new JPanel();
            grid.setLayout(new GridLayout(0, 1));
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            JLabel label = new JLabel("Maximum: ");
            panel.add(label);
            this.m_limit = this.m_diagram.getLimit();
            this.m_max = new JTextField("" + this.m_limit, 10);
            panel.add(this.m_max);
            grid.add(panel);
            contentPane.add((Component)grid, "Center");
            panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            panel.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            panel.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            contentPane.add((Component)panel, "South");
            this.pack();
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source == this.m_ok) {
                String max = this.m_max.getText();
                if ((max = max.trim()).length() > 0) {
                    try {
                        int limit = Integer.parseInt(max);
                        if (limit >= 0) {
                            this.m_diagram.setLimit(limit);
                            this.m_undoBox.fill();
                        }
                    }
                    catch (Throwable exception) {
                        // empty catch block
                    }
                }
                this.setVisible(false);
                return;
            }
            if (source == this.m_cancel) {
                this.setVisible(false);
                return;
            }
        }
    }

    public class ShowCompoundEdit
    extends JDialog {
        MyCompoundEdit m_compoundEdit;

        public ShowCompoundEdit(LandscapeEditorCore ls, UndoBox undoBox2, MyCompoundEdit compoundEdit) {
            super(ls.getFrame(), compoundEdit.getPresentationName(), true);
            Dimension preferredSize = new Dimension();
            int x = undoBox2.m_tabbedPane.getX() + 20;
            int y = undoBox2.m_tabbedPane.getY() + 20;
            this.setLocation(x, y);
            int width = undoBox2.getWidth();
            int height = undoBox2.getHeight();
            this.m_compoundEdit = compoundEdit;
            Vector v = compoundEdit.getEdits();
            preferredSize.height = v.size() * m_fontheight + 5 + 20;
            preferredSize.width = 0;
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                int w;
                UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                if (undoableEdit instanceof MyPaintableUndoableEdit) {
                    w = ((MyPaintableUndoableEdit)undoableEdit).getPreferredWidth();
                } else {
                    FontMetrics fm = this.getFontMetrics(m_textFont);
                    w = fm.stringWidth(undoableEdit.getPresentationName());
                }
                if (w <= preferredSize.width) continue;
                preferredSize.width = w;
            }
            preferredSize.width += 5;
            if (preferredSize.width < width / 2) {
                preferredSize.width = width / 2;
            }
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.setSize(preferredSize);
            ShowCompoundEditPanel panel = new ShowCompoundEditPanel(v);
            panel.setPreferredSize(preferredSize);
            panel.setSize(preferredSize);
            contentPane.add((Component)panel, "Center");
            this.pack();
            this.setVisible(true);
        }

        public class ShowCompoundEditPanel
        extends JComponent {
            Vector m_v;

            ShowCompoundEditPanel(Vector v) {
                this.m_v = v;
            }

            @Override
            public void paintComponent(Graphics g) {
                int height = m_fontheight;
                Vector v = this.m_v;
                this.setBackground(Color.lightGray);
                if (v != null) {
                    g.setFont(m_textFont);
                    g.setColor(Color.BLACK);
                    Enumeration en = v.elements();
                    while (en.hasMoreElements()) {
                        UndoableEdit undoableEdit = (UndoableEdit)en.nextElement();
                        if (undoableEdit instanceof MyPaintableUndoableEdit) {
                            ((MyPaintableUndoableEdit)undoableEdit).paintComponent(g, 5, height);
                        } else {
                            g.drawString(undoableEdit.getPresentationName(), 5, height + m_baseline);
                        }
                        height += m_fontheight;
                    }
                }
            }
        }
    }
}

