/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JPanel;
import lsedit.AttributeCache;
import lsedit.Diagram;
import lsedit.EntityCache;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeTokenStream;
import lsedit.MsgOut;
import lsedit.NoFeedback;
import lsedit.OrderedHashTableEnumeration;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.StringCache;
import lsedit.TaFeedback;
import lsedit.Util;
import lsedit.Version;
import lsedit.View;
import lsedit.ViewBox;

public class Ta
extends JPanel
implements TaFeedback {
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String CONTAIN_ID = "contain";
    public static final String ROOT_ID = "$ROOT";
    public static final int UPDATE_FREQ = 1000;
    public static boolean m_strict_TA = false;
    protected TaFeedback m_taFeedback;
    protected static TaFeedback m_noFeedback = null;
    private Diagram m_diagram;
    protected EntityCache m_entityCache;
    protected RelationClass m_defaultContainsClass;
    protected EntityInstance m_rootInstance;
    protected EntityInstance m_drawRoot;
    protected RelationClass[] m_containsClasses = null;
    protected boolean m_undoEnabled = false;
    protected Hashtable m_entityClasses = new Hashtable(50);
    protected Hashtable m_relationClasses = new Hashtable(50);
    private Vector m_numToRel = new Vector(50);
    public RelationClass m_relationBaseClass;
    public EntityClass m_entityBaseClass;
    protected RelationClass m_defaultRelationClass = null;
    protected int m_numRelationClasses = 0;
    protected EntityClass m_defaultEntityClass = null;
    private int m_numEntityClasses = 0;
    private Object m_context;
    private String m_zipEntry;
    protected String m_resString = null;
    protected int m_progressCount;
    protected boolean m_changedFlag = false;
    protected int m_numberRelations;
    private String m_comments = null;
    private Vector m_views = null;
    protected boolean m_changed_spanning_edges = false;
    protected boolean m_loaded_special = false;

    public void setNoFeedback() {
        if (m_noFeedback == null) {
            m_noFeedback = new NoFeedback();
        }
        this.m_taFeedback = m_noFeedback;
    }

    public Ta(TaFeedback taFeedback) {
        this.m_taFeedback = taFeedback;
        if (taFeedback == null) {
            this.setNoFeedback();
        }
        this.m_entityCache = new EntityCache();
        this.m_diagram = this.getDiagram();
        this.m_rootInstance = null;
        this.m_entityBaseClass = new EntityClass("$ENTITY", this.m_numEntityClasses++, this);
        this.m_entityBaseClass.setStyle(0);
        this.m_entityBaseClass.setObjectColor(Color.blue);
        this.m_entityBaseClass.setLabelColor(Color.cyan);
        this.m_entityClasses.put("$ENTITY", this.m_entityBaseClass);
        this.m_relationBaseClass = new RelationClass("$RELATION", this.m_numRelationClasses++, this);
        this.m_relationBaseClass.setIOfactor((short)0);
        this.m_relationBaseClass.setStyle(0);
        this.m_relationBaseClass.setObjectColor(Color.black);
        this.m_relationClasses.put("$RELATION", this.m_relationBaseClass);
        this.m_numToRel.addElement(this.m_relationBaseClass);
        RelationClass rc = new RelationClass(CONTAIN_ID, this.m_numRelationClasses++, this);
        rc.setCIndex(0);
        this.m_defaultContainsClass = rc;
        this.m_relationClasses.put(CONTAIN_ID, rc);
        this.m_numToRel.addElement(rc);
    }

    protected Diagram getDiagram() {
        return null;
    }

    public EntityClass getEntityBaseClass() {
        return this.m_entityBaseClass;
    }

    public RelationClass getRelationBaseClass() {
        return this.m_relationBaseClass;
    }

    public RelationClass[] getContainsClasses() {
        return this.m_containsClasses;
    }

    public RelationClass getPrimaryContainsClass() {
        if (this.m_containsClasses == null) {
            return null;
        }
        return this.m_containsClasses[0];
    }

    public RelationClass getDefaultContainsClass() {
        return this.m_defaultContainsClass;
    }

    public boolean getChangedFlag() {
        return this.m_changedFlag;
    }

    public boolean undoEnabled() {
        return this.m_undoEnabled;
    }

    public Vector getClassAndSubclasses(EntityClass ec) {
        return ec.getClassAndSubclasses(this.m_entityClasses);
    }

    public EntityClass getEntityClass(String id) {
        return (EntityClass)this.m_entityClasses.get(id);
    }

    public EntityInstance getRootInstance() {
        return this.m_rootInstance;
    }

    public EntityInstance getDrawRoot() {
        return this.m_drawRoot;
    }

    public Vector getClassAndSubclasses(RelationClass rc) {
        return rc.getClassAndSubclasses(this.m_relationClasses);
    }

    public RelationClass getRelationClass(String id) {
        return (RelationClass)this.m_relationClasses.get(id);
    }

    public int getMaxCIndex() {
        int cindex = -1;
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            int cindex1 = rc.getCIndex();
            if (cindex1 <= cindex) continue;
            cindex = cindex1;
        }
        return cindex;
    }

    public boolean entityExists(String name) {
        return this.getCache(name) != null;
    }

    public EntityCache getEntityCache() {
        return this.m_entityCache;
    }

    public EntityInstance getCache(String id) {
        return this.m_entityCache.get(id);
    }

    public void removeCache(EntityInstance e) {
        this.m_entityCache.remove(e);
    }

    public void putCache(EntityInstance e) {
        this.m_entityCache.put(e);
    }

    public Enumeration enumRelationClasses() {
        return this.m_relationClasses.elements();
    }

    public Enumeration enumRelationClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_relationClasses);
    }

    public int numRelationClasses() {
        return this.m_numRelationClasses;
    }

    public Enumeration enumEntityClasses() {
        return this.m_entityClasses.elements();
    }

    public Enumeration enumEntityClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_entityClasses);
    }

    public Enumeration enumEntityClassHierarchy(boolean hideEmpty) {
        return this.m_entityBaseClass.enumHierarchy(hideEmpty, this.m_entityClasses.size());
    }

    public Enumeration enumRelationClassHierarchy(boolean hideEmpty) {
        return this.m_relationBaseClass.enumHierarchy(hideEmpty, this.m_relationClasses.size());
    }

    public int numEntityClasses() {
        return this.m_entityClasses.size();
    }

    public Object getContext() {
        return this.m_context;
    }

    public void setContext(Object context) {
        this.m_context = context;
    }

    public String getContextName() {
        String ret = this.m_context instanceof File ? Util.nameFromPath(((File)this.m_context).getPath()) : (this.m_rootInstance == null ? null : this.m_rootInstance.getEntityLabel());
        if (this.m_zipEntry != null) {
            ret = ret + "[" + this.m_zipEntry + "]";
        }
        return ret;
    }

    public String getDir(File file) {
        if (file.isAbsolute()) {
            return file.getParent();
        }
        return new File(file.getAbsolutePath()).getParent();
    }

    public String getDir() {
        return this.getDir((File)this.m_context);
    }

    public String getAbsolutePath() {
        if (this.m_context != null && this.m_context instanceof File) {
            return ((File)this.m_context).getAbsolutePath();
        }
        return null;
    }

    public Vector getRelationClasses() {
        return this.m_numToRel;
    }

    public RelationClass numToRelationClass(int n) {
        return (RelationClass)this.m_numToRel.elementAt(n);
    }

    public int getNumberEntitiesLoaded() {
        return this.m_entityCache.size();
    }

    public int getNumberRelationsLoaded() {
        return this.m_numberRelations;
    }

    private void createRootInstance() {
        this.m_rootInstance = new EntityInstance(null, ROOT_ID);
        this.m_rootInstance.setRelLocal(0.0, 0.0, 1.0, 1.0);
        this.m_rootInstance.setParentClass(this.m_entityBaseClass);
    }

    private void setupUniversalScheme() {
        this.m_relationBaseClass.addRelationConstraint(this.m_entityBaseClass, this.m_entityBaseClass);
    }

    public EntityClass addEntityClass(String id) {
        EntityClass ec = this.getEntityClass(id);
        if (ec == null) {
            ec = new EntityClass(id, this.m_numEntityClasses++, this);
            this.m_entityClasses.put(id, ec);
            if (this.m_defaultEntityClass == null) {
                this.setDefaultEntityClass(ec);
            }
        }
        return ec;
    }

    public void setDefaultRelationClass(RelationClass rc) {
        this.m_defaultRelationClass = rc;
    }

    public RelationClass addRelationClass(String id) {
        RelationClass rc = this.getRelationClass(id);
        if (rc == null) {
            rc = new RelationClass(id, this.m_numRelationClasses, this);
            this.m_relationClasses.put(id, rc);
            this.m_numToRel.addElement(rc);
            ++this.m_numRelationClasses;
            if (this.m_defaultRelationClass == null) {
                this.setDefaultRelationClass(rc);
            }
        }
        return rc;
    }

    public EntityInstance newCachedEntity(EntityClass ec, String id) {
        if (ec == null) {
            System.out.println("newCachedEntity EntityClass null");
        }
        EntityInstance e = ec.newEntity(id);
        this.putCache(e);
        return e;
    }

    public RelationInstance newRelation(RelationClass rc, EntityInstance src, EntityInstance dst) {
        if (rc == null && (rc = this.m_defaultRelationClass) == null) {
            rc = this.m_relationBaseClass;
        }
        ++this.m_numberRelations;
        return new RelationInstance(rc, src, dst);
    }

    public RelationInstance addEdge(RelationClass rc, EntityInstance src, EntityInstance dst) {
        RelationInstance ri = this.newRelation(rc, src, dst);
        src.addSrcRelation(ri);
        dst.addDstRelation(ri);
        return ri;
    }

    public void changeIOfactor(RelationClass rc) {
        Enumeration en = this.m_entityClasses.elements();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            ec.changeIOfactor(rc);
        }
    }

    public void setDefaultEntityClass(EntityClass ec) {
        this.m_defaultEntityClass = ec;
    }

    public void noDiagram() {
        this.setupUniversalScheme();
        this.setDefaultEntityClass(this.m_entityBaseClass);
        this.setDefaultRelationClass(this.m_relationBaseClass);
        RelationClass[] containsClasses = new RelationClass[]{this.m_defaultContainsClass};
        this.setContainsClasses(containsClasses);
        this.m_rootInstance = null;
    }

    public void emptyDiagram() {
        RelationClass[] containsClasses = new RelationClass[1];
        this.setupUniversalScheme();
        this.setDefaultEntityClass(this.m_entityBaseClass);
        this.setDefaultRelationClass(this.m_relationBaseClass);
        this.m_drawRoot = this.m_rootInstance = this.newCachedEntity(this.m_entityBaseClass, ROOT_ID);
        containsClasses[0] = this.m_defaultContainsClass;
        this.switchContainsClasses(containsClasses);
    }

    private void compactEntities() {
        EntityCache entityCache = this.m_entityCache;
        EntityInstance e = entityCache.getFirst();
        while (e != null) {
            e.compact();
            e = entityCache.getNext();
        }
    }

    public void switchContainsClasses(RelationClass[] containsClasses) {
        this.setContainsClasses(containsClasses);
        for (int i = 0; i < containsClasses.length; ++i) {
            RelationClass containsClass = containsClasses[i];
            containsClass.computeCIndex();
        }
        this.prepostorder();
    }

    private void processSchemeTuples(LandscapeTokenStream ts) throws IOException {
        while (ts.nextSchemaTriple()) {
            RelationClass rc1;
            EntityClass ec2;
            EntityClass ec1;
            String verb = ts.m_verb;
            String object = ts.m_object;
            if (verb.equals(INHERIT_RELN)) {
                switch (ts.m_relations) {
                    case 0: {
                        if (object.equals("$ENTITY")) {
                            ts.errorNS(verb + " " + object + " " + ts.m_subject + ": Improper use of $ENTITY with $INHERIT");
                            break;
                        }
                        ec1 = this.addEntityClass(object);
                        String msg = ec1.addParentClass(ec2 = this.addEntityClass(ts.m_subject));
                        if (msg == null) break;
                        ts.errorNS(msg);
                        break;
                    }
                    case 1: 
                    case 2: {
                        ts.errorNS("Mismatched entity/relation with $INHERIT -- presuming both relations");
                    }
                    case 3: {
                        RelationClass rc2;
                        if (object.equals("$RELATION")) {
                            ts.errorNS(verb + " " + object + " " + ts.m_subject + ": Improper use of $RELATION with $INHERIT");
                            break;
                        }
                        rc1 = this.addRelationClass(object);
                        String msg = rc1.addParentClass(rc2 = this.addRelationClass(ts.m_subject));
                        if (msg == null) break;
                        ts.errorNS(msg);
                    }
                }
                continue;
            }
            if (ts.m_relations != 0) {
                ts.errorNS("Cannot create relationships between relationships");
                continue;
            }
            ec1 = this.addEntityClass(object);
            ec2 = this.addEntityClass(ts.m_subject);
            rc1 = this.addRelationClass(verb);
            rc1.addRelationConstraint(ec1, ec2);
        }
    }

    private void processFactTuples(LandscapeTokenStream ts) throws IOException {
        int ne = 0;
        int nr = 0;
        MsgOut.vprint("\nFACT TUPLE : ");
        while (ts.nextFactTriple()) {
            RelationClass rc;
            String verb = ts.m_verb;
            String object = ts.m_object;
            String subject = ts.m_subject;
            if (verb.equals(INSTANCE_ID)) {
                if (++ne % 1000 == 0) {
                    MsgOut.vprint(".");
                    this.m_taFeedback.showProgress("Entities: " + ne);
                }
                EntityInstance e = object.equals(ROOT_ID) ? this.getRootInstance() : this.getCache(object);
                EntityClass ec = !m_strict_TA ? this.addEntityClass(subject) : this.getEntityClass(subject);
                if (ec == null) {
                    ts.errorNS("Strict TA: Entity '" + object + "' instance of undeclared entity class '" + subject + "'");
                    continue;
                }
                if (e == null) {
                    e = this.newCachedEntity(ec, object);
                    continue;
                }
                EntityClass ec1 = e.getEntityClass();
                if (ec == ec1) continue;
                if (ec1 != null && ec1 != this.m_entityBaseClass) {
                    ts.warning("Redeclaration of " + e + " from instance of " + ec1 + " to instance of " + ec);
                }
                e.setParentClass(ec);
                continue;
            }
            if (++nr % 1000 == 0) {
                MsgOut.vprint(".");
                this.m_taFeedback.showProgress("Relations: " + nr);
            }
            EntityInstance e1 = this.getCache(object);
            EntityInstance e2 = this.getCache(subject);
            if (!m_strict_TA) {
                rc = this.addRelationClass(verb);
                if (e1 == null) {
                    e1 = this.newCachedEntity(this.m_entityBaseClass, object);
                }
                if (e2 == null) {
                    e2 = this.newCachedEntity(this.m_entityBaseClass, subject);
                }
            } else {
                rc = this.getRelationClass(verb);
            }
            if (rc == null || e1 == null || e2 == null) {
                String msg = "Strict TA: Relation (" + verb + " " + object + " " + subject + ")";
                if (rc == null) {
                    msg = msg + " member of undeclared relation class '" + verb + "'";
                }
                if (e1 == null) {
                    msg = msg + " has undeclared source entity '" + object + "'";
                }
                if (e2 == null) {
                    msg = msg + " has undeclared destination entity '" + subject + "'";
                }
                ts.errorNS(msg);
                continue;
            }
            this.addEdge(rc, e1, e2);
        }
        this.m_numberRelations = nr;
    }

    public void attachBaseClasses() {
        EntityInstance root = this.getRootInstance();
        if (root.getParentClass() == null) {
            root.setParentClass(this.m_entityBaseClass);
        }
        Enumeration en = this.m_entityClasses.elements();
        while (en.hasMoreElements()) {
            EntityClass ec1 = (EntityClass)en.nextElement();
            if (ec1 != this.m_entityBaseClass && ec1.getInheritsFromCnt() == 0) {
                ec1.addParentClass(this.m_entityBaseClass);
            }
            if (ec1.getStyle() != -1) continue;
            ec1.setStyle(1);
        }
        en = this.m_relationClasses.elements();
        while (en.hasMoreElements()) {
            RelationClass rc1 = (RelationClass)en.nextElement();
            if (rc1 != this.m_relationBaseClass && rc1.getInheritsFromCnt() == 0) {
                rc1.addParentClass(this.m_relationBaseClass);
            }
            if (rc1.getStyle() != -1) continue;
            rc1.setStyle(0);
        }
    }

    private void parseStream(Reader reader, String src, URL context) {
        block15: {
            LineNumberReader linenoReader = null;
            boolean schemeSetup = false;
            MsgOut.vprintln("Parse TA file: " + src);
            try {
                int sec;
                linenoReader = new LineNumberReader(reader);
                LandscapeTokenStream ts = new LandscapeTokenStream(linenoReader, src, this.m_entityCache);
                linenoReader.setLineNumber(1);
                ts.m_comments = "";
                while ((sec = ts.nextSection()) != 99) {
                    try {
                        switch (sec) {
                            case 0: {
                                schemeSetup = true;
                                this.processSchemeTuples(ts);
                                break;
                            }
                            case 1: {
                                if (!schemeSetup) {
                                    schemeSetup = true;
                                    this.setupUniversalScheme();
                                }
                                ts.processSchemeAttributes(this);
                                break;
                            }
                            case 2: {
                                this.m_comments = ts.m_comments.length() > 0 ? ts.m_comments : null;
                                ts.m_comments = null;
                                if (!schemeSetup) {
                                    schemeSetup = true;
                                    this.setupUniversalScheme();
                                }
                                this.processFactTuples(ts);
                                break;
                            }
                            case 3: {
                                this.compactEntities();
                                ts.processFactAttributes(this);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.m_resString = e.getMessage();
                        if (this.m_resString == null) {
                            this.m_resString = e.toString();
                        }
                        System.out.println("IO error reading landscape: " + this.m_resString);
                        System.out.println("Start Line number:" + ts.getStartLineno());
                        if (linenoReader != null) {
                            System.out.println("Last line read: " + linenoReader.getLineNumber());
                        }
                        e.printStackTrace();
                        break;
                    }
                }
                linenoReader.close();
                linenoReader = null;
            }
            catch (Exception e) {
                this.m_resString = e.getMessage();
                System.out.println("Parse error: " + this.m_resString);
                if (linenoReader == null) break block15;
                System.out.println("Line number: " + linenoReader.getLineNumber());
            }
        }
        this.attachBaseClasses();
    }

    private InputStream decompress(InputStream is, String source, String subfile) {
        InputStream ret = is;
        int lth = source.length();
        if (lth > 4) {
            String ends = source.substring(lth - 4);
            if (ends.equalsIgnoreCase(".zip")) {
                ZipInputStream zipInputStream;
                try {
                    zipInputStream = new ZipInputStream(is);
                    while (true) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (subfile != null && !subfile.equalsIgnoreCase(zipEntry.getName())) {
                            zipInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("Attempt to open " + source + (subfile == null ? "" : "#" + subfile) + " as zip file failed");
                    this.m_resString = e.getMessage();
                    zipInputStream = null;
                }
                return zipInputStream;
            }
            if (ends.equalsIgnoreCase(".jar")) {
                JarInputStream jarInputStream;
                try {
                    jarInputStream = new JarInputStream(is);
                    while (true) {
                        ZipEntry zipEntry = jarInputStream.getNextEntry();
                        if (subfile != null && !subfile.equalsIgnoreCase(zipEntry.getName())) {
                            jarInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("Attempt to open " + source + (subfile == null ? "" : "#" + subfile) + " as jar file failed");
                    this.m_resString = e.getMessage();
                    jarInputStream = null;
                }
                return jarInputStream;
            }
            if (lth > 5 && (ends = source.substring(lth - 5)).equalsIgnoreCase(".gzip")) {
                GZIPInputStream gzipInputStream;
                try {
                    gzipInputStream = new GZIPInputStream(is);
                }
                catch (Exception e) {
                    System.out.println("Attempt to open " + source + " as gzip file failed");
                    this.m_resString = e.getMessage();
                    gzipInputStream = null;
                }
                return gzipInputStream;
            }
        }
        return is;
    }

    private boolean parseURL(String taPath, URL context, boolean topLevel) {
        URL lsURL;
        int i;
        int lth = taPath.length();
        char lc = taPath.charAt(lth - 1);
        String entry = null;
        if (lth > 2 && lc == ']' && (i = taPath.lastIndexOf(91)) > 0 && i < lth - 2) {
            entry = taPath.substring(i + 1, lth - 1);
            taPath = taPath.substring(0, i);
            if (this.m_zipEntry == null) {
                this.m_zipEntry = entry;
            }
            lth = i;
            lc = taPath.charAt(lth - 1);
        }
        if (lc == File.separatorChar) {
            taPath = taPath.substring(0, lth - 1);
        }
        try {
            lsURL = context == null ? new URL(taPath) : new URL(context, taPath);
            MsgOut.dprintln("Opening URL: " + taPath);
            InputStream is = lsURL.openStream();
            is = this.decompress(is, taPath, entry);
            if (is == null) {
                return false;
            }
            MsgOut.dprintln("opened");
            InputStreamReader reader = new InputStreamReader(is);
            this.parseStream(reader, taPath, lsURL);
        }
        catch (Exception e) {
            this.m_resString = e.getMessage();
            return false;
        }
        if (topLevel) {
            this.setContext(lsURL);
        }
        return true;
    }

    public boolean parseFile(String taPath, Object context, boolean topLevel) {
        String entry = null;
        int lth = taPath.length();
        File file = null;
        if (lth > 0) {
            int i;
            char lc = taPath.charAt(lth - 1);
            if (lth > 2 && lc == ']' && (i = taPath.lastIndexOf(91)) > 0 && i < lth - 2) {
                entry = taPath.substring(i + 1, lth - 1);
                if (this.m_zipEntry == null) {
                    this.m_zipEntry = entry;
                }
                taPath = taPath.substring(0, i);
                lth = i;
                lc = taPath.charAt(lth - 1);
            }
            if (lc == File.separatorChar) {
                taPath = taPath.substring(0, lth - 1);
            }
        }
        try {
            InputStream is = null;
            if (lth == 0) {
                if (context instanceof InputStream) {
                    is = (InputStream)context;
                }
            } else {
                if (context instanceof File) {
                    String dir = this.getDir((File)context);
                    file = new File(dir, taPath);
                } else {
                    file = new File(taPath);
                }
                if (file != null) {
                    is = new FileInputStream(file);
                    is = this.decompress(is, taPath, entry);
                }
            }
            if (is == null) {
                this.m_resString = "No input stream specified";
                return false;
            }
            InputStreamReader reader = new InputStreamReader(is);
            this.parseStream(reader, taPath, null);
            is.close();
        }
        catch (Exception e) {
            this.m_resString = e.getMessage();
            return false;
        }
        if (topLevel && file != null) {
            this.setContext(file);
        }
        return true;
    }

    public void prepostorder() {
        this.m_rootInstance.prepostorder(1);
    }

    public void setContainsClasses(RelationClass[] containsClasses) {
        RelationClass rc;
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            rc = (RelationClass)en.nextElement();
            rc.setContainsClassOffset(-1);
        }
        if (containsClasses != null) {
            int i = containsClasses.length;
            while (--i >= 0) {
                rc = containsClasses[i];
                rc.setContainsClassOffset(i);
                if (this.m_defaultRelationClass != rc) continue;
                this.setDefaultRelationClass(this.m_relationBaseClass);
            }
        }
        this.m_containsClasses = containsClasses;
    }

    public void reverseRelations(RelationClass rc, boolean reverse) {
        EntityCache entityCache = this.m_entityCache;
        EntityInstance e = entityCache.getFirst();
        while (e != null) {
            Vector v = e.getSrcRelList();
            int i = 2;
            while (true) {
                if (v != null) {
                    int j = v.size();
                    while (j > 0) {
                        RelationInstance ri;
                        if ((ri = (RelationInstance)v.elementAt(--j)).getParentClass() != rc || ri.isMarked(0x200000) == reverse) continue;
                        ri.reverseRelation();
                        if (reverse) {
                            ri.orMark(0x200000);
                        } else {
                            ri.nandMark(0x200000);
                        }
                        if (!ri.isMarked(0x100000)) continue;
                        this.m_changed_spanning_edges = true;
                    }
                }
                if (--i == 0) break;
                v = e.getDstRelList();
            }
            e = entityCache.getNext();
        }
    }

    public void reverseRelations() {
        Enumeration en = this.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (rc.getShown() != 2) continue;
            this.reverseRelations(rc, true);
        }
        this.m_changed_spanning_edges = false;
    }

    public Vector getForest() {
        Enumeration en = this.m_rootInstance.srcRelationElements();
        Vector<EntityInstance> forest = new Vector<EntityInstance>();
        if (en != null) {
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                if (!ri.isMarked(0x100000)) continue;
                forest.addElement(ri.getDst());
            }
        }
        return forest;
    }

    protected void establishForest(RelationClass[] containsClasses, boolean switching) {
        EntityInstance rootInstance = this.m_rootInstance;
        EntityCache entityCache = this.m_entityCache;
        this.removeCache(rootInstance);
        int size = entityCache.size();
        if (size > 0) {
            RelationClass containsClass;
            EntityInstance[] array = new EntityInstance[size];
            TaFeedback taFeedback = this.m_taFeedback;
            int i = 0;
            EntityInstance e = entityCache.getFirst();
            while (e != null) {
                e.notInForest(switching);
                array[i++] = e;
                e = entityCache.getNext();
            }
            rootInstance.removeAllEdges();
            for (i = 0; i < containsClasses.length; ++i) {
                containsClass = containsClasses[i];
                int j = 0;
                while (j < size) {
                    e = array[j];
                    e.tryToAddToForest(containsClass, taFeedback);
                    if (!e.isMarked(0x100000)) {
                        array[j] = array[--size];
                        continue;
                    }
                    ++j;
                }
            }
            this.putCache(this.m_rootInstance);
            containsClass = containsClasses[0];
            for (i = 0; i < size; ++i) {
                e = array[i];
                RelationInstance ri = this.addEdge(containsClass, rootInstance, e);
                e.nandMark(0x100000);
                e.setContainedByRelation(ri);
            }
            array = null;
        }
    }

    protected void clearResultBox() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            LandscapeEditorCore ls = diagram.getLs();
            ResultBox resultBox = ls.getResultBox();
            resultBox.clear();
        }
    }

    protected void clearEstablishForest(RelationClass[] containsClasses) {
        this.clearResultBox();
        this.establishForest(containsClasses, true);
    }

    protected boolean isSpecialPath(String path) {
        return false;
    }

    protected String parseSpecialPath(Ta ta, String path) {
        return null;
    }

    public RelationClass[] computedContainsClasses() {
        RelationClass[] containsClasses;
        int containsClassOffset;
        RelationClass rc;
        int max_contain = -1;
        Enumeration en = this.m_relationClasses.elements();
        while (en.hasMoreElements()) {
            rc = (RelationClass)en.nextElement();
            containsClassOffset = rc.getContainsClassOffset();
            if (containsClassOffset <= max_contain) continue;
            max_contain = containsClassOffset;
        }
        if (max_contain < 0) {
            rc = this.getRelationClass(CONTAIN_ID);
            if (rc == null) {
                return null;
            }
            containsClasses = new RelationClass[]{rc};
        } else {
            containsClasses = new RelationClass[max_contain + 1];
            en = this.m_relationClasses.elements();
            while (en.hasMoreElements()) {
                rc = (RelationClass)en.nextElement();
                containsClassOffset = rc.getContainsClassOffset();
                if (0 > containsClassOffset) continue;
                if (containsClasses[containsClassOffset] == null) {
                    containsClasses[containsClassOffset] = rc;
                    continue;
                }
                rc.setContainsClassOffset(-1);
            }
        }
        return containsClasses;
    }

    public String loadTA(String taPath, Object context) {
        this.m_progressCount = 0;
        this.m_loaded_special = false;
        this.m_containsClasses = null;
        this.m_resString = null;
        this.m_zipEntry = null;
        this.clearResultBox();
        if (taPath == null) {
            this.noDiagram();
        } else {
            int lth = taPath.length();
            if (lth == 0 && context == null) {
                this.emptyDiagram();
            } else {
                boolean ok;
                this.m_numberRelations = 0;
                this.createRootInstance();
                AttributeCache.activate();
                if (this.isSpecialPath(taPath)) {
                    this.m_resString = this.parseSpecialPath(this, taPath);
                    boolean bl = ok = this.m_resString == null;
                    if (ok) {
                        this.m_loaded_special = true;
                    }
                } else if (context instanceof URL || Util.isHTTP(taPath)) {
                    MsgOut.dprintln("Parse a URL");
                    ok = this.parseURL(taPath, (URL)context, true);
                } else {
                    MsgOut.dprintln("Parse a file");
                    ok = this.parseFile(taPath, context, true);
                }
                AttributeCache.deactivate();
                if (!ok) {
                    if (this.m_resString == null) {
                        this.m_resString = "Unknown error parsing " + context;
                    }
                    this.m_rootInstance = null;
                    return this.m_resString;
                }
                this.putCache(this.m_rootInstance);
            }
        }
        if (this.m_defaultEntityClass == null) {
            this.setDefaultEntityClass(this.m_entityBaseClass);
        }
        if (this.m_defaultRelationClass == null) {
            this.setDefaultRelationClass(this.m_relationBaseClass);
        }
        StringCache.clear();
        this.reverseRelations();
        RelationClass[] containsClasses = this.computedContainsClasses();
        if (containsClasses == null) {
            this.m_taFeedback.noContainRelation(taPath);
            return "No contains relation class defined";
        }
        this.establishForest(containsClasses, false);
        this.switchContainsClasses(containsClasses);
        if (this.m_rootInstance != null) {
            this.m_rootInstance.setDefaultOpenStatus();
        }
        if (this.m_context == null) {
            return this.m_resString;
        }
        return null;
    }

    public void writeSchemeTuples(PrintWriter ps, Enumeration entityClasses, Enumeration relationClasses, Enumeration relationClassPairs) {
        RelationClass rc;
        Enumeration en1;
        String id;
        boolean seen;
        ps.println("SCHEME TUPLE :");
        ps.println("");
        while (entityClasses.hasMoreElements()) {
            EntityClass ec = (EntityClass)entityClasses.nextElement();
            if (ec == this.m_entityBaseClass) continue;
            seen = false;
            id = ec.getId();
            en1 = ec.enumInheritsFrom();
            while (en1.hasMoreElements()) {
                EntityClass parent = (EntityClass)en1.nextElement();
                ps.println("$INHERIT " + id + " " + parent.getId());
                seen = true;
            }
            if (seen || id.equals("$ENTITY")) continue;
            ps.println("$INHERIT " + id + " " + "$ENTITY");
        }
        while (relationClasses.hasMoreElements()) {
            rc = (RelationClass)relationClasses.nextElement();
            if (rc == this.m_relationBaseClass) continue;
            seen = false;
            id = rc.getId();
            en1 = rc.enumInheritsFrom();
            while (en1.hasMoreElements()) {
                RelationClass rparent = (RelationClass)en1.nextElement();
                ps.println("$INHERIT (" + id + ") (" + rparent.getId() + ")");
                seen = true;
            }
            if (seen || id.equals("$RELATION")) continue;
            ps.println("$INHERIT (" + id + ") (" + "$RELATION" + ")");
        }
        ps.println();
        while (relationClassPairs.hasMoreElements()) {
            rc = (RelationClass)relationClassPairs.nextElement();
            rc.writeEntityClassPairs(ps);
        }
    }

    public void writeSchemeTuples(PrintWriter ps) {
        this.writeSchemeTuples(ps, this.enumEntityClassesInOrder(), this.enumRelationClassesInOrder(), this.enumRelationClassesInOrder());
    }

    public void writeSchemeAttributes(PrintWriter ps, Enumeration entityClasses, Enumeration relationClasses) {
        ps.println();
        ps.println();
        ps.println("SCHEME ATTRIBUTE :");
        ps.println();
        Enumeration en = entityClasses;
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            ec.writeAttributes(ps);
        }
        en = relationClasses;
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            rc.writeAttributes(ps);
        }
    }

    public void writeSchemeAttributes(PrintWriter ps) {
        this.writeSchemeAttributes(ps, this.m_entityClasses.elements(), this.m_relationClasses.elements());
    }

    private void writeFactAttributes(PrintWriter ps) {
        EntityInstance rootInstance = this.m_rootInstance;
        Vector srcRelList = rootInstance.getSrcRelList();
        ps.println();
        ps.println();
        ps.println("FACT ATTRIBUTE :");
        ps.println();
        rootInstance.writeOptionsAttributes(ps);
        if (srcRelList != null) {
            int size = srcRelList.size();
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)srcRelList.elementAt(i);
                if (!ri.isMarked(0x100000)) continue;
                EntityInstance child = ri.getDst();
                child.writeAttributes(ps, ri.getRelationClass());
            }
        }
    }

    private void writeFactTuples(PrintWriter ps) {
        EntityInstance child;
        ps.println();
        ps.println();
        ps.println("FACT TUPLE :");
        ps.println();
        Enumeration en = this.m_rootInstance.getChildren();
        while (en.hasMoreElements()) {
            child = (EntityInstance)en.nextElement();
            child.writeInstances(ps);
        }
        en = this.m_rootInstance.getChildren();
        while (en.hasMoreElements()) {
            child = (EntityInstance)en.nextElement();
            child.writeRelations(ps);
        }
    }

    public String saveDiagram(OutputStream os, boolean markEnd) {
        String ret = null;
        if (this.m_rootInstance != null) {
            PrintWriter ps = new PrintWriter(os);
            ps.println("// Landscape TA file written by LSEdit " + Version.Number());
            if (this.m_comments != null) {
                ps.print(this.m_comments);
            }
            ps.println();
            this.writeSchemeTuples(ps);
            this.writeSchemeAttributes(ps);
            this.writeFactTuples(ps);
            this.writeFactAttributes(ps);
            if (markEnd) {
                ps.println("END");
            }
            if (ps.checkError()) {
                ret = "Error saving TA";
            } else {
                this.m_changedFlag = false;
            }
            ps.close();
        }
        return ret;
    }

    protected String saveByFile(String newPath) {
        OutputStream os = null;
        try {
            if (newPath != null && newPath.length() == 0) {
                os = System.out;
            } else {
                File file = (File)this.getContext();
                if (newPath == null) {
                    String name = file.getPath();
                    file.renameTo(new File(name + ".old"));
                } else {
                    file = new File(newPath);
                    this.setContext(file);
                }
                os = new FileOutputStream(file);
            }
        }
        catch (IOException e) {
            return "IOException on file open";
        }
        return this.saveDiagram(os, false);
    }

    public void addView(View view) {
        Vector<View> v = this.m_views;
        if (v == null) {
            this.m_views = v = new Vector<View>();
        }
        v.add(view);
    }

    public void addRootView(String attributeId, String value) {
        View view = new View();
        view.setDiagram(this.getDiagram());
        view.load(attributeId, value);
        this.addView(view);
    }

    private void repaintViewBox() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            LandscapeEditorCore ls = diagram.getLs();
            ViewBox viewBox = ls.getViewBox();
            viewBox.fill();
        }
    }

    public void removeView(View view) {
        if (this.m_views != null) {
            this.m_views.removeElement(view);
            this.repaintViewBox();
        }
    }

    public void removeAllViews() {
        if (this.m_views != null) {
            this.m_views.clear();
            this.repaintViewBox();
        }
    }

    public void moveView(View view, int direction, int offset) {
        int index;
        int newindex = index = this.m_views.indexOf(view);
        switch (direction) {
            case 0: {
                newindex = offset - 1;
                break;
            }
            case 1: {
                newindex = index + offset;
                break;
            }
            case -1: {
                newindex = index - offset;
            }
        }
        if (newindex < 0) {
            newindex = 0;
        } else if (newindex >= this.m_views.size()) {
            newindex = this.m_views.size() - 1;
        }
        if (newindex != index) {
            this.m_views.remove(index);
            if (newindex > index) {
                --newindex;
            }
            this.m_views.insertElementAt(view, newindex);
            this.repaintViewBox();
        }
    }

    public Vector getViews() {
        return this.m_views;
    }

    public void LoadSchemaForView(View view, String attributeId, String input) {
        TaFeedback save_taFeedback = this.m_taFeedback;
        Hashtable save_entityClasses = this.m_entityClasses;
        Hashtable save_relationClasses = this.m_relationClasses;
        Vector save_numToRel = this.m_numToRel;
        int save_numRelationClasses = this.m_numRelationClasses;
        int save_numEntityClasses = this.m_numEntityClasses;
        String save_comments = this.m_comments;
        StringReader reader = new StringReader(input);
        this.setNoFeedback();
        this.m_entityClasses = new Hashtable(50);
        this.m_relationClasses = new Hashtable(50);
        this.parseStream(reader, attributeId, null);
        view.getSchemeSnapshot(this);
        this.m_taFeedback = save_taFeedback;
        this.m_entityClasses = save_entityClasses;
        this.m_relationClasses = save_relationClasses;
        this.m_numToRel = save_numToRel;
        this.m_numRelationClasses = save_numRelationClasses;
        this.m_numEntityClasses = save_numEntityClasses;
        this.m_comments = save_comments;
    }

    @Override
    public void showProgress(String message) {
        this.m_taFeedback.showProgress(message);
    }

    @Override
    public void doFeedback(String message) {
        this.m_taFeedback.doFeedback(message);
    }

    @Override
    public void showInfo(String message) {
        this.m_taFeedback.showInfo(message);
    }

    @Override
    public void error(String message) {
        this.m_taFeedback.error(message);
    }

    @Override
    public void showCycle(RelationInstance ri) {
        this.m_taFeedback.showCycle(ri);
    }

    @Override
    public void noContainRelation(String taPath) {
        this.m_taFeedback.noContainRelation(taPath);
    }

    @Override
    public void hasMultipleParents(RelationClass rc, EntityInstance e) {
        this.m_taFeedback.hasMultipleParents(rc, e);
    }
}

