/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.Graph;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SugiyamaLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int BORDER = 0;
    protected static final int XGAP = 1;
    protected static final int YGAP = 2;
    protected static final String[] m_textfield_tags = new String[]{"sugiyama:border", "sugiyama:xgap", "sugiyama:ygap"};
    protected static final String[] m_textfield_titles = new String[]{"Border fraction of total:", "Horizontal whitespace fraction of grid:", "Vertical whitespace fraction of grid:"};
    protected static final String[] m_textfield_resets = new String[]{"0.0333", "0.2", "0.2"};
    protected static String[] m_textfield_defaults = new String[]{"0.0333", "0.2", "0.2"};
    protected static String[] m_textfield_currents = new String[]{"0.0333", "0.2", "0.2"};
    protected double m_border = 0.0333;
    protected double m_xgap = 0.2;
    protected double m_ygap = 0.2;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_DEFAULT = 3;
    protected static final int BUTTON_SET = 4;
    protected static final int BUTTON_RESET = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Use remembered default", "Set default to current", "Set default to initial"};

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            double dval = Double.parseDouble(string);
            switch (i) {
                case 0: {
                    this.m_border = dval;
                    break;
                }
                case 1: {
                    this.m_xgap = dval;
                    break;
                }
                case 2: {
                    this.m_ygap = dval;
                }
            }
            SugiyamaLayout.m_textfield_currents[i] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getTag() {
        return "sugiyama:";
    }

    @Override
    public void reset() {
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        for (int i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        String[] textfield_tags = m_textfield_tags;
        for (int i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.equals(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    SugiyamaLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    this.setParameter(i, value);
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        String[] emit_strings;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                emit_strings = m_textfield_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                emit_strings = m_textfield_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
    }

    public SugiyamaLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Sugiyama";
    }

    @Override
    public String getMenuLabel() {
        return "Layout using Sugiyama algorithm";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        SugiyamaConfigure configure = new SugiyamaConfigure();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean doLayout1(Vector selectedBoxes, EntityInstance container) {
        double curY;
        double scaleY;
        double heightrel;
        double widthrel;
        Enumeration f;
        Vector row;
        int index;
        EntityInstance e;
        Diagram diagram = this.m_ls.getDiagram();
        double border = this.m_border;
        double xgap = this.m_xgap;
        double ygap = this.m_ygap;
        int vertexID = 0;
        int groupSize = selectedBoxes.size();
        int width = diagram.getWidth();
        int height = diagram.getHeight();
        Graph graph = new Graph(groupSize);
        Enumeration en = selectedBoxes.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            graph.addVertex(e.widthRelLocal());
            e.orMark(0x200000);
        }
        en = selectedBoxes.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            Enumeration edge = e.srcRelationElements();
            if (edge != null) {
                while (edge.hasMoreElements()) {
                    EntityInstance child;
                    RelationInstance relation = (RelationInstance)edge.nextElement();
                    if (!relation.isRelationShown() || (child = relation.getDst()) == e || !child.isMarked(0x200000)) continue;
                    for (index = 0; index < selectedBoxes.size() && child != selectedBoxes.elementAt(index); ++index) {
                    }
                    graph.addGraphEdge(vertexID, index);
                }
            }
            ++vertexID;
        }
        en = selectedBoxes.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            e.nandMark(0x200000);
        }
        Vector layers = graph.doCoffmanGrahamSugiyama();
        int max_across = 0;
        en = layers.elements();
        while (en.hasMoreElements()) {
            row = (Vector)en.nextElement();
            int row_across = row.size();
            if (row_across <= max_across) continue;
            max_across = row_across;
        }
        int available_width = (int)((1.0 - border) * (double)width);
        int available_height = (int)((1.0 - border) * (double)height);
        int row_gap = max_across < 2 ? 0 : (int)(xgap * (double)available_width / (double)(max_across - 1));
        int numLayers = layers.size();
        int column_gap = numLayers < 2 ? 0 : (int)(ygap * (double)available_height / (double)(numLayers - 1));
        int graph_width = 0;
        int graph_height = 0;
        en = layers.elements();
        while (en.hasMoreElements()) {
            row = (Vector)en.nextElement();
            int row_width = 0;
            int row_height = 0;
            f = row.elements();
            while (f.hasMoreElements()) {
                int curVertex = (Integer)f.nextElement();
                if (curVertex >= groupSize) continue;
                e = (EntityInstance)selectedBoxes.elementAt(curVertex);
                widthrel = e.widthRelLocal();
                heightrel = e.heightRelLocal();
                row_width += row_gap + (int)(widthrel * (double)width);
                int entity_height = (int)(heightrel * (double)height);
                if (entity_height <= row_height) continue;
                row_height = entity_height;
            }
            if ((row_width -= row_gap) > graph_width) {
                graph_width = row_width;
            }
            graph_height += column_gap + row_height;
        }
        graph_height -= column_gap;
        double scaleX = (double)available_width / (double)graph_width;
        if (scaleX > 1.0) {
            scaleX = 1.0;
        }
        if ((scaleY = (double)available_height / (double)graph_height) > 1.0) {
            scaleY = 1.0;
            curY = ((double)height - (double)graph_height) / (2.0 * (double)height);
        } else {
            curY = border / 2.0;
        }
        xgap = scaleX * (double)row_gap / (double)width;
        ygap = scaleY * (double)column_gap / (double)height;
        index = layers.size();
        while (index > 0) {
            int curVertex;
            row = (Vector)layers.elementAt(--index);
            double curX = 0.0;
            double maxheightrel = 0.0;
            f = row.elements();
            while (f.hasMoreElements()) {
                curVertex = (Integer)f.nextElement();
                if (curVertex >= groupSize) continue;
                e = (EntityInstance)selectedBoxes.elementAt(curVertex);
                curX += e.widthRelLocal() * scaleX + xgap;
            }
            curX -= xgap;
            if ((curX = (1.0 - curX) / 2.0) < 0.0) {
                curX = 0.0;
            }
            f = row.elements();
            while (f.hasMoreElements()) {
                curVertex = (Integer)f.nextElement();
                if (curVertex >= groupSize) continue;
                e = (EntityInstance)selectedBoxes.elementAt(curVertex);
                widthrel = e.widthRelLocal() * scaleX;
                heightrel = e.heightRelLocal() * scaleY;
                diagram.updateRelLocal(e, curX, curY, widthrel, heightrel);
                curX += widthrel + xgap;
                if (!(heightrel > maxheightrel)) continue;
                maxheightrel = heightrel;
            }
            curY += maxheightrel + ygap;
        }
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        ls.setLayouter(this);
        Vector selectedBoxes = dg.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Sugiyama requires that all things laid out share same parent";
        }
        ls.doLayout1(this, selectedBoxes, parent, false);
        return "Graph redrawn with Coffman-Graham-Sugiyama method";
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class SugiyamaConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected LayoutImage m_layoutImage;
        protected JLabel m_message;
        protected JButton[] m_buttons;
        protected boolean m_ret;

        public SugiyamaConfigure() {
            int i;
            super(SugiyamaLayout.this.getLs().getFrame(), "Sugiyama Whitespace", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel = new JPanel();
            JPanel valuePanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(3, 1, 0, 10);
            labelPanel.setLayout(gridLayout);
            gridLayout = new GridLayout(3, 1, 0, 10);
            valuePanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                JLabel label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                textfield.addActionListener(this);
                textfield.setFont(font);
                valuePanel.add(textfield);
            }
            topPanel.add("West", labelPanel);
            topPanel.add("East", valuePanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            JPanel centerPanel = new JPanel();
            centerPanel.setLayout(new BorderLayout());
            this.m_layoutImage = new LayoutImage();
            centerPanel.add("North", this.m_layoutImage);
            this.m_layoutImage.validate();
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            centerPanel.add("South", this.m_message);
            contentPane.add("Center", centerPanel);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                this.m_buttons[i] = button = new JButton(m_button_titles[i]);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SugiyamaLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                }
                case 3: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    break;
                }
                case 4: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SugiyamaLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    break;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SugiyamaLayout.this.m_ls.getFrame(), "Border\n  Fraction of diagram to reserve for border\n  Must be a value between 0 and 1\nGap\n  Fraction of diagram to reserve for whitespace", "Help", 0);
                    return;
                }
                default: {
                    block19: for (i = 0; i < m_textfield_tags.length; ++i) {
                        JTextField textfield = this.m_textfields[i];
                        if (source != textfield && state != 0) continue;
                        String string = textfield.getText();
                        string = string.trim();
                        String name = m_textfield_titles[i];
                        switch (i) {
                            case 0: 
                            case 1: 
                            case 2: {
                                try {
                                    double dval = Double.parseDouble(string);
                                    if (dval < 0.0) {
                                        this.m_message.setText(name + " may not be negative");
                                        return;
                                    }
                                    if (!(dval >= 1.0)) continue block19;
                                    this.m_message.setText(name + " must be less than 1.0");
                                    return;
                                }
                                catch (Throwable exception) {
                                    this.m_message.setText(name + " not a double precision value");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            switch (state) {
                case 0: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SugiyamaLayout.this.setParameter(i, this.m_textfields[i].getText());
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    this.m_layoutImage.validate();
                    this.m_layoutImage.repaint();
                    return;
                }
            }
            this.setVisible(false);
        }

        class LayoutImage
        extends JComponent
        implements MouseListener {
            Rectangle[] m_boxs;
            int m_rows = 2;
            boolean m_validated;

            public LayoutImage() {
                Dimension dimension = new Dimension(400, 240);
                this.setLayout(null);
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.setMaximumSize(dimension);
                this.setSize(dimension);
                this.m_boxs = new Rectangle[25];
                this.m_validated = false;
                this.addMouseListener(this);
                this.setVisible(true);
            }

            @Override
            public void validate() {
                Rectangle[] boxs = this.m_boxs;
                int cnt = boxs.length;
                int dimension = this.m_rows;
                int width = this.getWidth();
                int height = this.getHeight();
                double new_border = SugiyamaLayout.this.m_border;
                double new_xgap = SugiyamaLayout.this.m_xgap;
                double new_ygap = SugiyamaLayout.this.m_ygap;
                int x = (int)((double)width * new_border / 2.0);
                int y = (int)((double)height * new_border / 2.0);
                int w = width - 2 * x;
                int h = height - 2 * y;
                this.m_validated = false;
                if (w < 1 || h < 1) {
                    return;
                }
                int gaps = dimension - 1;
                double dgaps = gaps;
                int gapw = (int)(new_xgap * (double)w / dgaps);
                int gaph = (int)(new_ygap * (double)h / dgaps);
                int w1 = (w - gapw * gaps) / dimension;
                int h1 = (h - gaph * gaps) / dimension;
                if (w1 < 1 || h1 < 1) {
                    return;
                }
                int col = 0;
                int row = 0;
                cnt = dimension * dimension;
                for (int i = 0; i < cnt; ++i) {
                    Rectangle rectangle = boxs[i];
                    if (rectangle == null) {
                        boxs[i] = rectangle = new Rectangle();
                    }
                    rectangle.x = x;
                    if (col != 0) {
                        rectangle.x += col * (w1 + gapw);
                    }
                    rectangle.y = y;
                    if (row != 0) {
                        rectangle.y += row * (h1 + gaph);
                    }
                    rectangle.width = w1;
                    rectangle.height = h1;
                    if (++col != dimension) continue;
                    ++row;
                    col = 0;
                }
                this.m_validated = true;
            }

            @Override
            public void paintComponent(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(Color.black);
                g.drawRect(0, 0, w - 1, h - 1);
                if (this.m_validated) {
                    Rectangle[] boxs = this.m_boxs;
                    g.setColor(Color.blue);
                    int dimension = this.m_rows;
                    int col = 0;
                    int row = 0;
                    int cnt = dimension * dimension;
                    for (int i = 0; i < cnt; ++i) {
                        if (row >= col) {
                            Rectangle rectangle = boxs[i];
                            g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        if (++col != dimension) continue;
                        ++row;
                        col = 0;
                    }
                    if (dimension == 2) {
                        String s = "Click to change dimensions";
                        FontMetrics fm = g.getFontMetrics();
                        int width = fm.stringWidth(s);
                        g.setColor(Color.black);
                        g.drawString(s, (w - width) / 2, h / 2);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
            }

            @Override
            public void mouseEntered(MouseEvent ev) {
            }

            @Override
            public void mouseExited(MouseEvent ev) {
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.isMetaDown()) {
                    --this.m_rows;
                    if (this.m_rows < 2) {
                        this.m_rows = 5;
                    }
                } else {
                    ++this.m_rows;
                    if (this.m_rows > 5) {
                        this.m_rows = 2;
                    }
                }
                this.validate();
                this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
            }
        }
    }
}

