/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SpringLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int ATTRACTIVE_FORCE = 0;
    protected static final int SPARSE_FACTOR = 1;
    protected static final int CLIENT_FORCE = 2;
    protected static final int CLIENT_FACTOR = 3;
    protected static final int SUPPLIER_FORCE = 4;
    protected static final int SUPPLIER_FACTOR = 5;
    protected static final int REPULSIVE_FORCE = 6;
    protected static final int REPULSIVE_DIAMETER = 7;
    protected static final int ITERATIONS = 8;
    protected static final int TIMEOUT = 9;
    protected static final String[] m_textfield_tags = new String[]{"spring:attraction", "spring:sparse", "spring:clientforce", "spring:clientfactor", "spring:supplierforce", "spring:supplierfactor", "spring:repulsion", "spring:diameter", "spring:iterations", "spring:timeout"};
    protected static final String[] m_textfield_titles = new String[]{"Related force", "Sparseness factor", "Client force", "Client factor", "Supplier force", "Supplier factor", "Unrelated force", "Repulsive range", "Iterations", "Time out"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "1.0", "0.05", "0.5", "0.05", "0.5", "0.01", "0.75", "1000", "300"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "1.0", "0.05", "0.5", "0.05", "0.5", "0.01", "0.75", "1000", "300"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "1.0", "0.05", "0.5", "0.05", "0.5", "0.01", "0.75", "1000", "300"};
    static double m_attractive_force = 0.05;
    static double m_sparse_factor = 1.0;
    static double m_client_force = 0.05;
    static double m_client_factor = 0.5;
    static double m_supplier_force = 0.05;
    static double m_supplier_factor = 0.5;
    static double m_repulsive_force = 0.01;
    static double m_repulsive_diameter = 0.75;
    static int m_iterations = 1000;
    static int m_timeout = 300;
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    @Override
    public String getTag() {
        return "spring:";
    }

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            switch (i) {
                case 8: 
                case 9: {
                    int ival = Integer.parseInt(string);
                    switch (i) {
                        case 8: {
                            m_iterations = ival;
                            break;
                        }
                        case 9: {
                            m_timeout = ival;
                        }
                    }
                    break;
                }
                default: {
                    double dval = Double.parseDouble(string);
                    switch (i) {
                        case 0: {
                            m_attractive_force = dval;
                            break;
                        }
                        case 1: {
                            m_sparse_factor = dval;
                            break;
                        }
                        case 2: {
                            m_client_force = dval;
                            break;
                        }
                        case 3: {
                            m_client_factor = dval;
                            break;
                        }
                        case 4: {
                            m_supplier_force = dval;
                            break;
                        }
                        case 5: {
                            m_supplier_factor = dval;
                            break;
                        }
                        case 6: {
                            m_repulsive_force = dval;
                            break;
                        }
                        case 7: {
                            m_repulsive_diameter = dval;
                        }
                    }
                }
            }
            SpringLayout.m_textfield_currents[i] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        for (int i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        String[] textfield_tags = m_textfield_tags;
        for (int i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.equals(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    SpringLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    this.setParameter(i, value);
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        String[] emit_strings;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                emit_strings = m_textfield_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                emit_strings = m_textfield_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
    }

    public SpringLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Old Spring";
    }

    @Override
    public String getMenuLabel() {
        return "Layout using old spring algorithm";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        SpringConfigure configure = new SpringConfigure();
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean doLayout1(Vector selectedBoxes, EntityInstance container) {
        double ydiff;
        double xdiff;
        int j;
        EntityInstance e;
        SpringNode springNode;
        int i;
        Option option = Options.getDiagramOptions();
        Diagram diagram = this.m_ls.getDiagram();
        double attractive_force = m_attractive_force;
        double sparse_factor = m_sparse_factor;
        double client_force = m_client_force;
        double client_factor = m_client_factor;
        double supplier_force = m_supplier_force;
        double supplier_factor = m_supplier_factor;
        double repulsive_force = m_repulsive_force;
        double repulsive_diameter = m_repulsive_diameter;
        int iterations = m_iterations;
        long timeout = m_timeout;
        int size = selectedBoxes.size();
        boolean some_edges = false;
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                EntityInstance e2 = (EntityInstance)selectedBoxes.firstElement();
                double width = 0.5;
                double height = 0.5;
                double x = (1.0 - width) / 2.0;
                double y = (1.0 - height) / 2.0;
                diagram.updateRelLocal(e2, x, y, width, height);
                return true;
            }
        }
        SpringNode[] springNodes = new SpringNode[size];
        boolean isTopClients = option.isTopClients();
        boolean[][] related = new boolean[size][];
        for (i = 0; i < size; ++i) {
            springNodes[i] = springNode = new SpringNode();
            related[i] = new boolean[size - i];
            springNode.m_e = e = (EntityInstance)selectedBoxes.elementAt(i);
            springNode.m_x = e.xRelLocal();
            springNode.m_y = e.yRelLocal();
            springNode.m_xmax = 1.0 - e.widthRelLocal();
            springNode.m_ymax = 1.0 - e.heightRelLocal();
            springNode.m_clients = false;
            springNode.m_suppliers = false;
            e.orMark(0x4000000);
        }
        double ideal_length = 0.0;
        double ideal_client = 0.0;
        double ideal_supplier = 0.0;
        for (i = 0; i < size; ++i) {
            double height1;
            double width1;
            EntityInstance e1;
            RelationInstance ri;
            springNode = springNodes[i];
            e = springNode.m_e;
            double width = e.widthRelLocal();
            double height = e.heightRelLocal();
            Enumeration en = e.srcLiftedRelationElements();
            if (en != null) {
                block6: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown()) continue;
                    e1 = ri.getDrawDst();
                    if (e1.isMarked(6)) {
                        springNode.m_suppliers = true;
                    }
                    if (!e1.isMarked(0x4000000)) continue;
                    some_edges = true;
                    for (j = i + 1; j < size; ++j) {
                        if (e1 != springNodes[j].m_e) continue;
                        related[i][j - i] = true;
                        related[i][0] = true;
                        related[j][0] = true;
                        width1 = e1.widthRelLocal();
                        height1 = e1.heightRelLocal();
                        xdiff = width + width1;
                        if (xdiff > ideal_length) {
                            ideal_length = xdiff;
                        }
                        if (!((ydiff = height + height1) > ideal_length)) continue block6;
                        ideal_length = ydiff;
                        continue block6;
                    }
                }
            }
            if ((en = e.dstLiftedRelationElements()) != null) {
                block8: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown()) continue;
                    e1 = ri.getDrawSrc();
                    if (e1.isMarked(6)) {
                        springNode.m_clients = true;
                    }
                    if (!e1.isMarked(0x4000000)) continue;
                    some_edges = true;
                    for (j = i + 1; j < size; ++j) {
                        if (e1 != springNodes[j].m_e) continue;
                        related[i][j - i] = true;
                        related[i][0] = true;
                        related[j][0] = true;
                        width1 = e1.widthRelLocal();
                        height1 = e1.heightRelLocal();
                        xdiff = width + width1;
                        if (xdiff > ideal_length) {
                            ideal_length = xdiff;
                        }
                        if (!((ydiff = height + height1) > ideal_length)) continue block8;
                        ideal_length = ydiff;
                        continue block8;
                    }
                }
            }
            if (!some_edges) {
                return false;
            }
            if (springNode.m_clients || springNode.m_suppliers) {
                if (springNode.m_clients & springNode.m_suppliers) {
                    springNode.m_clients = false;
                    springNode.m_suppliers = false;
                } else if (!isTopClients) {
                    boolean temp = springNode.m_clients;
                    springNode.m_clients = springNode.m_suppliers;
                    springNode.m_suppliers = temp;
                }
            }
            e.nandMark(0x4000000);
        }
        ideal_client = ideal_length * client_factor;
        ideal_supplier = ideal_length * supplier_factor;
        ideal_length *= sparse_factor;
        timeout = System.currentTimeMillis() + timeout * 1000L;
        for (int iteration = iterations; iteration > 0; --iteration) {
            for (i = 0; i < size; ++i) {
                springNode = springNodes[i];
                double x = springNode.m_x;
                double y = springNode.m_y;
                double xmax = springNode.m_xmax;
                double ymax = springNode.m_ymax;
                if (springNode.m_suppliers || springNode.m_clients) {
                    y = springNode.m_suppliers ? (y += (ymax - y - ideal_supplier) * supplier_force) : (y += (ideal_client - y) * client_force);
                    if (y > ymax) {
                        y = ymax;
                    }
                    if (y < 0.0) {
                        y = 0.0;
                    }
                }
                for (j = i + 1; j < size; ++j) {
                    SpringNode springNode1 = springNodes[j];
                    double x1 = springNode1.m_x;
                    double y1 = springNode1.m_y;
                    double x1max = springNode1.m_xmax;
                    double y1max = springNode1.m_ymax;
                    xdiff = x1 - x;
                    ydiff = y1 - y;
                    if (xdiff == 0.0 && ydiff == 0.0) {
                        xdiff = i % 3 - 1;
                        ydiff = xdiff == 0.0 ? (double)(j % 2 * 2 - 1) : (double)(j % 3 - 1);
                    }
                    double length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    double f = related[i][j - i] ? (length - ideal_length) * attractive_force : (length - repulsive_diameter) * repulsive_force;
                    x += f * xdiff / length;
                    x1 -= f * xdiff / length;
                    y += f * ydiff / length;
                    y1 -= f * ydiff / length;
                    if (x > xmax) {
                        x1 += xmax - x;
                        x = xmax;
                    }
                    if (x1 > x1max) {
                        x += x1max - x1;
                        x1 = x1max;
                    }
                    if (x < 0.0) {
                        x1 -= x;
                        x = 0.0;
                    }
                    if (x1 < 0.0) {
                        x -= x1;
                        x1 = 0.0;
                    }
                    if (x > xmax) {
                        x = xmax;
                    }
                    if (x1 > x1max) {
                        x1 = x1max;
                    }
                    if (y > ymax) {
                        y1 += ymax - y;
                        y = ymax;
                    }
                    if (y1 > y1max) {
                        y += y1max - y1;
                        y1 = y1max;
                    }
                    if (y < 0.0) {
                        y1 -= y;
                        y = 0.0;
                    }
                    if (y1 < 0.0) {
                        y -= y1;
                        y1 = 0.0;
                    }
                    if (y > ymax) {
                        y = ymax;
                    }
                    if (y1 > y1max) {
                        y1 = y1max;
                    }
                    springNode1.m_x = x1;
                    springNode1.m_y = y1;
                }
                springNode.m_x = x;
                springNode.m_y = y;
            }
            if (System.currentTimeMillis() <= timeout) continue;
            System.out.println(Util.toLocaleString() + ": SpringLayout: Timeout after " + (iterations - iteration) + " iterations");
            break;
        }
        for (i = 0; i < size; ++i) {
            springNode = springNodes[i];
            e = springNode.m_e;
            diagram.updateRelLocal(e, springNode.m_x, springNode.m_y, e.widthRelLocal(), e.heightRelLocal());
        }
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        ls.setLayouter(this);
        Vector selectedBoxes = dg.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Spring layout requires that all things laid out share same parent";
        }
        msg = "Graph redrawn using Old Spring Layout";
        ls.doLayout1(this, selectedBoxes, parent, false);
        return msg;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    class SpringNode {
        public EntityInstance m_e;
        double m_x;
        double m_y;
        double m_xmax;
        double m_ymax;
        boolean m_clients;
        boolean m_suppliers;

        SpringNode() {
        }
    }

    class SpringConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public SpringConfigure() {
            int i;
            super(SpringLayout.this.getLs().getFrame(), "SpringLayout Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel labelPanel1 = new JPanel();
            JPanel valuePanel1 = new JPanel();
            JPanel labelPanel2 = new JPanel();
            JPanel valuePanel2 = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
            labelPanel1.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            valuePanel1.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            labelPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(5, 1, 0, 10);
            valuePanel2.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                JPanel valuePanel;
                JPanel labelPanel;
                if (i % 2 == 0) {
                    labelPanel = labelPanel1;
                    valuePanel = valuePanel1;
                } else {
                    labelPanel = labelPanel2;
                    valuePanel = valuePanel2;
                }
                JLabel label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                labelPanel.add(label);
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                textfield.setFont(font);
                textfield.addActionListener(this);
                valuePanel.add(textfield);
            }
            JPanel leftPanel = new JPanel();
            leftPanel.setLayout(new BorderLayout());
            leftPanel.add("West", labelPanel1);
            leftPanel.add("East", valuePanel1);
            JPanel rightPanel = new JPanel();
            rightPanel.setLayout(new BorderLayout());
            rightPanel.add("West", labelPanel2);
            rightPanel.add("East", valuePanel2);
            topPanel.add("West", leftPanel);
            topPanel.add("East", rightPanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            contentPane.add("Center", this.m_message);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                String string = m_button_titles[i];
                if (string == null) {
                    string = SpringLayout.this.undoLabel();
                }
                this.m_buttons[i] = button = new JButton(string);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 6: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SpringLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                }
                case 4: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    return;
                }
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SpringLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore ls = SpringLayout.this.m_ls;
                    ls.invertUndo();
                    this.m_buttons[state].setText(SpringLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SpringLayout.this.m_ls.getFrame(), "Attractive force\n  Scales size of jumps towards ideal distance for related nodes.\n  Actual jump is proportional to difference from ideal distance\nRepulsive force\n  Scales size of jumps towards repulsive diameter for unrelated nodes\n  Actual jump is proportional to difference from repulsive diameter\nClient force\n  Scales size of jumps towards ideal distance from clients\nSupplier force\n  Scales size of jumps towards ideal distance from suppliers\n\nSparse factor\n  The maximum width/height of any two distinct nodes is multiplied\n  by the sparse factor to give the ideal distance\nClient factor\n  The maximum width/height of any two distinct nodes is multiplied\n  by the client factor to give the ideal distance from clients\nSupplier factor\n  The maximum width/height of any two distinct nodes is multiplied\n  by the supplier factor to give the ideal distance from suppliers\nRepulsive diameter\n  Ideal ratio of distance between unrelated nodes to screen size\nIterations\n  Number of times to iterate over the algorithm\nTimeout\n  Maximum number of seconds to spend iterating", "Help", 0);
                    return;
                }
            }
            block22: for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield = this.m_textfields[i];
                if (source != textfield && state != 0) continue;
                String string = textfield.getText();
                string = string.trim();
                String name = m_textfield_titles[i];
                switch (i) {
                    case 8: 
                    case 9: {
                        try {
                            int ivalue = Integer.parseInt(string);
                            if (ivalue > 0) continue block22;
                            this.m_message.setText(name + " must be positive");
                            return;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not an integer value");
                            return;
                        }
                    }
                    default: {
                        try {
                            Double.parseDouble(string);
                            continue block22;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (state) {
                case 0: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SpringLayout.this.setParameter(i, this.m_textfields[i].getText());
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

