/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyJTable;
import lsedit.MyTableModel;
import lsedit.RelationClass;

public class SpanningClasses
extends JDialog
implements ActionListener {
    protected static final int BUTTON_ADD = 0;
    protected static final int BUTTON_REMOVE = 1;
    protected static final int BUTTON_UP = 2;
    protected static final int BUTTON_DOWN = 3;
    protected static final int BUTTON_OK = 4;
    protected static final int BUTTON_CANCEL = 5;
    protected static final int BUTTON_RESTART = 6;
    protected static final int BUTTON_HELP = 7;
    protected static final String[] m_button_titles = new String[]{"Add", "Remove", "Up", "Down", "Ok", "Cancel", "Restart", "Help"};
    private LandscapeEditorCore m_ls;
    private Diagram m_diagram;
    private MyTableModel m_model;
    private MyJTable m_table;
    private JButton[] m_buttons;

    protected SpanningClasses(JFrame frame, Diagram diagram) {
        super(frame, "Choose Spanning Classes", true);
        MyJTable table;
        MyTableModel tableModel;
        this.m_diagram = diagram;
        this.m_ls = diagram.getLs();
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        this.m_model = tableModel = new MyTableModel(diagram);
        this.m_table = table = new MyJTable(tableModel);
        table.setFont(font);
        FontMetrics fm = this.getFontMetrics(font);
        table.setRowHeight(fm.getHeight() + 4);
        table.setVisible(true);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setVisible(true);
        contentPane.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 4);
        gridLayout.setVgap(0);
        bottomPanel.setLayout(gridLayout);
        this.m_buttons = new JButton[m_button_titles.length];
        for (int i = 0; i < m_button_titles.length; ++i) {
            JButton button;
            this.m_buttons[i] = button = new JButton(m_button_titles[i]);
            button.setFont(bold);
            button.addActionListener(this);
            bottomPanel.add(button);
        }
        contentPane.add((Component)bottomPanel, "South");
        this.pack();
        this.setVisible(true);
        table.removeEditor();
    }

    public RelationClass[] getSpanningClasses() {
        int cnt = this.m_model.getCntSpanning();
        RelationClass[] ret = null;
        if (cnt > 0) {
            Vector classes = this.m_model.getClasses();
            ret = new RelationClass[cnt];
            for (int i = 0; i < cnt; ++i) {
                ret[i] = (RelationClass)classes.elementAt(i);
            }
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        int state = -1;
        for (int i = 0; i < m_button_titles.length; ++i) {
            if (source != this.m_buttons[i]) continue;
            state = i;
            break;
        }
        switch (state) {
            case 0: {
                this.m_model.add(this.m_table.getSelectedRows());
                return;
            }
            case 1: {
                this.m_model.remove(this.m_table.getSelectedRows());
                return;
            }
            case 2: {
                this.m_model.up(this.m_table.getSelectedRows());
                return;
            }
            case 3: {
                this.m_model.down(this.m_table.getSelectedRows());
                return;
            }
            case 5: {
                this.m_model.clearSpanningClasses();
            }
            case 4: {
                break;
            }
            case 6: {
                this.m_model.restart();
                return;
            }
            case 7: {
                JOptionPane.showMessageDialog(this.m_ls.getFrame(), "Blue relation classes in the order shown will be used to form a new spanning\ntree. Earlier named classes will be preferred for this purpose over later\nnamed classes.  Use [add] to add to the end of the set of selected spanning\nclasses, [remove] to remove from this set, and [up] and [down] to reorder items\nin the list of spanning classes.  Multiple items may be selected by each of these\noperations.", "Help", 0);
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }

    public static RelationClass[] getSpanningClasses(LandscapeEditorCore ls) {
        SpanningClasses spanningClasses = new SpanningClasses(ls.getFrame(), ls.getDiagram());
        RelationClass[] classes = spanningClasses.getSpanningClasses();
        spanningClasses.dispose();
        return classes;
    }
}

