/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.HiArc;
import lsedit.HiChildren;
import lsedit.HiGraph;
import lsedit.HiGraphCoordinates;
import lsedit.HiGraphException;
import lsedit.HiGroup;
import lsedit.HiRank;
import lsedit.HiRow;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SimplexLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int XGAP = 0;
    protected static final int YGAP = 1;
    protected static final int SIMPLEX = 2;
    protected static final int CROSSINGS = 3;
    protected static final int BORDER = 4;
    protected static final String[] m_textfield_tags = new String[]{"simplex:xgap", "simplex:ygap", "simplex:simplex", "simplex:crossings", "simplex:border"};
    protected static final String[] m_textfield_titles = new String[]{"Minimum horizontal gap between nodes:", "Minimum vertical gap between nodes:", "Maximum allowed simplex pivots:", "Maximum reorderings of a row:", "Percentage for border"};
    protected static final String[] m_textfield_resets = new String[]{"20", "20", "10000", "125", "0.08"};
    protected static String[] m_textfield_defaults = new String[]{"20", "20", "10000", "125", "0.08"};
    protected static String[] m_textfield_currents = new String[]{"20", "20", "10000", "125", "0.08"};
    private static int m_xgap = 20;
    private static int m_ygap = 20;
    private static int m_simplex = 10000;
    private static int m_crossings = 125;
    private static double m_border = 0.08;
    private static RelationClass m_designated = null;
    private static boolean m_lisp = false;
    protected static final int FIXEDRATIO = 0;
    protected static final String[] m_checkbox_tags = new String[]{"simplex:fixedratio"};
    protected static final String[] m_checkbox_titles = new String[]{"Scale using fixed ratio"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false};
    protected static boolean[] m_checkbox_currents = new boolean[]{false};
    protected static final int FIXEDORDER = 0;
    protected static final String[] m_combobox_tags = new String[]{"simplex:fixedorder"};
    protected static final String[] m_combobox_titles = new String[]{"Horizontal order by"};
    protected static final String[] g_preserveOrdering = new String[]{"edge crossings", "hierarchical order", "src edge order"};
    protected static final String[][] m_combobox_entries = new String[][]{g_preserveOrdering};
    protected static final int[] m_combobox_resets = new int[]{0};
    protected static int[] m_combobox_defaults = new int[]{0};
    protected static int[] m_combobox_currents = new int[]{0};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_DEFAULT = 3;
    protected static final int BUTTON_SET = 4;
    protected static final int BUTTON_RESET = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Use remembered default", "Set default to current", "Set default to initial"};
    public static final int horizMargin = 2;
    public static final int vertMargin = 2;
    private static int m_weight_1dummy = 0;
    private static int m_weight_2dummy = 0;
    private static int m_outside_bias = 1;
    private static int m_group_children = 0;
    private static boolean m_fixedRatio;
    private static boolean m_bends;
    String m_message;

    protected static boolean parameterBoolean(int i) {
        return m_checkbox_currents[i];
    }

    protected static int parameterCombo(int i) {
        return m_combobox_currents[i];
    }

    protected void setParameter(int i, String string) {
        string = string.trim();
        try {
            switch (i) {
                case 4: {
                    double dval;
                    m_border = dval = Double.parseDouble(string);
                    break;
                }
                default: {
                    int ival = Integer.parseInt(string);
                    switch (i) {
                        case 0: {
                            m_xgap = ival;
                            break;
                        }
                        case 1: {
                            m_ygap = ival;
                            break;
                        }
                        case 2: {
                            m_simplex = ival;
                            break;
                        }
                        case 3: {
                            m_crossings = ival;
                        }
                    }
                    SimplexLayout.m_textfield_currents[i] = string;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getTag() {
        return "simplex:";
    }

    @Override
    public void reset() {
        int i;
        String[] textfield_resets = m_textfield_resets;
        String[] textfield_defaults = m_textfield_defaults;
        String[] textfield_currents = m_textfield_currents;
        boolean[] checkbox_resets = m_checkbox_resets;
        boolean[] checkbox_defaults = m_checkbox_defaults;
        boolean[] checkbox_currents = m_checkbox_currents;
        int[] combo_resets = m_combobox_resets;
        int[] combo_defaults = m_combobox_defaults;
        int[] combo_currents = m_combobox_currents;
        for (i = 0; i < textfield_resets.length; ++i) {
            String string;
            textfield_defaults[i] = string = textfield_resets[i];
            textfield_currents[i] = string;
        }
        for (i = 0; i < checkbox_resets.length; ++i) {
            boolean bool;
            checkbox_defaults[i] = bool = checkbox_resets[i];
            checkbox_currents[i] = bool;
        }
        for (i = 0; i < combo_resets.length; ++i) {
            int combo;
            combo_defaults[i] = combo = combo_resets[i];
            combo_currents[i] = combo;
        }
    }

    @Override
    public void loadLayoutOption(int mode, String attribute, String value) {
        int i;
        String[] textfield_tags = m_textfield_tags;
        for (i = 0; i < textfield_tags.length; ++i) {
            if (!attribute.equals(textfield_tags[i])) continue;
            switch (mode) {
                case 0: {
                    SimplexLayout.m_textfield_defaults[i] = value;
                }
                case 1: {
                    this.setParameter(i, value);
                }
            }
            return;
        }
        String[] checkbox_tags = m_checkbox_tags;
        for (i = 0; i < checkbox_tags.length; ++i) {
            if (!attribute.equals(checkbox_tags[i])) continue;
            boolean bool = value.charAt(0) == 't';
            switch (mode) {
                case 0: {
                    SimplexLayout.m_checkbox_defaults[i] = bool;
                }
                case 1: {
                    SimplexLayout.m_checkbox_currents[i] = bool;
                }
            }
            return;
        }
        String[] combobox_tags = m_combobox_tags;
        for (i = 0; i < combobox_tags.length; ++i) {
            if (!attribute.equals(combobox_tags[i])) continue;
            int val = value.charAt(0) - 48;
            if (val >= 0 && val <= 9) {
                switch (mode) {
                    case 0: {
                        SimplexLayout.m_combobox_defaults[i] = val;
                    }
                    case 1: {
                        SimplexLayout.m_combobox_currents[i] = val;
                    }
                }
            }
            return;
        }
    }

    @Override
    public void saveLayoutOptions(int mode, PrintWriter ps) {
        int i;
        int[] emit_combos;
        boolean[] emit_booleans;
        String[] emit_strings;
        int[] prior_combos;
        boolean[] prior_booleans;
        String[] prior_strings;
        switch (mode) {
            case 0: {
                prior_strings = m_textfield_resets;
                prior_booleans = m_checkbox_resets;
                prior_combos = m_combobox_resets;
                emit_strings = m_textfield_defaults;
                emit_booleans = m_checkbox_defaults;
                emit_combos = m_combobox_defaults;
                break;
            }
            case 1: {
                prior_strings = m_textfield_defaults;
                prior_booleans = m_checkbox_defaults;
                prior_combos = m_combobox_defaults;
                emit_strings = m_textfield_currents;
                emit_booleans = m_checkbox_currents;
                emit_combos = m_combobox_currents;
                break;
            }
            default: {
                return;
            }
        }
        for (i = 0; i < m_textfield_tags.length; ++i) {
            String string = emit_strings[i];
            if (string.equals(prior_strings[i])) continue;
            ps.println(m_textfield_tags[i] + "=" + string);
        }
        for (i = 0; i < m_checkbox_tags.length; ++i) {
            boolean bool = emit_booleans[i];
            if (bool == prior_booleans[i]) continue;
            ps.println(m_checkbox_tags[i] + "=" + (bool ? "true" : "false"));
        }
        for (i = 0; i < m_combobox_tags.length; ++i) {
            int val = emit_combos[i];
            if (val == prior_combos[i]) continue;
            ps.println(m_combobox_tags[i] + "=" + val);
        }
    }

    public static void lispSemantics() {
        m_lisp = true;
    }

    public static void setBends(boolean value) {
        if (value) {
            m_weight_1dummy = 2;
            m_weight_2dummy = 8;
        } else {
            m_weight_1dummy = 0;
            m_weight_2dummy = 0;
        }
        m_bends = value;
    }

    public static boolean hasBends() {
        return m_bends;
    }

    public static int xgap() {
        return m_xgap;
    }

    public static boolean xgap(int value) {
        if (value >= 1) {
            m_xgap = value;
            return true;
        }
        return false;
    }

    public static int ygap() {
        return m_ygap;
    }

    public static boolean ygap(int value) {
        if (value >= 1) {
            m_ygap = value;
            return true;
        }
        return false;
    }

    public static int simplex() {
        return m_simplex;
    }

    public static boolean simplex(int value) {
        if (value >= 0) {
            m_simplex = value;
            return true;
        }
        return false;
    }

    public static int crossing() {
        return m_crossings;
    }

    public static boolean crossing(int value) {
        if (value >= 0) {
            m_crossings = value;
            return true;
        }
        return false;
    }

    public static double border() {
        return m_border;
    }

    public static void border(double value) {
        m_border = value;
    }

    public static boolean fixedRatio() {
        return m_fixedRatio;
    }

    public static void fixedRatio(boolean value) {
        m_fixedRatio = value;
    }

    public static int weight_1dummy() {
        return m_weight_1dummy;
    }

    public static boolean weight_1dummy(int value) {
        if (value >= 1) {
            m_weight_1dummy = value;
            return true;
        }
        return false;
    }

    public static int weight_2dummy() {
        return m_weight_2dummy;
    }

    public static boolean weight_2dummy(int value) {
        if (value >= 1) {
            m_weight_2dummy = value;
            return true;
        }
        return false;
    }

    public static int outside_bias() {
        return m_outside_bias;
    }

    public static boolean outside_bias(int value) {
        if (value >= 0) {
            m_outside_bias = value;
            return true;
        }
        return false;
    }

    public static int group_children() {
        return m_group_children;
    }

    public static boolean group_children(int value) {
        if (value >= -1 && value <= 1) {
            m_group_children = value;
            return true;
        }
        return false;
    }

    public static int xmargin() {
        return 2;
    }

    public static int ymargin() {
        return 2;
    }

    public static RelationClass getDesignatedClass() {
        return m_designated;
    }

    public boolean coordinates(HiGraph root) {
        try {
            HiGraphCoordinates.coordinates(this, root);
            return true;
        }
        catch (HiGraphException e) {
            System.out.println("HiGraph error in HiGraphCoordinates: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Error during HiGraph layout in HiGraphCoordinates: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    protected void orderByEdges(HiGraph root) {
        int outSize;
        Vector out;
        HiGraph node;
        HiArc arc;
        int i;
        boolean seen = false;
        Vector children = root.children();
        int childrenSize = children.size();
        for (i = 0; i < childrenSize; ++i) {
            arc = (HiArc)children.elementAt(i);
            node = arc.to();
            out = node.out();
            node.m_position = out.size();
        }
        Vector children1 = (Vector)children.clone();
        SortVector.byPosition(children1);
        int position = 0;
        for (i = 0; i < childrenSize; ++i) {
            arc = (HiArc)children.elementAt(i);
            node = arc.to();
            node.m_position = position;
            position += 1024;
        }
        i = childrenSize;
        block2: while (--i >= 0 && (outSize = (out = (node = (arc = (HiArc)children1.elementAt(i)).to()).out()).size()) >= 2) {
            int listSize;
            Vector srcRelList;
            EntityInstance e = node.getReferencedObject();
            if (e == null || (srcRelList = e.getSrcRelList()) == null || (listSize = srcRelList.size()) < 2) continue;
            position = -1;
            int phase = 0;
            while (true) {
                boolean reorder = false;
                for (int j = 0; j < outSize; ++j) {
                    EntityInstance e2;
                    RelationInstance ri;
                    EntityInstance e1;
                    arc = (HiArc)out.elementAt(j);
                    HiGraph to = arc.to();
                    if (to.m_rank <= node.m_rank || (to.m_position & 0x3FF) != 0 || (e1 = to.getReferencedObject()) == null) continue;
                    int k = listSize;
                    while (--k >= 0 && ((ri = (RelationInstance)srcRelList.elementAt(k)).isMarked(0x100000) || !e1.hasDescendantOrSelf(e2 = ri.getDst()))) {
                    }
                    if (k < 0) continue;
                    if (phase == 0) {
                        if (position < 0) {
                            position = to.m_position;
                            continue;
                        }
                        reorder = true;
                        break;
                    }
                    to.m_position = position | k + 1 & 0x3FF;
                    seen = true;
                }
                if (!reorder) continue block2;
                ++phase;
            }
        }
        if (seen) {
            SortVector.byPosition(children);
        }
    }

    public boolean layout(HiGraph root) {
        int fixedOrder = SimplexLayout.parameterCombo(0);
        try {
            HiGroup.group(root, SimplexLayout.group_children());
            HiRank.compute(root, SimplexLayout.simplex(), SimplexLayout.getDesignatedClass());
            switch (fixedOrder) {
                case 0: {
                    HiChildren.order(root, SimplexLayout.outside_bias());
                    HiRow.order(this, root);
                    break;
                }
                case 2: {
                    this.orderByEdges(root);
                }
            }
            boolean ret = this.coordinates(root);
            return ret;
        }
        catch (HiGraphException e) {
            System.out.println("HiGraph error in " + root + ": " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Error during HiGraph layout in " + root + ": " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public SimplexLayout(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        super(ls, fallback);
    }

    @Override
    public String getName() {
        return "Simplex";
    }

    @Override
    public String getMenuLabel() {
        return "Layout using Simplex algorithm";
    }

    protected static int edgesBetween(EntityInstance from, EntityInstance to) {
        EntityInstance e;
        Vector srcList = from.getSrcLiftedList();
        int ret = 0;
        if (srcList != null) {
            int i = srcList.size();
            while (--i >= 0) {
                RelationInstance ri = (RelationInstance)srcList.elementAt(i);
                if (!ri.isRelationShown() || !to.hasDescendantOrSelf(e = ri.getDrawDst())) continue;
                ++ret;
            }
        }
        if (from.isOpen()) {
            Enumeration en = from.getChildrenShown();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                ret += SimplexLayout.edgesBetween(e, to);
            }
        }
        return ret;
    }

    protected static int edgesFromClient(EntityInstance to, boolean visibleEdges) {
        EntityInstance e;
        Enumeration en = to.dstLiftedRelationElements();
        int ret = 0;
        if (en != null) {
            while (en.hasMoreElements()) {
                RelationClass rc;
                RelationInstance ri = (RelationInstance)en.nextElement();
                if (visibleEdges && !(rc = ri.getRelationClass()).isShown() || !(e = ri.getDrawSrc()).isMarked(2)) continue;
                ++ret;
            }
        }
        if (to.isOpen()) {
            en = to.getChildrenShown();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                ret += SimplexLayout.edgesFromClient(e, visibleEdges);
            }
        }
        return ret;
    }

    protected static int edgesToSupplier(EntityInstance from, boolean visibleEdges) {
        EntityInstance e;
        Enumeration en = from.srcLiftedRelationElements();
        int ret = 0;
        if (en != null) {
            while (en.hasMoreElements()) {
                RelationClass rc;
                RelationInstance ri = (RelationInstance)en.nextElement();
                if (visibleEdges && !(rc = ri.getRelationClass()).isShown() || !(e = ri.getDrawDst()).isMarked(4)) continue;
                ++ret;
            }
        }
        if (from.isOpen()) {
            en = from.getChildrenShown();
            while (en.hasMoreElements()) {
                e = (EntityInstance)en.nextElement();
                ret += SimplexLayout.edgesToSupplier(e, visibleEdges);
            }
        }
        return ret;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public boolean configure(LandscapeEditorCore ls) {
        SimplexConfigure configure = new SimplexConfigure(ls);
        boolean ok = configure.ok();
        configure.dispose();
        return ok;
    }

    @Override
    public boolean doLayout1(Vector selectedBoxes, EntityInstance container) {
        HiGraph to;
        int weight;
        HiGraph from;
        HiArc arc1;
        EntityInstance e2;
        Enumeration en;
        Option option = Options.getDiagramOptions();
        LandscapeEditorCore ls = this.m_ls;
        Diagram diagram = ls.getDiagram();
        int fixedOrder = SimplexLayout.parameterCombo(0);
        boolean visibleEdges = option.isVisibleEdges();
        boolean some_src_edges = false;
        boolean some_dst_edges = false;
        m_fixedRatio = SimplexLayout.parameterBoolean(0);
        double border = SimplexLayout.border();
        switch (selectedBoxes.size()) {
            case 0: {
                return true;
            }
            case 1: {
                EntityInstance e2 = (EntityInstance)selectedBoxes.firstElement();
                double widthrel = 1.0 - border;
                double heightrel = 1.0 - border;
                double xrel = (1.0 - widthrel) / 2.0;
                double yrel = (1.0 - heightrel) / 2.0;
                diagram.updateRelLocal(e2, xrel, yrel, widthrel, heightrel);
                return true;
            }
        }
        if (m_lisp) {
            en = diagram.enumRelationClassesInOrder();
            while (en.hasMoreElements()) {
                RelationClass rc = (RelationClass)en.nextElement();
                String id = rc.getId();
                if (!id.equalsIgnoreCase("cdr")) continue;
                m_designated = rc;
            }
            m_lisp = false;
        }
        Graphics graphics = ls.getGraphics();
        int width = diagram.getWidth();
        int height = diagram.getHeight();
        double avg_relheight = 0.0;
        int max_width = 0;
        en = selectedBoxes.elements();
        while (en.hasMoreElements()) {
            e2 = (EntityInstance)en.nextElement();
            avg_relheight += e2.heightRelLocal();
            int fit = e2.getMinFitWidth(graphics);
            if (fit <= max_width) continue;
            max_width = fit;
        }
        avg_relheight /= (double)selectedBoxes.size();
        HiGraph root = new HiGraph(null, "root", 0, height);
        en = selectedBoxes.elements();
        while (en.hasMoreElements()) {
            e2 = (EntityInstance)en.nextElement();
            root.newChild(e2, e2.getEntityLabel(), max_width, (int)(avg_relheight * (double)height));
        }
        Vector children = root.children();
        en = children.elements();
        while (en.hasMoreElements()) {
            arc1 = (HiArc)en.nextElement();
            from = arc1.to();
            e2 = from.getReferencedObject();
            Enumeration en1 = children.elements();
            while (en1.hasMoreElements()) {
                EntityInstance other;
                HiArc arc2 = (HiArc)en1.nextElement();
                if (arc2 == arc1 || (weight = SimplexLayout.edgesBetween(e2, other = (to = arc2.to()).getReferencedObject())) <= 0) continue;
                some_src_edges = true;
                some_dst_edges = true;
                arc1 = to.newInputArc(from);
                arc1.setWeight(weight);
                arc1.setMinlength(1);
            }
        }
        HiGraph client = null;
        HiGraph supplier = null;
        if (container != ls.getDiagram().getRootInstance()) {
            if (option.isShowClients()) {
                en = children.elements();
                while (en.hasMoreElements()) {
                    arc1 = (HiArc)en.nextElement();
                    to = arc1.to();
                    e2 = to.getReferencedObject();
                    if (e2 == null || (weight = SimplexLayout.edgesFromClient(e2, visibleEdges)) <= 0) continue;
                    if (client == null) {
                        client = root.newChild(null, "client", 0, 0);
                    }
                    arc1 = option.isTopClients() ? to.newInputArc(client) : client.newInputArc(to);
                    some_src_edges = true;
                    arc1.setWeight(weight);
                    arc1.setMinlength(1);
                }
            }
            if (option.isShowSuppliers()) {
                en = children.elements();
                while (en.hasMoreElements()) {
                    arc1 = (HiArc)en.nextElement();
                    from = arc1.to();
                    e2 = from.getReferencedObject();
                    if (e2 == null || (weight = SimplexLayout.edgesToSupplier(e2, visibleEdges)) <= 0) continue;
                    if (supplier == null) {
                        supplier = root.newChild(null, "supplier", 0, 0);
                    }
                    arc1 = option.isTopClients() ? supplier.newInputArc(from) : from.newInputArc(supplier);
                    some_dst_edges = true;
                    arc1.setWeight(weight);
                    arc1.setMinlength(1);
                }
            }
        }
        if (!some_src_edges || !some_dst_edges) {
            return false;
        }
        Vector<HiArc> unconnected = null;
        int i = children.size();
        while (--i >= 0) {
            arc1 = (HiArc)children.elementAt(i);
            from = arc1.to();
            if (from.in().size() != 0 || from.out().size() != 0) continue;
            if (unconnected == null) {
                unconnected = new Vector<HiArc>();
            }
            unconnected.addElement(arc1);
            children.remove(i);
        }
        if (!this.layout(root)) {
            root = null;
            this.m_message = "Simplex layout algorithm failed";
            return false;
        }
        int min_y = Integer.MAX_VALUE;
        int min_x = Integer.MAX_VALUE;
        int max_y = Integer.MIN_VALUE;
        int max_x = Integer.MIN_VALUE;
        children = root.children();
        en = children.elements();
        while (en.hasMoreElements()) {
            arc1 = (HiArc)en.nextElement();
            from = arc1.to();
            e2 = from.getReferencedObject();
            if (e2 == null) continue;
            int min_x1 = from.x() - from.width() / 2;
            int max_x1 = min_x1 + from.width();
            int min_y1 = from.y() - from.height() / 2;
            int max_y1 = min_y1 + from.height();
            if (min_x1 < min_x) {
                min_x = min_x1;
            }
            if (max_x1 > max_x) {
                max_x = max_x1;
            }
            if (min_y1 < min_y) {
                min_y = min_y1;
            }
            if (max_y1 <= max_y) continue;
            max_y = max_y1;
        }
        if (unconnected != null) {
            int new_max_y = max_y;
            int cols = 1;
            int rows = 0;
            int at_y = min_y;
            i = 0;
            while (true) {
                arc1 = (HiArc)unconnected.elementAt(i);
                from = arc1.to();
                children.addElement(arc1);
                from.y(at_y + from.height() / 2);
                if ((at_y += from.height()) > new_max_y) {
                    new_max_y = at_y;
                }
                if (cols == 1) {
                    ++rows;
                }
                if (++i >= unconnected.size()) break;
                if ((at_y += m_ygap) <= max_y) continue;
                ++cols;
                at_y = min_y;
            }
            min_x -= cols * (max_width + m_xgap);
            max_y = new_max_y;
            int row = 0;
            int col = 0;
            for (i = 0; i < unconnected.size(); ++i) {
                arc1 = (HiArc)unconnected.elementAt(i);
                from = arc1.to();
                from.x(min_x + col * (max_width + m_xgap) + from.width() / 2);
                if (++row < rows) continue;
                ++col;
                row = 0;
            }
        }
        double graph_width = max_x - min_x;
        double graph_x = (double)min_x - graph_width * border / 2.0;
        graph_width += graph_width * border;
        double graph_height = max_y - min_y;
        double graph_y = (double)min_y - graph_height * border / 2.0;
        graph_height += graph_height * border;
        if (graph_width <= 0.0 || graph_height <= 0.0) {
            return false;
        }
        double shiftX = 0.0;
        double shiftY = 0.0;
        double scaleWidth = 1.0;
        double scaleHeight = 1.0;
        if (SimplexLayout.fixedRatio()) {
            scaleWidth = graph_width * (double)height / (graph_height * (double)width);
            if (scaleWidth <= 1.0) {
                shiftX = (1.0 - scaleWidth) / 2.0;
            } else {
                scaleHeight = 1.0 / scaleWidth;
                scaleWidth = 1.0;
                shiftY = (1.0 - scaleHeight) / 2.0;
            }
            graph_width /= scaleWidth;
            graph_height /= scaleHeight;
        }
        en = children.elements();
        while (en.hasMoreElements()) {
            arc1 = (HiArc)en.nextElement();
            from = arc1.to();
            e2 = from.getReferencedObject();
            if (e2 == null) continue;
            double widthrel = (double)from.width() / graph_width;
            double heightrel = (double)from.height() / graph_height;
            double xrel = ((double)from.x() - graph_x) / graph_width;
            double yrel = ((double)from.y() - graph_y) / graph_height;
            diagram.updateRelLocal(e2, xrel += shiftX - widthrel / 2.0, yrel += shiftY - heightrel / 2.0, widthrel, heightrel);
        }
        return true;
    }

    @Override
    public String doLayout(Diagram dg) {
        LandscapeEditorCore ls = this.m_ls;
        this.m_message = "Graph redrawn using Network Simplex algorithm";
        ls.setLayouter(this);
        Vector selectedBoxes = dg.getClusterGroup();
        if (selectedBoxes == null) {
            Util.beep();
            return "No group selected";
        }
        String msg = this.allInDiagram(selectedBoxes);
        if (msg != null) {
            return msg;
        }
        EntityInstance parent = this.parentOfSet(selectedBoxes);
        if (parent == null) {
            return "Simplex algorithm requires that all things laid out share same parent";
        }
        ls.doLayout1(this, selectedBoxes, parent, false);
        return this.m_message;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
        }
    }

    static {
        m_bends = false;
    }

    class SimplexConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JComboBox[] m_comboboxes;
        protected JComboBox m_designatedClass;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public SimplexConfigure(LandscapeEditorCore ls) {
            JLabel label;
            int i;
            super(ls.getFrame(), "Set Simplex Algorithm parameters", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font bold = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel topPanel = new JPanel();
            JPanel leftPanel = new JPanel();
            JPanel rightPanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(8, 1);
            gridLayout.setVgap(10);
            leftPanel.setLayout(gridLayout);
            gridLayout = new GridLayout(8, 1);
            gridLayout.setVgap(10);
            rightPanel.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield;
                label = new JLabel(m_textfield_titles[i], 4);
                label.setFont(bold);
                leftPanel.add(label);
                this.m_textfields[i] = textfield = new JTextField(m_textfield_currents[i], 20);
                textfield.addActionListener(this);
                textfield.setFont(font);
                rightPanel.add(textfield);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (i = 0; i < m_checkbox_tags.length; ++i) {
                JCheckBox checkbox;
                label = new JLabel(m_checkbox_titles[i], 4);
                label.setFont(bold);
                leftPanel.add(label);
                this.m_checkboxes[i] = checkbox = new JCheckBox("", m_checkbox_currents[i]);
                checkbox.setFont(font);
                rightPanel.add(checkbox);
            }
            this.m_comboboxes = new JComboBox[m_combobox_tags.length];
            for (i = 0; i < m_combobox_tags.length; ++i) {
                JComboBox<String> combobox;
                label = new JLabel(m_combobox_titles[i], 4);
                label.setFont(bold);
                leftPanel.add(label);
                this.m_comboboxes[i] = combobox = new JComboBox<String>(m_combobox_entries[i]);
                combobox.setSelectedIndex(m_combobox_currents[i]);
                combobox.setFont(font);
                rightPanel.add(combobox);
            }
            Diagram diagram = ls.getDiagram();
            if (diagram == null) {
                this.m_designatedClass = null;
            } else {
                this.m_designatedClass = new JComboBox();
                label = new JLabel("Horizontal class", 4);
                label.setFont(bold);
                leftPanel.add(label);
                this.m_designatedClass.setFont(font);
                int selected = 0;
                this.m_designatedClass.addItem("");
                i = 0;
                Enumeration en = diagram.enumRelationClassesInOrder();
                while (en.hasMoreElements()) {
                    RelationClass rc = (RelationClass)en.nextElement();
                    String id = rc.getId();
                    this.m_designatedClass.addItem(rc);
                    ++i;
                    if (m_lisp && id.equalsIgnoreCase("cdr")) {
                        m_designated = rc;
                    }
                    if (rc != m_designated) continue;
                    selected = i;
                }
                m_lisp = false;
                this.m_designatedClass.setSelectedIndex(selected);
                rightPanel.add(this.m_designatedClass);
            }
            topPanel.add("West", leftPanel);
            topPanel.add("East", rightPanel);
            Container contentPane = this.getContentPane();
            contentPane.add("North", topPanel);
            this.m_message = new JLabel(" ", 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            contentPane.add("Center", this.m_message);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (i = 0; i < m_button_titles.length; ++i) {
                JButton button;
                this.m_buttons[i] = button = new JButton(m_button_titles[i]);
                button.setFont(bold);
                String tip = m_button_tips[i];
                if (tip != null) {
                    button.setToolTipText(tip);
                }
                button.addActionListener(this);
                bottomPanel.add(button);
            }
            contentPane.add("South", bottomPanel);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int i;
            Object source = ev.getSource();
            int state = -1;
            for (i = 0; i < m_button_titles.length; ++i) {
                if (source != this.m_buttons[i]) continue;
                state = i;
                break;
            }
            switch (state) {
                case 5: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SimplexLayout.m_textfield_defaults[i] = m_textfield_resets[i];
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        SimplexLayout.m_checkbox_defaults[i] = m_checkbox_resets[i];
                    }
                    for (i = 0; i < m_combobox_tags.length; ++i) {
                        SimplexLayout.m_combobox_defaults[i] = m_combobox_resets[i];
                    }
                }
                case 3: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        this.m_textfields[i].setText(m_textfield_defaults[i]);
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        this.m_checkboxes[i].setSelected(m_checkbox_defaults[i]);
                    }
                    for (i = 0; i < m_combobox_tags.length; ++i) {
                        this.m_comboboxes[i].setSelectedIndex(m_combobox_defaults[i]);
                    }
                    return;
                }
                case 4: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SimplexLayout.m_textfield_defaults[i] = this.m_textfields[i].getText();
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        SimplexLayout.m_checkbox_defaults[i] = this.m_checkboxes[i].isSelected();
                    }
                    for (i = 0; i < m_combobox_tags.length; ++i) {
                        SimplexLayout.m_combobox_defaults[i] = this.m_comboboxes[i].getSelectedIndex();
                    }
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(SimplexLayout.this.m_ls.getFrame(), "Gap\n  Minimum number of pixels between entities\nBorder\n  Fraction of diagram to reserve for border\n  Must be a value between 0 and 1\nPivots\n  Maximum number of simplex pivots to perform\nReorderings\n  Maximumn number of horizontal reorderings", "Help", 0);
                    return;
                }
            }
            block28: for (i = 0; i < m_textfield_tags.length; ++i) {
                JTextField textfield = this.m_textfields[i];
                if (source != textfield && state != 0) continue;
                String string = textfield.getText();
                string = string.trim();
                String name = m_textfield_titles[i];
                switch (i) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        try {
                            int ivalue = Integer.parseInt(string);
                            if (ivalue >= 0) continue block28;
                            this.m_message.setText(name + " may not be negative");
                            return;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not an integer value");
                            return;
                        }
                    }
                    case 4: {
                        try {
                            double dval = Double.parseDouble(string);
                            if (!(dval < 0.0) && !(dval >= 1.0)) continue block28;
                            this.m_message.setText(name + " must be in the range 0 to 1.0");
                            return;
                        }
                        catch (Throwable exception) {
                            this.m_message.setText(name + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (state) {
                case 0: {
                    for (i = 0; i < m_textfield_tags.length; ++i) {
                        SimplexLayout.this.setParameter(i, this.m_textfields[i].getText());
                    }
                    for (i = 0; i < m_checkbox_tags.length; ++i) {
                        SimplexLayout.m_checkbox_currents[i] = this.m_checkboxes[i].isSelected();
                    }
                    for (i = 0; i < m_combobox_tags.length; ++i) {
                        SimplexLayout.m_combobox_currents[i] = this.m_comboboxes[i].getSelectedIndex();
                    }
                    if (this.m_designatedClass == null || this.m_designatedClass.getSelectedIndex() <= 0) {
                        m_designated = null;
                    } else {
                        m_designated = (RelationClass)this.m_designatedClass.getSelectedItem();
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

