/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.ColorCache;
import lsedit.ColorChooser;
import lsedit.FontCache;

class SetNewGridDialog
extends JDialog
implements ChangeListener,
ActionListener {
    JFrame m_frame;
    JSlider m_gridSlider;
    GridImage m_gridImage;
    JLabel m_feedback;
    JButton m_color;
    int m_gridSize;
    Color m_gridColor;

    public SetNewGridDialog(JFrame frame, int gridSize, Color gridColor) {
        super(frame, "Set grid size", true);
        JSlider gridSlider;
        Container contentPane = this.getContentPane();
        this.m_frame = frame;
        this.m_gridSize = gridSize;
        this.m_gridColor = gridColor;
        Font font = FontCache.getDialogFont();
        Font bold = font.deriveFont(1);
        JLabel sliderLabel = new JLabel("Grid size when moving entities", 0);
        sliderLabel.setAlignmentX(0.5f);
        sliderLabel.setFont(bold);
        JLabel feedback = new JLabel("Current grid size " + gridSize, 0);
        feedback.setAlignmentX(0.5f);
        feedback.setFont(font);
        feedback.setForeground(Color.BLUE);
        this.m_feedback = feedback;
        this.m_gridImage = new GridImage();
        this.m_gridSlider = gridSlider = new JSlider(0, 0, 100, this.m_gridSize);
        gridSlider.addChangeListener(this);
        gridSlider.setMajorTickSpacing(10);
        gridSlider.setMinorTickSpacing(2);
        gridSlider.setPaintTicks(true);
        gridSlider.setPaintLabels(true);
        gridSlider.setFont(font);
        gridSlider.setPreferredSize(new Dimension(400, 50));
        gridSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)feedback, "North");
        panel.add((Component)this.m_gridImage, "Center");
        this.m_color = new JButton("Colour");
        this.m_color.addActionListener(this);
        panel.add((Component)this.m_color, "South");
        contentPane.add((Component)sliderLabel, "North");
        contentPane.add((Component)gridSlider, "Center");
        contentPane.add((Component)panel, "South");
        if (frame != null) {
            this.setLocation(frame.getX() + 200, frame.getY() + 300);
        }
        this.pack();
        this.setVisible(true);
    }

    public int getGridSize() {
        return this.m_gridSize;
    }

    public Color getGridColor() {
        return this.m_gridColor;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_color) {
            ColorChooser colorChooser = new ColorChooser(this.m_frame, "Pick a grid color", this.m_gridColor, true, false);
            this.m_gridColor = colorChooser.getColor();
            colorChooser.dispose();
            this.m_gridImage.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_gridSlider) {
            int value = this.m_gridSlider.getValue();
            if (value < 1) {
                value = 1;
            }
            this.m_gridSize = value;
            this.m_gridImage.repaint();
        }
    }

    class GridImage
    extends JComponent {
        public GridImage() {
            this.setPreferredSize(new Dimension(400, 100));
        }

        @Override
        public void paintComponent(Graphics g) {
            int grid = SetNewGridDialog.this.m_gridSize;
            int w = this.getWidth();
            int h = this.getHeight();
            g.drawRect(0, 0, w - 1, h - 1);
            if (grid > 1) {
                int i;
                Color color = SetNewGridDialog.this.m_gridColor;
                Color inverse = ColorCache.getInverse(color.getRGB());
                g.setColor(inverse);
                g.fillRect(1, 1, w - 2, w - 2);
                g.setColor(color);
                for (i = grid; i < h; i += grid) {
                    g.drawLine(0, i, w - 1, i);
                }
                for (i = grid; i < w; i += grid) {
                    g.drawLine(i, 0, i, h - 1);
                }
            }
        }
    }
}

