/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyMenuItem;
import lsedit.Option;
import lsedit.Options;
import lsedit.ToolBarEventHandler;

public class RightTabbedPane
extends JTabbedPane
implements ToolBarEventHandler,
MouseListener {
    LandscapeEditorCore m_ls;
    JPopupMenu m_popup = null;

    public RightTabbedPane(LandscapeEditorCore ls) {
        this.m_ls = ls;
        this.addMouseListener(this);
    }

    public void setTabsScroll(boolean state) {
        this.setTabLayoutPolicy(state ? 1 : 0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (ev.isMetaDown()) {
            int x = ev.getX();
            int y = ev.getY();
            if (this.m_popup == null) {
                JPopupMenu m;
                this.m_popup = m = new JPopupMenu("Tabbed Pane menu");
                new MyMenuItem(m, "Flip position", this, -1, 108, "Reverse the left/right position of the tab pane");
                new MyMenuItem(m, "Flip tabs", this, -1, 116, "Move where the tabs are with respect to the tab pane");
                new MyMenuItem(m, "Scroll tabs", this, -1, 115, "Use/don't use scrolling tabs");
            }
            FontCache.setMenuTreeFont(this.m_popup);
            this.m_popup.show(this, x, y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public boolean processMetaKeyEvent(String name) {
        return this.m_ls.processMetaKeyEvent(name);
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        switch (key) {
            case 108: {
                Option option = Options.getDiagramOptions();
                boolean value = !option.isLeftTabbox();
                option.setLeftTabbox(value);
                this.m_ls.changeLeftTabbox(value);
                break;
            }
            case 116: {
                int placement = this.getTabPlacement();
                switch (placement) {
                    case 1: {
                        placement = 2;
                        break;
                    }
                    case 3: {
                        placement = 4;
                        break;
                    }
                    case 2: {
                        placement = 3;
                        break;
                    }
                    case 4: {
                        placement = 1;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.setTabPlacement(placement);
                break;
            }
            case 115: {
                Option option = Options.getDiagramOptions();
                boolean value = !option.isTabsScroll();
                option.setTabsScroll(value);
                this.setTabsScroll(value);
                break;
            }
        }
    }

    @Override
    public void showInfo(String msg) {
    }
}

