/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import lsedit.Diagram;
import lsedit.DrawOutline;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;

public class ResizeModeHandler
extends LandscapeModeHandler {
    protected static final int[] resizeCursor = new int[]{6, 8, 7, 11, 5, 9, 4, 10};
    protected static final int RM_NONE = 0;
    protected static final int RM_LEFT = 1;
    protected static final int RM_RIGHT = 2;
    protected static final int RM_TOP = 4;
    protected static final int RM_BOTTOM = 8;
    protected static final int LR_MASK = 3;
    protected static final int TB_MASK = 12;
    protected static final int RZONE_SIZE = 5;
    protected static final double MIN_DIM = 10.0;
    protected EditModeHandler m_parent;
    protected int m_zn;
    protected DrawOutline m_drawOutline;
    protected Rectangle m_curLayout;
    private Rectangle m_plyt = null;
    protected int m_resizeMode = 0;
    protected int m_cursor = 0;
    protected int[] startMode = new int[]{5, 4, 6, 2, 10, 8, 9, 1};

    protected int overResizeTab(Object thing, int x, int y) {
        int ret = -1;
        if (thing instanceof EntityInstance) {
            Diagram diagram = this.m_ls.getDiagram();
            EntityInstance e = (EntityInstance)thing;
            if (!e.isDrawRoot() && e.getGroupKeyFlag()) {
                ret = e.overResizeTab(x, y);
            }
        }
        return ret;
    }

    protected void setCurLayout(int x, int y, int width, int height) {
        DrawOutline drawOutline = this.m_drawOutline;
        Rectangle curLayout = this.m_curLayout;
        if (curLayout == null) {
            Diagram diagram = this.m_ls.getDiagram();
            this.m_curLayout = curLayout = new Rectangle(x, y, width, height);
            drawOutline.setBounds(x, y, width + 1, height + 1);
            drawOutline.setVisible(true);
            diagram.add((Component)this.m_drawOutline, 0);
        } else {
            curLayout.x = x;
            curLayout.y = y;
            curLayout.width = width;
            curLayout.height = height;
            drawOutline.setBounds(x, y, width + 1, height + 1);
            this.m_drawOutline.repaint();
        }
    }

    protected void addMode(int newMode) {
        int omode = 0;
        switch (newMode) {
            case 4: {
                omode = 8;
                break;
            }
            case 8: {
                omode = 4;
                break;
            }
            case 1: {
                omode = 2;
                break;
            }
            case 2: {
                omode = 1;
            }
        }
        if ((this.m_resizeMode & omode) == 0) {
            this.m_resizeMode |= newMode;
        }
    }

    private String resizeDescription() {
        String ret;
        if (this.m_resizeMode == 0) {
            ret = "NONE";
        } else {
            ret = "";
            if ((this.m_resizeMode & 1) != 0) {
                ret = ret + "LEFT ";
            }
            if ((this.m_resizeMode & 2) != 0) {
                ret = ret + "RIGHT ";
            }
            if ((this.m_resizeMode & 4) != 0) {
                ret = ret + "TOP ";
            }
            if ((this.m_resizeMode & 8) != 0) {
                ret = ret + "BOTTOM";
            }
        }
        return ret;
    }

    protected void doResizeAdjust(int mode, int xpos, int ypos) {
        int gap = 20;
        int x1 = this.m_curLayout.x;
        int y1 = this.m_curLayout.y;
        int width1 = this.m_curLayout.width;
        int height1 = this.m_curLayout.height;
        if (xpos - x1 < 4) {
            this.addMode(1);
        }
        if (x1 + width1 - xpos < 4) {
            this.addMode(2);
        }
        if (ypos - y1 < 4) {
            this.addMode(4);
        }
        if (y1 + height1 - ypos < 4) {
            this.addMode(8);
        }
        if ((mode & 4) != 0) {
            if (ypos >= this.m_plyt.y + gap) {
                height1 += y1 - ypos;
                y1 = ypos;
            }
        } else if ((mode & 8) != 0 && ypos <= this.m_plyt.y + this.m_plyt.height - gap) {
            height1 = ypos - y1;
        }
        if ((mode & 1) != 0) {
            if (xpos >= this.m_plyt.x + gap) {
                width1 += x1 - xpos;
                x1 = xpos;
            }
        } else if ((mode & 2) != 0 && xpos <= this.m_plyt.x + this.m_plyt.width - gap) {
            width1 = xpos - x1;
        }
        if ((double)width1 < 10.0) {
            x1 = this.m_curLayout.x;
            width1 = this.m_curLayout.width;
        }
        if ((double)height1 < 10.0) {
            y1 = this.m_curLayout.y;
            height1 = this.m_curLayout.height;
        }
        this.setCurLayout(x1, y1, width1, height1);
    }

    public ResizeModeHandler(EditModeHandler parent) {
        super(parent.m_ls);
        this.m_parent = parent;
        this.m_drawOutline = new DrawOutline();
    }

    public Rectangle getCurLayout() {
        return this.m_curLayout;
    }

    @Override
    public void cleanup() {
        if (this.m_curLayout != null) {
            Diagram diagram = this.m_ls.getDiagram();
            diagram.remove(this.m_drawOutline);
            this.m_curLayout = null;
        }
        if (this.m_cursor != 0) {
            this.m_cursor = 0;
            this.m_ls.setCursor(this.m_cursor);
        }
        this.m_resizeMode = 0;
    }

    @Override
    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        this.m_zn = this.overResizeTab(thing, x, y);
        if (this.m_parent.getSubHandler() != this) {
            if (this.m_zn != -1) {
                this.m_cursor = resizeCursor[this.m_zn];
                this.m_ls.setCursor(this.m_cursor);
                this.m_parent.setSubHandler(this);
            }
        } else if (this.m_zn == -1) {
            this.m_parent.cleanup();
        }
    }

    @Override
    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        EntityInstance parent;
        this.movedOverThing(ev, e, x, y);
        if (this.m_zn == -1) {
            return;
        }
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            return;
        }
        this.m_resizeMode = this.startMode[this.m_zn];
        this.setCurLayout(e.getDiagramX(), e.getDiagramY(), e.getWidth(), e.getHeight());
        if (this.m_plyt == null) {
            this.m_plyt = new Rectangle();
        }
        if ((parent = e.getContainedBy()) != null && parent.getContainedBy() != null) {
            Rectangle plyt = parent.getDiagramBounds();
            this.m_plyt.x = plyt.x;
            this.m_plyt.y = plyt.y;
            this.m_plyt.width = plyt.width;
            this.m_plyt.height = plyt.height;
        } else {
            this.m_plyt = diagram.getBounds();
            this.m_plyt.x = 0;
            this.m_plyt.y = 0;
        }
        this.m_ls.doFeedback("Size: " + this.m_curLayout.width + " x " + this.m_curLayout.height);
    }

    @Override
    public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        double xpos = x;
        double ypos = y;
        if (this.m_resizeMode == 0) {
            boolean l = xpos <= (double)this.m_curLayout.x;
            boolean r = xpos >= (double)(this.m_curLayout.x + this.m_curLayout.width);
            boolean t = ypos <= (double)this.m_curLayout.y;
            boolean b = ypos >= (double)(this.m_curLayout.y + this.m_curLayout.height);
            Diagram diagram = this.m_ls.getDiagram();
            if (e.isDrawRoot()) {
                l = false;
                t = false;
            }
            if (l) {
                this.m_resizeMode = t || ypos - (double)this.m_curLayout.y < 4.0 ? 5 : (b || (double)(this.m_curLayout.y + this.m_curLayout.height) - ypos < 4.0 ? 9 : 1);
            } else if (r) {
                this.m_resizeMode = t || ypos - (double)this.m_curLayout.y < 4.0 ? 6 : (b || (double)(this.m_curLayout.y + this.m_curLayout.height) - ypos < 4.0 ? 10 : 2);
            } else if (t) {
                this.m_resizeMode = xpos - (double)this.m_curLayout.x < 4.0 ? 5 : ((double)(this.m_curLayout.x + this.m_curLayout.width) - xpos < 4.0 ? 6 : 4);
            } else if (b) {
                this.m_resizeMode = xpos - (double)this.m_curLayout.x < 4.0 ? 9 : ((double)(this.m_curLayout.x + this.m_curLayout.width) - xpos < 4.0 ? 10 : 8);
            }
        }
        if (this.m_resizeMode != 0) {
            this.doResizeAdjust(this.m_resizeMode, x, y);
            this.m_ls.doFeedback("Size: " + this.m_curLayout.width + " x " + this.m_curLayout.height);
        }
    }

    @Override
    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        if (e != null) {
            Diagram diagram = this.m_ls.getDiagram();
            diagram.resizeEntity(e, this.m_curLayout);
        }
        this.m_ls.clearFeedback();
        this.m_parent.cleanup();
    }
}

