/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.ArcInfo;
import lsedit.Diagram;
import lsedit.DrawInfo;
import lsedit.EdgeInfo;
import lsedit.EdgePoint;
import lsedit.ElidedInfo;
import lsedit.EntityInstance;
import lsedit.InElidedInfo;
import lsedit.LandscapeEditorCore;
import lsedit.MoveModeHandler;
import lsedit.MsgOut;
import lsedit.Option;
import lsedit.Options;
import lsedit.OutElidedInfo;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.RelationLabel;

public class RelationComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int DRAW_TAIL_MARK = 1;
    public static final int DRAW_CENTRE_MARK = 2;
    public static final int DRAW_ARROW_MARK = 4;
    public static final int DRAW_LABEL = 8;
    private static int[] m_arc_xp = new int[]{0, 0, 0};
    private static int[] m_arc_yp = new int[]{0, 0, 0};
    private RelationInstance m_relationInstance;
    private Object m_drawInfo;
    private RelationLabel m_label;
    private int m_freq = 1;

    @Override
    public String toString() {
        return "RelationComponent: " + this.m_relationInstance;
    }

    @Override
    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            x += this.getX();
            y += this.getY();
            if (this.m_drawInfo != null) {
                if (this.m_drawInfo instanceof DrawInfo) {
                    return ((DrawInfo)this.m_drawInfo).contains(x, y);
                }
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    if (!((DrawInfo)en.nextElement()).contains(x, y)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        int shiftX = this.getX();
        int shiftY = this.getY();
        g.setColor(this.m_relationInstance.getInheritedObjectColor());
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                ((DrawInfo)this.m_drawInfo).paintComponent(g, shiftX, shiftY);
            } else {
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)en.nextElement();
                    drawInfo.paintComponent(g, shiftX, shiftY);
                }
            }
        }
    }

    protected int getDirection() {
        RelationClass rc = this.m_relationInstance.getRelationClass();
        return rc.getShown();
    }

    protected LandscapeEditorCore getLs() {
        return this.m_relationInstance.getLs();
    }

    protected Vector computePoints(EntityInstance drawSrc, EntityInstance drawDst, int style) {
        EdgeInfo edgeInfo;
        EntityInstance ep;
        EntityInstance next;
        EntityInstance endDown;
        EntityInstance endUp;
        boolean supplier;
        RelationInstance relationInstance = this.m_relationInstance;
        RelationClass rc = relationInstance.getRelationClass();
        Diagram diagram = rc.getDiagram();
        int nid = rc.getNid();
        int direction = rc.getShown();
        EntityInstance root = diagram.getDrawRoot();
        OutElidedInfo outElided = null;
        InElidedInfo inElided = null;
        boolean client = !root.hasDescendantOrSelf(drawSrc);
        boolean bl = supplier = !root.hasDescendantOrSelf(drawDst);
        if (!client && !supplier) {
            endDown = endUp = drawSrc.commonAncestor(drawDst);
        } else if (client) {
            endUp = drawSrc.getContainedBy();
            endDown = root.getContainedBy();
        } else {
            endUp = root.getContainedBy();
            endDown = drawDst.getContainedBy();
        }
        if (endUp == null) {
            System.out.println("C Error: " + relationInstance + " " + client + " " + supplier);
            return null;
        }
        if (endDown == null) {
            System.out.println("S Error: " + relationInstance + " " + client + " " + supplier);
            return null;
        }
        Vector<DrawInfo> v1 = new Vector<DrawInfo>();
        Vector<DrawInfo> v2 = new Vector<DrawInfo>();
        Option diagramOptions = Options.getDiagramOptions();
        int edgeMode = diagramOptions.getEdgeMode();
        int embellished = 0;
        EntityInstance sp = drawSrc;
        while ((next = sp.getContainedBy()) != endUp) {
            sp = next;
        }
        EntityInstance dp = drawDst;
        while ((next = dp.getContainedBy()) != endDown) {
            dp = next;
        }
        Rectangle spLyt = sp.getDiagramBounds();
        Rectangle dpLyt = dp.getDiagramBounds();
        switch (direction) {
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                embellished = 1;
            }
            default: {
                if (!relationInstance.getGroupFlag()) break;
                embellished |= 2;
            }
        }
        int edgeMode2 = -1;
        int edgeMode1 = -1;
        if (edgeMode == 1) {
            edgeMode1 = 1;
            edgeMode2 = 0;
        }
        EdgePoint pt1 = null;
        EdgePoint ppt = null;
        EntityInstance ept1 = null;
        EntityInstance eppt = null;
        EntityInstance e = drawSrc;
        while (e != endUp) {
            if (e == null) {
                MsgOut.println("Error in points: (" + rc.getId() + " " + relationInstance + ")");
                return null;
            }
            ep = e.getContainedBy();
            ept1 = e;
            pt1 = ept1.getOutPoint(rc, edgeMode1, spLyt, dpLyt);
            if (ppt != null) {
                if (e.getElision(3, nid)) {
                    outElided = new OutElidedInfo(this);
                    ((ElidedInfo)outElided).setElidedInfo(ept1, pt1, eppt, ppt);
                    outElided.setStyle(style);
                    v1.addElement(outElided);
                    break;
                }
                edgeInfo = new EdgeInfo(this);
                edgeInfo.setEdgeInfo(eppt, ppt, ept1, pt1);
                edgeInfo.setStyle(style);
                edgeInfo.setEmbellished(embellished);
                embellished &= 0xFFFFFFFE;
                v1.addElement(edgeInfo);
            }
            ppt = pt1;
            eppt = ept1;
            e = ep;
        }
        embellished &= 0xFFFFFFFE;
        switch (direction) {
            case 1: 
            case 2: {
                embellished |= 4;
            }
        }
        EdgePoint pt2 = null;
        ppt = null;
        EntityInstance ept2 = null;
        e = drawDst;
        while (e != endDown) {
            ep = e.getContainedBy();
            ept2 = e;
            pt2 = ept2.getOutPoint(rc, edgeMode2, dpLyt, spLyt);
            if (ppt != null) {
                if (e.getElision(2, nid)) {
                    inElided = new InElidedInfo(this);
                    ((ElidedInfo)inElided).setElidedInfo(eppt, ppt, ept2, pt2);
                    inElided.setStyle(style);
                    v2.addElement(inElided);
                    break;
                }
                edgeInfo = new EdgeInfo(this);
                edgeInfo.setEdgeInfo(ept2, pt2, eppt, ppt);
                edgeInfo.setStyle(style);
                edgeInfo.setEmbellished(embellished);
                embellished &= 0xFFFFFFFB;
                v2.addElement(edgeInfo);
            }
            ppt = pt2;
            eppt = ept2;
            e = ep;
        }
        if (outElided == null && inElided == null) {
            edgeInfo = new EdgeInfo(this);
            edgeInfo.setEdgeInfo(ept1, pt1, ept2, pt2);
            edgeInfo.setStyle(style);
            v1.addElement(edgeInfo);
        } else if (inElided == null) {
            v2.removeAllElements();
        } else if (outElided == null) {
            v1.removeAllElements();
        }
        for (int i = v2.size() - 1; i >= 0; --i) {
            v1.addElement((DrawInfo)v2.elementAt(i));
        }
        return v1;
    }

    public RelationComponent(RelationInstance relationInstance) {
        String tip;
        String label;
        Option option = Options.getDiagramOptions();
        this.setLayout(null);
        this.m_relationInstance = relationInstance;
        relationInstance.setRelationComponent(this);
        if (option.isShowEdgeLabels() && (label = relationInstance.getRelationLabel()) != null) {
            Color color = relationInstance.getInheritedLabelColor();
            this.m_label = new RelationLabel(label, color);
        }
        if (option.isShowEdgeTooltip() && (tip = relationInstance.getRelationTooltip()) != null) {
            this.setToolTipText(tip);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void initFrequency() {
        this.m_freq = 1;
    }

    public void incrementFrequency() {
        ++this.m_freq;
    }

    public int getFrequency() {
        return this.m_freq;
    }

    public RelationInstance getRelationInstance() {
        return this.m_relationInstance;
    }

    public RelationLabel getRelationLabel() {
        return this.m_label;
    }

    public void orEmbellished(int value) {
        if (this.m_drawInfo != null) {
            boolean change;
            if (this.m_drawInfo instanceof DrawInfo) {
                change = ((DrawInfo)this.m_drawInfo).orEmbellished(value);
            } else {
                change = false;
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)en.nextElement();
                    change |= drawInfo.orEmbellished(value);
                }
            }
            if (change) {
                this.repaint();
            }
        }
    }

    public void nandEmbellished(int value) {
        if (this.m_drawInfo != null) {
            boolean change;
            if (this.m_drawInfo instanceof DrawInfo) {
                change = ((DrawInfo)this.m_drawInfo).nandEmbellished(value);
            } else {
                change = false;
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)en.nextElement();
                    change |= drawInfo.nandEmbellished(value);
                }
            }
            if (change) {
                this.repaint();
            }
        }
    }

    public void styleChanged(int value) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                ((DrawInfo)this.m_drawInfo).setStyle(value);
            } else {
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)en.nextElement();
                    drawInfo.setStyle(value);
                }
            }
        }
    }

    public void switchEdgePoint(EdgePoint oldPoint, EdgePoint newPoint) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                ((DrawInfo)this.m_drawInfo).switchEdgePoint(oldPoint, newPoint);
            } else {
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)en.nextElement();
                    drawInfo.switchEdgePoint(oldPoint, newPoint);
                }
            }
        }
    }

    public void computeBounds(Rectangle r) {
        if (this.m_drawInfo == null) {
            r.setBounds(0, 0, 0, 0);
            return;
        }
        if (this.m_drawInfo instanceof DrawInfo) {
            ((DrawInfo)this.m_drawInfo).getBounds(r);
        } else {
            int x1 = Integer.MAX_VALUE;
            int x2 = Integer.MIN_VALUE;
            int y1 = Integer.MAX_VALUE;
            int y2 = Integer.MIN_VALUE;
            Enumeration en = ((Vector)this.m_drawInfo).elements();
            while (en.hasMoreElements()) {
                int y;
                DrawInfo drawInfo = (DrawInfo)en.nextElement();
                drawInfo.getBounds(r);
                int x = r.x;
                if (x < x1) {
                    x1 = x;
                }
                if ((y = r.y) < y1) {
                    y1 = y;
                }
                y += r.height;
                if ((x += r.width) > x2) {
                    x2 = x;
                }
                if (y <= y2) continue;
                y2 = y;
            }
            r.setBounds(x1, y1, x2 - x1, y2 - y1);
        }
    }

    public void fill() {
        RelationInstance relationInstance = this.m_relationInstance;
        if (!relationInstance.isMarked(816)) {
            return;
        }
        EntityInstance drawSrc = relationInstance.getDrawSrc();
        if (drawSrc == null) {
            return;
        }
        EntityInstance drawDst = relationInstance.getDrawDst();
        if (drawDst == null) {
            return;
        }
        int style = relationInstance.getSrc() != drawSrc || relationInstance.getDst() != drawDst ? 2 : relationInstance.getInheritedStyle();
        RelationClass rc = relationInstance.getRelationClass();
        int direction = rc.getShown();
        Diagram diagram = rc.getDiagram();
        Option diagramOptions = Options.getDiagramOptions();
        int edgeMode = diagramOptions.getEdgeMode();
        int embellished = 0;
        switch (direction) {
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                embellished = 4;
            }
            default: {
                if (!relationInstance.getGroupFlag()) break;
                embellished |= 2;
            }
        }
        if (relationInstance.isMarked(16)) {
            if (this.m_drawInfo == null || !(this.m_drawInfo instanceof ArcInfo)) {
                this.m_drawInfo = new ArcInfo(this);
            }
            ((ArcInfo)this.m_drawInfo).setStyle(style);
            ((ArcInfo)this.m_drawInfo).setEmbellished(embellished);
            ((ArcInfo)this.m_drawInfo).setElided(relationInstance.isMarked(768));
            ((ArcInfo)this.m_drawInfo).computePosition();
        } else if (!relationInstance.isMarked(768) && edgeMode != 2 && edgeMode != 3 && drawSrc.getContainedBy() != drawDst.getContainedBy() && relationInstance.isMarked(64)) {
            this.m_drawInfo = this.computePoints(drawSrc, drawDst, style);
        } else {
            Rectangle srcLyt = drawSrc.getDiagramBounds();
            Rectangle dstLyt = drawDst.getDiagramBounds();
            EdgePoint pt2 = null;
            EdgePoint pt1 = null;
            if (drawSrc.hasDescendant(drawDst)) {
                if (edgeMode == 3) {
                    pt1 = drawSrc.getLeftOutPoint(relationInstance);
                    pt2 = drawDst.getLeftOutPoint(relationInstance);
                } else {
                    pt1 = drawSrc.getTopOutPoint(relationInstance);
                    pt2 = drawDst.getTopOutPoint(relationInstance);
                }
            } else if (drawDst.hasDescendant(drawSrc)) {
                if (edgeMode == 3) {
                    pt1 = drawSrc.getRightOutPoint(relationInstance);
                    pt2 = drawDst.getRightOutPoint(relationInstance);
                } else {
                    pt1 = drawSrc.getBottomOutPoint(relationInstance);
                    pt2 = drawDst.getBottomOutPoint(relationInstance);
                }
            } else {
                int edgeMode1;
                int edgeMode2;
                if (edgeMode != 1) {
                    edgeMode2 = -1;
                    edgeMode1 = -1;
                } else {
                    edgeMode1 = 1;
                    edgeMode2 = 0;
                }
                pt1 = drawSrc.getOutPoint(rc, edgeMode1, srcLyt, dstLyt);
                pt2 = drawDst.getOutPoint(rc, edgeMode2, dstLyt, srcLyt);
            }
            if (relationInstance.isMarked(768)) {
                DrawInfo drawInfo;
                Enumeration en;
                OutElidedInfo out = null;
                InElidedInfo in = null;
                if (relationInstance.isMarked(256)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof OutElidedInfo) {
                            out = (OutElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            en = ((Vector)this.m_drawInfo).elements();
                            while (en.hasMoreElements()) {
                                drawInfo = (DrawInfo)en.nextElement();
                                if (!(drawInfo instanceof OutElidedInfo)) continue;
                                out = (OutElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (out == null) {
                        out = new OutElidedInfo(this);
                    }
                    out.setElidedInfo(drawSrc, pt1, drawDst, pt2);
                    out.setStyle(relationInstance.getInheritedStyle());
                }
                if (relationInstance.isMarked(512)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof InElidedInfo) {
                            in = (InElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            en = ((Vector)this.m_drawInfo).elements();
                            while (en.hasMoreElements()) {
                                drawInfo = (DrawInfo)en.nextElement();
                                if (!(drawInfo instanceof InElidedInfo)) continue;
                                in = (InElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (in == null) {
                        in = new InElidedInfo(this);
                    }
                    in.setElidedInfo(drawSrc, pt1, drawDst, pt2);
                    in.setStyle(relationInstance.getInheritedStyle());
                }
                if (out == null) {
                    this.m_drawInfo = in;
                } else if (in == null) {
                    this.m_drawInfo = out;
                } else {
                    if (this.m_drawInfo instanceof Vector) {
                        ((Vector)this.m_drawInfo).removeAllElements();
                    } else {
                        this.m_drawInfo = new Vector();
                    }
                    ((Vector)this.m_drawInfo).addElement(out);
                    ((Vector)this.m_drawInfo).addElement(in);
                }
            } else {
                if (this.m_drawInfo == null || !(this.m_drawInfo instanceof EdgeInfo)) {
                    this.m_drawInfo = new EdgeInfo(this);
                }
                EdgeInfo edgeInfo = (EdgeInfo)this.m_drawInfo;
                edgeInfo.setEdgeInfo(drawSrc, pt1, drawDst, pt2);
                edgeInfo.setStyle(style);
                if (this.m_label != null) {
                    embellished |= 8;
                }
                edgeInfo.setEmbellished(embellished);
            }
        }
        if (this.m_drawInfo != null) {
            Rectangle r = new Rectangle();
            this.computeBounds(r);
            ++r.width;
            ++r.height;
            this.setBounds(r);
        }
    }

    public boolean mouseOverEdgePoint(int x, int y, MoveModeHandler handler) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                return ((DrawInfo)this.m_drawInfo).mouseOverEdgePoint(x, y, handler);
            }
            Enumeration en = ((Vector)this.m_drawInfo).elements();
            while (en.hasMoreElements()) {
                if (!((DrawInfo)en.nextElement()).mouseOverEdgePoint(x, y, handler)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFramedBy(Rectangle frame) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                return ((DrawInfo)this.m_drawInfo).isFramedBy(frame);
            }
            Enumeration en = ((Vector)this.m_drawInfo).elements();
            while (en.hasMoreElements()) {
                if (!((DrawInfo)en.nextElement()).isFramedBy(frame)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.m_relationInstance.mouseEntered();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.m_relationInstance.mouseExited();
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.m_relationInstance.mousePressed(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.m_relationInstance.mouseReleased(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        this.m_relationInstance.mouseDragged(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        this.m_relationInstance.mouseMoved(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }
}

