/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import lsedit.DeleteActiveContainers;
import lsedit.DeleteActiveEdges;
import lsedit.DeleteActiveEntities;
import lsedit.DuplicateEdges;
import lsedit.ERBox;
import lsedit.EntityClass;
import lsedit.GrpChkBox;
import lsedit.LandscapeEditorCore;
import lsedit.LiftEntityClassEdges;
import lsedit.Options;
import lsedit.QueryPersistsChkBox;
import lsedit.RelationClass;
import lsedit.ResetIOpoints;
import lsedit.TaListener;
import lsedit.TraceLiftedChkBox;

public final class QueryBox
extends ERBox
implements ChangeListener,
TaListener,
MouseListener {
    public static final String g_duplicateRelations = "Duplicate Relations";
    public static final String g_liftActiveRelations = "Lift Active Relations";
    public static final String g_deleteActiveEntities = "Delete Active Entities";
    public static final String g_deleteActiveContainers = "Delete Active Containers";
    public static final String g_deleteActiveRelations = "Delete Active Relations";
    public static final String g_resetIOpoints = "Reset IO points";
    public static final String m_helpStr = "This box shows the active entities and relations during update and queries";
    protected static Font m_titleFont = null;
    protected static Font m_textFont = null;
    protected TraceLiftedChkBox m_traceLiftedChk;
    protected GrpChkBox m_grpChk;
    protected QueryPersistsChkBox m_queryPersistsChk;

    public QueryBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Query", m_helpStr);
        Font titleFont = m_titleFont;
        Font textFont = m_textFont;
        if (titleFont == null) {
            m_titleFont = titleFont = Options.getTargetFont(10);
        }
        if (textFont == null) {
            m_textFont = textFont = Options.getTargetFont(11);
        }
        this.m_ulabel = new JLabel("Active Entities");
        this.m_ulabel.setForeground(Color.red);
        this.m_elabel1 = new JLabel("Pass cursor over entity for description.");
        this.m_elabel1.setForeground(Color.black);
        this.m_elabel2 = new JLabel("Right click for menu.");
        this.m_elabel2.setForeground(Color.black);
        this.m_rlabel = new JLabel("Active Relations");
        this.m_rlabel.setForeground(Color.red);
        this.m_rlabel2 = new JLabel("Active Reversed Relations");
        this.m_rlabel2.setForeground(Color.red);
        this.m_clabel.setForeground(Color.red);
        this.m_footer1 = new JLabel("Checkboxes select query relations.");
        this.m_footer1.setForeground(Color.black);
        this.m_footer2 = new JLabel("Click relation arrow for description.");
        this.m_footer2.setForeground(Color.black);
        this.m_traceLiftedChk = new TraceLiftedChkBox(this.m_ls);
        this.m_traceLiftedChk.setForeground(Color.black);
        this.m_grpChk = new GrpChkBox(this.m_ls);
        this.m_grpChk.setForeground(Color.black);
        this.m_queryPersistsChk = new QueryPersistsChkBox(this.m_ls);
        this.m_queryPersistsChk.setForeground(Color.black);
        this.setComponentsTitleFont(titleFont);
        this.setComponentsTextFont(textFont);
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    @Override
    public void setComponentsTextFont(Font textFont) {
        super.setComponentsTextFont(textFont);
        this.m_traceLiftedChk.setFont(textFont);
        this.m_grpChk.setFont(textFont);
        this.m_queryPersistsChk.setFont(textFont);
    }

    @Override
    public Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void setTraceLifted(boolean value) {
        if (this.m_traceLiftedChk.isSelected() != value) {
            this.m_traceLiftedChk.setSelected(value);
        }
    }

    public void setGroupQuery(boolean value) {
        if (this.m_grpChk.isSelected() != value) {
            this.m_grpChk.setSelected(value);
        }
    }

    public void setQueryPersists(boolean value) {
        if (this.m_queryPersistsChk.isSelected() != value) {
            this.m_queryPersistsChk.setSelected(value);
        }
    }

    @Override
    protected boolean getFlag(EntityClass ec) {
        return ec.isActive();
    }

    @Override
    protected int setFlag(EntityClass ec, boolean value, boolean applyToSubclasses) {
        return ec.setActive(value, applyToSubclasses);
    }

    @Override
    protected boolean getFlag(RelationClass rc, int direction) {
        return rc.isActive(direction);
    }

    @Override
    protected int setFlag(RelationClass rc, int direction, boolean value, boolean applyToSubclasses) {
        return rc.setActive(direction, value, applyToSubclasses);
    }

    @Override
    protected String getFlagName() {
        return "Active";
    }

    @Override
    protected void customFill() {
        this.add(this.m_traceLiftedChk);
        this.m_height += 10;
        this.add(this.m_grpChk);
        this.m_height += 10;
        this.add(this.m_queryPersistsChk);
    }

    @Override
    protected void customRelationOptions(JPopupMenu popup, RelationClass rc) {
        LandscapeEditorCore ls = this.getLs();
        JMenuItem mi = new JMenuItem(g_duplicateRelations);
        mi.addActionListener(new DuplicateEdges(ls, rc));
        popup.add(mi);
    }

    @Override
    protected void customOptions(JPopupMenu popupMenu) {
        LandscapeEditorCore ls = this.m_ls;
        JMenuItem mi = new JMenuItem(g_liftActiveRelations);
        mi.addActionListener(new LiftEntityClassEdges(ls));
        popupMenu.add(mi);
        mi = new JMenuItem(g_deleteActiveEntities);
        mi.addActionListener(new DeleteActiveEntities(ls));
        popupMenu.add(mi);
        mi = new JMenuItem(g_deleteActiveContainers);
        mi.addActionListener(new DeleteActiveContainers(ls));
        popupMenu.add(mi);
        mi = new JMenuItem(g_deleteActiveRelations);
        mi.addActionListener(new DeleteActiveEdges(ls));
        popupMenu.add(mi);
        mi = new JMenuItem(g_resetIOpoints);
        mi.addActionListener(new ResetIOpoints(ls));
        popupMenu.add(mi);
    }
}

