/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.FontCache;
import lsedit.IconCache;
import lsedit.LandscapeEditorCore;
import lsedit.Option;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.SetNewGridDialog;

public class OptionsDialog
extends JDialog
implements ActionListener {
    protected LandscapeEditorCore m_ls;
    protected Font m_font;
    protected Font m_bold;
    private JCheckBox m_show_toolbar = new JCheckBox("");
    private JCheckBox m_show_desc = new JCheckBox("");
    private JCheckBox m_show_feedback = new JCheckBox("");
    private JCheckBox m_left_tabbox = new JCheckBox("");
    private JCheckBox m_tabs_scroll = new JCheckBox("");
    private JCheckBox m_fix_scrollbars = new JCheckBox("");
    private JCheckBox m_sort_toc = new JCheckBox("");
    private JCheckBox m_top_clients = new JCheckBox("");
    private JCheckBox m_show_clients = new JCheckBox("");
    private JCheckBox m_show_suppliers = new JCheckBox("");
    private JCheckBox m_use_compaction = new JCheckBox("");
    private JCheckBox m_visible_edges = new JCheckBox("");
    private JCheckBox m_visible_entities = new JCheckBox("");
    private JCheckBox m_lift_edges = new JCheckBox("");
    private JCheckBox m_show_dst_cardinals = new JCheckBox("");
    private JCheckBox m_show_src_cardinals = new JCheckBox("");
    private JCheckBox m_focus_ancestor = new JCheckBox("");
    private JCheckBox m_hide_empty = new JCheckBox("");
    private JCheckBox m_member_counts = new JCheckBox("");
    private JCheckBox m_inheritance = new JCheckBox("");
    private JCheckBox m_legend_labels = new JCheckBox("");
    private JTextField m_line_width = new JTextField(8);
    private JTextField m_arrow_length = new JTextField(8);
    private JTextField m_arrow_arc = new JTextField(8);
    private JTextField m_pixels_3d = new JTextField(8);
    private JTextField m_shadow_size = new JTextField(8);
    private JTextField m_label_angle = new JTextField(8);
    private JTextField m_hover_scale = new JTextField(8);
    private JTextField m_zoom_x = new JTextField(8);
    private JTextField m_zoom_y = new JTextField(8);
    private JCheckBox m_fill_arrowhead = new JCheckBox("");
    private JCheckBox m_center_arrowhead = new JCheckBox("");
    private JCheckBox m_permanently_weight = new JCheckBox("");
    private JCheckBox m_blackwhite_3d = new JCheckBox("");
    private JCheckBox m_show_edge_labels = new JCheckBox("");
    private JCheckBox m_rotate_edge_labels = new JCheckBox("");
    private JCheckBox m_show_edge_tooltip = new JCheckBox("");
    private JCheckBox m_variable_arrow_color = new JCheckBox("");
    private JCheckBox m_invert_edge_label_back = new JCheckBox("");
    private JCheckBox m_label_invert_fore = new JCheckBox("");
    private JCheckBox m_label_invert_back = new JCheckBox("");
    private JCheckBox m_entity_labels_blackwhite = new JCheckBox("");
    public static final String[] g_loadchoices = new String[]{"Load", "Ignore", "Prompt"};
    private JComboBox m_loadchoices = new JComboBox<String>(g_loadchoices);
    public static final String[] g_edgechoices = new String[]{"Inflection", "Top/Bottom", "Direct", "Direct+Side"};
    private JComboBox m_edgechoices = new JComboBox<String>(g_edgechoices);
    public static final String[] g_iconchoices = new String[]{"No icons", "Plain icons", "Labels centered", "Labels bottom", "Labels top", "Empty cache"};
    public static final String[] g_showchoices = new String[]{"Hide", "Show", "Image"};
    private JComboBox m_iconchoices = new JComboBox<String>(g_iconchoices);
    private JComboBox m_elision_icon = new JComboBox();
    private JTextField m_iconPath = new JTextField(8);
    private JCheckBox m_icon_fixed_shape = new JCheckBox("");
    private JCheckBox m_show_grid = new JCheckBox("");
    private JCheckBox m_snap_to_grid = new JCheckBox("");
    private JButton m_setGridSize = new JButton();
    private JTextField m_chase_edges = new JTextField(8);
    private JCheckBox m_chase_hide = new JCheckBox("");
    private JCheckBox m_visible_spans = new JCheckBox("");
    private JComboBox m_show_span_type = new JComboBox<String>(g_showchoices);
    private JComboBox m_show_class_type = new JComboBox<String>(g_showchoices);
    private JComboBox m_show_navnext = new JComboBox<String>(g_showchoices);
    private JComboBox m_show_navprev = new JComboBox<String>(g_showchoices);
    private JCheckBox m_trace_lifted = new JCheckBox("");
    private JCheckBox m_group_query = new JCheckBox("");
    private JCheckBox m_query_persists = new JCheckBox("");
    private Container m_contentPane;
    private JComponent m_centerThing;
    private JScrollPane m_scrollPane1;
    private JScrollPane m_scrollPane2;
    private JScrollPane m_scrollPane3;
    private boolean m_use_tabs = false;
    public static final String[] g_optionchoices = new String[]{"Reset", "Default", "Landscape", "Current"};
    protected JComboBox m_optionchoices = new JComboBox<String>(g_optionchoices);
    protected Option m_current = new Option("Current");
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_LOAD = 2;
    protected static final int BUTTON_SAVE = 3;
    protected static final int BUTTON_TAB = 4;
    protected static final int BUTTON_HELP = 5;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Load", "Save", "Tab", "Help"};
    protected static final String[] m_button_tips = new String[]{"Set values shown as current options", "Change nothing", "Load values show with specified options", "Set specified options to values shown", "Switch to/from tabbed view", "Bring up browser describing options"};
    protected JLabel m_message;
    protected JButton[] m_buttons = new JButton[m_button_titles.length];

    protected Option getTarget() {
        switch (this.m_optionchoices.getSelectedIndex()) {
            case 1: {
                return Options.getDefaultOptions();
            }
            case 2: {
                return Options.getLandscapeOptions();
            }
            case 3: {
                return Options.getDiagramOptions();
            }
        }
        return null;
    }

    protected String getTargetName() {
        int choice = this.m_optionchoices.getSelectedIndex();
        if (choice >= 0 && choice < g_optionchoices.length) {
            return g_optionchoices[choice];
        }
        return "?";
    }

    protected void loadValues1() {
        Option option = this.m_current;
        this.m_show_toolbar.setSelected(option.isShowToolbar());
        this.m_show_desc.setSelected(option.isShowDesc());
        this.m_show_feedback.setSelected(option.isShowFeedback());
        this.m_left_tabbox.setSelected(option.isLeftTabbox());
        this.m_tabs_scroll.setSelected(option.isTabsScroll());
        this.m_fix_scrollbars.setSelected(option.isFixScrollBars());
        this.m_sort_toc.setSelected(option.isSortTOC());
        this.m_top_clients.setSelected(option.isTopClients());
        this.m_show_clients.setSelected(option.isShowClients());
        this.m_show_suppliers.setSelected(option.isShowSuppliers());
        this.m_use_compaction.setSelected(option.isUseCompaction());
        this.m_visible_edges.setSelected(option.isVisibleEdges());
        this.m_visible_entities.setSelected(option.isVisibleEntities());
        this.m_lift_edges.setSelected(option.isLiftEdges());
        this.m_show_dst_cardinals.setSelected(option.isShowDstCardinals());
        this.m_show_src_cardinals.setSelected(option.isShowSrcCardinals());
        this.m_focus_ancestor.setSelected(option.isFocusAncestor());
        this.m_hide_empty.setSelected(option.isHideEmpty());
        this.m_member_counts.setSelected(option.isMemberCounts());
        this.m_inheritance.setSelected(option.isShowInheritance());
        this.m_legend_labels.setSelected(option.isLegendLabelBlack());
    }

    protected void saveValues1() {
        Option option = this.m_current;
        option.setShowToolbar(this.m_show_toolbar.isSelected());
        option.setShowDesc(this.m_show_desc.isSelected());
        option.setShowFeedback(this.m_show_feedback.isSelected());
        option.setLeftTabbox(this.m_left_tabbox.isSelected());
        option.setTabsScroll(this.m_tabs_scroll.isSelected());
        option.setFixScrollBars(this.m_fix_scrollbars.isSelected());
        option.setSortTOC(this.m_sort_toc.isSelected());
        option.setTopClients(this.m_top_clients.isSelected());
        option.setShowClients(this.m_show_clients.isSelected());
        option.setShowSuppliers(this.m_show_suppliers.isSelected());
        option.setUseCompaction(this.m_use_compaction.isSelected());
        option.setVisibleEdges(this.m_visible_edges.isSelected());
        option.setVisibleEntities(this.m_visible_entities.isSelected());
        option.setLiftEdges(this.m_lift_edges.isSelected());
        option.setShowDstCardinals(this.m_show_dst_cardinals.isSelected());
        option.setShowSrcCardinals(this.m_show_src_cardinals.isSelected());
        option.setFocusAncestor(this.m_focus_ancestor.isSelected());
        option.setHideEmpty(this.m_hide_empty.isSelected());
        option.setMemberCounts(this.m_member_counts.isSelected());
        option.setShowInheritance(this.m_inheritance.isSelected());
        option.setLegendLabelBlack(this.m_legend_labels.isSelected());
    }

    protected void loadValues2() {
        Option option = this.m_current;
        this.m_line_width.setText("" + option.getLineWidth());
        this.m_arrow_length.setText("" + option.getArrowLength());
        this.m_arrow_arc.setText("" + option.getArrowArc());
        this.m_pixels_3d.setText("" + option.getPixels3D());
        this.m_shadow_size.setText("" + option.getShadowSize());
        this.m_label_angle.setText("" + option.getLabelAngle());
        this.m_hover_scale.setText("" + option.getHoverScale());
        this.m_zoom_x.setText("" + option.getZoomX());
        this.m_zoom_y.setText("" + option.getZoomY());
        this.m_fill_arrowhead.setSelected(option.isFillArrowhead());
        this.m_center_arrowhead.setSelected(option.isCenterArrowhead());
        this.m_permanently_weight.setSelected(option.isPermanentlyWeight());
        this.m_blackwhite_3d.setSelected(option.isBlackWhite3D());
        this.m_show_edge_labels.setSelected(option.isShowEdgeLabels());
        this.m_rotate_edge_labels.setSelected(option.isRotateEdgeLabels());
        this.m_show_edge_tooltip.setSelected(option.isShowEdgeTooltip());
        this.m_variable_arrow_color.setSelected(option.isVariableArrowColor());
        this.m_invert_edge_label_back.setSelected(option.isInvertEdgeLabelBackground());
        this.m_label_invert_fore.setSelected(option.isLabelInvertForeground());
        this.m_label_invert_back.setSelected(option.isLabelInvertBackground());
        this.m_entity_labels_blackwhite.setSelected(option.isLabelBlackWhite());
    }

    protected String saveValues2() {
        Option option = this.m_current;
        String ret = null;
        String ret1 = option.setLineWidth(this.m_line_width.getText());
        if (ret1 != null) {
            ret = ret1;
        }
        if ((ret1 = option.setArrowLength(this.m_arrow_length.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setArrowArc(this.m_arrow_arc.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setPixels3D(this.m_pixels_3d.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setShadowSize(this.m_shadow_size.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setLabelAngle(this.m_label_angle.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setHoverScale(this.m_hover_scale.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setZoomX(this.m_zoom_x.getText())) != null) {
            ret = ret1;
        }
        if ((ret1 = option.setZoomY(this.m_zoom_y.getText())) != null) {
            ret = ret1;
        }
        option.setFillArrowhead(this.m_fill_arrowhead.isSelected());
        option.setCenterArrowhead(this.m_center_arrowhead.isSelected());
        option.setPermanentlyWeight(this.m_permanently_weight.isSelected());
        option.setBlackWhite3D(this.m_blackwhite_3d.isSelected());
        option.setShowEdgeLabels(this.m_show_edge_labels.isSelected());
        option.setRotateEdgeLabels(this.m_rotate_edge_labels.isSelected());
        option.setShowEdgeTooltip(this.m_show_edge_tooltip.isSelected());
        option.setVariableArrowColor(this.m_variable_arrow_color.isSelected());
        option.setInvertEdgeLabelBackground(this.m_invert_edge_label_back.isSelected());
        option.setLabelInvertForeground(this.m_label_invert_fore.isSelected());
        option.setLabelInvertBackground(this.m_label_invert_back.isSelected());
        option.setLabelBlackWhite(this.m_entity_labels_blackwhite.isSelected());
        return ret;
    }

    protected void loadValues3() {
        JComboBox elision_icon = this.m_elision_icon;
        Option option = this.m_current;
        int elision = option.getElisionIcon();
        this.m_loadchoices.setSelectedIndex(option.getLoadMode());
        this.m_show_grid.setSelected(option.isShowGrid());
        this.m_snap_to_grid.setSelected(option.isSnapToGrid());
        this.m_setGridSize.setText("" + option.getGridSize());
        this.m_setGridSize.setForeground(option.getGridColor());
        this.m_iconPath.setText(option.getIconPath());
        this.m_iconchoices.setSelectedIndex(option.getIconRule());
        elision_icon.setSelectedIndex(0);
        if (elision >= 0) {
            int i = elision_icon.getItemCount();
            while (--i > 0) {
                RelationClass rc = (RelationClass)elision_icon.getItemAt(i);
                if (rc.getNid() != elision) continue;
                elision_icon.setSelectedIndex(i);
                break;
            }
        }
        this.m_icon_fixed_shape.setSelected(option.isIconFixedShape());
        this.m_edgechoices.setSelectedIndex(option.getEdgeMode());
        this.m_chase_edges.setText("" + option.getChaseEdges());
        this.m_chase_hide.setSelected(option.isChaseHide());
        this.m_visible_spans.setSelected(option.isVisibleSpans());
        this.m_show_span_type.setSelectedIndex(option.getShowSpanType());
        this.m_show_class_type.setSelectedIndex(option.getShowClassType());
        this.m_show_navnext.setSelectedIndex(option.getShowNavNext());
        this.m_show_navprev.setSelectedIndex(option.getShowNavPrev());
        this.m_trace_lifted.setSelected(option.isTraceLifted());
        this.m_group_query.setSelected(option.isGroupQuery());
        this.m_query_persists.setSelected(option.isQueryPersists());
    }

    protected String saveValues3() {
        Option option = this.m_current;
        JComboBox elision_icon = this.m_elision_icon;
        option.setLoadMode(this.m_loadchoices.getSelectedIndex());
        option.setShowGrid(this.m_show_grid.isSelected());
        option.setSnapToGrid(this.m_snap_to_grid.isSelected());
        option.setIconPath(this.m_iconPath.getText());
        int index = this.m_iconchoices.getSelectedIndex();
        if (index == 5) {
            IconCache.clear();
            index = 0;
        }
        option.setIconRule(index);
        index = elision_icon.getSelectedIndex();
        if (index <= 0) {
            index = -1;
        } else {
            RelationClass rc = (RelationClass)elision_icon.getItemAt(index);
            index = rc.getNid();
        }
        option.setElisionIcon(index);
        option.setIconFixedShape(this.m_icon_fixed_shape.isSelected());
        option.setChaseHide(this.m_chase_hide.isSelected());
        option.setVisibleSpans(this.m_visible_spans.isSelected());
        option.setShowSpanType(this.m_show_span_type.getSelectedIndex());
        option.setShowClassType(this.m_show_class_type.getSelectedIndex());
        option.setShowNavNext(this.m_show_navnext.getSelectedIndex());
        option.setShowNavPrev(this.m_show_navprev.getSelectedIndex());
        option.setTraceLifted(this.m_trace_lifted.isSelected());
        option.setGroupQuery(this.m_group_query.isSelected());
        option.setQueryPersists(this.m_query_persists.isSelected());
        option.setEdgeMode(this.m_edgechoices.getSelectedIndex());
        String msg = option.setChaseEdges(this.m_chase_edges.getText());
        return msg;
    }

    protected void addCenterThing() {
        if (this.m_use_tabs) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("Main", this.m_scrollPane1);
            tabbedPane.add("Visualisation", this.m_scrollPane2);
            tabbedPane.add("Diagram", this.m_scrollPane3);
            this.m_centerThing = tabbedPane;
        } else {
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            topPanel.add("West", this.m_scrollPane1);
            topPanel.add("East", this.m_scrollPane3);
            topPanel.add("Center", this.m_scrollPane2);
            this.m_centerThing = topPanel;
        }
        this.m_contentPane.add("Center", this.m_centerThing);
    }

    protected void addPanel(JPanel panel, String text) {
        JLabel label = new JLabel(text, 4);
        label.setFont(this.m_bold);
        panel.add(label);
    }

    protected void addUnits(JPanel panel, String text) {
        JLabel label = new JLabel(text, 2);
        label.setFont(this.m_bold);
        panel.add(label);
    }

    protected void addPanel(JPanel panel, JComboBox combobox) {
        combobox.setFont(this.m_font);
        panel.add(combobox);
    }

    protected void addPanel(JPanel panel, JCheckBox checkbox) {
        checkbox.setFont(this.m_font);
        panel.add(checkbox);
    }

    protected void addPanel(JPanel panel, JTextField textfield) {
        textfield.setFont(this.m_font);
        panel.add(textfield);
    }

    protected OptionsDialog(LandscapeEditorCore ls) {
        super(ls.getFrame(), "Modify LSEdit options", true);
        Container contentPane;
        Font bold;
        Font font;
        Diagram diagram = ls.getDiagram();
        this.m_ls = ls;
        this.m_font = font = FontCache.getDialogFont();
        this.m_bold = bold = this.m_font.deriveFont(1);
        this.m_contentPane = contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel topPanel = new JPanel();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        topPanel.setLayout(new BorderLayout());
        GridLayout gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel1.setLayout(gridLayout);
        gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel2.setLayout(gridLayout);
        topPanel.add("West", panel1);
        topPanel.add("East", panel2);
        this.addPanel(panel1, "Show toolbar:");
        this.addPanel(panel2, this.m_show_toolbar);
        this.addPanel(panel1, "Show description box:");
        this.addPanel(panel2, this.m_show_desc);
        this.addPanel(panel1, "Show feedback box:");
        this.addPanel(panel2, this.m_show_feedback);
        this.addPanel(panel1, "Show Tab Box on left:");
        this.addPanel(panel2, this.m_left_tabbox);
        this.addPanel(panel1, "Scroll through tabs:");
        this.addPanel(panel2, this.m_tabs_scroll);
        this.addPanel(panel1, "Always show scrollbars:");
        this.addPanel(panel2, this.m_fix_scrollbars);
        this.addPanel(panel1, "Sort the Table of Contents:");
        this.addPanel(panel2, this.m_sort_toc);
        this.addPanel(panel1, "Show clients at top:");
        this.addPanel(panel2, this.m_top_clients);
        this.addPanel(panel1, "Show clients:");
        this.addPanel(panel2, this.m_show_clients);
        this.addPanel(panel1, "Show suppliers:");
        this.addPanel(panel2, this.m_show_suppliers);
        this.addPanel(panel1, "Use client/supplier compaction:");
        this.addPanel(panel2, this.m_use_compaction);
        this.addPanel(panel1, "Client/suppliers use visible edges:");
        this.addPanel(panel2, this.m_visible_edges);
        this.addPanel(panel1, "Client/suppliers use visible entities:");
        this.addPanel(panel2, this.m_visible_entities);
        this.addPanel(panel1, "Lift edges under closed entities:");
        this.addPanel(panel2, this.m_lift_edges);
        this.addPanel(panel1, "Show destination cardinal counts:");
        this.addPanel(panel2, this.m_show_dst_cardinals);
        this.addPanel(panel1, "Show source cardinal counts:");
        this.addPanel(panel2, this.m_show_src_cardinals);
        this.addPanel(panel1, "Nearest ancestor changing hierarchy:");
        this.addPanel(panel2, this.m_focus_ancestor);
        this.addPanel(panel1, "Hide empty classes in the legend:");
        this.addPanel(panel2, this.m_hide_empty);
        this.addPanel(panel1, "Show member counts in the legend:");
        this.addPanel(panel2, this.m_member_counts);
        this.addPanel(panel1, "Show inheritance in legend:");
        this.addPanel(panel2, this.m_inheritance);
        this.addPanel(panel1, "Show legend labels in black:");
        this.addPanel(panel2, this.m_legend_labels);
        this.m_scrollPane1 = new JScrollPane(topPanel);
        topPanel = new JPanel();
        panel1 = new JPanel();
        panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        topPanel.setLayout(new BorderLayout());
        gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel1.setLayout(gridLayout);
        gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel2.setLayout(gridLayout);
        gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel3.setLayout(gridLayout);
        topPanel.add("West", panel1);
        topPanel.add("East", panel3);
        topPanel.add("Center", panel2);
        this.addPanel(panel1, "Width of edge:");
        this.addPanel(panel2, this.m_line_width);
        this.addUnits(panel3, "Pixels");
        this.addPanel(panel1, "Length of arrow edge:");
        this.addPanel(panel2, this.m_arrow_length);
        this.addUnits(panel3, "Pixels");
        this.addPanel(panel1, "Width of arrow arc:");
        this.addPanel(panel2, this.m_arrow_arc);
        this.addUnits(panel3, "Radians");
        this.addPanel(panel1, "3D highlighting weight:");
        this.addPanel(panel2, this.m_pixels_3d);
        this.addUnits(panel3, "Pixels");
        this.addPanel(panel1, "Incidental shadow size:");
        this.addPanel(panel2, this.m_shadow_size);
        this.addUnits(panel3, "Pixels");
        this.addPanel(panel1, "Angle of label:");
        this.addPanel(panel2, this.m_label_angle);
        this.addUnits(panel3, "Degrees");
        this.addPanel(panel1, "Entity hover factor:");
        this.addPanel(panel2, this.m_hover_scale);
        this.addUnits(panel3, "Scale");
        this.addPanel(panel1, "Horizontal zoom factor:");
        this.addPanel(panel2, this.m_zoom_x);
        this.addUnits(panel3, "Scale");
        this.addPanel(panel1, "Vertical zoom factor:");
        this.addPanel(panel2, this.m_zoom_y);
        this.addUnits(panel3, "Scale");
        this.addPanel(panel1, "Fill arrow head:");
        this.addPanel(panel2, this.m_fill_arrowhead);
        this.addPanel(panel1, "Center arrow head:");
        this.addPanel(panel2, this.m_center_arrowhead);
        this.addPanel(panel1, "Permanently weight arrow head:");
        this.addPanel(panel2, this.m_permanently_weight);
        this.addPanel(panel1, "3D in Black&White:");
        this.addPanel(panel2, this.m_blackwhite_3d);
        this.addPanel(panel1, "Show fixed edge labels:");
        this.addPanel(panel2, this.m_show_edge_labels);
        this.addPanel(panel1, "Edge labels angle w.r.t edge:");
        this.addPanel(panel2, this.m_rotate_edge_labels);
        this.addPanel(panel1, "Show edge tooltip:");
        this.addPanel(panel2, this.m_show_edge_tooltip);
        this.addPanel(panel1, "Variable arrow color:");
        this.addPanel(panel2, this.m_variable_arrow_color);
        this.addPanel(panel1, "Invert edge label background:");
        this.addPanel(panel2, this.m_invert_edge_label_back);
        this.addPanel(panel1, "Label color inverts background");
        this.addPanel(panel2, this.m_label_invert_fore);
        this.addPanel(panel1, "Invert entity label background");
        this.addPanel(panel2, this.m_label_invert_back);
        this.addPanel(panel1, "Make entity label black/white");
        this.addPanel(panel2, this.m_entity_labels_blackwhite);
        this.m_scrollPane2 = new JScrollPane(topPanel);
        topPanel = new JPanel();
        panel1 = new JPanel();
        panel2 = new JPanel();
        topPanel.setLayout(new BorderLayout());
        gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel1.setLayout(gridLayout);
        gridLayout = new GridLayout(22, 1);
        gridLayout.setVgap(0);
        panel2.setLayout(gridLayout);
        topPanel.add("West", panel1);
        topPanel.add("East", panel2);
        this.addPanel(panel1, "Load TA options:");
        this.addPanel(panel2, this.m_loadchoices);
        this.addPanel(panel1, "Edge mode:");
        this.addPanel(panel2, this.m_edgechoices);
        this.addPanel(panel1, "Icon search path:");
        this.addPanel(panel2, this.m_iconPath);
        this.addPanel(panel1, "Show icons:");
        this.addPanel(panel2, this.m_iconchoices);
        this.m_elision_icon.addItem("");
        if (diagram != null) {
            Vector relationClasses = diagram.getRelationClasses();
            int size = relationClasses.size();
            for (int i = 0; i < size; ++i) {
                this.m_elision_icon.addItem(relationClasses.elementAt(i));
            }
        }
        this.addPanel(panel1, "Elision icon:");
        this.addPanel(panel2, this.m_elision_icon);
        this.addPanel(panel1, "Fixed Icon Shape:");
        this.addPanel(panel2, this.m_icon_fixed_shape);
        this.addPanel(panel1, "Set Diagram Grid:");
        panel2.add(this.m_setGridSize);
        this.m_setGridSize.addActionListener(this);
        this.addPanel(panel1, "Show grid:");
        this.addPanel(panel2, this.m_show_grid);
        this.addPanel(panel1, "Snap entities to grid:");
        this.addPanel(panel2, this.m_snap_to_grid);
        this.addPanel(panel1, "Chase max edges:");
        this.addPanel(panel2, this.m_chase_edges);
        this.addPanel(panel1, "Hide not chased:");
        this.addPanel(panel2, this.m_chase_hide);
        this.addPanel(panel1, "Visible spans");
        this.addPanel(panel2, this.m_visible_spans);
        this.addPanel(panel1, "Show span type");
        this.addPanel(panel2, this.m_show_span_type);
        this.addPanel(panel1, "Show class type");
        this.addPanel(panel2, this.m_show_class_type);
        this.addPanel(panel1, "Show navnext arrow");
        this.addPanel(panel2, this.m_show_navnext);
        this.addPanel(panel1, "Show navprev arrow");
        this.addPanel(panel2, this.m_show_navprev);
        this.addPanel(panel1, "Trace lifted:");
        this.addPanel(panel2, this.m_trace_lifted);
        this.addPanel(panel1, "Group the queried items:");
        this.addPanel(panel2, this.m_group_query);
        this.addPanel(panel1, "Queries persist:");
        this.addPanel(panel2, this.m_query_persists);
        this.m_scrollPane3 = new JScrollPane(topPanel);
        Option options = Options.getDiagramOptions();
        this.m_current.setMainOptionsTo(options);
        this.m_current.setArrowOptionsTo(options);
        this.m_current.setDiagramOptionsTo(options);
        this.m_message = new JLabel(" ", 0);
        this.m_message.setFont(font);
        this.m_message.setForeground(Color.RED);
        this.m_message.setSize(400, 50);
        contentPane.add("North", this.m_message);
        this.addCenterThing();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(1, 15, 15));
        this.m_optionchoices.setFont(bold);
        this.m_optionchoices.setSelectedIndex(3);
        this.loadValues1();
        this.loadValues2();
        this.loadValues3();
        this.m_loadchoices.setEnabled(false);
        bottomPanel.add(this.m_optionchoices);
        for (int i = 0; i < m_button_titles.length; ++i) {
            JButton button;
            this.m_buttons[i] = button = new JButton(m_button_titles[i]);
            button.setFont(bold);
            String tip = m_button_tips[i];
            if (tip != null) {
                button.setToolTipText(tip);
            }
            button.addActionListener(this);
            bottomPanel.add(button);
        }
        this.m_optionchoices.addActionListener(this);
        contentPane.add("South", bottomPanel);
        this.setLocation(20, 20);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_optionchoices) {
            int index = this.m_optionchoices.getSelectedIndex();
            this.m_buttons[3].setEnabled(index != 0);
            this.m_loadchoices.setEnabled(index != 3);
            return;
        }
        Option current = this.m_current;
        if (source == this.m_setGridSize) {
            SetNewGridDialog dialog = new SetNewGridDialog(this.m_ls.getFrame(), current.getGridSize(), current.getGridColor());
            current.setGridSize(dialog.getGridSize());
            current.setGridColor(dialog.getGridColor());
            this.m_setGridSize.setText("" + current.getGridSize());
            this.m_setGridSize.setForeground(current.getGridColor());
            dialog.dispose();
            dialog = null;
            return;
        }
        int state = -1;
        for (int i = 0; i < m_button_titles.length; ++i) {
            if (source != this.m_buttons[i]) continue;
            state = i;
            break;
        }
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                String msg;
                boolean thirdPane;
                boolean secondPane;
                boolean firstPane;
                Option target = this.getTarget();
                if (!this.m_use_tabs) {
                    firstPane = true;
                    secondPane = true;
                    thirdPane = true;
                    msg = "All";
                } else {
                    Component currentPane = ((JTabbedPane)this.m_centerThing).getSelectedComponent();
                    firstPane = false;
                    secondPane = false;
                    thirdPane = false;
                    if (currentPane == this.m_scrollPane1) {
                        firstPane = true;
                        msg = "Main";
                    } else if (currentPane == this.m_scrollPane2) {
                        secondPane = true;
                        msg = "Visualisation";
                    } else {
                        thirdPane = true;
                        msg = "Diagram";
                    }
                }
                if (firstPane) {
                    current.setMainOptionsTo(target);
                    this.loadValues1();
                }
                if (secondPane) {
                    current.setArrowOptionsTo(target);
                    this.loadValues2();
                }
                if (thirdPane) {
                    current.setDiagramOptionsTo(target);
                    this.loadValues3();
                }
                this.m_message.setText(msg + " options loaded from " + this.getTargetName() + " values");
                return;
            }
            case 0: 
            case 3: {
                String msg1;
                String msg;
                boolean thirdPane;
                boolean secondPane;
                boolean firstPane;
                Option target = state == 0 ? Options.getDiagramOptions() : this.getTarget();
                if (target == null) {
                    this.m_message.setText("Can't alter factory reset options");
                    return;
                }
                if (!this.m_use_tabs) {
                    firstPane = true;
                    secondPane = true;
                    thirdPane = true;
                    msg = "All";
                } else {
                    Component currentPane = ((JTabbedPane)this.m_centerThing).getSelectedComponent();
                    firstPane = false;
                    secondPane = false;
                    thirdPane = false;
                    if (currentPane == this.m_scrollPane1) {
                        firstPane = true;
                        msg = "Main";
                    } else if (currentPane == this.m_scrollPane2) {
                        secondPane = true;
                        msg = "Visualisation";
                    } else {
                        thirdPane = true;
                        msg = "Diagram";
                    }
                }
                if (thirdPane) {
                    msg1 = this.saveValues3();
                    if (msg1 != null) {
                        this.m_message.setText(msg1);
                        return;
                    }
                    target.setDiagramOptionsTo(current);
                }
                if (secondPane) {
                    msg1 = this.saveValues2();
                    if (msg1 != null) {
                        this.m_message.setText(msg1);
                        return;
                    }
                    target.setArrowOptionsTo(current);
                }
                if (firstPane) {
                    this.saveValues1();
                    target.setMainOptionsTo(current);
                }
                if (state == 0) break;
                this.m_message.setText(msg + " values saved to " + this.getTargetName() + " options");
                return;
            }
            case 4: {
                this.m_use_tabs = !this.m_use_tabs;
                this.m_contentPane.remove(this.m_centerThing);
                this.addCenterThing();
                this.m_buttons[4].setText(this.m_use_tabs ? "Detab" : "Tab");
                this.pack();
                return;
            }
            case 5: {
                this.m_ls.showURL(this.m_ls.m_helpURL + "/options.html", 4);
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }

    public static void create(LandscapeEditorCore ls) {
        Option option = Options.getDiagramOptions();
        Option oldOptions = new Option("OptionDialog old");
        oldOptions.setTo(option);
        OptionsDialog optionsDialog = new OptionsDialog(ls);
        optionsDialog.dispose();
        option.optionsChanged(ls, oldOptions);
    }
}

