/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Font;
import lsedit.Option;

public class Options {
    public static final int DEFAULT_OPTION = 0;
    public static final int LANDSCAPE_OPTION = 1;
    public static final int DIAGRAM_OPTION = 2;
    private static Option m_defaultOption = new Option("Default");
    private static Option m_landscapeOption = new Option("Landscape");
    private static Option m_diagramOption = new Option("Diagram");

    public static Option getDefaultOptions() {
        return m_defaultOption;
    }

    public static Option getLandscapeOptions() {
        return m_landscapeOption;
    }

    public static Option getDiagramOptions() {
        return m_diagramOption;
    }

    public static void setDiagramOptions(Option diagramOption) {
        m_diagramOption = diagramOption;
    }

    public static void resetFonts() {
        m_defaultOption.resetFonts();
        m_landscapeOption.resetFonts();
        m_diagramOption.resetFonts();
    }

    public static void useDefaultFonts() {
        m_landscapeOption.setFontsTo(m_defaultOption);
        m_diagramOption.setFontsTo(m_defaultOption);
    }

    public static void setDefaultFonts() {
        m_defaultOption.setFontsTo(m_diagramOption);
    }

    public static void saveLandscapeFonts() {
        m_landscapeOption.setFontsTo(m_diagramOption);
    }

    public static void forgetDiagramFonts() {
        m_diagramOption.setFontsTo(m_landscapeOption);
    }

    public static Font getTargetFont(int target) {
        return m_diagramOption.getTargetFont(target);
    }

    public static double getHoverScale() {
        return m_diagramOption.getHoverScale();
    }

    public static boolean isTraceLifted() {
        return m_diagramOption.isTraceLifted();
    }

    public static boolean isQueryPersists() {
        return m_diagramOption.isQueryPersists();
    }

    public static boolean isGroupQuery() {
        return m_diagramOption.isGroupQuery();
    }

    public static int getLineWidth() {
        return m_diagramOption.getLineWidth();
    }

    public static double getArrowLength() {
        return m_diagramOption.getArrowLength();
    }
}

