/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RelationInstance;
import lsedit.Util;

public class NewEdgeModeHandler
extends LandscapeModeHandler {
    protected DrawOutline m_drawOutline;
    protected EditModeHandler m_parent;
    protected EntityInstance m_from;
    protected EntityInstance m_to;
    protected int m_x;
    protected int m_y;

    protected void stateChange() {
        String msg;
        if (this.m_from == null) {
            msg = "Click on new Edge's source entity";
        } else if (this.m_to == null) {
            this.m_drawOutline.activate();
            msg = "Click on target entity for edge having source entity " + this.m_from;
        } else {
            this.m_ls.updateNewRelation(this.m_from, this.m_to);
            msg = "Edge created from " + this.m_from + " to " + this.m_to;
            this.m_parent.cleanup();
        }
        this.m_ls.doFeedback(msg);
    }

    public NewEdgeModeHandler(EditModeHandler parent) {
        super(parent.m_ls);
        this.m_parent = parent;
        this.m_drawOutline = new DrawOutline();
    }

    @Override
    public void cleanup() {
        if (this.m_from != null || this.m_to != null) {
            Diagram diagram = this.m_ls.getDiagram();
            this.m_from = null;
            this.m_to = null;
            this.m_drawOutline.deactivate();
        }
    }

    public void activate(Object object) {
        this.m_parent.cleanup();
        this.m_parent.setSubHandler(this);
        Diagram diagram = this.m_ls.getDiagram();
        Vector entities = diagram.targetEntities(object);
        this.m_from = null;
        this.m_to = null;
        if (entities != null) {
            switch (entities.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.m_from = (EntityInstance)entities.elementAt(0);
                    break;
                }
                case 2: {
                    this.m_from = (EntityInstance)entities.elementAt(0);
                    this.m_to = (EntityInstance)entities.elementAt(1);
                    if (!this.m_from.getGroupKeyFlag()) break;
                    EntityInstance temp = this.m_from;
                    this.m_from = this.m_to;
                    this.m_to = temp;
                }
            }
        }
        this.stateChange();
    }

    @Override
    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        this.m_x = x;
        this.m_y = y;
        if (this.m_from == null) {
            this.m_from = e;
        } else {
            this.m_to = e;
        }
        this.stateChange();
    }

    @Override
    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ls.error("Edges must be between two entities -- don't click on relations");
    }

    @Override
    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        this.m_x = x;
        this.m_y = y;
        if (this.m_from != null) {
            this.m_drawOutline.repaint();
        }
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        public void activate() {
            Diagram diagram = NewEdgeModeHandler.this.m_ls.getDiagram();
            this.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
            this.setVisible(true);
            diagram.add((Component)NewEdgeModeHandler.this.m_drawOutline, 0);
        }

        public void deactivate() {
            Diagram diagram = NewEdgeModeHandler.this.m_ls.getDiagram();
            this.setVisible(false);
            diagram.remove(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            EntityInstance from = NewEdgeModeHandler.this.m_from;
            int from_x = from.getDiagramX();
            int from_y = from.getDiagramY();
            int from_w = from.getWidth();
            int from_h = from.getHeight();
            int x = NewEdgeModeHandler.this.m_x;
            int y = NewEdgeModeHandler.this.m_y;
            if (x >= from_x) {
                from_x = x <= from_x + from_w ? (from_x += from_w / 2) : (from_x += from_w);
            }
            if (y >= from_y) {
                from_y = y <= from_y + from_h ? (from_y += from_h / 2) : (from_y += from_h);
            }
            double fraction = Util.drawArrowHead(g, from_x, from_y, x, y, 1);
            x -= (int)((double)(x - from_x) * fraction);
            y -= (int)((double)(y - from_y) * fraction);
            Util.drawSegment(g, 0, from_x, from_y, x, y);
        }
    }
}

