/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import lsedit.LandscapeEditorCore;

class MyHistoryMenuItem
extends JMenuItem
implements ActionListener {
    protected LandscapeEditorCore m_ls;
    protected String m_path;

    public static String getLabel(String path) {
        if (path == null) {
            return "";
        }
        int from = path.lastIndexOf(47);
        int to = path.lastIndexOf(92);
        if (to > from) {
            from = to;
        }
        if ((to = path.length()) > 3 && path.endsWith(".ta")) {
            to -= 3;
        }
        return path.substring(from + 1, to);
    }

    public void setPath(String path) {
        this.m_path = path;
        if (path == null || path.length() == 0) {
            path = "New Landscape";
        }
        this.setText(MyHistoryMenuItem.getLabel(path));
        this.setToolTipText(path);
    }

    public MyHistoryMenuItem(JMenu menu, String path, LandscapeEditorCore ls) {
        this.m_ls = ls;
        this.setPath(path);
        menu.add(this);
        this.addActionListener(this);
    }

    public boolean isPath(String path) {
        return this.m_path.equals(path);
    }

    public String getPath() {
        return this.m_path;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        int modifiers = ev.getModifiers();
        if ((modifiers & 4) != 0) {
            switch (JOptionPane.showConfirmDialog(null, this.m_path, "Delete All history menu items", 1)) {
                case 0: {
                    this.m_ls.removeHistory();
                    break;
                }
                case 1: {
                    this.m_ls.removeHistoryMenu(this);
                }
            }
            return;
        }
        this.m_ls.loadLs(this.m_path, null, false);
    }
}

