/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.RelationInstance;

public class MoveModeHandler
extends LandscapeModeHandler {
    protected DrawOutline m_drawOutline;
    protected EditModeHandler m_parent;
    protected EdgePoint m_edgePoint;
    protected EntityInstance m_entityInstance;
    protected RelationInstance m_relationInstance;
    protected RelationClass m_rc;
    protected int m_active = 0;
    protected int m_cursor = 0;

    public void overEdgePointCallBack(EntityInstance entityInstance, RelationInstance relationInstance, EdgePoint edgePoint) {
        this.m_entityInstance = entityInstance;
        this.m_relationInstance = relationInstance;
        this.m_edgePoint = edgePoint;
    }

    protected boolean overEdgePoint(Object thing, int x, int y) {
        RelationInstance ri;
        RelationComponent c;
        if (thing instanceof RelationInstance && (c = (ri = (RelationInstance)thing).getRelationComponent()).mouseOverEdgePoint(x, y, this)) {
            this.m_rc = ri.getRelationClass();
            return true;
        }
        return false;
    }

    protected RealPoint getFactors(int x, int y) {
        double hf;
        double wf;
        Rectangle lyt = this.m_entityInstance.getDiagramBounds();
        double xp = x;
        double yp = y;
        double dl = Math.abs(xp - (double)lyt.x);
        double dr = Math.abs(xp - (double)(lyt.x + lyt.width));
        double dt = Math.abs(yp - (double)lyt.y);
        double db = Math.abs(yp - (double)(lyt.y + lyt.height));
        if (dl < dr) {
            if (dt < db) {
                if (dt < dl) {
                    wf = (xp - (double)lyt.x) / (double)lyt.width;
                    hf = 0.0;
                } else {
                    wf = 0.0;
                    hf = (yp - (double)lyt.y) / (double)lyt.height;
                }
            } else if (db < dl) {
                wf = (xp - (double)lyt.x) / (double)lyt.width;
                hf = 1.0;
            } else {
                wf = 0.0;
                hf = (yp - (double)lyt.y) / (double)lyt.height;
            }
        } else if (dt < db) {
            if (dt < dr) {
                wf = (xp - (double)lyt.x) / (double)lyt.width;
                hf = 0.0;
            } else {
                wf = 1.0;
                hf = (yp - (double)lyt.y) / (double)lyt.height;
            }
        } else if (db < dr) {
            wf = (xp - (double)lyt.x) / (double)lyt.width;
            hf = 1.0;
        } else {
            wf = 1.0;
            hf = (yp - (double)lyt.y) / (double)lyt.height;
        }
        wf = Math.max(0.0, Math.min(1.0, wf));
        hf = Math.max(0.0, Math.min(1.0, hf));
        return new RealPoint(wf, hf);
    }

    protected boolean moveIOStart(int x, int y) {
        Diagram diagram = this.m_ls.getDiagram();
        this.m_active = 2;
        this.m_ls.setCursor(1);
        this.m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
        this.m_drawOutline.setVisible(true);
        diagram.add((Component)this.m_drawOutline, 0);
        RealPoint factors = this.getFactors(x, y);
        this.m_ls.doFeedback("I/O point at factors (" + factors.getX() + ", " + factors.getY() + ")");
        return true;
    }

    protected void moveIOMotion(int x, int y) {
        RealPoint factors = this.getFactors(x, y);
        this.m_ls.setCursor(1);
        this.m_edgePoint = this.m_entityInstance.setFactors(this.m_relationInstance, this.m_edgePoint, factors.getX(), factors.getY());
        this.m_entityInstance.revalidateAllMyEdgesForClass(this.m_rc);
        this.m_drawOutline.repaint();
        this.m_ls.doFeedback("I/O point at (" + factors.getX() + ", " + factors.getY() + ")");
    }

    public MoveModeHandler(EditModeHandler parent) {
        super(parent.m_ls);
        this.m_parent = parent;
        this.m_drawOutline = new DrawOutline();
    }

    @Override
    public void cleanup() {
        this.m_edgePoint = null;
        switch (this.m_active) {
            case 2: {
                Diagram diagram = this.m_ls.getDiagram();
                this.m_drawOutline.setVisible(false);
                diagram.remove(this.m_drawOutline);
            }
            case 1: {
                this.m_active = 0;
                if (this.m_cursor == 0) break;
                this.m_cursor = 0;
                this.m_ls.setCursor(this.m_cursor);
            }
        }
    }

    @Override
    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        switch (this.m_active) {
            case 0: {
                if (!this.overEdgePoint(thing, x, y)) {
                    return;
                }
                this.m_cursor = 1;
                this.m_parent.setSubHandler(this);
                this.m_active = 1;
                break;
            }
            case 1: {
                if (this.overEdgePoint(thing, x, y)) break;
                this.m_active = 0;
                this.m_parent.cleanup();
                return;
            }
        }
        this.m_ls.setCursor(this.m_cursor);
    }

    @Override
    public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.m_active == 1) {
            this.moveIOStart(x, y);
        }
    }

    @Override
    public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.movedOverThing(ev, ri, x, y);
        if (this.m_active == 1) {
            this.moveIOStart(x, y);
        }
    }

    @Override
    public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.m_edgePoint != null) {
            this.moveIOMotion(x, y);
        }
    }

    @Override
    public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ls.clearFeedback();
        this.m_parent.cleanup();
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        @Override
        public void paintComponent(Graphics g) {
            EdgePoint edgePoint = MoveModeHandler.this.m_edgePoint;
            super.paintComponent(g);
            if (edgePoint != null) {
                EntityInstance entityInstance = MoveModeHandler.this.m_entityInstance;
                g.drawOval((int)entityInstance.getEdgePointX(edgePoint) - 6, (int)entityInstance.getEdgePointY(edgePoint) - 6, 12, 12);
            }
        }
    }
}

