/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.text.NumberFormat;
import lsedit.EntityInstance;

class MetricsEntry {
    public EntityInstance m_drawRoot;
    public int m_internal_edges;
    public int m_external_edges;
    public int m_boxes_seen;
    public int m_leaf_nodes;
    public int m_max_children;
    public int m_min_children;
    public int m_total_children;
    public int m_max_depth;

    public MetricsEntry(EntityInstance drawRoot) {
        this.m_drawRoot = drawRoot;
        this.m_internal_edges = 0;
        this.m_external_edges = 0;
        this.m_boxes_seen = 0;
        this.m_leaf_nodes = 0;
        this.m_max_children = 0;
        this.m_min_children = 0;
        this.m_total_children = 0;
        this.m_max_depth = 0;
    }

    public boolean sameEntry(MetricsEntry last, int i) {
        boolean ret;
        switch (i) {
            case 0: {
                ret = last.m_drawRoot == this.m_drawRoot;
                break;
            }
            case 1: {
                ret = last.m_internal_edges == this.m_internal_edges;
                break;
            }
            case 2: {
                ret = last.m_external_edges == this.m_external_edges;
                break;
            }
            case 3: {
                ret = last.m_min_children == this.m_min_children;
                break;
            }
            case 4: {
                ret = last.m_max_children == this.m_max_children;
                break;
            }
            case 5: {
                ret = last.m_boxes_seen == this.m_boxes_seen && last.m_total_children == this.m_total_children;
                break;
            }
            case 6: {
                ret = last.m_leaf_nodes == this.m_leaf_nodes;
                break;
            }
            case 7: {
                ret = last.m_leaf_nodes + last.m_boxes_seen == this.m_leaf_nodes + this.m_boxes_seen;
                break;
            }
            case 8: {
                ret = last.m_max_depth == this.m_max_depth;
                break;
            }
            default: {
                ret = true;
            }
        }
        return ret;
    }

    public boolean same(MetricsEntry last) {
        if (last != null) {
            for (int i = 0; i < 9; ++i) {
                if (this.sameEntry(last, i)) continue;
                return false;
            }
        }
        return true;
    }

    public String text(int i) {
        String s;
        switch (i) {
            case 0: {
                s = this.m_drawRoot.getFullEntityLabel() + " ";
                break;
            }
            case 1: {
                s = "" + this.m_internal_edges;
                break;
            }
            case 2: {
                s = "" + this.m_external_edges;
                break;
            }
            case 3: {
                s = "" + this.m_min_children;
                break;
            }
            case 4: {
                s = "" + this.m_max_children;
                break;
            }
            case 5: {
                if (this.m_boxes_seen == 0) {
                    s = "N/A";
                    break;
                }
                NumberFormat format = NumberFormat.getInstance();
                format.setMaximumFractionDigits(2);
                s = format.format((double)this.m_total_children / (double)this.m_boxes_seen);
                break;
            }
            case 6: {
                s = "" + this.m_leaf_nodes;
                break;
            }
            case 7: {
                s = "" + (this.m_leaf_nodes + this.m_boxes_seen + 1);
                break;
            }
            case 8: {
                s = "" + this.m_max_depth;
                break;
            }
            default: {
                s = "????";
            }
        }
        return s;
    }
}

