/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.Map;
import lsedit.Options;
import lsedit.RelationClass;
import lsedit.TaListener;
import lsedit.TabBox;

public class MapBox
extends TabBox
implements ChangeListener,
TaListener {
    protected static final int GAP = 5;
    protected static Font m_textFont = null;
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected EntityInstance m_drawRoot = null;
    protected boolean m_refill = false;
    public static final String m_helpStr = "This box shows stylized versions of landscapes representing the path from the top of the containment hierarchy to the current landscape, with green boxes highlighting steps in the path.";

    private int getPreferredWidth() {
        Insets insets = this.m_scrollPane.getInsets();
        return this.m_scrollPane.getWidth() - insets.left - insets.right;
    }

    private int getPreferredHeight() {
        Insets insets = this.m_scrollPane.getInsets();
        int height = this.m_scrollPane.getHeight() - insets.top - insets.bottom;
        int cnt = this.getComponentCount();
        if (cnt > 0) {
            int width = this.m_scrollPane.getWidth() - insets.left - insets.right;
            double ratio = this.getRatio();
            int height1 = this.getPreferredMapHeight(width, ratio);
            if ((height1 = (height1 + 5) * cnt) > height) {
                height = height1;
            }
        }
        return height;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight();
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    @Override
    public void validate() {
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight();
        double ratio = this.getRatio();
        int height1 = this.getPreferredMapHeight(width, ratio);
        if (this.getWidth() != width || this.getHeight() != height) {
            this.setBounds(0, 0, width, height);
        }
        if (height1 > 0) {
            int width1 = width - 5;
            int y = 0;
            int cnt = this.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Component map = this.getComponent(i);
                map.setBounds(5, y, width1, height1);
                y += height1 + 5;
            }
        }
    }

    public MapBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) {
        super(ls, tabbedPane, "Map", m_helpStr);
        this.setBounds(0, 0, tabbedPane.getWidth(), tabbedPane.getHeight());
        tabbedPane.addChangeListener(this);
    }

    public double getRatio() {
        double ratio;
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            ratio = 0.0;
        } else {
            int diagram_width = diagram.getWidth();
            if (diagram_width <= 0) {
                ratio = 0.0;
            } else {
                int diagram_height = diagram.getHeight();
                ratio = (double)diagram_height / (double)diagram_width;
            }
        }
        return ratio;
    }

    private int getPreferredMapHeight(int width, double ratio) {
        int width1 = width - 5;
        if (width1 <= 0 || ratio <= 0.0) {
            return 0;
        }
        return (int)(ratio * (double)width1);
    }

    private void addAll(EntityInstance e) {
        EntityInstance parent;
        Font textFont = m_textFont;
        if (textFont == null) {
            m_textFont = textFont = Options.getTargetFont(15);
        }
        if (e != null && (parent = e.getContainedBy()) != null) {
            this.addAll(parent);
            this.add(new Map(this, e, textFont));
        }
    }

    private void fill() {
        this.removeAll();
        if (this.isActive()) {
            this.addAll(this.m_drawRoot);
        }
        this.validate();
        this.repaint();
    }

    public void setDrawRoot(EntityInstance e) {
        this.m_drawRoot = e;
        this.fill();
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        MapBox.setTextFont(font);
        this.fill();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fill();
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
        this.setDrawRoot(diagram.getDrawRoot());
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
        if (this.m_refill) {
            this.m_refill = false;
            this.fill();
        }
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
        this.m_refill = true;
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
        switch (signal) {
            case 8: {
                this.m_refill = true;
            }
        }
    }
}

