/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.MapBox;

class Map
extends JComponent
implements MouseListener {
    protected MapBox m_mapBox;
    protected int m_style;
    protected JLabel m_label;
    protected EntityInstance m_entity;

    @Override
    public String toString() {
        return "Map " + this.m_label.getText() + " " + this.getBounds();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.m_label.setSize(width, 20);
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int lheight = this.m_label.getHeight();
        if (this.m_style != 0) {
            g.setColor(Diagram.boxColor);
            g.draw3DRect(0, 0, width - 2, height - 2, this.m_style == 1);
        }
        g.setColor(Color.black);
        g.drawLine(0, height - 1, width - 1, height - 1);
        EntityInstance parent = this.m_entity.getContainedBy();
        if (parent != null) {
            parent.paintMap(g, (int)((double)width * 0.166), lheight + 5, (int)((double)width * 0.66), height - lheight - 10, this.m_entity, 0);
        }
    }

    @Override
    public void validate() {
        int label_height = this.m_label.getHeight();
        this.m_label.setBounds(0, 0, this.getWidth(), label_height);
        super.validate();
    }

    public Map(MapBox mapBox, EntityInstance entity, Font textFont) {
        this.setLayout(null);
        this.m_mapBox = mapBox;
        this.m_style = 0;
        this.m_entity = entity;
        EntityInstance parent = entity.getContainedBy();
        this.m_label = new JLabel(parent != null ? parent.getEntityLabel() : "", 0);
        this.m_label.setForeground(Color.black);
        this.m_label.setFont(textFont);
        this.m_label.setLocation(0, 0);
        this.add(this.m_label);
        this.setToolTipText(entity.getEntityLabel());
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.m_style = 1;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.m_style = 0;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.m_style = 2;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.m_style = 0;
        this.m_mapBox.getLs().followLink(this.m_entity.getContainedBy(), false);
    }
}

