/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Distance;
import lsedit.EditableTa;
import lsedit.EntityInstance;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.TaFeedback;
import lsedit.Util;

public class LsClusterer
implements TaFeedback {
    protected static final double default_attractive_force = 0.05;
    protected static final double default_sparse_factor = 1.0;
    protected static final double default_repulsive_force = 0.01;
    protected static final double default_repulsive_diameter = 0.75;
    protected static final int default_iterations = 1000;
    protected static final int default_timeout = 60;
    protected static final double default_separation_factor = 2.5;
    protected static final double default_margin = 0.05;
    protected static final double default_gap = 0.4;
    protected static final int default_form_clusters = 0;
    protected static final boolean default_remove_contains = true;
    protected static final boolean default_mustbe_related = true;
    protected static final boolean default_feedback = true;
    protected double m_attractive_force = 0.05;
    protected double m_sparse_factor = 1.0;
    protected double m_repulsive_force = 0.01;
    protected double m_repulsive_diameter = 0.75;
    protected int m_iterations = 1000;
    protected int m_timeout = 60;
    protected boolean m_remove_contains = true;
    protected boolean m_mustbe_related = true;
    protected boolean m_feedback = true;
    protected double m_separation_factor = 2.5;
    protected double m_margin = 0.05;
    protected double m_gap = 0.4;
    protected int m_form_clusters = 0;

    protected static void die() {
        System.exit(1);
    }

    protected void log(String message) {
        if (this.m_feedback) {
            System.err.println(Util.toLocaleString() + ": LSClusterer : " + message);
        }
    }

    protected void layout(EditableTa ta) {
        ClusterNode tail;
        double length;
        double y;
        double x;
        double ydiff;
        double xdiff;
        ClusterNode clusterNode1;
        double width;
        int j;
        EntityInstance e1;
        EntityInstance e;
        ClusterNode clusterNode;
        EntityInstance rootInstance = ta.getRootInstance();
        Vector selectedBoxes = new Vector();
        rootInstance.gatherLeaves(selectedBoxes);
        int size = selectedBoxes.size();
        if (size < 3) {
            return;
        }
        this.log("Clustering " + size + " items");
        ClusterNode[] clusterNodes = new ClusterNode[size];
        boolean[][] related = new boolean[size][];
        int i = 0;
        while (i < size) {
            clusterNodes[i] = clusterNode = new ClusterNode();
            related[i] = new boolean[size - i];
            clusterNode.m_e = e = (EntityInstance)selectedBoxes.elementAt(i);
            clusterNode.m_x = e.xRelLocal();
            clusterNode.m_y = e.yRelLocal();
            clusterNode.m_cluster = i++;
            clusterNode.m_next = null;
            e.orMark(0x4000000);
        }
        double ideal_length = 0.0;
        for (i = 0; i < size; ++i) {
            RelationInstance ri;
            clusterNode = clusterNodes[i];
            e = clusterNode.m_e;
            Enumeration en = e.srcRelationElements();
            if (en != null) {
                block2: while (en.hasMoreElements()) {
                    ri = (RelationInstance)en.nextElement();
                    if (!ri.isRelationShown() || !(e1 = ri.getDst()).isMarked(0x4000000)) continue;
                    for (j = i + 1; j < size; ++j) {
                        if (e1 != clusterNodes[j].m_e) continue;
                        related[i][j - i] = true;
                        continue block2;
                    }
                }
            }
            if ((en = e.dstRelationElements()) == null) continue;
            block4: while (en.hasMoreElements()) {
                ri = (RelationInstance)en.nextElement();
                if (!ri.isRelationShown() || !(e1 = ri.getSrc()).isMarked(0x4000000)) continue;
                for (j = i + 1; j < size; ++j) {
                    if (e1 != clusterNodes[j].m_e) continue;
                    related[i][j - i] = true;
                    continue block4;
                }
            }
        }
        for (i = 0; i < size; ++i) {
            clusterNode = clusterNodes[i];
            e = clusterNode.m_e;
            width = e.widthRelLocal();
            double height = e.heightRelLocal();
            for (j = i + 1; j < size; ++j) {
                if (!related[i][j - i]) continue;
                clusterNode1 = clusterNodes[j];
                e1 = clusterNode1.m_e;
                double width1 = e1.widthRelLocal();
                double height1 = e1.heightRelLocal();
                xdiff = width + width1;
                if (xdiff > ideal_length) {
                    ideal_length = xdiff;
                }
                if (!((ydiff = height + height1) > ideal_length)) continue;
                ideal_length = ydiff;
            }
        }
        ideal_length *= this.m_sparse_factor;
        this.log("Iterating over these " + size + " items");
        long timeout = System.currentTimeMillis() + (long)(this.m_timeout * 1000);
        for (int iteration = this.m_iterations; iteration > 0; --iteration) {
            for (i = 0; i < size; ++i) {
                clusterNode = clusterNodes[i];
                x = clusterNode.m_x;
                y = clusterNode.m_y;
                for (j = i + 1; j < size; ++j) {
                    clusterNode1 = clusterNodes[j];
                    double x1 = clusterNode1.m_x;
                    double y1 = clusterNode1.m_y;
                    xdiff = x1 - x;
                    ydiff = y1 - y;
                    if (xdiff == 0.0 && ydiff == 0.0) {
                        xdiff = i % 3 - 1;
                        ydiff = xdiff == 0.0 ? (double)(j % 2 * 2 - 1) : (double)(j % 3 - 1);
                    }
                    length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    double f = related[i][j - i] ? (length - ideal_length) * this.m_attractive_force : (length - this.m_repulsive_diameter) * this.m_repulsive_force;
                    x += f * xdiff / length;
                    y += f * ydiff / length;
                    clusterNode1.m_x = x1 -= f * xdiff / length;
                    clusterNode1.m_y = y1 -= f * ydiff / length;
                }
                clusterNode.m_x = x;
                clusterNode.m_y = y;
            }
            if (System.currentTimeMillis() <= timeout) continue;
            this.log("Timeout after " + (this.m_iterations - iteration) + " iterations");
            break;
        }
        this.log("Build graph for " + size + " items");
        int clusters = size;
        if (this.m_form_clusters != 1 && this.m_form_clusters < clusters) {
            Vector<Distance> distances = new Vector<Distance>();
            for (i = 0; i < size; ++i) {
                clusterNode = clusterNodes[i];
                x = clusterNode.m_x;
                y = clusterNode.m_y;
                for (j = i + 1; j < size; ++j) {
                    if (this.m_mustbe_related && !related[i][j - i]) continue;
                    clusterNode1 = clusterNodes[j];
                    xdiff = clusterNode1.m_x - x;
                    ydiff = clusterNode1.m_y - y;
                    length = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    distances.add(new Distance(length, i, j));
                }
            }
            int pairs = distances.size();
            this.log("Sorting " + pairs + " of distances");
            SortVector.byDistance(distances);
            ideal_length = -1.0;
            for (i = 0; i < pairs; ++i) {
                Distance distance = (Distance)distances.elementAt(i);
                length = distance.m_length;
                if (length > ideal_length * this.m_separation_factor && this.m_form_clusters == 0 && ideal_length >= 0.0) break;
                ideal_length = length;
                clusterNode = clusterNodes[distance.m_i];
                clusterNode1 = clusterNodes[distance.m_j];
                if (clusterNode.m_cluster == clusterNode1.m_cluster) continue;
                j = clusterNode.m_cluster;
                clusterNode = clusterNodes[j];
                tail = clusterNode1 = clusterNodes[clusterNode1.m_cluster];
                while (tail.m_next != null) {
                    tail.m_cluster = j;
                    tail = tail.m_next;
                }
                tail.m_cluster = j;
                tail.m_next = clusterNode.m_next;
                clusterNode.m_next = clusterNode1;
                if (--clusters <= this.m_form_clusters || clusters < 3) break;
            }
        }
        int size1 = size - 1;
        ClusterNode utilities = null;
        if (clusters > this.m_form_clusters) {
            this.log("Identifying utilities");
            size1 = -1;
            clusters = 0;
            for (i = 0; i < size; ++i) {
                clusterNode = clusterNodes[i];
                if (clusterNode.m_cluster != i) continue;
                if (clusterNode.m_next == null) {
                    if (utilities != null) {
                        clusterNode.m_cluster = utilities.m_cluster;
                        clusterNode.m_next = utilities.m_next;
                        utilities.m_next = clusterNode;
                        continue;
                    }
                    utilities = clusterNode;
                }
                ++clusters;
                size1 = i;
            }
        }
        this.log("Reorganising " + size + " items into " + clusters + " selected clusters");
        clusters = 0;
        e1 = null;
        for (i = 0; i <= size1; ++i) {
            double ymax;
            double xmax;
            clusterNode = clusterNodes[i];
            if (clusterNode.m_cluster != i) continue;
            e1 = ta.getNewEntity(null, rootInstance);
            String text = "Cluster" + ++clusters;
            if (clusterNode == utilities) {
                text = this.m_form_clusters == 1 ? text + " (Layout)" : text + " (Utilities)";
            }
            e1.setLabel(text);
            int cnt = 0;
            x = xmax = clusterNode.m_x;
            y = ymax = clusterNode.m_y;
            tail = clusterNode;
            while (tail != null) {
                if (tail.m_x < x) {
                    x = tail.m_x;
                }
                if (tail.m_y < y) {
                    y = tail.m_y;
                }
                if (tail.m_x > xmax) {
                    xmax = tail.m_x;
                }
                if (tail.m_y > ymax) {
                    ymax = tail.m_y;
                }
                ++cnt;
                tail = tail.m_next;
            }
            e1.setDescription("Cluster of " + cnt + " items");
            cnt = (int)Math.ceil(Math.sqrt(cnt));
            width = (1.0 - this.m_margin) * (1.0 - this.m_gap) / (double)cnt;
            xdiff = xmax - x;
            double xm = xdiff == 0.0 ? 0.0 : (1.0 - this.m_margin - width) / xdiff;
            double xc = this.m_margin * 0.5 - xm * x;
            ydiff = ymax - y;
            double ym = ydiff == 0.0 ? 0.0 : (1.0 - this.m_margin - width) / ydiff;
            double yc = this.m_margin * 0.5 - ym * y;
            while (clusterNode != null) {
                e = clusterNode.m_e;
                x = clusterNode.m_x * xm + xc;
                y = clusterNode.m_y * ym + yc;
                e.setRelLocal(x, y, width, width);
                ta.moveEntityContainment(e1, e);
                e.orMark(0x4000000);
                clusterNode = clusterNode.m_next;
            }
        }
        this.log("Finished forming " + clusters + " clusters");
    }

    public LsClusterer(String input, String output) {
        EditableTa ta = new EditableTa(this);
        String ret = ta.loadTA(input, System.in);
        if (ret != null) {
            this.error(ret);
        }
        this.layout(ta);
        ret = ta.saveByFile(output);
        if (ret != null) {
            this.error(ret);
        }
        System.exit(0);
    }

    @Override
    public void showProgress(String message) {
        if (this.m_feedback) {
            System.err.println("Progress: " + message + "\n");
        }
    }

    @Override
    public void doFeedback(String message) {
        if (this.m_feedback) {
            System.err.println("Feedback: " + message + "\n");
        }
    }

    @Override
    public void showInfo(String message) {
        if (this.m_feedback) {
            System.err.println("    Info: " + message + "\n");
        }
    }

    @Override
    public void error(String message) {
        System.err.println("   Error: " + message + "\n");
        LsClusterer.die();
    }

    @Override
    public void showCycle(RelationInstance ri) {
        System.err.println("Cycle detected in contains heirarchy within input TA\n");
        LsClusterer.die();
    }

    @Override
    public void noContainRelation(String taPath) {
        System.err.println("No contains relation defined in the input TA\n");
        LsClusterer.die();
    }

    @Override
    public void hasMultipleParents(RelationClass rc, EntityInstance e) {
        System.err.println("Multiple parents detected in contains heirarchy within input TA\n");
        LsClusterer.die();
    }

    public static void main(String[] args) {
        String input = "";
        String output = "";
        switch (args.length) {
            case 2: {
                output = args[1];
            }
            case 1: {
                input = args[0];
            }
            case 0: {
                break;
            }
            default: {
                System.err.println("usage: java lsedit.LsClusterer [<input> [<output>]]\n");
                LsClusterer.die();
            }
        }
        new LsClusterer(input, output);
    }

    class ClusterNode {
        public EntityInstance m_e;
        double m_x;
        double m_y;
        int m_cluster;
        ClusterNode m_next;

        ClusterNode() {
        }
    }
}

