/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.ScreenPoint;

public class LineWalker {
    protected double segLen;
    protected double segGap;
    protected double x;
    protected double y;
    protected double dx1;
    protected double dy1;
    protected double dx2;
    protected double dy2;
    protected int num;
    protected int seg = 0;

    protected double sign(double val) {
        return val < 0.0 ? -1.0 : 1.0;
    }

    public void init(int x1, int y1, int x2, int y2, int len, int gap) {
        this.segLen = len;
        this.segGap = gap;
        this.x = x1;
        this.y = y1;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double h = Math.sqrt(dx * dx + dy * dy);
        this.num = (int)((h - this.segLen) / (this.segLen + this.segGap)) + 1;
        this.segGap = (h - (double)this.num * this.segLen) / (double)(this.num - 1);
        double angle = Math.asin(dy / h);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double mfx = this.sign(dx) == this.sign(cos) ? 1.0 : -1.0;
        double mfy = this.sign(dy) == this.sign(sin) ? 1.0 : -1.0;
        this.dx1 = this.segLen * cos * mfx;
        this.dy1 = this.segLen * sin * mfy;
        this.dx2 = (this.segLen + this.segGap) * cos * mfx;
        this.dy2 = (this.segLen + this.segGap) * sin * mfy;
    }

    public LineWalker(int x1, int y1, int x2, int y2, int len, int gap) {
        this.init(x1, y1, x2, y2, len, gap);
    }

    public LineWalker(ScreenPoint p1, ScreenPoint p2, int len, int gap) {
        this.init(p1.x, p1.y, p2.x, p2.y, len, gap);
    }

    public boolean morePoints() {
        return this.seg != this.num;
    }

    public void nextPoints(ScreenPoint p1, ScreenPoint p2) {
        ScreenPoint p = new ScreenPoint(this.x, this.y);
        p1.x = p.x;
        p1.y = p.y;
        p = new ScreenPoint(this.x + this.dx1, this.y + this.dy1);
        p2.x = p.x;
        p2.y = p.y;
        this.x += this.dx2;
        this.y += this.dy2;
        ++this.seg;
    }
}

