/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import lsedit.EntityCache;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.TA_StreamTokenizer;
import lsedit.Ta;

public class LandscapeTokenStream
extends TA_StreamTokenizer {
    public static final int SCHEME_TUPLE = 0;
    public static final int SCHEME_ATTRIBUTE = 1;
    public static final int FACT_TUPLE = 2;
    public static final int FACT_ATTRIBUTE = 3;
    public static final int ERROR = -1;
    public static final int NONE = -2;
    public static final int EOF = 99;
    protected static final String SCHEME_ID = "SCHEME";
    protected static final String FACT_ID = "FACT";
    protected static final String TUPLE_ID = "TUPLE";
    protected static final String ATTRIBUTE_ID = "ATTRIBUTE";
    protected EntityCache m_entityCache;
    protected boolean m_fatalError = false;
    protected String m_includeFile;
    protected String m_token1;
    protected String m_token2;
    protected int m_ttype3;
    public String m_verb;
    public String m_object;
    public String m_subject;
    public int m_relations;
    protected int m_startLineno = -1;
    static Vector m_tempAttributes = new Vector();

    protected void skipRecord() throws IOException {
        int ttype;
        while ((ttype = this.nextToken()) != -1 && ttype != 125) {
        }
    }

    protected void parseAttributes(LandscapeObject target) throws IOException {
        Vector tempAttributes = m_tempAttributes;
        tempAttributes.clear();
        while (true) {
            String value;
            int ttype = this.nextToken();
            switch (ttype) {
                case 125: {
                    target.addAttributes(tempAttributes);
                    return;
                }
                case -2: {
                    break;
                }
                default: {
                    this.error("Expecting attribute id for " + target);
                    target.addAttributes(tempAttributes);
                    return;
                }
            }
            String attributeId = this.m_sval;
            ttype = this.nextToken();
            if (ttype != 61) {
                this.pushBack(ttype);
                value = null;
            } else {
                value = this.nextAVI();
            }
            target.addAttribute(attributeId, value, tempAttributes);
        }
    }

    public LandscapeTokenStream(Reader reader, String filename, EntityCache entityCache) {
        super(reader, filename);
        this.m_entityCache = entityCache;
    }

    public int getStartLineno() {
        return this.m_startLineno;
    }

    public void errorNS(String msg) {
        MsgOut.println("*** Error (" + this.filename() + ":" + this.lineno() + "): " + msg);
    }

    public void error(String msg) {
        MsgOut.println("*** Error (" + this.filename() + ":" + this.lineno() + "): " + msg + ". Found " + this.m_sval);
    }

    public void warning(String msg) {
        MsgOut.println(">>> Warning (" + this.filename() + ":" + this.lineno() + "): " + msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextSection() throws IOException {
        String type;
        String graph;
        if (this.m_fatalError) {
            return 99;
        }
        if (this.m_token1 != null) {
            if (this.m_ttype3 != 58) {
                this.error("Expecting section header ':'");
                return -1;
            }
            graph = this.m_token1;
            type = this.m_token2;
            this.m_token1 = null;
            this.m_token2 = null;
        } else {
            int ttype = this.nextToken();
            switch (ttype) {
                case -1: {
                    return 99;
                }
                case -2: {
                    graph = this.m_sval;
                    if (this.nextToken() != -2) {
                        this.error("Expecting section type id");
                        return -1;
                    }
                    type = this.m_sval;
                    if (this.nextToken() == 58) break;
                    this.error("Expecting ':'");
                    return -1;
                }
                default: {
                    this.error("Expecting graph id");
                    return -1;
                }
            }
        }
        if (graph.equals(SCHEME_ID)) {
            if (type.equals(TUPLE_ID)) {
                return 0;
            }
            if (type.equals(ATTRIBUTE_ID)) {
                return 1;
            }
            if (type.equals("END")) {
                return 99;
            }
            this.error("Bad section type");
            return -1;
        }
        if (!graph.equals(FACT_ID)) {
            this.error("Bad section id");
            return -1;
        }
        if (type.equals(TUPLE_ID)) {
            return 2;
        }
        if (type.equals(ATTRIBUTE_ID)) {
            return 3;
        }
        this.error("Bad section type");
        return -1;
    }

    public String getIncludeFile() {
        return this.m_includeFile;
    }

    public boolean nextSchemaTriple() throws IOException {
        if (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            switch (this.nextToken()) {
                case -1: {
                    return false;
                }
                case -2: {
                    break;
                }
                default: {
                    this.error("Expecting word verb token");
                    this.m_fatalError = true;
                    return false;
                }
            }
            this.m_relations = 0;
            this.m_verb = this.m_sval;
            switch (this.nextToken()) {
                case -2: {
                    this.m_object = this.m_sval;
                    break;
                }
                case 40: {
                    this.m_relations |= 1;
                    if (this.nextToken() == -2) {
                        this.m_object = this.m_sval;
                        if (this.nextToken() == 41) break;
                    }
                }
                default: {
                    this.error("Expecting word object token");
                    this.m_fatalError = true;
                    return false;
                }
            }
            switch (this.nextToken()) {
                case 58: {
                    this.m_token1 = this.m_verb;
                    this.m_token2 = this.m_object;
                    this.m_ttype3 = 58;
                    return false;
                }
                case -2: {
                    this.m_subject = this.m_sval;
                    return true;
                }
                case 40: {
                    this.m_relations |= 2;
                    if (this.nextToken() != -2) break;
                    this.m_subject = this.m_sval;
                    if (this.nextToken() != 41) break;
                    return true;
                }
            }
            this.error("Expecting word subject token");
            this.m_fatalError = true;
            return true;
        }
        return false;
    }

    public boolean nextFactTriple() throws IOException {
        if (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            int ttype = this.nextToken();
            switch (ttype) {
                case -1: {
                    return false;
                }
                case -2: {
                    this.m_verb = this.m_sval;
                    if (this.nextToken() != -2) {
                        this.error("Expecting word token");
                        break;
                    }
                    this.m_object = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype == 58) {
                        this.m_token1 = this.m_verb;
                        this.m_token2 = this.m_object;
                        this.m_ttype3 = ttype;
                        return false;
                    }
                    if (ttype != -2) {
                        this.error("Error in tuple parse");
                        break;
                    }
                    this.m_subject = this.m_sval;
                    return true;
                }
                default: {
                    this.error("Expecting word token");
                }
            }
            this.m_fatalError = true;
        }
        return false;
    }

    public void processSchemeAttributes(Ta ta) throws IOException {
        LandscapeClassObject target = null;
        while (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            int ttype = this.nextToken();
            String msg = null;
            switch (ttype) {
                case -1: {
                    return;
                }
                case 40: {
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected ( <relation class name>";
                        break;
                    }
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 41) {
                        msg = "Expected ( " + token1 + "<)>";
                        break;
                    }
                    ttype = this.nextToken();
                    if (ttype != 123) {
                        msg = "Expected (...) <{>";
                        break;
                    }
                    if (Ta.m_strict_TA) {
                        target = ta.getRelationClass(token1);
                        if (target != null) break;
                        msg = "Strict TA: Undeclared relation class '" + token1 + "' has attributes";
                        break;
                    }
                    target = ta.addRelationClass(token1);
                    break;
                }
                case -2: {
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 123) {
                        if (ttype != -2) {
                            msg = "Expecting " + token1 + " <{>";
                            break;
                        }
                        String token2 = this.m_sval;
                        ttype = this.nextToken();
                        if (ttype != 58) {
                            msg = "Expecting section header or id <{>";
                            break;
                        }
                        this.m_token1 = token1;
                        this.m_token2 = token2;
                        this.m_ttype3 = ttype;
                        return;
                    }
                    if (!Ta.m_strict_TA) {
                        target = ta.addEntityClass(token1);
                        break;
                    }
                    target = ta.getEntityClass(token1);
                    if (target != null) break;
                    msg = "Strict TA: Undeclared entity class '" + token1 + "' has attributes";
                    break;
                }
                default: {
                    msg = "Expecting object id";
                }
            }
            if (msg != null) {
                this.errorNS(msg);
                this.skipRecord();
                continue;
            }
            this.parseAttributes(target);
        }
    }

    public void processFactAttributes(Ta ta) throws IOException {
        LandscapeObject target = null;
        MsgOut.vprint("\nFACT ATTRIBUTES : ");
        int n = 0;
        while (!this.m_fatalError) {
            if (++n % 1000 == 0) {
                ta.showProgress("Attr Records: " + n);
            }
            this.m_startLineno = this.lineno();
            int ttype = this.nextToken();
            String msg = null;
            switch (ttype) {
                case -1: {
                    return;
                }
                case 40: {
                    EntityInstance dst;
                    EntityInstance src;
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected ( <class> src dst )";
                        break;
                    }
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected (" + token1 + " <src> dst)" + " not " + ttype;
                        break;
                    }
                    String token2 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected (" + token1 + " " + token2 + " <dst>)" + " not " + ttype;
                        break;
                    }
                    String token3 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 41) {
                        msg = "Expected (" + token1 + " " + token2 + " " + token3 + "<)>" + " not " + ttype;
                        break;
                    }
                    ttype = this.nextToken();
                    if (ttype != 123) {
                        msg = "Expected (...) <{> not " + ttype;
                        break;
                    }
                    RelationClass rc = ta.getRelationClass(token1);
                    if (rc == null && !Ta.m_strict_TA) {
                        rc = ta.addRelationClass(token1);
                    }
                    if ((src = this.m_entityCache.get(token2)) == null && !Ta.m_strict_TA) {
                        src = ta.newCachedEntity(ta.m_entityBaseClass, token2);
                    }
                    if ((dst = this.m_entityCache.get(token3)) == null && !Ta.m_strict_TA) {
                        dst = ta.newCachedEntity(ta.m_entityBaseClass, token3);
                    }
                    if (rc == null || src == null || dst == null) {
                        msg = "Strict TA: Relation (" + token1 + " " + token2 + " " + token3 + ")";
                        if (rc == null) {
                            msg = msg + " member of undeclared relation class '" + token1 + "'";
                        }
                        if (src == null) {
                            msg = msg + " has undeclared source entity '" + token2 + "'";
                        }
                        if (dst != null) break;
                        msg = msg + " has undeclared destination entity '" + token3 + "'";
                        break;
                    }
                    target = src.getRelationTo(rc, dst);
                    if (target != null) break;
                    if (Ta.m_strict_TA) {
                        msg = "Strict TA: Undeclared relation (" + token1 + " " + token2 + " " + token3 + ") has attributes";
                        break;
                    }
                    ta.addEdge(rc, src, dst);
                    target = src.getRelationTo(rc, dst);
                    break;
                }
                case -2: {
                    String token2;
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 123) {
                        if (ttype != -2) {
                            msg = "Expecting " + token1 + " <{>";
                            break;
                        }
                        token2 = this.m_sval;
                        ttype = this.nextToken();
                        if (ttype != 58) {
                            msg = "Expecting section header or id <{>";
                            break;
                        }
                        this.m_token1 = token1;
                        this.m_token2 = token2;
                        this.m_ttype3 = ttype;
                        return;
                    }
                    if (token1.equals("$ROOT")) {
                        target = ta.getRootInstance();
                        break;
                    }
                    target = this.m_entityCache.get(token1);
                    if (target != null) break;
                    if (Ta.m_strict_TA) {
                        msg = "Strict TA: Undeclared entity '" + token1 + "' has attributes";
                        break;
                    }
                    target = ta.newCachedEntity(ta.m_entityBaseClass, token1);
                    break;
                }
                default: {
                    msg = "Expecting object id";
                }
            }
            if (msg != null) {
                this.errorNS(msg);
                this.skipRecord();
                continue;
            }
            this.parseAttributes(target);
        }
    }
}

