/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import javax.swing.JComponent;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;

public abstract class LandscapeObject3D
extends LandscapeObject {
    private String m_id;
    private String m_description;
    private String m_label;
    private Color m_labelColor = null;
    private Color m_colorWhenOpen = null;

    public String toString() {
        String label = this.getLabel();
        if (label == null) {
            label = this.m_id;
        }
        return label;
    }

    public JComponent getSwingObject() {
        return null;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public boolean hasId(String id) {
        return this.m_id.equals(id);
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        if (description != null && description.length() == 0) {
            description = null;
        }
        this.m_description = description;
    }

    protected String getLabel() {
        return this.m_label;
    }

    protected void setLabel(String label) {
        JComponent swingObject = this.getSwingObject();
        this.m_label = label;
        if (swingObject != null) {
            swingObject.setToolTipText(label);
        }
    }

    @Override
    public Color getLabelColor() {
        return this.m_labelColor;
    }

    @Override
    public Color getInheritedLabelColor() {
        Color ret = this.getLabelColor();
        if (ret == null) {
            LandscapeClassObject superclass;
            int i = 0;
            while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getInheritedLabelColor()) == null) {
                ++i;
            }
        }
        return ret;
    }

    @Override
    public boolean setLabelColor(Color color) {
        this.m_labelColor = color;
        return true;
    }

    @Override
    public Color getSuperColorWhenOpen() {
        LandscapeClassObject superclass;
        Color ret = null;
        int i = 0;
        while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getInheritedColorWhenOpen()) == null) {
            ++i;
        }
        return ret;
    }

    @Override
    public Color getColorWhenOpen() {
        return this.m_colorWhenOpen;
    }

    @Override
    public Color getInheritedColorWhenOpen() {
        Color ret = this.getColorWhenOpen();
        if (ret == null) {
            ret = this.getSuperColorWhenOpen();
        }
        return ret;
    }

    @Override
    public void setColorWhenOpen(Color color) {
        this.m_colorWhenOpen = color;
    }

    @Override
    public boolean canEditAttribute(int index) {
        if (index == 0) {
            return false;
        }
        return super.canEditAttribute(index);
    }
}

