/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.AttributeCache;
import lsedit.Diagram;
import lsedit.LandscapeClassObject;
import lsedit.StringCache;
import lsedit.Ta;
import lsedit.Util;

public abstract class LandscapeObject {
    public static final String COLOR_ID = "color";
    public static final String LABEL_COLOR_ID = "labelcolor";
    public static final String OPEN_COLOR_ID = "opencolor";
    public static final String STYLE_ID = "style";
    public static final String ARROWCOLOR_ID = "arrowcolor";
    private static final int MAX_RGB = 255;
    public static LandscapeObject g_infoShown = null;
    private LandscapeClassObject m_parentClass;
    private Color m_objectColor = null;
    public Attribute[] m_attributes = null;
    protected static final String specialChars = "\n\t\f\r\u001b\u007f\\\" /,:(){}^<>=";

    public static String qt(String str) {
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < specialChars.length(); ++i) {
            if (str.indexOf(specialChars.charAt(i)) < 0) continue;
            if (i < 8) {
                String ret = "\"";
                int c = 0;
                for (i = 0; i < str.length(); ++i) {
                    c = str.charAt(i);
                    block0 : switch (c) {
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 27: 
                        case 34: 
                        case 92: 
                        case 127: {
                            ret = ret + '\\';
                            switch (c) {
                                case 10: {
                                    c = 110;
                                    break block0;
                                }
                                case 9: {
                                    c = 116;
                                    break block0;
                                }
                                case 12: {
                                    c = 102;
                                    break block0;
                                }
                                case 13: {
                                    c = 114;
                                    break block0;
                                }
                                case 27: {
                                    c = 101;
                                    break block0;
                                }
                                case 127: {
                                    c = 100;
                                }
                            }
                        }
                    }
                    ret = ret + (char)c;
                }
                return ret + '\"';
            }
            return "\"" + str + "\"";
        }
        return str;
    }

    public LandscapeClassObject getParentClass() {
        return this.m_parentClass;
    }

    public LandscapeClassObject derivedFrom(int i) {
        return i == 0 ? this.m_parentClass : null;
    }

    public void decrementClassMembers() {
        LandscapeClassObject pc = this.m_parentClass;
        if (pc != null) {
            pc.decrementMembers();
        }
    }

    public void incrementClassMembers() {
        LandscapeClassObject pc = this.m_parentClass;
        if (pc != null) {
            pc.incrementMembers();
        }
    }

    public void setParentClass(LandscapeClassObject parentClass) {
        this.decrementClassMembers();
        this.m_parentClass = parentClass;
        this.incrementClassMembers();
    }

    public Ta getTa() {
        return this.m_parentClass.getTa();
    }

    public Diagram getDiagram() {
        return this.m_parentClass.getDiagram();
    }

    public String getId() {
        return null;
    }

    public int getStyle() {
        return -1;
    }

    public void setStyle(int value) {
        System.out.println("Can't set style on " + this);
    }

    public int getInheritedStyle() {
        int ret = this.getStyle();
        if (ret < 0) {
            LandscapeClassObject superclass;
            int i = 0;
            while ((superclass = this.derivedFrom(i)) != null) {
                ret = superclass.getInheritedStyle();
                if (ret >= 0) {
                    return ret;
                }
                ++i;
            }
            return 0;
        }
        return ret;
    }

    public String getStyleName(int style) {
        return "";
    }

    public Color getSuperColorWhenOpen() {
        return null;
    }

    public Color getColorWhenOpen() {
        return null;
    }

    public Color getInheritedColorWhenOpen() {
        return null;
    }

    public void setColorWhenOpen(Color color) {
        System.out.println("Can't setColorWhenOpen(" + color + ") on " + this);
    }

    public Color getSuperObjectColor() {
        LandscapeClassObject superclass;
        Color ret = null;
        int i = 0;
        while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getInheritedObjectColor()) == null) {
            ++i;
        }
        return ret;
    }

    public Color getObjectColor() {
        return this.m_objectColor;
    }

    public void setObjectColor(Color color) {
        this.m_objectColor = color;
    }

    public Color getInheritedObjectColor() {
        Color ret = this.getObjectColor();
        if (ret == null) {
            ret = this.getSuperObjectColor();
        }
        return ret;
    }

    public Color getSuperLabelColor() {
        LandscapeClassObject superclass;
        Color ret = null;
        int i = 0;
        while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getInheritedLabelColor()) == null) {
            ++i;
        }
        return ret;
    }

    public Color getLabelColor() {
        Attribute attribute = this.getLsAttribute(LABEL_COLOR_ID);
        if (attribute != null) {
            return attribute.parseColor(this, LABEL_COLOR_ID);
        }
        return null;
    }

    public Color getInheritedLabelColor() {
        Color ret = this.getLabelColor();
        if (ret == null) {
            ret = this.getSuperLabelColor();
        }
        return ret;
    }

    public boolean setLabelColor(Color color) {
        return false;
    }

    public Color getSuperArrowColor() {
        LandscapeClassObject superclass;
        Color ret = null;
        int i = 0;
        while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getInheritedArrowColor()) == null) {
            ++i;
        }
        return ret;
    }

    public Color getArrowColor() {
        Attribute attribute = this.getLsAttribute(ARROWCOLOR_ID);
        if (attribute != null) {
            return attribute.parseColor(this, ARROWCOLOR_ID);
        }
        return null;
    }

    public Color getInheritedArrowColor() {
        Color ret = this.getArrowColor();
        if (ret == null) {
            ret = this.getSuperArrowColor();
        }
        return ret;
    }

    public Color getSuperColor(String id) {
        if (id.equals(COLOR_ID)) {
            return this.getSuperObjectColor();
        }
        if (id.equals(LABEL_COLOR_ID)) {
            return this.getSuperLabelColor();
        }
        if (id.equals(OPEN_COLOR_ID)) {
            return this.getSuperColorWhenOpen();
        }
        if (id.equals(ARROWCOLOR_ID)) {
            return this.getSuperArrowColor();
        }
        return null;
    }

    public int getAttributesLength() {
        Attribute[] attributes = this.m_attributes;
        if (attributes == null) {
            return 0;
        }
        return attributes.length;
    }

    public int getLsAttributesSize() {
        int ret = 0;
        Attribute[] attributes = this.m_attributes;
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (attribute == null) continue;
                ++ret;
            }
        }
        return ret;
    }

    public Attribute getLsAttribute(String id) {
        Attribute[] attributes = this.m_attributes;
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (attribute == null || !id.equals(attribute.m_id)) continue;
                return attribute;
            }
        }
        return null;
    }

    public Attribute getLsAttributeAt(int index) {
        Attribute[] attributes = this.m_attributes;
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (attribute == null) continue;
                if (index == 0) {
                    return attribute;
                }
                --index;
            }
        }
        return null;
    }

    public int countAttributes() {
        Attribute[] attributes = this.m_attributes;
        int ret = 0;
        if (attributes != null) {
            int length = attributes.length;
            for (int i = 0; i < length; ++i) {
                if (attributes[i] == null) continue;
                ++ret;
            }
        }
        return ret;
    }

    public void maxAttributes(int max) {
        Attribute[] oldAttributes = this.m_attributes;
        Attribute[] attributes = new Attribute[max];
        if (oldAttributes != null) {
            for (Attribute attributes[i] : oldAttributes) {
            }
            oldAttributes = null;
        }
        this.m_attributes = attributes;
    }

    public void putAttribute(String id, String value) {
        int free;
        Attribute[] attributes = this.m_attributes;
        if (attributes == null) {
            this.m_attributes = attributes = new Attribute[1];
        }
        int length = free = attributes.length;
        for (int i = 0; i < length; ++i) {
            Attribute attribute = attributes[i];
            if (attribute == null) {
                if (free <= i) continue;
                free = i;
                continue;
            }
            if (!id.equals(attribute.m_id)) continue;
            String oldValue = attribute.externalString();
            if (value == null ? oldValue == null : value.equals(oldValue)) {
                return;
            }
            free = i;
            break;
        }
        if (free == length) {
            this.maxAttributes(free + 1);
            attributes = this.m_attributes;
        }
        attributes[free] = AttributeCache.get(id, value);
    }

    public boolean processFirstOrder(String id, String value) {
        if (id.equals(COLOR_ID)) {
            this.setObjectColor(Attribute.parseColorValue(value, this, COLOR_ID));
            return true;
        }
        if (id.equals(LABEL_COLOR_ID)) {
            return this.setLabelColor(Attribute.parseColorValue(value, this, LABEL_COLOR_ID));
        }
        if (id.equals(OPEN_COLOR_ID)) {
            this.setColorWhenOpen(Attribute.parseColorValue(value, this, OPEN_COLOR_ID));
            return true;
        }
        return false;
    }

    public void addAttribute(String id, String value) {
        if (this.processFirstOrder(id, value)) {
            return;
        }
        this.putAttribute(id, value);
    }

    public void addAttribute(String id, int ivalue) {
        String value = StringCache.get(String.valueOf(ivalue));
        this.addAttribute(id, value);
    }

    public void addAttribute(String id, boolean bvalue) {
        String value = bvalue ? "true" : "false";
        this.addAttribute(id, value);
    }

    public void addAttribute(String id, String value, Vector v) {
        if (this.processFirstOrder(id, value)) {
            return;
        }
        v.add(AttributeCache.get(id, value));
    }

    public void addAttributes(Vector newAttributes) {
        int size = newAttributes.size();
        if (size != 0) {
            int max = this.countAttributes() + size;
            this.maxAttributes(max);
            Attribute[] attributes = this.m_attributes;
            int length = attributes.length;
            for (int i = 0; i < size; ++i) {
                int free = length;
                Attribute newAttribute = (Attribute)newAttributes.elementAt(i);
                if (newAttribute == null) continue;
                String id = newAttribute.m_id;
                for (int j = 0; j < length; ++j) {
                    Attribute oldAttribute = attributes[j];
                    if (oldAttribute == null) {
                        if (free <= j) continue;
                        free = j;
                        continue;
                    }
                    if (!id.equals(oldAttribute.m_id)) continue;
                    free = j;
                    break;
                }
                attributes[free] = newAttribute;
            }
        }
    }

    public String writeColorAttributes(PrintWriter ps, String nodeId, LandscapeObject parentClass) {
        Color color1;
        Color color = this.getObjectColor();
        if (color != null && !color.equals(color1 = parentClass != null ? parentClass.getInheritedObjectColor() : null)) {
            nodeId = LandscapeObject.writeAttribute(ps, nodeId, COLOR_ID, Util.taColor(color));
        }
        if ((color = this.getLabelColor()) != null && !color.equals(color1 = parentClass != null ? parentClass.getInheritedLabelColor() : null)) {
            nodeId = LandscapeObject.writeAttribute(ps, nodeId, LABEL_COLOR_ID, Util.taColor(color));
        }
        if ((color = this.getColorWhenOpen()) != null && !color.equals(color1 = parentClass != null ? parentClass.getInheritedColorWhenOpen() : null)) {
            nodeId = LandscapeObject.writeAttribute(ps, nodeId, OPEN_COLOR_ID, Util.taColor(color));
        }
        return nodeId;
    }

    public static String writeAttribute(PrintWriter ps, String nodeId, String label, String value) {
        if (nodeId != null) {
            ps.println(nodeId + "{");
            nodeId = null;
        }
        if (value == null) {
            ps.println(" " + label);
        } else {
            ps.println(" " + label + " = " + value);
        }
        return nodeId;
    }

    public static String writeAttribute(PrintWriter ps, String nodeId, String label, short value) {
        return LandscapeObject.writeAttribute(ps, nodeId, label, "" + value);
    }

    public static String writeAttribute(PrintWriter ps, String nodeId, String label, int value) {
        return LandscapeObject.writeAttribute(ps, nodeId, label, "" + value);
    }

    public static String writeAttribute(PrintWriter ps, String nodeId, String label, double value) {
        return LandscapeObject.writeAttribute(ps, nodeId, label, "" + value);
    }

    public String writeAttributes(PrintWriter ps, String nodeId, LandscapeObject parentClass, boolean classType) {
        nodeId = this.writeColorAttributes(ps, nodeId, parentClass);
        Attribute[] attributes = this.m_attributes;
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (attribute == null) continue;
                nodeId = attribute.writeAttribute(ps, nodeId, parentClass, classType);
            }
        }
        return nodeId;
    }

    public int getPrimaryAttributeCount() {
        return 0;
    }

    public int getLsAttributeCount() {
        return this.getPrimaryAttributeCount() + this.getLsAttributesSize() + 1;
    }

    public boolean canEditName(int index) {
        int primary = this.getPrimaryAttributeCount();
        return index >= primary;
    }

    public boolean canEditAttribute(int index) {
        int primary = this.getPrimaryAttributeCount();
        if (index < primary) {
            return true;
        }
        return (index -= primary) < this.getLsAttributesSize();
    }

    public String getLsAttributeNameAt(int index) {
        if ((index -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attr = this.getLsAttributeAt(index);
        if (attr == null) {
            return null;
        }
        return attr.m_id;
    }

    public Object getLsAttributeValueAt(int index) {
        if ((index -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attr = this.getLsAttributeAt(index);
        if (attr == null) {
            return null;
        }
        String ret = attr.parseString();
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public boolean unknownAttributeName(String name) {
        String name1;
        int i = 0;
        while ((name1 = this.getLsAttributeNameAt(i)) != null) {
            if (name.equals(name1)) {
                System.out.println("Can't rename generic attribute to '" + name + "': attribute already exists");
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setAttributeName(String oldName, String newName) {
        String value = null;
        Attribute[] attributes = this.m_attributes;
        if (attributes != null && oldName != null) {
            for (Attribute attribute : attributes) {
                if (attribute == null || !oldName.equals(attribute.m_id)) continue;
                value = attribute.externalString();
                attributes[i] = null;
                break;
            }
        }
        if (newName != null) {
            this.addAttribute(newName, value);
        }
    }

    public int getLsAttributeTypeAt(int index) {
        if (index < this.getLsAttributeCount() - 1) {
            return 11;
        }
        return 0;
    }

    public int getLsAttributeOffset(String id) {
        int i = 0;
        String name;
        while ((name = this.getLsAttributeNameAt(i)) != null) {
            if (name.equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean defaultValue(String id, Object object) {
        Object object1;
        int i;
        return object != null && (i = this.getLsAttributeOffset(id)) >= 0 && object.equals(object1 = this.getLsAttributeValueAt(i));
    }
}

