/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public abstract class LandscapeLayouter
implements ToolBarEventHandler {
    protected LandscapeEditorCore m_ls;
    protected LandscapeLayouter m_fallback;

    protected EntityInstance parentOfSet(Vector set) {
        EntityInstance parent = null;
        Enumeration en = set.elements();
        while (en.hasMoreElements()) {
            EntityInstance e = (EntityInstance)en.nextElement();
            EntityInstance parent1 = e.getContainedBy();
            if (parent == null) {
                parent = parent1;
                continue;
            }
            if (parent == parent1) continue;
            parent = null;
            break;
        }
        return parent;
    }

    public LandscapeLayouter(LandscapeEditorCore ls, LandscapeLayouter fallback) {
        this.m_ls = ls;
        this.m_fallback = fallback;
    }

    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    public LandscapeLayouter getFallback() {
        return this.m_fallback;
    }

    public String undoLabel() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            return "No diagram";
        }
        if (diagram.undoEnabled()) {
            return "Disable undo";
        }
        return "Enable undo";
    }

    public boolean ok() {
        return false;
    }

    public String allInDiagram(Vector selectedBoxes) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            Util.beep();
            return "Can't layout: No diagram";
        }
        int i = selectedBoxes.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)selectedBoxes.elementAt(i);
            if (e.isMarked(1)) continue;
            Util.beep();
            return "Attempting to layout things not in diagram";
        }
        return null;
    }

    abstract String getName();

    abstract String getMenuLabel();

    abstract boolean doLayout1(Vector var1, EntityInstance var2);

    public abstract String doLayout(Diagram var1);

    public String getTag() {
        return "xxx:";
    }

    public void reset() {
    }

    public void loadLayoutOption(int mode, String attribute, String value) {
    }

    public void saveLayoutOptions(int mode, PrintWriter ps) {
    }

    public boolean configure(LandscapeEditorCore ls) {
        return false;
    }

    public boolean isConfigurable() {
        return false;
    }

    public boolean isLayouter() {
        return true;
    }

    @Override
    public boolean processMetaKeyEvent(String name) {
        return this.m_ls.processMetaKeyEvent(name);
    }

    public void actionPerformed(ActionEvent ev) {
    }

    @Override
    public void showInfo(String msg) {
    }
}

