/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import lsedit.LandscapeEditorCore;
import lsedit.MsgOut;
import lsedit.SpecialPath;
import lsedit.Ta;
import lsedit.Util;

public class LandscapeEditorFrame
extends JFrame
implements WindowListener {
    protected static final int MAX_WIDTH = 1280;
    protected static final int MAX_HEIGHT = 1024;
    protected static String m_title = LandscapeEditorCore.getTitle();
    protected static boolean m_landscapeGeo = false;
    protected static int m_frameWidth = 0;
    protected static int m_frameHeight = 0;
    protected static int m_diagramPercentWidth = 0;
    protected static int m_diagramPercentHeight = 0;
    protected LandscapeEditorCore m_app = new LandscapeEditorCore(this, this.getSpecialPath());

    public SpecialPath getSpecialPath() {
        return null;
    }

    public void setDebugOn() {
        MsgOut.setDebugFlag(true);
        MsgOut.dprintln("Start app: ");
    }

    public void setVerboseOn() {
        MsgOut.setVerboseFlag(true);
    }

    public void setLandscapeGeo() {
        m_landscapeGeo = true;
    }

    public boolean setFrameDimension(int width, int height) {
        if (width > 0 && height > 0) {
            m_frameWidth = width;
            m_frameHeight = height;
            return true;
        }
        return false;
    }

    public boolean setForward(String value) {
        int size;
        try {
            size = Util.parseInt(value);
        }
        catch (Exception e) {
            return false;
        }
        this.m_app.setForward(size);
        return true;
    }

    public boolean setFrameDimension(String geo) {
        int ind = geo.indexOf(120);
        if (ind > 0) {
            try {
                int w = Util.parseInt(geo.substring(0, ind));
                int h = Util.parseInt(geo.substring(ind + 1));
                return this.setFrameDimension(w, h);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean setDiagramPercent(int width, int height) {
        if (width > 0 && width <= 100 && height > 0 && height <= 100) {
            m_diagramPercentWidth = width;
            m_diagramPercentHeight = height;
            return true;
        }
        return false;
    }

    public boolean setDiagramPercent(String geo) {
        int ind = geo.indexOf(120);
        if (ind > 0) {
            try {
                int w = Util.parseInt(geo.substring(0, ind));
                int h = Util.parseInt(geo.substring(ind + 1));
                return this.setDiagramPercent(w, h);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean setHandicapped(String fontsize) {
        int size;
        try {
            size = Util.parseInt(fontsize);
        }
        catch (Exception e) {
            return false;
        }
        if (size > 0) {
            this.m_app.setHandicapped(size);
        }
        return true;
    }

    public void setLsPath(String file) {
        this.m_app.setLsPath(file);
    }

    public static void usage() {
        System.out.println("\nLandscape Editor 7.4.0\n");
        System.out.println("<executor> LandscapeEditorFrame [options] <HTTP or file path>\n");
        System.out.println("-h\t               This message");
        System.out.println("-?\t               This message");
        System.out.println("-b fontsize        Use larger fonts than normal");
        System.out.println("-d                 Debugging output");
        System.out.println("-v\t               Verbose parsing output");
        System.out.println("-s\t\t\t\t   Enforce strict semantics when reading TA");
        System.out.println("");
        System.out.println("-g<width>x<height> Geometry of editor");
        System.out.println("-G<width>x<height> Geometry of diagram");
        System.out.println("");
        System.out.println("-l \"matrix\"      Use the matrix layout algorithm in any initial layout");
        System.out.println("-l \"simplex\"     Use the network simplex layout algorithm in any initial layout");
        System.out.println("-l \"sugiyama\"    Use the sugiyama layout algorithm in any initial layout");
        System.out.println("-l \"spring\"      Use the spring layout algorithm in any initial layout");
        System.out.println("-l \"old spring\"  Use the old spring layout algorithm in any initial layout");
        System.out.println("-l \"lisp\"        Use the lisp layout algorithm in any initial layout");
        System.out.println("-N <entity>        Open the landscape with the named entity as the draw root");
        System.out.println("-f <steps>         Forward path from <entity> n steps");
        System.out.println("-i <inifile>       Use this init file");
        System.out.println("-L\t               Start with landscape geometry");
        System.out.println("-V\t               Start in viewer mode");
        System.out.println("");
        System.out.println("-P <save path>     Optional save path");
        System.out.println("-S <path suffix>   Optional save suffix");
        System.out.println("-T <frame title>   Optional frame title");
        System.out.println("-X <application>   Optional application to exec on save");
        System.out.println("");
    }

    public boolean setOptions(String[] args) {
        String option;
        int lth;
        char c;
        int n;
        boolean ok = true;
        for (n = 0; n < args.length && args[n].charAt(0) == '-'; ++n) {
            c = args[n].charAt(1);
            switch (c) {
                case '?': 
                case 'h': {
                    return false;
                }
            }
        }
        block24: for (n = 0; n < args.length && (lth = (option = args[n]).length()) >= 2 && option.charAt(0) == '-'; ++n) {
            c = option.charAt(1);
            switch (c) {
                case 'd': {
                    this.setDebugOn();
                    continue block24;
                }
                case '?': 
                case 'h': {
                    ok = false;
                    continue block24;
                }
                case 'v': {
                    this.setVerboseOn();
                    continue block24;
                }
                case 'L': {
                    this.setLandscapeGeo();
                    continue block24;
                }
                case 's': {
                    Ta.m_strict_TA = true;
                    continue block24;
                }
                default: {
                    String value;
                    if (lth > 2) {
                        value = option.substring(2);
                    } else {
                        if (++n >= args.length) {
                            System.out.println("Option " + option + " missing argument");
                            ok = false;
                            break block24;
                        }
                        value = args[n];
                    }
                    switch (c) {
                        case 'b': {
                            if (this.setHandicapped(value)) continue block24;
                            System.out.println("Invalid use of -b");
                            ok = false;
                            continue block24;
                        }
                        case 'f': {
                            if (this.setForward(value)) continue block24;
                            System.out.println("Illegal -f option [ignored]");
                            ok = false;
                            continue block24;
                        }
                        case 'g': {
                            if (this.setFrameDimension(value)) continue block24;
                            System.out.println("Illegal -g option [ignored]");
                            ok = false;
                            continue block24;
                        }
                        case 'G': {
                            if (this.setDiagramPercent(value)) continue block24;
                            System.out.println("Illegal -G option [must be percentages]");
                            ok = false;
                            continue block24;
                        }
                        case 'i': {
                            this.m_app.m_lsInit = value;
                            continue block24;
                        }
                        case 'l': {
                            this.m_app.defaultToLayouter(value);
                            continue block24;
                        }
                        case 'N': {
                            this.m_app.setStartEntity(value);
                            continue block24;
                        }
                        case 'P': {
                            this.m_app.m_lsSavePath = value;
                            continue block24;
                        }
                        case 'S': {
                            this.m_app.m_lsSaveSuffix = value;
                            continue block24;
                        }
                        case 'T': {
                            m_title = value;
                            continue block24;
                        }
                        case 'X': {
                            this.m_app.m_lsSaveCmd = value;
                            continue block24;
                        }
                        default: {
                            ok = false;
                        }
                    }
                }
            }
        }
        while (n < args.length) {
            this.setLsPath(args[n++]);
        }
        return ok;
    }

    public void launch(String[] args) {
        if (args != null && !this.setOptions(args)) {
            LandscapeEditorFrame.usage();
            System.exit(0);
        }
        if (m_frameWidth <= 0 || m_frameHeight <= 0) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dim = tk.getScreenSize();
            double f = 0.75;
            if (m_landscapeGeo) {
                m_frameWidth = Math.min(1280, dim.width);
                m_frameHeight = Math.min(1024, dim.height);
            } else {
                m_frameWidth = (int)((double)dim.width / f);
                m_frameHeight = dim.height - 50;
            }
            m_frameWidth = Math.min(m_frameWidth, dim.width);
            m_frameHeight = Math.min(m_frameHeight, dim.height);
        }
        this.setBounds(0, 0, m_frameWidth, m_frameHeight);
        LandscapeEditorCore app = this.m_app;
        this.setTitle(m_title);
        this.setVisible(true);
        JMenuBar mb = app.genMenu();
        this.setJMenuBar(mb);
        app.init_core(m_diagramPercentWidth, m_diagramPercentHeight);
        this.addWindowListener(this);
        this.setBackground(Color.lightGray);
        this.setVisible(true);
    }

    public static LandscapeEditorFrame create() {
        return new LandscapeEditorFrame();
    }

    public static void main(String[] args) {
        LandscapeEditorFrame af = LandscapeEditorFrame.create();
        af.launch(args);
        MsgOut.dprintln("exit main");
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        if (this.m_app != null) {
            this.m_app.testForClose(true);
        }
        this.removeWindowListener(this);
        Runtime.getRuntime().exit(0);
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }
}

