/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeBox;
import lsedit.BrowserLauncher;
import lsedit.Cardinal;
import lsedit.ClientSupplierSet;
import lsedit.ClipboardBox;
import lsedit.DefaultBrowserButton;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.ERBox;
import lsedit.EditAttribute;
import lsedit.EditElisions;
import lsedit.EditModeHandler;
import lsedit.Elision_CS_Button;
import lsedit.Elision_CU_Button;
import lsedit.Elision_I_Button;
import lsedit.Elision_c_Button;
import lsedit.Elision_s_Button;
import lsedit.Elision_u_Button;
import lsedit.EntityClass;
import lsedit.EntityComponent;
import lsedit.EntityInstance;
import lsedit.ExecuteAction;
import lsedit.Feedback;
import lsedit.Find;
import lsedit.FindBox;
import lsedit.FindNext_Button;
import lsedit.FindPrev_Button;
import lsedit.FindRules;
import lsedit.Find_Button;
import lsedit.FontBiggerButton;
import lsedit.FontCache;
import lsedit.FontChooser;
import lsedit.FontSmallerButton;
import lsedit.HistoryBox;
import lsedit.HistoryNext_Button;
import lsedit.HistoryPrev_Button;
import lsedit.IconCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorFrame;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeObject;
import lsedit.LegendBox;
import lsedit.LoadLsSwingWorker;
import lsedit.MapBox;
import lsedit.MsgOut;
import lsedit.MyHistoryMenuItem;
import lsedit.MyWindowsMenuItem;
import lsedit.Option;
import lsedit.Options;
import lsedit.OptionsDialog;
import lsedit.QueryBox;
import lsedit.Query_C_Button;
import lsedit.Query_Clear_Button;
import lsedit.Query_b_Button;
import lsedit.Query_f_Button;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.RelationLabel;
import lsedit.ResultBox;
import lsedit.RightTabbedPane;
import lsedit.SortVector;
import lsedit.SpecialPath;
import lsedit.Ta;
import lsedit.TaFeedback;
import lsedit.TaListener;
import lsedit.TextBox;
import lsedit.TocBox;
import lsedit.ToolBarButton;
import lsedit.ToolBarEventHandler;
import lsedit.UndoBox;
import lsedit.UndoListener;
import lsedit.Util;
import lsedit.Version;
import lsedit.ViewBox;
import lsedit.Vista;

public final class LandscapeEditorCore
extends Do
implements TaListener,
UndoListener,
TaFeedback,
ToolBarEventHandler {
    protected static final int GRID_MAX = 100;
    protected static final int GAP = 4;
    protected static final String TITLE = "Software Landscape Editor";
    public static final int FA_LOAD = 0;
    public static final int FA_LOAD_DIR = 1;
    public static final int FA_SAVE = 2;
    protected EditModeHandler m_editModeHandler;
    public String m_aboutURL = "http://www.swag.uwaterloo.ca";
    public String m_helpURL = "http://www.swag.uwaterloo.ca/lsedit";
    public String m_startParam = null;
    public String m_startEntity = null;
    public String m_lsPath = null;
    public String m_lsInit = null;
    protected JFrame m_frame = null;
    protected URL m_documentBase = null;
    protected AppletContext m_ac = null;
    protected static final String m_leftTextBoxHelp = "Displays the 'description' for the current landscape.";
    protected static final String m_rightTextBoxHelp = "Displays the 'description' for the closed (not a container) entity currently under the mouse cursor.";
    protected static final String m_feedbackHelp = "Displays feedback from the program. Examples include errors, warnings, and confirmations of action.";
    protected static final String m_nameBoxHelp = "Displays the landscape entity, edge, or application button/box currently under the mouse cursor.";
    protected static double m_mainSplitRatio = 0.8;
    protected static double m_secondSplitRatio = 0.1;
    protected static double m_thirdSplitRatio = 0.5;
    protected static String m_browser = null;
    protected static JMenuBar m_menuBar;
    protected static JMenu m_fileMenu;
    protected static JMenu m_windowsMenu;
    protected static int m_openFrames;
    protected Container m_contentPane;
    protected JToolBar m_toolBar = null;
    protected JSplitPane m_infoSplitPane = null;
    protected JSplitPane m_infoDiagramSplitPane = null;
    protected JSplitPane m_diagramTabSplitPane = null;
    protected JScrollPane m_scrollLeftTextBox = null;
    protected JPanel m_leftInfoPanel = null;
    protected JPanel m_rightInfoPanel = null;
    protected JLabel m_leftTextBoxTitle = null;
    protected TextBox m_leftTextBox = null;
    protected JScrollPane m_scrollRightTextBox = null;
    protected JLabel m_rightTextBoxTitle = null;
    protected TextBox m_rightTextBox = null;
    protected Feedback m_feedback = null;
    protected Feedback m_nameBox = null;
    public JScrollPane m_scrollDiagram = null;
    protected Diagram m_diagram = null;
    protected RightTabbedPane m_rightTabbedPane = null;
    protected LegendBox m_legendBox = null;
    protected MapBox m_mapBox = null;
    protected QueryBox m_queryBox = null;
    protected ResultBox m_resultBox = null;
    protected TocBox m_tocBox = null;
    protected UndoBox m_undoBox = null;
    protected HistoryBox m_historyBox = null;
    protected ClipboardBox m_clipboardBox = null;
    protected AttributeBox m_attributeBox = null;
    protected ViewBox m_viewBox = null;
    protected EntityInstance m_currentNameEntity = null;
    protected String m_lsSavePath;
    protected String m_lsSaveSuffix;
    protected String m_lsSaveCmd;
    protected int m_handicapped = 0;
    protected int m_forward = -1;
    protected EntityInstance m_forwardEntity = null;
    protected int mode = 0;
    protected boolean modeHandlingActive = false;
    protected RelationInstance m_currentEdge = null;
    protected EntityInstance m_currentDescEntity = null;
    protected Find m_findResults = null;
    private int m_curCursor = 0;
    protected JApplet m_applet = null;
    protected static int PREV_HISTORY_BUTTON;
    protected static int NEXT_HISTORY_BUTTON;
    protected static int PREV_FIND_BUTTON;
    protected static int NEXT_FIND_BUTTON;
    protected ToolBarButton[] m_toolButton;
    protected SpecialPath m_specialPath = null;
    static int[] g_showSourceKeys;
    protected static final String indAdd = "  ";

    public boolean isSpecialPath(String path) {
        if (this.m_specialPath == null) {
            return false;
        }
        return this.m_specialPath.isSpecialPath(path);
    }

    public String parseSpecialPath(Ta ta, String path) {
        return this.m_specialPath.parseSpecialPath(ta, this.m_resultBox, path);
    }

    public void specialPathOptions(Option option) {
        this.m_specialPath.specialPathOptions(option);
    }

    public void add(JComponent c) {
        this.m_contentPane.add(c);
    }

    public void repaint() {
        this.m_contentPane.repaint();
    }

    public void validate() {
        this.m_contentPane.validate();
    }

    public void requestFocus() {
        this.m_contentPane.requestFocus();
    }

    public Graphics getGraphics() {
        return this.m_contentPane.getGraphics();
    }

    public int getHeight() {
        return this.m_contentPane.getHeight();
    }

    public boolean isApplet() {
        return this.m_applet != null;
    }

    public String getStartEntity() {
        return this.m_startEntity;
    }

    public void setStartEntity(String entityName) {
        this.m_startParam = entityName;
        this.m_startEntity = entityName;
    }

    public String parameterDetails() {
        LandscapeLayouter layout;
        String ret = "\n";
        if (this.m_aboutURL != null) {
            ret = ret + "toolabout=\"" + this.m_aboutURL + "\"\n";
        }
        if (this.m_helpURL != null) {
            ret = ret + "toolhelp=\"" + this.m_helpURL + "\"\n";
        }
        if (this.m_lsPath != null) {
            ret = ret + "lsfile=\"" + this.m_lsPath + "\"\n";
        }
        if (this.m_startParam != null) {
            ret = ret + "startEntity=\"" + this.m_startParam + "\"\n";
        }
        if (this.m_lsInit != null) {
            ret = ret + "init=\"" + this.m_lsInit + "\"\n";
        }
        if ((layout = this.getLayouter()) != null) {
            ret = ret + "layout=\"" + layout.getName() + "\"\n";
        }
        return ret;
    }

    public boolean isAddToClipboard() {
        return this.m_clipboardBox.isAddToClipboard();
    }

    protected void createFileMenu() {
        JMenu m;
        m_fileMenu = m = new JMenu("File");
        LandscapeEditorCore.fileMenuItem(m, this, this.isApplet());
        m.addSeparator();
    }

    public LandscapeEditorCore(JFrame frame, SpecialPath specialPath) {
        this.m_frame = frame;
        this.m_specialPath = specialPath;
        this.m_contentPane = frame.getContentPane();
        this.createFileMenu();
    }

    public LandscapeEditorCore(JApplet applet, SpecialPath specialPath) {
        this.m_applet = applet;
        this.m_specialPath = specialPath;
        this.m_documentBase = applet.getDocumentBase();
        this.m_contentPane = applet.getContentPane();
        this.createFileMenu();
    }

    public static String getTitle() {
        return TITLE;
    }

    public EditModeHandler getModeHandler() {
        return this.m_editModeHandler;
    }

    public URL getDocumentBase() {
        return this.m_documentBase;
    }

    protected void repaintTabs() {
        if (this.m_rightTabbedPane != null) {
            this.m_rightTabbedPane.revalidate();
        }
    }

    protected static String canonicalPath(String lseditFile) {
        String path;
        try {
            File file = new File(lseditFile);
            path = file.getCanonicalPath();
        }
        catch (Exception e) {
            path = lseditFile;
        }
        return path;
    }

    protected String defaultIniFile() {
        if (this.m_lsInit == null) {
            String os;
            String file = this.isApplet() ? "http:lsedit.ini" : ((os = Version.Detail("os.name")) != null && os.startsWith("Windows") ? "lsedit.ini" : ".lsedit");
            this.m_lsInit = file;
        }
        return this.m_lsInit;
    }

    protected String defaultIniDir() {
        if (this.isApplet()) {
            return ".";
        }
        return Version.Detail("user.home");
    }

    protected String defaultIniPath() {
        return Util.formFileName(this.defaultIniDir(), this.defaultIniFile());
    }

    protected void addLseditHistory(String lseditPath) {
        String path = LandscapeEditorCore.canonicalPath(lseditPath);
        int cnt = m_fileMenu.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            JMenuItem item = m_fileMenu.getItem(i);
            if (!(item instanceof MyHistoryMenuItem) || !((MyHistoryMenuItem)item).isPath(path)) continue;
            return;
        }
        new MyHistoryMenuItem(m_fileMenu, path, this);
    }

    private static void reportException(Throwable e) {
        while (e != null) {
            System.out.println(e.toString() + ": " + e.getMessage());
            e = e.getCause();
        }
    }

    protected void loadLseditHistory(JMenu m, String file) {
        LandscapeLayouter layouter;
        int i;
        Option defaultOptions = Options.getDefaultOptions();
        Option landscapeOptions = Options.getLandscapeOptions();
        Option diagramOptions = Options.getDiagramOptions();
        Option options = null;
        int mode = -2;
        defaultOptions.reset();
        landscapeOptions.reset();
        diagramOptions.reset();
        for (i = 0; i < this.m_layouters.length; ++i) {
            layouter = this.m_layouters[i];
            layouter.reset();
        }
        try {
            String line;
            BufferedReader bufferedReader;
            if (this.isApplet()) {
                if (file == null) {
                    file = this.defaultIniFile();
                }
            } else if (file == null) {
                String userHome = this.defaultIniDir();
                if (userHome == null || userHome == "") {
                    System.out.println("Can't load state: Unknown home directory");
                    return;
                }
                file = this.defaultIniPath();
            }
            if (file == null || file.length() == 0) {
                System.out.println("Can't load state: no filename");
                return;
            }
            if (file.startsWith("http:")) {
                URL url = this.isApplet() ? new URL(this.m_documentBase, file) : new URL(file);
                file = url.toString();
                URLConnection conn = url.openConnection();
                InputStream is = conn.getInputStream();
                InputStreamReader reader = new InputStreamReader(is);
                bufferedReader = new BufferedReader(reader);
            } else {
                FileReader fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
            }
            System.out.println("Load state from " + file);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals("GENERAL:")) {
                    mode = -1;
                    continue;
                }
                if (line.equals("DEFAULTS:")) {
                    options = defaultOptions;
                    mode = 0;
                    continue;
                }
                if (line.equals("USER:")) {
                    landscapeOptions.setTo(defaultOptions);
                    options = landscapeOptions;
                    mode = 1;
                    continue;
                }
                if (line.equals("DIAGRAM:")) {
                    options = diagramOptions;
                    mode = 2;
                    continue;
                }
                if (mode < -1 || (i = line.indexOf(61)) < 0 || line.length() == i + 1) continue;
                String attribute = line.substring(0, i);
                attribute = attribute.trim();
                String value = line.substring(i + 1);
                value = value.trim();
                if (attribute.equals("browser")) {
                    m_browser = value;
                    continue;
                }
                if (attribute.startsWith("execute:")) {
                    ExecuteAction.loadIni(attribute, value);
                    continue;
                }
                for (i = 0; i < this.m_layouters.length; ++i) {
                    layouter = this.m_layouters[i];
                    if (!attribute.startsWith(layouter.getTag())) continue;
                    layouter.loadLayoutOption(mode, attribute, value);
                    break;
                }
                if (attribute.equals("menu")) {
                    this.addLseditHistory(value);
                    continue;
                }
                if (options == null) continue;
                options.loadOption(attribute, value);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            System.out.println("Exception reading \"" + file + "\"");
            LandscapeEditorCore.reportException(e);
            return;
        }
    }

    public void saveLseditHistory() {
        if (this.isApplet()) {
            return;
        }
        String file = "";
        try {
            String userHome = this.defaultIniDir();
            if (userHome == null) {
                System.out.println("Can't save state: don't know location of $HOME");
            } else {
                LandscapeLayouter layouter;
                int i;
                file = this.defaultIniPath();
                System.out.println("Saving state in " + file);
                Option defaultOptions = Options.getDefaultOptions();
                Option landscapeOptions = Options.getLandscapeOptions();
                Option diagramOptions = Options.getDiagramOptions();
                FileOutputStream os = new FileOutputStream(file);
                PrintWriter ps = new PrintWriter(os);
                ps.println("GENERAL:");
                ps.println("");
                int cnt = m_fileMenu.getItemCount();
                for (i = 0; i < cnt; ++i) {
                    JMenuItem item = m_fileMenu.getItem(i);
                    if (!(item instanceof MyHistoryMenuItem)) continue;
                    String path = ((MyHistoryMenuItem)item).getPath();
                    ps.println("menu=" + path);
                }
                String browser = m_browser;
                if (browser != null) {
                    ps.println("browser=" + browser);
                }
                ExecuteAction.saveOptions(ps);
                ps.println("");
                ps.println("DEFAULTS:");
                ps.println("");
                defaultOptions.saveOptions(ps, false);
                for (i = 0; i < this.m_layouters.length; ++i) {
                    layouter = this.m_layouters[i];
                    layouter.saveLayoutOptions(0, ps);
                }
                ps.println("");
                ps.println("USER:");
                ps.println("");
                landscapeOptions.saveOptions(ps, false);
                for (i = 0; i < this.m_layouters.length; ++i) {
                    layouter = this.m_layouters[i];
                    layouter.saveLayoutOptions(1, ps);
                }
                ps.println("");
                ps.println("DIAGRAM:");
                ps.println("");
                diagramOptions.saveOptions(ps, false);
                if (ps.checkError()) {
                    System.out.println("Print error occured when attempting to save history in " + file);
                }
                ps.close();
            }
        }
        catch (Exception e) {
            System.out.println("Exception  " + e.getMessage() + " caught when attempting to save history in " + file);
        }
    }

    public void removeHistoryMenu(MyHistoryMenuItem item) {
        m_fileMenu.remove(item);
    }

    public void removeHistory() {
        int cnt;
        int i = cnt = m_fileMenu.getItemCount();
        while (i > 0) {
            JMenuItem item;
            if (!((item = m_fileMenu.getItem(--i)) instanceof MyHistoryMenuItem)) continue;
            this.removeHistoryMenu((MyHistoryMenuItem)item);
        }
    }

    protected void rememberDiagram(Diagram newDg, String path) {
        int cnt = m_windowsMenu.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            JMenuItem item = m_windowsMenu.getItem(i);
            if (!(item instanceof MyWindowsMenuItem) || !((MyWindowsMenuItem)item).isDiagram(newDg)) continue;
            return;
        }
        new MyWindowsMenuItem(m_windowsMenu, newDg, path, this);
    }

    protected void changeDiagramPath(String path) {
        int cnt = m_windowsMenu.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            JMenuItem item = m_windowsMenu.getItem(i);
            if (!(item instanceof MyWindowsMenuItem) || !((MyWindowsMenuItem)item).isDiagram(this.m_diagram)) continue;
            ((MyWindowsMenuItem)item).setPath(path);
            return;
        }
    }

    protected void activeDiagram(Diagram diagram) {
        int cnt = m_windowsMenu.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            JMenuItem item = m_windowsMenu.getItem(i);
            if (!(item instanceof MyWindowsMenuItem)) continue;
            ((MyWindowsMenuItem)item).activeDiagram(diagram);
        }
    }

    protected Diagram getOpenDiagram(String path) {
        int cnt = m_windowsMenu.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            Diagram diagram;
            JMenuItem item = m_windowsMenu.getItem(i);
            if (!(item instanceof MyWindowsMenuItem) || (diagram = ((MyWindowsMenuItem)item).getDiagram(path)) == null) continue;
            return diagram;
        }
        return null;
    }

    private Diagram newDiagram() {
        Diagram diagram = new Diagram(this);
        diagram.addTaListener(this.m_legendBox, 3);
        diagram.addTaListener(this.m_mapBox, 1);
        diagram.addTaListener(this.m_queryBox, 1);
        diagram.addTaListener(this.m_resultBox, 2);
        diagram.addTaListener(this.m_tocBox, 2);
        diagram.addTaListener(this.m_historyBox, 2);
        diagram.addTaListener(this.m_undoBox, 0);
        diagram.addTaListener(this.m_viewBox, 0);
        diagram.addTaListener(this, 2);
        return diagram;
    }

    protected void showDescription(RelationInstance ri, boolean showOpens) {
        if (ri != this.m_currentEdge) {
            this.m_currentEdge = ri;
            this.m_currentNameEntity = null;
            EntityInstance src = ri.drawSrc();
            EntityInstance dst = ri.drawDst();
            String info = src == null ? "??null??" : Util.quoted(src.getEntityLabel());
            info = info + " " + ri.getClassLabel() + " ";
            info = dst == null ? info + "??null??" : info + Util.quoted(dst.getEntityLabel());
            this.showInfo(info);
        }
    }

    protected void showDescription(EntityInstance e, boolean showOpens) {
        if (e != this.m_currentNameEntity) {
            EntityInstance pe;
            this.m_currentNameEntity = e;
            this.m_currentEdge = null;
            String str = e == null ? "" : ((pe = e.getContainedBy()) != null ? pe.getEntityLabel() + " . " + e.getEntityLabel() : e.getEntityLabel());
            this.showInfo(str);
        }
        if (e != null && this.m_currentDescEntity != e && (!e.isOpen() || showOpens) && e.getEntityClass() != null) {
            String label = e.getEntityLabel();
            String title = e.getTitle();
            String desc = e.getDescription();
            if (desc == null) {
                desc = "The " + label + " " + e.getClassLabel() + ".";
            }
            String topline = " (" + e.getClassLabel() + (e.hasChildren() ? " - " + e.numChildren() + " items)" : ")");
            topline = title != null ? title + topline : label + topline;
            this.m_rightTextBoxTitle.setText(topline);
            this.m_rightTextBox.set(desc);
            this.m_currentDescEntity = e;
        }
    }

    public JMenuBar genMenu() {
        JMenuBar menuBar;
        m_menuBar = menuBar = new JMenuBar();
        menuBar.add(m_fileMenu);
        JMenu m = new JMenu("Edit");
        this.editMenuItem(m, this);
        menuBar.add(m);
        m = new JMenu("Layout");
        this.layoutMenuItem(m, this, this.isApplet());
        menuBar.add(m);
        m = new JMenu("Explore");
        LandscapeEditorCore.exploreMenuItem(m, this, this.isApplet());
        menuBar.add(m);
        m = new JMenu("Options");
        this.optionsMenuItem(m, this);
        menuBar.add(m);
        m_windowsMenu = m = new JMenu("Windows");
        menuBar.add(m);
        m = new JMenu("Help");
        LandscapeEditorCore.helpMenuItem(m, this, "Editor");
        menuBar.add(m);
        this.setMenuFont(FontCache.getMenuFont());
        this.loadLseditHistory(m, null);
        return menuBar;
    }

    protected void setMenuFont(Font font) {
        FontCache.setMenuFont(font);
        FontCache.setMenuFont(m_menuBar, font);
    }

    protected void setTabsFont(Font font) {
        this.m_rightTabbedPane.setFont(font);
    }

    public void fontsChanged(Option oldOptions, Option newOptions) {
        ResultBox resultBox = null;
        ERBox legendBox = null;
        ERBox queryBox = null;
        boolean diagram_changed = false;
        block27: for (int i = 1; i <= 25; ++i) {
            Font newFont;
            Font oldFont = oldOptions.getTargetFont(i);
            if (oldFont == (newFont = newOptions.getTargetFont(i))) continue;
            switch (i) {
                case 1: {
                    EntityInstance.setClosedFont(newFont);
                    IconCache.setElisionIconFont(newFont);
                    diagram_changed = true;
                    continue block27;
                }
                case 2: {
                    EntityInstance.setSmallFont(newFont);
                    diagram_changed = true;
                    continue block27;
                }
                case 3: {
                    EntityInstance.setOpenFont(newFont);
                    diagram_changed = true;
                    continue block27;
                }
                case 4: {
                    ClientSupplierSet.setTextFont(newFont);
                    diagram_changed = true;
                    continue block27;
                }
                case 5: {
                    Cardinal.setTextFont(newFont);
                    diagram_changed = true;
                    continue block27;
                }
                case 6: {
                    resultBox = this.m_resultBox;
                    ResultBox.setTitleFont(newFont);
                    continue block27;
                }
                case 7: {
                    resultBox = this.m_resultBox;
                    ResultBox.setTextFont(newFont);
                    continue block27;
                }
                case 8: {
                    legendBox = this.m_legendBox;
                    LegendBox.setTitleFont(newFont);
                    continue block27;
                }
                case 9: {
                    legendBox = this.m_legendBox;
                    LegendBox.setTextFont(newFont);
                    continue block27;
                }
                case 10: {
                    queryBox = this.m_queryBox;
                    QueryBox.setTitleFont(newFont);
                    continue block27;
                }
                case 11: {
                    queryBox = this.m_queryBox;
                    QueryBox.setTextFont(newFont);
                    continue block27;
                }
                case 12: {
                    this.m_tocBox.textFontChanged(newFont);
                    continue block27;
                }
                case 13: {
                    this.m_undoBox.textFontChanged(newFont);
                    continue block27;
                }
                case 14: {
                    this.m_historyBox.textFontChanged(newFont);
                    continue block27;
                }
                case 24: {
                    this.m_viewBox.textFontChanged(newFont);
                    continue block27;
                }
                case 15: {
                    this.m_mapBox.textFontChanged(newFont);
                    continue block27;
                }
                case 16: {
                    this.m_leftTextBoxTitle.setFont(newFont);
                    this.m_rightTextBoxTitle.setFont(newFont);
                    continue block27;
                }
                case 17: {
                    this.m_leftTextBox.setFont(newFont);
                    this.m_rightTextBox.setFont(newFont);
                    continue block27;
                }
                case 18: {
                    this.m_feedback.setFont(newFont);
                    this.m_nameBox.setFont(newFont);
                    this.repaintFeedback();
                    continue block27;
                }
                case 19: {
                    this.setMenuFont(newFont);
                    continue block27;
                }
                case 20: {
                    FontCache.setDialogFont(newFont);
                    continue block27;
                }
                case 21: {
                    this.m_clipboardBox.textFontChanged(newFont);
                    continue block27;
                }
                case 22: {
                    this.m_attributeBox.textFontChanged(newFont);
                    continue block27;
                }
                case 23: {
                    RelationLabel.setEdgeLabelFont(newFont);
                    diagram_changed = true;
                    continue block27;
                }
                case 25: {
                    this.setTabsFont(newFont);
                }
            }
        }
        if (resultBox != null) {
            resultBox.fontChanged();
        }
        if (legendBox != null) {
            legendBox.fontChanged();
        }
        if (queryBox != null) {
            queryBox.fontChanged();
        }
        if (diagram_changed) {
            this.refillDiagram();
        }
    }

    protected void genMainGUI() {
        this.m_infoSplitPane = new JSplitPane(1);
        this.m_infoDiagramSplitPane = new JSplitPane(0);
        this.m_diagramTabSplitPane = new JSplitPane(1);
        Option options = Options.getDiagramOptions();
        boolean showToolbar = options.isShowToolbar();
        Container contentPane = this.m_contentPane;
        int width = contentPane.getWidth();
        int height = contentPane.getHeight();
        int toolbar_width = width - 8;
        int usable_height = height - 24;
        int divider1 = this.m_diagramTabSplitPane.getDividerSize();
        int diagram_width = (int)((double)width * m_mainSplitRatio) - divider1;
        int divider3 = this.m_infoSplitPane.getDividerSize();
        int left_width = (diagram_width - divider3) / 2;
        int right_width = diagram_width - divider3 - left_width;
        int info_height = (int)((double)usable_height * m_secondSplitRatio);
        int box_height = info_height - 40;
        int divider2 = this.m_infoDiagramSplitPane.getDividerSize();
        int diagram_height = usable_height - info_height - divider2;
        int tab_width = width - diagram_width;
        contentPane.setVisible(false);
        this.m_toolBar = new JToolBar();
        this.m_toolBar.setRollover(true);
        this.m_toolButton = new ToolBarButton[17];
        this.m_toolButton[0] = new Find_Button(this);
        this.m_toolButton[1] = new Query_f_Button(this);
        this.m_toolButton[2] = new Query_b_Button(this);
        this.m_toolButton[3] = new Query_C_Button(this);
        this.m_toolButton[4] = new Query_Clear_Button(this);
        this.m_toolButton[5] = new Elision_c_Button(this);
        this.m_toolButton[6] = new Elision_I_Button(this);
        this.m_toolButton[7] = new Elision_u_Button(this);
        this.m_toolButton[8] = new Elision_CU_Button(this);
        this.m_toolButton[9] = new Elision_s_Button(this);
        this.m_toolButton[10] = new Elision_CS_Button(this);
        this.m_toolButton[11] = new FontSmallerButton(this);
        this.m_toolButton[12] = new FontBiggerButton(this);
        this.m_toolButton[13] = new HistoryPrev_Button(this);
        this.m_toolButton[14] = new HistoryNext_Button(this);
        this.m_toolButton[15] = new FindPrev_Button(this);
        this.m_toolButton[16] = new FindNext_Button(this);
        this.m_toolButton[NEXT_FIND_BUTTON].setEnabled(false);
        this.m_toolButton[PREV_FIND_BUTTON].setEnabled(false);
        this.m_toolButton[NEXT_HISTORY_BUTTON].setEnabled(false);
        this.m_toolButton[PREV_HISTORY_BUTTON].setEnabled(false);
        for (int i = 0; i < this.m_toolButton.length; ++i) {
            this.m_toolBar.add(this.m_toolButton[i]);
        }
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.setSize(toolbar_width, 24);
        contentPane.add((Component)this.m_toolBar, "North");
        this.m_toolBar.setVisible(showToolbar);
        Font textBoxTitleFont = Option.getDefaultFont(16);
        this.m_leftInfoPanel = new JPanel(new BorderLayout());
        this.m_leftInfoPanel.setPreferredSize(new Dimension(left_width, info_height));
        this.m_leftInfoPanel.setVisible(true);
        this.m_leftTextBoxTitle = new JLabel("");
        this.m_leftTextBoxTitle.setSize(left_width, 20);
        this.m_leftTextBoxTitle.setBackground(Diagram.boxColor);
        this.m_leftTextBoxTitle.setForeground(TextBox.titleColor);
        this.m_leftTextBoxTitle.setFont(textBoxTitleFont);
        this.m_leftInfoPanel.add((Component)this.m_leftTextBoxTitle, "North");
        this.m_scrollLeftTextBox = new JScrollPane();
        this.m_scrollLeftTextBox.setSize(left_width, box_height);
        this.m_leftTextBox = new TextBox(this.m_scrollLeftTextBox, m_leftTextBoxHelp);
        this.m_leftTextBox.setSize(left_width, box_height);
        this.m_leftInfoPanel.add((Component)this.m_scrollLeftTextBox, "Center");
        this.m_feedback = new Feedback(m_feedbackHelp);
        this.m_feedback.setSize(left_width, 20);
        this.m_leftInfoPanel.add((Component)this.m_feedback, "South");
        this.m_rightInfoPanel = new JPanel(new BorderLayout());
        this.m_rightInfoPanel.setSize(right_width, info_height);
        this.m_rightInfoPanel.setPreferredSize(new Dimension(right_width, info_height));
        this.m_rightInfoPanel.setVisible(true);
        this.m_rightTextBoxTitle = new JLabel("");
        this.m_rightTextBoxTitle.setSize(right_width, 20);
        this.m_rightTextBoxTitle.setBackground(Diagram.boxColor);
        this.m_rightTextBoxTitle.setForeground(TextBox.titleColor);
        this.m_rightTextBoxTitle.setFont(textBoxTitleFont);
        this.m_rightInfoPanel.add((Component)this.m_rightTextBoxTitle, "North");
        this.m_scrollRightTextBox = new JScrollPane();
        this.m_scrollRightTextBox.setSize(right_width, box_height);
        this.m_rightTextBox = new TextBox(this.m_scrollRightTextBox, m_rightTextBoxHelp);
        this.m_rightTextBox.setSize(right_width, box_height);
        this.m_rightInfoPanel.add((Component)this.m_scrollRightTextBox, "Center");
        this.m_nameBox = new Feedback(m_nameBoxHelp);
        this.m_nameBox.setSize(right_width, 20);
        this.m_rightInfoPanel.add((Component)this.m_nameBox, "South");
        this.computeMinInfoHeight();
        this.m_infoSplitPane.setLeftComponent(this.m_leftInfoPanel);
        this.m_infoSplitPane.setRightComponent(this.m_rightInfoPanel);
        this.m_infoSplitPane.setOneTouchExpandable(true);
        this.m_infoSplitPane.setDividerLocation(left_width);
        this.m_infoSplitPane.setResizeWeight(0.5);
        this.m_rightTabbedPane = new RightTabbedPane(this);
        this.m_rightTabbedPane.setMinimumSize(new Dimension(100, 50));
        this.m_rightTabbedPane.setSize(tab_width, usable_height);
        this.m_legendBox = new LegendBox(this, this.m_rightTabbedPane);
        this.m_queryBox = new QueryBox(this, this.m_rightTabbedPane);
        this.m_resultBox = new ResultBox(this, this.m_rightTabbedPane);
        this.m_mapBox = new MapBox(this, this.m_rightTabbedPane);
        this.m_tocBox = new TocBox(this, this.m_rightTabbedPane);
        this.m_undoBox = new UndoBox(this, this.m_rightTabbedPane);
        this.m_historyBox = new HistoryBox(this, this.m_rightTabbedPane);
        this.m_clipboardBox = new ClipboardBox(this, this.m_rightTabbedPane);
        this.m_attributeBox = new AttributeBox(this, this.m_rightTabbedPane);
        this.m_viewBox = new ViewBox(this, this.m_rightTabbedPane);
        this.setTabsFont(FontCache.getMenuFont());
        this.m_scrollDiagram = new JScrollPane();
        this.m_scrollDiagram.setSize(diagram_width, diagram_height);
        this.m_scrollDiagram.setPreferredSize(new Dimension(diagram_width, diagram_height));
        this.m_diagram = this.newDiagram();
        this.m_diagram.setSize(diagram_width, diagram_height);
        this.m_scrollDiagram.setViewportView(this.m_diagram);
        this.m_diagram.initialZoom();
        this.m_infoDiagramSplitPane.setTopComponent(this.m_infoSplitPane);
        this.m_infoDiagramSplitPane.setBottomComponent(this.m_scrollDiagram);
        this.m_infoDiagramSplitPane.setMinimumSize(new Dimension(100, 50));
        this.m_infoDiagramSplitPane.setPreferredSize(new Dimension(diagram_width, usable_height));
        this.m_infoDiagramSplitPane.setSize(diagram_width, usable_height);
        this.m_infoDiagramSplitPane.setOneTouchExpandable(true);
        this.m_infoDiagramSplitPane.setDividerLocation(info_height);
        this.m_infoDiagramSplitPane.setResizeWeight(0.0);
        this.m_diagramTabSplitPane.setLeftComponent(this.m_infoDiagramSplitPane);
        this.m_diagramTabSplitPane.setRightComponent(this.m_rightTabbedPane);
        this.m_diagramTabSplitPane.setSize(width, usable_height);
        this.m_diagramTabSplitPane.setPreferredSize(new Dimension(width, usable_height));
        this.m_diagramTabSplitPane.setOneTouchExpandable(true);
        this.m_diagramTabSplitPane.setDividerLocation(diagram_width);
        this.m_diagramTabSplitPane.setResizeWeight(1.0);
        contentPane.add((Component)this.m_diagramTabSplitPane, "Center");
        contentPane.setVisible(true);
    }

    protected void genModeHandlers() {
        this.m_editModeHandler = new EditModeHandler(this);
    }

    protected void computeMinInfoHeight() {
        Dimension d;
        int left = 0;
        int right = 0;
        if (this.m_leftTextBoxTitle != null && this.m_leftTextBoxTitle.isVisible()) {
            d = this.m_leftTextBoxTitle.getMinimumSize();
            left += d.height;
        }
        if (this.m_scrollLeftTextBox != null && this.m_scrollLeftTextBox.isVisible()) {
            d = this.m_scrollLeftTextBox.getMinimumSize();
            left += d.height;
        }
        if (this.m_feedback != null && this.m_feedback.isVisible()) {
            d = this.m_feedback.getMinimumSize();
            left += d.height;
        }
        d = new Dimension(100, left);
        this.m_leftInfoPanel.setMinimumSize(d);
        if (this.m_rightTextBoxTitle != null && this.m_rightTextBoxTitle.isVisible()) {
            d = this.m_rightTextBoxTitle.getMinimumSize();
            right += d.height;
        }
        if (this.m_scrollRightTextBox != null && this.m_scrollRightTextBox.isVisible()) {
            d = this.m_scrollRightTextBox.getMinimumSize();
            right += d.height;
        }
        if (this.m_nameBox != null && this.m_nameBox.isVisible()) {
            d = this.m_nameBox.getMinimumSize();
            right += d.height;
        }
        d = new Dimension(100, right);
        this.m_rightInfoPanel.setMinimumSize(d);
    }

    protected void setLeftBox() {
        EntityInstance root;
        Diagram diagram = this.m_diagram;
        if (diagram != null && (root = diagram.getDrawRoot()) != null) {
            String label = root.getEntityLabel();
            String title = root.getTitle();
            String desc = root.getDescription();
            if (desc == null) {
                desc = root.getContainedBy() == null ? "The " + label + " landscape." : "The " + label + " " + root.getClassLabel();
            }
            String topline = title != null ? title + " (" + label + ")" : label;
            this.m_leftTextBoxTitle.setText(topline);
            this.m_leftTextBox.set(desc);
        }
    }

    protected void changingDiagram() {
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            diagram.signalDiagramChanging(diagram);
        }
    }

    protected void changeDiagram(Diagram diagram) {
        Diagram oldDiagram = this.m_diagram;
        this.m_editModeHandler.cleanup();
        if (oldDiagram != null) {
            oldDiagram.removeEntitiesFromCache();
        }
        if (diagram != null) {
            diagram.addEntitiesToCache();
        }
        this.setDiagram(diagram);
        this.activeDiagram(diagram);
        this.clipboardChanged();
        this.m_scrollDiagram.setViewportView(diagram);
        if (diagram != null) {
            diagram.initialZoom();
            String diagramName = diagram.getContextName();
            if (diagramName == null) {
                this.doFeedback("No diagram");
            } else {
                this.doFeedback("Set to: " + diagramName);
            }
            diagram.signalDiagramChanged(diagram, 44);
        }
        this.setLeftBox();
    }

    private boolean loadDiagram(Diagram diagram, String file) {
        EntityInstance startEntity = null;
        EntityInstance parentEntity = null;
        this.changingDiagram();
        String rc = diagram.loadDiagram(file);
        if (rc != null) {
            this.error("Load failed (" + rc + ") for: " + file);
            System.out.println("Load failed (" + rc + ") for: " + file);
            return false;
        }
        this.changeDiagram(diagram);
        EntityInstance e = diagram.getRootInstance();
        if (this.m_startEntity != null) {
            startEntity = diagram.getCache(this.m_startEntity);
            if (startEntity == null) {
                System.out.println("Start Entity not found: '" + this.m_startEntity + "'");
            } else {
                e = startEntity;
                if (this.m_forward >= 0) {
                    parentEntity = startEntity.getContainedBy();
                    if (parentEntity == null) {
                        System.out.println("Parent entity of '" + this.m_startEntity + "' not found");
                    } else {
                        System.out.println("Doing " + this.m_forward + " step for " + e);
                        this.m_forwardEntity = startEntity;
                        e = parentEntity;
                    }
                }
            }
            this.m_startEntity = null;
        }
        if (e != null) {
            diagram.navigateTo(e, false);
            this.addHistoryEntity(e);
        }
        return true;
    }

    public void loadLs1(String file, String drawRoot) {
        Diagram newDg = this.newDiagram();
        if (file == null) {
            this.doFeedback("No diagram");
            newDg.noDiagram();
        } else if (file.length() < 1) {
            this.changingDiagram();
            this.doFeedback("New Diagram");
            newDg.emptyDiagram();
            this.changeDiagram(newDg);
        } else {
            EntityInstance e;
            this.doFeedback("Reading: " + file + " in background");
            if (!this.loadDiagram(newDg, file)) {
                return;
            }
            if (drawRoot != null && (e = this.m_diagram.getCache(drawRoot)) != null) {
                this.navigateTo(e, false);
            }
        }
        this.rememberDiagram(newDg, file);
        this.requestFocus();
        this.repaint();
    }

    public void loadLs(String file, String drawRoot, boolean async) {
        if (async) {
            LoadLsSwingWorker worker = new LoadLsSwingWorker(this, file, drawRoot);
            worker.start();
        } else {
            this.loadLs1(file, drawRoot);
        }
    }

    public void switchDiagram(Diagram newDg, String lsPath, String drawRoot, boolean async) {
        EntityInstance e;
        Diagram old = this.m_diagram;
        if (old != newDg) {
            IconCache.clearElisionCache();
            if (newDg == null) {
                this.loadLs(lsPath, drawRoot, async);
                return;
            }
            this.changingDiagram();
            this.changeDiagram(newDg);
            newDg.revalidate();
        }
        if (drawRoot != null && (e = this.m_diagram.getCache(drawRoot)) != null) {
            this.navigateTo(e, false);
        }
    }

    protected void attach(String lsPath, String drawRoot) {
        Diagram attachDiagram = this.getOpenDiagram(lsPath);
        this.switchDiagram(attachDiagram, lsPath, drawRoot, false);
    }

    public String getParameter(String name) {
        String ret = this.isApplet() ? this.m_applet.getParameter(name) : System.getProperty(name);
        return ret;
    }

    public void mapboxChanged(EntityInstance e) {
        this.m_mapBox.setDrawRoot(e);
    }

    public void zoomChanged() {
        this.m_diagram.zoomChanged();
    }

    public void refillDiagram() {
        this.m_diagram.revalidate();
    }

    public void repaintDiagram() {
        this.m_diagram.repaint();
    }

    public void refillToolbar() {
        this.m_toolBar.revalidate();
    }

    public void showToolbarChanged() {
        Option options = Options.getDiagramOptions();
        boolean showToolbar = options.isShowToolbar();
        if (showToolbar) {
            this.refillToolbar();
        }
        this.m_toolBar.setVisible(showToolbar);
    }

    public void iconPathChanged() {
        Diagram diagram = this.m_diagram;
        IconCache.clear();
        if (diagram != null) {
            diagram.iconPathChanged();
        }
    }

    public void iconFixedChanged() {
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            diagram.iconPathChanged();
        }
    }

    public String filePrompt(String banner, String default_file, int mode, FileFilter[] filters) {
        String name;
        if (this.isApplet()) {
            name = JOptionPane.showInputDialog("Which file do you wish to upload from the server");
        } else {
            int ret;
            JFileChooser fd = new JFileChooser(".");
            fd.setDialogTitle(banner);
            int select = mode == 1 ? 1 : 0;
            fd.setFileSelectionMode(select);
            if (default_file != null) {
                fd.setSelectedFile(new File(default_file));
            }
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    fd.addChoosableFileFilter(filters[i]);
                }
            }
            if ((ret = mode != 2 ? fd.showOpenDialog(this.m_contentPane) : fd.showSaveDialog(this.m_contentPane)) == 0) {
                File file = fd.getSelectedFile();
                name = file.getAbsolutePath();
            } else {
                name = null;
            }
        }
        return name;
    }

    protected void getBrowser() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        String os = Version.Detail("os.name");
        String defaultFilename = null;
        String browser = null;
        if (os != null && os.startsWith("Windows")) {
            defaultFilename = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
        }
        File defaultfile = defaultFilename != null ? new File(defaultFilename) : null;
        fileChooser.setDialogTitle("Identify internet browser");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setApproveButtonText("Select");
        File startfile = m_browser == null ? defaultfile : new File(m_browser);
        if (startfile != null) {
            fileChooser.setSelectedFile(startfile);
        }
        if (defaultfile != null) {
            fileChooser.setAccessory(new DefaultBrowserButton(fileChooser, os, defaultfile));
        }
        if ((ret = fileChooser.showOpenDialog(this.m_contentPane)) == 0) {
            File file = fileChooser.getSelectedFile();
            browser = file.getAbsolutePath();
            if (browser.equals(m_browser)) {
                return;
            }
            m_browser = browser;
        }
    }

    protected void showURL(String urlName, int target) {
        block16: {
            MsgOut.vprintln("URL: " + urlName + " - target: " + target);
            try {
                if (!this.isApplet()) {
                    try {
                        BrowserLauncher.openURL(urlName);
                    }
                    catch (Exception e) {
                        System.out.println("Unable to execute BrowserLauncher " + e.getMessage());
                        String[] argv = new String[2];
                        String browser = m_browser;
                        if (browser == null) {
                            this.getBrowser();
                            browser = m_browser;
                            if (browser == null) {
                                return;
                            }
                        }
                        argv[0] = browser;
                        argv[1] = urlName;
                        try {
                            Runtime runtime = Runtime.getRuntime();
                            runtime.exec(argv);
                            break block16;
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(this.m_frame, "Unable to execute " + argv[0] + " " + e1.getMessage(), "Browser error", 0);
                        }
                    }
                    break block16;
                }
                URL newURL = new URL(this.m_documentBase, urlName);
                if (this.m_ac == null) {
                    this.m_ac = this.m_applet.getAppletContext();
                }
                switch (target) {
                    case 0: {
                        this.m_ac.showDocument(newURL, "_top");
                        break;
                    }
                    case 4: {
                        this.m_ac.showDocument(newURL, "_blank");
                        break;
                    }
                    case 2: {
                        this.m_ac.showDocument(newURL, "Map");
                        break;
                    }
                    case 3: {
                        this.m_ac.showDocument(newURL, "List");
                    }
                }
            }
            catch (MalformedURLException ex) {
                MsgOut.println("Malformed URL: " + urlName + " " + ex.getMessage());
            }
        }
    }

    protected void showSource(Object object, int key) {
        int index;
        if (this.isApplet()) {
            this.error("Applets can't execute external commands");
            return;
        }
        if (object == null) {
            if (this.m_diagram != null) {
                object = this.m_diagram.targetEntityRelation(object);
            } else {
                this.error("No diagram");
            }
        }
        if (object == null) {
            return;
        }
        if (!(object instanceof LandscapeObject)) {
            this.error(object + " not a LandscapeObject");
            return;
        }
        for (index = 0; index < g_showSourceKeys.length && key != g_showSourceKeys[index]; ++index) {
        }
        ExecuteAction.onObject(this, index, (LandscapeObject)object);
    }

    protected void about() {
        if (this.m_aboutURL != null) {
            this.showURL(this.m_aboutURL, 4);
        }
    }

    protected void help() {
        if (this.m_helpURL != null) {
            this.showURL(this.m_helpURL, 4);
        }
    }

    protected void setVisibility(JComponent bd, boolean state) {
        if (bd != null) {
            bd.setVisible(state);
        }
    }

    protected void readyMsg() {
        this.doFeedback(LandscapeEditorCore.getTitle() + " " + 7 + "." + 4 + " (build " + 0 + ") Started.");
    }

    public void setLsPath(String file) {
        if (this.m_lsPath == null) {
            this.m_lsPath = file;
        } else {
            this.addLseditHistory(file);
        }
    }

    protected void followURL(String url, int target) {
        switch (target) {
            case 5: {
                this.attach(url, null);
                break;
            }
            case 1: {
                if (this.m_frame != null) {
                    LandscapeEditorFrame af = LandscapeEditorFrame.create();
                    af.setLsPath(url);
                    af.launch(null);
                    ++m_openFrames;
                    break;
                }
            }
            default: {
                this.showURL(url, target);
            }
        }
    }

    public void clearFeedback() {
        this.m_feedback.set("");
    }

    protected void fitToLabel() {
        Vector v = this.startGroupOp();
        if (v == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        int i = v.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)v.elementAt(i);
            Dimension ld = e.getLabelDim(this.getGraphics(), 1);
            int width = ld.width + 10;
            int height = ld.height + 10;
            if (e.hasChildren()) {
                width += 11;
                if (height < 17) {
                    height = 17;
                }
            }
            EntityComponent entityComponent = e.getEntityComponent();
            Container parentComponent = entityComponent.getParent();
            int parentWidth = parentComponent.getWidth();
            int parentHeight = parentComponent.getHeight();
            double relWidth = (double)parentWidth <= 0.0 ? 0.1 : (double)width / (double)parentWidth;
            double relHeight = (double)parentHeight <= 0.0 ? 0.1 : (double)height / (double)parentHeight;
            diagram.updateSizeRelLocal(e, relWidth, relHeight);
        }
    }

    protected void avoidCollisions() {
        double shift;
        int k;
        int j;
        EntityInstance e;
        int i;
        Vector v = this.startGroupOp();
        if (v == null) {
            return;
        }
        int size = v.size();
        if (size == 0) {
            return;
        }
        Diagram diagram = this.getDiagram();
        double[] x = new double[size];
        double[] y = new double[size];
        double[] width = new double[size];
        double[] height = new double[size];
        int[] next = new int[size];
        int[] prior = new int[size];
        for (i = 0; i < size; ++i) {
            e = (EntityInstance)v.elementAt(i);
            x[i] = e.xRelLocal();
            y[i] = e.yRelLocal();
            width[i] = e.widthRelLocal();
            height[i] = e.heightRelLocal();
            next[i] = -1;
            prior[i] = -1;
        }
        for (i = 0; i < size; ++i) {
            double xi = x[i];
            double yi = y[i];
            double widthi = width[i];
            double heighti = height[i];
            for (j = i + 1; j < size; ++j) {
                double yj = y[j];
                if (yj >= yi + heighti || yj + height[j] <= yi) continue;
                double xj = x[j];
                if (xi <= xj) {
                    k = prior[j];
                    if (k == -1 || xi + widthi > x[k] + width[k]) {
                        prior[j] = i;
                    }
                    if ((k = next[i]) != -1 && !(xj < x[k])) continue;
                    next[i] = j;
                    continue;
                }
                k = prior[i];
                if (k == -1 || xj + width[j] > x[k] + width[k]) {
                    prior[i] = j;
                }
                if ((k = next[j]) != -1 && !(xi < x[k])) continue;
                next[j] = i;
            }
        }
        block3: for (i = 0; i < size; ++i) {
            j = i;
            while ((k = prior[j]) >= 0 && !((shift = x[k] + width[k] - x[j]) < 0.0)) {
                e = (EntityInstance)v.elementAt(k);
                int n = k;
                x[n] = x[n] - (shift + 0.001);
                if (x[k] <= 0.0) {
                    x[k] = 0.0;
                    continue block3;
                }
                j = k;
            }
        }
        block5: for (i = 0; i < size; ++i) {
            j = i;
            while ((k = next[j]) >= 0 && !((shift = x[j] + width[j] - x[k]) < 0.0)) {
                double max = 1.0 - x[k] - width[k];
                if ((shift += 0.001) >= max) {
                    shift = max;
                }
                if (shift <= 0.0) continue block5;
                e = (EntityInstance)v.elementAt(k);
                int n = k;
                x[n] = x[n] + shift;
                j = k;
            }
        }
        for (i = 0; i < size; ++i) {
            e = (EntityInstance)v.elementAt(i);
            if (x[i] == e.xRelLocal()) continue;
            diagram.updateRelLocal(e, x[i], y[i], width[i], height[i]);
        }
    }

    protected Vector startGroupOp() {
        Vector grp = this.m_diagram.getGroupedEntities();
        if (grp == null) {
            this.error("Group not selected");
            return null;
        }
        return grp;
    }

    protected void alignTop() {
        EntityInstance e;
        int size;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double top = ke.yRelLocal();
        int i = size = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(top + e.heightRelLocal() > 1.0)) continue;
            top = 1.0 - e.heightRelLocal();
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateYRelLocal(e, top);
        }
    }

    protected void alignHorizontal() {
        EntityInstance e;
        int size;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double center = ke.yRelLocal() + ke.heightRelLocal() / 2.0;
        int i = size = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(center + e.heightRelLocal() / 2.0 > 1.0)) continue;
            center = 1.0 - e.heightRelLocal() / 2.0;
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(center - e.heightRelLocal() / 2.0 < 0.0)) continue;
            center = e.heightRelLocal() / 2.0;
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateYRelLocal(e, center - e.heightRelLocal() / 2.0);
        }
    }

    protected void alignBottom() {
        EntityInstance e;
        int size;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double bottom = ke.yRelLocal() + ke.heightRelLocal();
        int i = size = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(bottom - e.heightRelLocal() < 0.0)) continue;
            bottom = e.heightRelLocal();
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateYRelLocal(e, bottom - e.heightRelLocal());
        }
    }

    protected void alignLeft() {
        EntityInstance e;
        int size;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double left = ke.xRelLocal();
        int i = size = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(left + e.widthRelLocal() > 1.0)) continue;
            left = 1.0 - e.widthRelLocal();
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateXRelLocal(e, left);
        }
    }

    protected void alignVertical() {
        EntityInstance e;
        int size;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double center = ke.xRelLocal() + ke.widthRelLocal() / 2.0;
        int i = size = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(center + e.widthRelLocal() / 2.0 > 1.0)) continue;
            center = 1.0 - e.widthRelLocal() / 2.0;
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(center - e.widthRelLocal() / 2.0 < 0.0)) continue;
            center = e.widthRelLocal() / 2.0;
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateXRelLocal(e, center - e.widthRelLocal() / 2.0);
        }
    }

    protected void alignRight() {
        EntityInstance e;
        int size;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double right = ke.xRelLocal() + ke.widthRelLocal();
        int i = size = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            if (!(right - e.widthRelLocal() < 0.0)) continue;
            right = e.widthRelLocal();
        }
        i = size;
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateXRelLocal(e, right - e.widthRelLocal());
        }
    }

    protected void sameWidth() {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double width = ke.widthRelLocal();
        int i = grp.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)grp.elementAt(i);
            if (e == ke) continue;
            diagram.updateWidthRelLocal(e, width);
        }
    }

    protected void sameHeight() {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        double height = ke.heightRelLocal();
        int i = grp.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)grp.elementAt(i);
            if (e == ke) continue;
            diagram.updateHeightRelLocal(e, height);
        }
    }

    protected void sameSize() {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance ke = diagram.getKeyEntity();
        Rectangle klyt = ke.getDiagramBounds();
        double width = ke.widthRelLocal();
        double height = ke.heightRelLocal();
        int i = grp.size();
        while (--i >= 0) {
            EntityInstance e = (EntityInstance)grp.elementAt(i);
            if (e == ke) continue;
            diagram.updateSizeRelLocal(e, width, height);
        }
    }

    protected void equalHorizontalSpacing() {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        int size = grp.size();
        if (size < 3) {
            this.error("Minimum group of three required");
            return;
        }
        SortVector.byHorizontalPosition(grp);
        Diagram diagram = this.m_diagram;
        EntityInstance e = (EntityInstance)grp.elementAt(0);
        double xRelLocal = e.xRelLocal() + e.widthRelLocal();
        int i = size - 1;
        e = (EntityInstance)grp.elementAt(i);
        double space = e.xRelLocal() - xRelLocal;
        while (--i > 0) {
            e = (EntityInstance)grp.elementAt(i);
            space -= e.widthRelLocal();
        }
        space /= (double)(size - 1);
        --size;
        for (i = 1; i < size; ++i) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateXRelLocal(e, xRelLocal += space);
            xRelLocal += e.widthRelLocal();
        }
    }

    protected void equalVerticalSpacing() {
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        int size = grp.size();
        if (size < 3) {
            this.error("Minimum group of three required");
            return;
        }
        SortVector.byVerticalPosition(grp);
        Diagram diagram = this.m_diagram;
        EntityInstance e = (EntityInstance)grp.elementAt(0);
        double yRelLocal = e.yRelLocal() + e.heightRelLocal();
        int i = size - 1;
        e = (EntityInstance)grp.elementAt(i);
        double space = e.yRelLocal() - yRelLocal;
        while (--i > 0) {
            e = (EntityInstance)grp.elementAt(i);
            space -= e.heightRelLocal();
        }
        space /= (double)(--size);
        for (i = 1; i < size; ++i) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateYRelLocal(e, yRelLocal += space);
            yRelLocal += e.heightRelLocal();
        }
    }

    protected void updateCreateContainedGroup() {
        EntityInstance e;
        Vector grp = this.startGroupOp();
        if (grp == null) {
            return;
        }
        Diagram diagram = this.m_diagram;
        EntityInstance pe = ((EntityInstance)grp.firstElement()).getContainedBy();
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxX = Double.MIN_VALUE;
        int i = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            EntityComponent entityComponent = e.getEntityComponent();
            double x = e.xRelLocal();
            double y = e.yRelLocal();
            x = entityComponent.getDiagramX();
            y = entityComponent.getDiagramY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            x += e.widthRelLocal();
            y += e.heightRelLocal();
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        this.beginUndoRedo("New Entity Container");
        EntityInstance ne = diagram.updateNewEntity(null, pe);
        diagram.updateRelLocal(ne, minX, minY, maxX - minX, maxY - minY);
        i = grp.size();
        while (--i >= 0) {
            e = (EntityInstance)grp.elementAt(i);
            diagram.updateMoveEntityContainment(ne, e);
        }
        this.endUndoRedo();
    }

    protected void saveStatus(String stat) {
        this.doFeedback("Save status: " + stat);
    }

    protected String doSaveByURL(String lsSaveURL) {
        OutputStream os;
        URLConnection urlCon;
        URL lsURL;
        try {
            lsURL = new URL(lsSaveURL);
        }
        catch (MalformedURLException e) {
            return "Malformed URL on write";
        }
        try {
            urlCon = lsURL.openConnection();
            urlCon.setDoInput(false);
            urlCon.setDoOutput(true);
            urlCon.setAllowUserInteraction(false);
        }
        catch (IOException e) {
            return "Couldn't open URL connection " + e.getMessage();
        }
        try {
            os = urlCon.getOutputStream();
        }
        catch (IOException e) {
            return "Couldn't open URL Output Stream " + e.getMessage();
        }
        return this.m_diagram.saveDiagram(os, false);
    }

    protected void saveByURL(String overridePath) {
        InputStream is;
        URL lsURL;
        MsgOut.dprintln("Save by URL");
        String str = this.doSaveByURL(this.m_lsSavePath);
        if (str != null) {
            this.saveStatus(str);
            return;
        }
        if (this.m_lsSaveCmd == null) {
            this.saveStatus("Success");
            return;
        }
        try {
            lsURL = new URL(this.m_lsSaveCmd);
        }
        catch (MalformedURLException e) {
            this.saveStatus("Malformed URL on write");
            return;
        }
        try {
            is = lsURL.openStream();
        }
        catch (IOException e) {
            this.saveStatus("Couldn't openStream for store " + e.getMessage());
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader bufferedReader = new BufferedReader(reader);
            str = bufferedReader.readLine();
            is.close();
            this.saveStatus(str);
        }
        catch (IOException e) {
            this.saveStatus("IOexception on store " + e.getMessage());
        }
    }

    protected String saveByFile(String newPath) {
        String ret = this.m_diagram.saveByFile(newPath);
        if (ret == null && newPath != null) {
            this.changeDiagramPath(newPath);
        }
        return ret;
    }

    protected String saveWithCmd(String saveSuffix, String cmdTemplate) {
        String rc;
        FileOutputStream os;
        File file = (File)this.m_diagram.getContext();
        String path = file.getPath() + saveSuffix;
        File nfile = new File(path);
        try {
            os = new FileOutputStream(nfile);
        }
        catch (IOException e) {
            return "IOException creating output stream " + e.getMessage();
        }
        String ret = this.m_diagram.saveDiagram(os, true);
        if (ret != null) {
            return ret;
        }
        String cmd = Util.expand(cmdTemplate, file.getName(), this);
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            InputStreamReader reader = new InputStreamReader(p.getErrorStream());
            BufferedReader bufferedReader = new BufferedReader(reader);
            rc = bufferedReader.readLine();
            if (rc.equals("Done")) {
                rc = "Save succeeded";
            }
            p.destroy();
        }
        catch (Exception e) {
            rc = "Exec failed for: " + cmd;
        }
        return rc;
    }

    protected void doSaveLs(String overridePath) {
        this.doFeedback("Saving landscape...");
        if (this.m_diagram.getContext() instanceof URL) {
            this.saveByURL(overridePath);
        } else {
            String rc;
            if (overridePath == null && this.m_lsSaveCmd != null) {
                MsgOut.dprintln("Save by app");
                rc = this.saveWithCmd(this.m_lsSaveSuffix, this.m_lsSaveCmd);
            } else {
                MsgOut.dprintln("Save by file");
                rc = this.saveByFile(overridePath);
            }
            if (rc == null) {
                rc = "Success";
            }
            this.saveStatus(rc);
        }
    }

    protected void saveLs() {
        Object context = this.m_diagram.getContext();
        String txt = null;
        if (context == null && ((txt = this.filePrompt("Save Landscape", this.m_diagram.getAbsolutePath(), 2, null)) == null || txt.length() == 0)) {
            return;
        }
        this.doSaveLs(txt);
    }

    protected void initialLoad() {
        Object startEntity = null;
        int forward = this.m_forward;
        String lsPath = this.m_lsPath;
        Diagram diagram = this.m_diagram;
        this.setDiagram(diagram);
        if (lsPath == null) {
            MsgOut.dprintln("Empty landscape");
            if (this.m_leftTextBox != null) {
                this.m_leftTextBoxTitle.setText("Empty Landscape");
                this.m_leftTextBox.set("Select 'Open landscape' from 'File' menu to load a new landscape.");
            }
            this.readyMsg();
        } else if (diagram != null) {
            MsgOut.dprintln("Load: " + lsPath);
            if (!this.loadDiagram(diagram, lsPath)) {
                return;
            }
            this.setLeftBox();
            this.readyMsg();
        }
        if (this.m_rightTabbedPane != null && this.m_rightTabbedPane.isVisible() && !this.m_legendBox.isActive()) {
            this.m_legendBox.activate();
        }
        this.requestFocus();
        this.rememberDiagram(this.m_diagram, lsPath);
        this.activeDiagram(this.m_diagram);
    }

    public void init_core(int diagramPercentWidth, int diagramPercentHeight) {
        this.m_contentPane.setBackground(Color.lightGray);
        this.genModeHandlers();
        if (diagramPercentWidth > 0 && diagramPercentHeight > 0) {
            m_secondSplitRatio = 1.0 - (double)diagramPercentHeight / 100.0;
            m_mainSplitRatio = (double)diagramPercentWidth / 100.0;
        }
        this.genMainGUI();
        this.initialLoad();
        this.showInfo("");
    }

    protected void goTo(Vector res) {
        Diagram diagram = this.m_diagram;
        this.doFeedback("");
        diagram.clearFlags(true);
        EntityInstance e = (EntityInstance)res.elementAt(0);
        EntityInstance pe = e.getContainedBy();
        SortVector.byString(res);
        this.m_resultBox.showResults("FIND RESULTS:", res, "-- Find step --");
        this.m_resultBox.activate();
        this.m_rightTextBoxTitle.setText("");
        this.m_rightTextBox.set("");
        this.navigateTo(pe, false);
        int i = res.size();
        while (--i >= 0) {
            e = (EntityInstance)res.elementAt(i);
            diagram.setRedBoxFlag(e);
        }
    }

    protected void findNext() {
        if (this.m_findResults == null) {
            this.error("No search has occured.");
        } else if (this.m_findResults.isEmpty()) {
            this.error("No entities found which match search pattern.");
        } else {
            boolean state;
            ToolBarButton button = this.m_toolButton[PREV_FIND_BUTTON];
            boolean change = false;
            boolean bl = state = !this.m_findResults.atBeginning();
            if (button.isEnabled() != state) {
                button.setEnabled(state);
                change = true;
            }
            Vector result = this.m_findResults.nextResult();
            state = !this.m_findResults.atEnd();
            button = this.m_toolButton[NEXT_FIND_BUTTON];
            if (button.isEnabled() != state) {
                button.setEnabled(state);
                change = true;
            }
            if (change) {
                this.refillToolbar();
            }
            if (result == null) {
                this.error("No more results available.");
            } else {
                this.goTo(result);
            }
        }
    }

    protected void find() {
        Diagram diagram = this.m_diagram;
        FindBox findBox = new FindBox(this.getFrame(), this, this.m_diagram);
        FindRules findRules = findBox.getFindRules();
        findBox.dispose();
        if (findRules == null) {
            this.error("No meaningful find rules provided");
        } else {
            this.m_findResults = new Find(diagram.getRootInstance(), findRules);
            if (this.m_findResults.isEmpty()) {
                this.error("No entities found which match search pattern.");
            } else {
                if (diagram.clearHighlighting(true)) {
                    diagram.revalidate();
                }
                this.m_findResults.reset();
                this.findNext();
                if (!this.m_findResults.atEnd()) {
                    this.m_rightTextBox.set("Use F3 to step forward through layers found and F2 to step back");
                }
            }
        }
    }

    protected void findPrev() {
        if (this.m_findResults == null) {
            this.error("No search has occured.");
        } else if (this.m_findResults.isEmpty()) {
            this.error("No search results.");
        } else if (!this.m_findResults.regress()) {
            this.error("At first result.");
        } else {
            this.findNext();
        }
    }

    public RelationInstance updateNewRelation(EntityInstance from, EntityInstance to) {
        this.beginUndoRedo("New Relation");
        RelationInstance ri = this.m_diagram.updateNewRelation(null, from, to);
        this.endUndoRedo();
        return ri;
    }

    protected boolean deleteContainer(EntityInstance e) {
        Diagram diagram = this.m_diagram;
        diagram.clearEntityGroupFlag(e);
        this.beginUndoRedo("Delete Container " + e);
        boolean ret = diagram.updateDeleteContainer(e);
        if (ret) {
            this.doFeedback("Container " + e.getEntityLabel() + " has been deleted.");
        } else {
            this.doFeedback("Container " + e.getEntityLabel() + " can't be deleted.");
        }
        this.endUndoRedo();
        return ret;
    }

    protected boolean testForClose(boolean windowClosing) {
        if (this.isApplet()) {
            return false;
        }
        if (this.m_diagram.getChangedFlag()) {
            Util.beep();
            int option = windowClosing ? 0 : 1;
            int rc = JOptionPane.showConfirmDialog(this.m_frame, "Landscape has been changed.\nShould it be saved?", "Landscape Changed", option);
            switch (rc) {
                case 0: {
                    this.saveLs();
                }
                case 1: {
                    break;
                }
                default: {
                    if (windowClosing) break;
                    return false;
                }
            }
        }
        this.saveLseditHistory();
        return true;
    }

    protected void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void navigateTo(EntityInstance e, boolean mustbeContainer) {
        this.m_diagram.navigateTo(e, mustbeContainer);
        this.setRightTextBox("", "");
    }

    public void navigateToDrawRootParent() {
        Diagram diagram = this.m_diagram;
        if (diagram != null) {
            EntityInstance e = diagram.getDrawRootParent();
            if (e == null) {
                this.error("At topmost landscape");
            } else {
                this.navigateTo(e, false);
            }
        }
    }

    public void followLink(EntityInstance e, boolean mustbeContainer) {
        Attribute attr = e.getLsAttribute("navlink");
        this.m_editModeHandler.cleanup();
        this.m_diagram.clearFlags(true);
        if (attr == null) {
            this.navigateTo(e, mustbeContainer);
            return;
        }
        attr.followLink(this, e, mustbeContainer);
    }

    protected void shiftDeltaFont(int delta) {
        String msg;
        Diagram diagram = this.m_diagram;
        Vector grp = diagram.getGroupedEntities();
        if (grp != null && !grp.isEmpty()) {
            int i = grp.size();
            while (--i >= 0) {
                EntityInstance ge = (EntityInstance)grp.elementAt(i);
                diagram.shiftDeltaFont(ge, delta);
            }
            msg = "Selected entities font changed";
        } else {
            EntityInstance ge = this.m_diagram.getDrawRoot();
            if (ge == null) {
                msg = "No entities exist";
            } else {
                diagram.shiftDeltaFont(ge, delta);
                msg = "Draw root font changed";
            }
        }
        this.doFeedback(msg);
    }

    protected void redboxEntities() {
        String msg;
        Diagram diagram = this.m_diagram;
        Vector grp = diagram.getGroupedEntities();
        if (grp != null && !grp.isEmpty()) {
            int i = grp.size();
            while (--i >= 0) {
                EntityInstance ge = (EntityInstance)grp.elementAt(i);
                diagram.setRedBoxFlag(ge);
            }
            msg = "Selected redbox entities changed";
        } else {
            msg = "No entities exist";
        }
        this.doFeedback(msg);
    }

    public void show_groupList() {
        String msg;
        Diagram diagram = this.m_diagram;
        if (diagram != null && (msg = diagram.show_groupList(this.m_resultBox)) != null) {
            this.doFeedback(msg);
        }
    }

    public void groupAll() {
        String msg;
        Diagram diagram = this.m_diagram;
        if (diagram != null && (msg = diagram.groupAll()) != null) {
            this.doFeedback(msg);
        }
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public JPanel getContentPane() {
        return (JPanel)this.m_contentPane;
    }

    public Feedback getFeedbackBox() {
        return this.m_feedback;
    }

    public Feedback getNameBox() {
        return this.m_nameBox;
    }

    public Diagram getDiagram() {
        return this.m_diagram;
    }

    protected void setDiagram(Diagram diagram) {
        Option diagramOptions = diagram.getDiagramOptions();
        this.m_diagram = diagram;
        Options.setDiagramOptions(diagramOptions);
        if (this.m_handicapped > 0) {
            Font font = FontCache.get("Dialog", 1, this.m_handicapped);
            diagramOptions.setTargetFont(0, font, true, true, false);
        }
        diagram.setClipboardListener(this.m_clipboardBox);
        diagram.setUndoListener(this);
    }

    public TocBox getTocBox() {
        return this.m_tocBox;
    }

    public UndoBox getUndoBox() {
        return this.m_undoBox;
    }

    public LegendBox getLegendBox() {
        return this.m_legendBox;
    }

    public MapBox getMapBox() {
        return this.m_mapBox;
    }

    public QueryBox getQueryBox() {
        return this.m_queryBox;
    }

    public ResultBox getResultBox() {
        return this.m_resultBox;
    }

    public AttributeBox getAttributeBox() {
        return this.m_attributeBox;
    }

    public ClipboardBox getClipboardBox() {
        return this.m_clipboardBox;
    }

    public HistoryBox getHistoryBox() {
        return this.m_historyBox;
    }

    public ViewBox getViewBox() {
        return this.m_viewBox;
    }

    public TextBox getLeftTextBox() {
        return this.m_leftTextBox;
    }

    public TextBox getRightTextBox() {
        return this.m_rightTextBox;
    }

    public int getCursor() {
        return this.m_curCursor;
    }

    public int setCursor(int value) {
        int ret = this.m_curCursor;
        if (ret != value) {
            Cursor cursor = Cursor.getPredefinedCursor(value);
            this.m_curCursor = value;
            if (this.m_frame != null) {
                this.m_frame.setCursor(cursor);
            } else {
                this.m_applet.setCursor(cursor);
            }
        }
        return ret;
    }

    public void setRightTextBox(String title, String description) {
        this.m_rightTextBoxTitle.setText(title);
        this.m_rightTextBox.set(description);
    }

    public Enumeration enumEntityClasses() {
        return this.m_diagram.enumEntityClasses();
    }

    public Enumeration enumEntityClassesInOrder() {
        return this.m_diagram.enumEntityClassesInOrder();
    }

    public Enumeration enumRelationClassesInOrder() {
        return this.m_diagram.enumRelationClassesInOrder();
    }

    public void beginUndoRedo(String name) {
        if (this.m_diagram != null) {
            this.m_diagram.beginUndoRedo(name);
        }
    }

    public void endUndoRedo() {
        if (this.m_diagram != null) {
            this.m_diagram.endUndoRedo();
        }
    }

    public Vector getEdits() {
        if (this.m_diagram != null) {
            return this.m_diagram.getEdits();
        }
        return null;
    }

    public UndoableEdit getEditToBeRedone() {
        return this.m_diagram.getEditToBeRedone();
    }

    public int countEdits() {
        return this.m_diagram.countEdits();
    }

    public void massChange(UndoableEdit undoableEdit, boolean redo) {
        if (this.m_diagram != null) {
            this.m_diagram.massChange(undoableEdit, redo);
            this.doFeedback("Changes " + (redo ? "redone" : "undone"));
        }
    }

    public void discardAllEdits() {
        if (this.m_diagram != null) {
            this.m_diagram.discardAllEdits();
        }
    }

    public boolean clearUndoCache() {
        boolean ret;
        Vector v = this.getEdits();
        if (v == null || v.size() == 0) {
            ret = true;
        } else {
            int ret1 = JOptionPane.showConfirmDialog(this.getFrame(), "Confirm deletion of undo history?", "Delete Undo History", 2);
            boolean bl = ret = ret1 == 0;
            if (ret) {
                this.discardAllEdits();
                this.m_undoBox.fill();
            }
        }
        return ret;
    }

    public boolean clearAllUndoCaches() {
        boolean ret = false;
        int cnt = m_windowsMenu.getItemCount();
        for (int i = 0; i < cnt; ++i) {
            Diagram diagram;
            Vector v;
            JMenuItem item = m_windowsMenu.getItem(i);
            if (!(item instanceof MyWindowsMenuItem) || (v = (diagram = ((MyWindowsMenuItem)item).getDiagram()).getEdits()) == null || v.size() == 0) continue;
            if (!ret) {
                int ret1 = JOptionPane.showConfirmDialog(this.getFrame(), "Confirm deletion of all undo histories to free memory?", "Delete All Undo Histories", 2);
                if (ret1 != 0) break;
                ret = true;
            }
            diagram.discardAllEdits();
        }
        if (ret) {
            this.m_undoBox.fill();
        }
        return ret;
    }

    public int getDiagramX() {
        return this.m_scrollDiagram.getX();
    }

    public int getDiagramY() {
        return this.m_scrollDiagram.getY();
    }

    public Point getDiagramViewPosition() {
        JViewport viewport = this.m_scrollDiagram.getViewport();
        return viewport.getViewPosition();
    }

    protected void edgeNavigateSrc(Object object) {
        Diagram diagram = this.getDiagram();
        RelationInstance ri = diagram.targetRelation(object);
        if (ri == null) {
            return;
        }
        this.followLink(ri.getSrc(), true);
    }

    protected void edgeNavigateDst(Object object) {
        Diagram diagram = this.getDiagram();
        RelationInstance ri = diagram.targetRelation(object);
        if (ri == null) {
            return;
        }
        this.followLink(ri.getDst(), true);
    }

    public void setHistoryButtons(HistoryBox historyBox) {
        ToolBarButton button = this.m_toolButton[PREV_HISTORY_BUTTON];
        boolean change = false;
        boolean state = historyBox.hasPrevious();
        if (button.isEnabled() != state) {
            button.setEnabled(state);
            change = true;
        }
        state = historyBox.hasNext();
        button = this.m_toolButton[NEXT_HISTORY_BUTTON];
        if (button.isEnabled() != state) {
            button.setEnabled(state);
            change = true;
        }
        if (change) {
            this.refillToolbar();
        }
    }

    public void addHistoryEntity(EntityInstance e) {
        HistoryBox historyBox = this.m_historyBox;
        if (historyBox != null) {
            historyBox.addEntity(e);
            this.setHistoryButtons(historyBox);
        }
    }

    protected void closeEditor() {
        if (this.testForClose(false)) {
            MyWindowsMenuItem menuItem;
            JMenuItem item;
            int cnt;
            int i = cnt = m_windowsMenu.getItemCount();
            while (i > 0) {
                if (!((item = m_windowsMenu.getItem(--i)) instanceof MyWindowsMenuItem) || !(menuItem = (MyWindowsMenuItem)item).isDiagram(this.m_diagram)) continue;
                m_windowsMenu.remove(i);
                break;
            }
            i = cnt = m_windowsMenu.getItemCount();
            while (i > 0) {
                if (!((item = m_windowsMenu.getItem(--i)) instanceof MyWindowsMenuItem)) continue;
                menuItem = (MyWindowsMenuItem)item;
                menuItem.actionPerformed(null);
                return;
            }
            System.exit(0);
        }
    }

    public void clipboardChanged() {
        if (this.m_clipboardBox != null) {
            this.m_clipboardBox.clipboardChanged();
        }
    }

    public void repaintFeedback() {
        this.computeMinInfoHeight();
        this.m_infoDiagramSplitPane.revalidate();
    }

    public void changeShowDesc(boolean show) {
        this.setVisibility(this.m_leftTextBoxTitle, show);
        this.setVisibility(this.m_scrollLeftTextBox, show);
        this.setVisibility(this.m_rightTextBoxTitle, show);
        this.setVisibility(this.m_scrollRightTextBox, show);
        this.repaintFeedback();
    }

    public void changeShowFeedback(boolean show) {
        this.setVisibility(this.m_feedback, show);
        this.setVisibility(this.m_nameBox, show);
        this.repaintFeedback();
    }

    public void changeFixScrollbars(boolean state) {
        if (state) {
            this.m_scrollDiagram.setVerticalScrollBarPolicy(22);
            this.m_scrollDiagram.setHorizontalScrollBarPolicy(32);
            this.doFeedback("Diagram scroll bars permanently enabled");
        } else {
            this.m_scrollDiagram.setVerticalScrollBarPolicy(20);
            this.m_scrollDiagram.setHorizontalScrollBarPolicy(30);
            this.doFeedback("Diagram scroll bars will appear as needed");
        }
    }

    public void changeLeftTabbox(boolean state) {
        JComponent right;
        JComponent left;
        this.m_diagramTabSplitPane.setLeftComponent(null);
        this.m_diagramTabSplitPane.setRightComponent(null);
        if (state) {
            left = this.m_rightTabbedPane;
            right = this.m_infoDiagramSplitPane;
        } else {
            left = this.m_infoDiagramSplitPane;
            right = this.m_rightTabbedPane;
        }
        this.m_diagramTabSplitPane.setLeftComponent(left);
        this.m_diagramTabSplitPane.setRightComponent(right);
        this.m_diagramTabSplitPane.setDividerLocation(left.getWidth());
    }

    public void changeTabsScroll(boolean state) {
        this.m_rightTabbedPane.setTabsScroll(state);
    }

    public void changeTraceLifted(boolean state) {
        this.m_queryBox.setTraceLifted(state);
    }

    public void changeGroupQuery(boolean state) {
        this.m_queryBox.setGroupQuery(state);
    }

    public void changeQueryPersists(boolean state) {
        this.m_queryBox.setQueryPersists(state);
    }

    public void repaintTOC() {
        if (this.m_tocBox != null) {
            this.m_tocBox.repaint();
        }
    }

    public void changeTOC() {
        if (this.m_tocBox != null) {
            this.m_tocBox.fill();
        }
    }

    public void changeLegendQuery() {
        if (this.m_legendBox != null) {
            this.m_legendBox.fill();
        }
        if (this.m_queryBox != null) {
            this.m_queryBox.fill();
        }
    }

    public RelationClass newRelationClass() {
        Diagram diagram = this.getDiagram();
        RelationClass rc = null;
        if (diagram != null) {
            this.beginUndoRedo("New relation class");
            rc = diagram.newRelationClass();
            this.endUndoRedo();
        }
        return rc;
    }

    public void duplicateEdges(RelationClass oldRc) {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            this.beginUndoRedo("Duplicate Edges " + oldRc);
            RelationClass newRc = diagram.newRelationClass();
            if (newRc != null) {
                diagram.duplicateEdges(oldRc, newRc);
            }
            this.endUndoRedo();
        }
    }

    public void moveGroup(int key) {
        this.beginUndoRedo("Move");
        this.m_editModeHandler.moveGroup(key);
        this.endUndoRedo();
    }

    protected void newEntity(Object object) {
        Diagram diagram = this.getDiagram();
        if (diagram == null) {
            this.error("No diagram to add entity to");
            return;
        }
        EntityInstance pe = diagram.targetEntity(object);
        if (pe == null) {
            this.error("No entity to add new entity to");
            return;
        }
        this.beginUndoRedo("New Entity");
        EntityInstance e = diagram.updateNewEntity(null, pe);
        diagram.setInitialLocation(e, pe);
        this.endUndoRedo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout1(LandscapeLayouter layouter, Vector selectedBoxes, EntityInstance parent, boolean force) {
        Runtime r = Runtime.getRuntime();
        Diagram dg = this.getDiagram();
        boolean undo = dg.undoEnabled();
        dg.beginUndoRedo(layouter.getName() + " layout");
        this.setCursor(3);
        try {
            block11: for (int state = 0; state < 2; ++state) {
                String name = layouter.getName();
                try {
                    r.gc();
                    System.out.println(name + ": started");
                    if (!layouter.doLayout1(selectedBoxes, parent)) {
                        LandscapeLayouter layouter1 = layouter.getFallback();
                        state = 0;
                        if (layouter1 == null) {
                            System.out.println(name + ": failed and no fallback strategy");
                            state = 2;
                        }
                        layouter = layouter1;
                        continue;
                    }
                    state = 2;
                    System.out.println(name + ": finished");
                    continue;
                }
                catch (Throwable e) {
                    System.out.print(name + ": " + e.getMessage());
                    if (!force) {
                        state = 2;
                    }
                    switch (state) {
                        case 0: {
                            if (this.clearAllUndoCaches()) {
                                if (undo) {
                                    dg.setUndoEnabled(false);
                                }
                                System.out.println(" - cleared caches");
                                state = 1;
                                continue block11;
                            }
                        }
                        case 1: {
                            layouter = layouter.getFallback();
                            if (layouter != null) {
                                System.out.println(" - fallback to " + layouter.getName());
                                state = 0;
                                continue block11;
                            }
                            System.out.println("");
                            state = 2;
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (undo) {
                dg.setUndoEnabled(true);
            }
            this.setCursor(0);
            dg.endUndoRedo();
        }
    }

    public void navigateToLandscape(EntityInstance e, boolean forward) {
        String lseditDrawRoot;
        String lseditPath;
        if (forward) {
            lseditPath = e.getNavNext();
            if (lseditPath == null) {
                return;
            }
            lseditDrawRoot = e.getNavNextDrawRoot();
        } else {
            lseditPath = e.getNavPrev();
            if (lseditPath == null) {
                return;
            }
            lseditDrawRoot = e.getNavPrevDrawRoot();
        }
        this.attach(lseditPath, lseditDrawRoot);
    }

    public void processKey(int key, int modifiers, Object object) {
        block111: {
            block112: {
                block110: {
                    if ((modifiers & 2) == 0) break block110;
                    switch (key) {
                        case 97: {
                            this.groupAll();
                            break;
                        }
                        case 113: {
                            if (!this.testForClose(false)) break;
                            System.exit(0);
                            break;
                        }
                        case 119: {
                            this.closeEditor();
                            break;
                        }
                        case 110: {
                            this.loadLs("", null, false);
                            break;
                        }
                        case 114: {
                            this.refillDiagram();
                            break;
                        }
                        case 102: {
                            this.find();
                            break;
                        }
                        case 116: {
                            if (this.m_tocBox == null) break;
                            this.m_tocBox.switch_TOC();
                            break;
                        }
                        case 100: {
                            if (!this.m_diagram.set_to_viewport()) break;
                            this.doFeedback("Diagram set to viewport");
                            break;
                        }
                        case 111: {
                            String txt;
                            Object context = null;
                            if (this.m_diagram != null) {
                                context = this.m_diagram.getContext();
                            }
                            if ((txt = context != null ? this.filePrompt("Load Landscape", this.m_diagram.getAbsolutePath(), 0, null) : this.filePrompt("Load Landscape", "", 0, null)) == null) break;
                            this.loadLs(txt, null, true);
                            break;
                        }
                        case 108: {
                            String file = this.filePrompt("Load settings", this.defaultIniPath(), 0, null);
                            if (file != null) {
                                this.loadLseditHistory(m_fileMenu, file);
                            }
                            this.refillDiagram();
                            break;
                        }
                        case 98: {
                            this.getBrowser();
                            break;
                        }
                        case 104: {
                            ExecuteAction.configure(this, -1);
                            break;
                        }
                        case 101: {
                            if (this.m_diagram == null) break;
                            int cnt = this.m_diagram.clearElisions(object);
                            this.doFeedback("Cleared " + cnt + " elisions");
                            if (cnt != 0) {
                                this.refillDiagram();
                                break;
                            }
                            break block111;
                        }
                        case 112: {
                            Vista vista = new Vista(this);
                            break;
                        }
                        case 83: {
                            Object context = this.m_diagram.getContext();
                            String txt = context != null ? this.filePrompt("Save Landscape As", this.m_diagram.getAbsolutePath(), 2, null) : this.filePrompt("Save Landscape As", "", 2, null);
                            if (txt == null || txt.length() == 0) break;
                            this.doSaveLs(txt);
                            break;
                        }
                        case 115: {
                            this.saveLs();
                            break;
                        }
                        case 118: {
                            this.m_diagram.pasteGroup(object);
                            break;
                        }
                        case 120: {
                            this.m_diagram.cutGroup(object);
                            break;
                        }
                        case 122: {
                            if (this.m_diagram == null) break;
                            this.m_diagram.undo();
                            break;
                        }
                        case 121: {
                            if (this.m_diagram == null) break;
                            this.m_diagram.redo();
                            break;
                        }
                        case 106: {
                            if (object != null) {
                                EntityInstance e = (EntityInstance)object;
                                this.navigateToLandscape(e, true);
                            }
                            return;
                        }
                        case 107: {
                            if (object != null) {
                                EntityInstance e = (EntityInstance)object;
                                this.navigateToLandscape(e, false);
                            }
                            return;
                        }
                    }
                    break block111;
                }
                if ((modifiers & 8) == 0) break block112;
                switch (key) {
                    case 74: {
                        if (object == null) break;
                        Diagram diagram = this.m_diagram;
                        if (diagram != null) {
                            this.navigateTo((EntityInstance)object, true);
                            break;
                        }
                        break block111;
                    }
                    case 67: 
                    case 73: 
                    case 79: 
                    case 99: 
                    case 105: 
                    case 111: {
                        if (this.m_diagram == null) break;
                        this.m_diagram.handleEdgeExpansion(key, object, this.getResultBox());
                        break;
                    }
                    case 78: {
                        this.edgeNavigateSrc(object);
                        break;
                    }
                    case 110: {
                        this.edgeNavigateDst(object);
                        break;
                    }
                    case 112: {
                        if (this.m_tocBox == null) break;
                        this.m_tocBox.toc_path();
                        break;
                    }
                    case 38: {
                        this.beginUndoRedo("Align top");
                        this.alignTop();
                        this.endUndoRedo();
                        break;
                    }
                    case 88: {
                        this.beginUndoRedo("Align horizontal center");
                        this.alignHorizontal();
                        this.endUndoRedo();
                        break;
                    }
                    case 40: {
                        this.beginUndoRedo("Align bottom");
                        this.alignBottom();
                        this.endUndoRedo();
                        break;
                    }
                    case 37: {
                        this.beginUndoRedo("Align vertical left");
                        this.alignLeft();
                        this.endUndoRedo();
                        break;
                    }
                    case 39: {
                        this.beginUndoRedo("Align vertical right");
                        this.alignRight();
                        this.endUndoRedo();
                        break;
                    }
                    case 89: {
                        this.beginUndoRedo("Align vertical center");
                        this.alignVertical();
                        this.endUndoRedo();
                        break;
                    }
                    case 102: {
                        this.beginUndoRedo("Fit label");
                        this.fitToLabel();
                        this.endUndoRedo();
                        break;
                    }
                    case 103: {
                        this.updateCreateContainedGroup();
                        break;
                    }
                    case 119: {
                        this.beginUndoRedo("Same width");
                        this.sameWidth();
                        this.endUndoRedo();
                        break;
                    }
                    case 104: {
                        this.beginUndoRedo("Same height");
                        this.sameHeight();
                        this.endUndoRedo();
                        break;
                    }
                    case 120: {
                        this.beginUndoRedo("Same size");
                        this.sameSize();
                        this.endUndoRedo();
                        break;
                    }
                    case 87: {
                        this.beginUndoRedo("Space horizontally");
                        this.equalHorizontalSpacing();
                        this.endUndoRedo();
                        break;
                    }
                    case 72: {
                        this.beginUndoRedo("Space vertically");
                        this.equalVerticalSpacing();
                        this.endUndoRedo();
                        break;
                    }
                    case 106: {
                        String msg = this.m_diagram.relayoutAll();
                        if (msg == null) break;
                        this.doFeedback(msg);
                        break;
                    }
                    case 114: {
                        String msg = this.m_diagram.closeAll();
                        if (msg != null) {
                            this.doFeedback(msg);
                        }
                        this.refillDiagram();
                        break;
                    }
                    case 82: {
                        String msg = this.m_diagram.openAll();
                        if (msg != null) {
                            this.doFeedback(msg);
                        }
                        this.refillDiagram();
                        break;
                    }
                    case 70: {
                        FontChooser.create(this);
                        break;
                    }
                    case 77: 
                    case 109: {
                        if (this.m_diagram == null) break;
                        this.beginUndoRedo("Magnify");
                        String msg = this.m_diagram.scaleEntity(key, !this.m_editModeHandler.mouseIsDown());
                        this.endUndoRedo();
                        if (msg != null) {
                            this.doFeedback(msg);
                        }
                        this.refillDiagram();
                        break;
                    }
                    case 101: {
                        Diagram diagram = this.getDiagram();
                        if (diagram == null) break;
                        diagram.newEntityClass();
                        break;
                    }
                    case 69: {
                        this.newRelationClass();
                        break;
                    }
                    case 90: {
                        this.validateAll();
                        break;
                    }
                    case 97: {
                        EditElisions dialog = new EditElisions(this.getFrame(), this, object);
                        dialog.dispose();
                        break;
                    }
                    case 98: {
                        if (object instanceof EntityInstance) {
                            this.m_diagram.setRedBoxFlag((EntityInstance)object);
                            break;
                        }
                        this.redboxEntities();
                        break;
                    }
                    case 122: {
                        if (this.m_diagram == null) break;
                        this.m_diagram.checkRefcnts(this.getResultBox());
                    }
                }
                break block111;
            }
            if (modifiers == 1) {
                switch (key) {
                    case 10: {
                        this.navigateToDrawRootParent();
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.m_queryBox.activate();
                        this.m_queryBox.toggleFlags(key - 48);
                        this.refillDiagram();
                        this.requestFocus();
                    }
                }
            } else if (modifiers == 0) {
                switch (key) {
                    case 27: {
                        boolean cleared = this.m_diagram.clearFlags(true);
                        this.doFeedback("Query/selection cleared");
                        this.m_editModeHandler.cleanup();
                        if (!cleared) break;
                        this.refillDiagram();
                        break;
                    }
                    case 34: {
                        if (this.m_historyBox == null) break;
                        this.m_historyBox.navigatePrevious();
                        break;
                    }
                    case 33: {
                        if (this.m_historyBox == null) break;
                        this.m_historyBox.navigateNext();
                        break;
                    }
                    case 100: {
                        if (this.m_diagram == null) break;
                        int cnt = this.m_diagram.toggleDescendants(object);
                        this.doFeedback("Opened/closed " + cnt + " entities");
                        if (cnt == 0) break;
                        this.refillDiagram();
                        break;
                    }
                    case 66: 
                    case 70: 
                    case 82: 
                    case 86: 
                    case 98: 
                    case 102: 
                    case 118: {
                        if (this.m_diagram == null) break;
                        this.m_diagram.queryEntity(key, object, this.getResultBox(), -1);
                        break;
                    }
                    case 73: 
                    case 83: 
                    case 85: 
                    case 99: 
                    case 115: 
                    case 117: {
                        if (this.m_diagram == null) break;
                        String msg = this.m_diagram.handleElision(key, object);
                        if (msg != null) {
                            this.doFeedback(msg);
                        }
                        this.refillDiagram();
                        break;
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 120: 
                    case 121: 
                    case 122: {
                        if (this.m_diagram == null) break;
                        this.beginUndoRedo("Scale");
                        String msg = this.m_diagram.scaleEntity(key, !this.m_editModeHandler.mouseIsDown());
                        this.endUndoRedo();
                        if (msg == null) break;
                        this.doFeedback(msg);
                        break;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.moveGroup(key);
                        break;
                    }
                    case 36: {
                        EntityInstance e;
                        Diagram diagram = this.getDiagram();
                        if (diagram == null || (e = diagram.getRootInstance()) == null) break;
                        EntityInstance drawRoot = diagram.getDrawRoot();
                        if (e == drawRoot) {
                            this.error("Already in: " + e.getEntityLabel());
                            break;
                        }
                        this.followLink(e, false);
                        break;
                    }
                    case 10: {
                        EntityInstance e;
                        Diagram diagram = this.getDiagram();
                        if (diagram == null || (e = diagram.targetEntity(object)) == null) break;
                        EntityInstance drawRoot = diagram.getDrawRoot();
                        if (e == drawRoot) {
                            this.error("Already in: " + e.getEntityLabel());
                            break;
                        }
                        this.followLink(e, e.isClientOrSupplier());
                        break;
                    }
                    case 127: {
                        this.m_diagram.doDelete(object);
                        break;
                    }
                    case 84: {
                        this.beginUndoRedo("Increase Font");
                        this.shiftDeltaFont(1);
                        this.endUndoRedo();
                        break;
                    }
                    case 116: {
                        this.beginUndoRedo("Decrease Font");
                        this.shiftDeltaFont(-1);
                        this.endUndoRedo();
                        break;
                    }
                    case 69: {
                        Diagram diagram = this.getDiagram();
                        if (diagram == null || diagram.getRootInstance() == null) break;
                        this.m_editModeHandler.newEdge(object);
                        break;
                    }
                    case 101: {
                        this.newEntity(object);
                        break;
                    }
                    case 65: {
                        LandscapeObject landscapeObject;
                        Diagram diagram = this.getDiagram();
                        if (diagram == null || (landscapeObject = diagram.targetEntityRelation(object)) == null) break;
                        if (landscapeObject instanceof EntityInstance) {
                            EntityInstance e = (EntityInstance)landscapeObject;
                            EditAttribute.Create(this, e.getEntityClass());
                            break;
                        }
                        RelationInstance ri = (RelationInstance)landscapeObject;
                        EditAttribute.Create(this, ri.getRelationClass());
                        break;
                    }
                    case 97: {
                        LandscapeObject landscapeObject;
                        Diagram diagram = this.getDiagram();
                        if (diagram == null || (landscapeObject = diagram.targetEntityRelation(object)) == null) break;
                        if (landscapeObject instanceof EntityInstance) {
                            EntityInstance e = (EntityInstance)landscapeObject;
                            EditAttribute.Create(this, e);
                            break;
                        }
                        RelationInstance ri = (RelationInstance)landscapeObject;
                        EditAttribute.Create(this, ri);
                        break;
                    }
                    case 107: {
                        EntityInstance e;
                        Diagram diagram = this.getDiagram();
                        if (diagram == null || (e = diagram.targetEntity(object)) == null) break;
                        this.deleteContainer(e);
                        break;
                    }
                    case 71: 
                    case 103: {
                        Diagram diagram = this.getDiagram();
                        if (diagram == null) break;
                        diagram.groupRedBoxes(key == 103);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.m_legendBox.activate();
                        this.m_legendBox.toggleFlags(key - 48);
                        this.refillDiagram();
                        this.requestFocus();
                        break;
                    }
                    case 1137: {
                        this.findPrev();
                        break;
                    }
                    case 1138: {
                        this.findNext();
                        break;
                    }
                    case 1136: {
                        JOptionPane.showMessageDialog(this.m_frame, LandscapeEditorCore.getTitle() + " " + Version.Details(this.getDiagram()), "About " + LandscapeEditorCore.getTitle(), 0);
                        break;
                    }
                    case 1146: {
                        this.about();
                        break;
                    }
                    case 1147: {
                        this.help();
                        break;
                    }
                    case 87: {
                        Diagram diagram = this.m_diagram;
                        if (diagram == null) break;
                        diagram.redistribute();
                        break;
                    }
                    case 119: {
                        Diagram diagram = this.m_diagram;
                        if (diagram == null) break;
                        diagram.group_unconnected();
                        break;
                    }
                    case 75: {
                        if (this.m_diagram == null) break;
                        this.m_diagram.clusterMetrics();
                        break;
                    }
                    case 104: 
                    case 1139: 
                    case 1140: 
                    case 1141: 
                    case 1142: 
                    case 1143: 
                    case 1144: 
                    case 1145: {
                        this.showSource(object, key);
                        break;
                    }
                    case 111: {
                        OptionsDialog.create(this);
                        break;
                    }
                    case 72: {
                        this.beginUndoRedo("Avoid collisions");
                        this.avoidCollisions();
                        this.endUndoRedo();
                    }
                }
            }
        }
    }

    public Font getFont() {
        if (this.m_frame != null) {
            return this.m_frame.getFont();
        }
        return this.m_applet.getFont();
    }

    public void setHandicapped(int size) {
        this.m_handicapped = size;
    }

    public int getForward() {
        return this.m_forward;
    }

    public void setForward(int value) {
        this.m_forward = value;
    }

    public void setForward(String value) {
        if (value != null) {
            this.setForward(Util.parseInt(value, -1));
        }
    }

    public EntityInstance getForwardEntity() {
        return this.m_forwardEntity;
    }

    public void clearForwardEntity() {
        this.m_forwardEntity = null;
    }

    public void showValidAttributes(LandscapeClassObject o) {
        ResultBox resultBox = this.getResultBox();
        resultBox.clear();
        this.m_diagram.showValidAttributes(o, resultBox);
    }

    public void validateEntityAttributes(EntityClass ec) {
        ResultBox resultBox = this.getResultBox();
        resultBox.clear();
        this.m_diagram.validateEntityAttributes(ec, resultBox, true);
    }

    public void validateRelationAttributes(RelationClass rc) {
        ResultBox resultBox = this.getResultBox();
        resultBox.clear();
        this.m_diagram.validateRelationAttributes(rc, resultBox, true);
    }

    public void validateRelations(RelationClass rc) {
        ResultBox resultBox = this.getResultBox();
        resultBox.clear();
        this.m_diagram.validateRelations(rc, resultBox, true);
    }

    public void validateAll() {
        ResultBox resultBox = this.getResultBox();
        resultBox.clear();
        this.m_diagram.validateAll(resultBox);
    }

    @Override
    public void showProgress(String str) {
        if (this.m_nameBox != null) {
            this.m_nameBox.set(str);
        }
    }

    @Override
    public void doFeedback(String str) {
        if (this.m_feedback != null) {
            this.m_feedback.set(str);
        }
    }

    @Override
    public void showInfo(String str) {
        if (this.m_nameBox != null) {
            this.m_nameBox.set(str);
        }
    }

    @Override
    public void error(String msg) {
        this.doFeedback(msg);
        Util.beep();
    }

    public void showCycle1(ResultBox resultBox, RelationInstance ri) {
        EntityInstance parent = ri.getSrc();
        if (!parent.isMarked(0x100000)) {
            this.showCycle1(resultBox, parent.getContainedByRelation());
        }
        resultBox.addRelation(indAdd, ri);
    }

    @Override
    public void showCycle(RelationInstance ri) {
        ResultBox resultBox = this.getResultBox();
        if (resultBox != null) {
            resultBox.activate();
            resultBox.addResultTitle("Cycle using " + ri.getParentClass().getLabel());
            this.showCycle1(resultBox, ri);
        }
    }

    @Override
    public void noContainRelation(String taPath) {
        JOptionPane.showMessageDialog(this.getFrame(), "No containing relation class defined", "Unable to load '" + taPath + "'", 0);
    }

    @Override
    public void hasMultipleParents(RelationClass rc, EntityInstance e) {
        Diagram diagram = this.getDiagram();
        String containsLabel = rc.getLabel();
        JFrame frame = this.getFrame();
        ResultBox resultBox = this.getResultBox();
        if (resultBox != null) {
            resultBox.activate();
            resultBox.addResultTitle("Parents of " + e);
            Vector v = e.getDstRelList();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                RelationInstance ri = (RelationInstance)v.elementAt(i);
                if (ri.getRelationClass() != rc) continue;
                resultBox.addRelation(indAdd, ri);
            }
        }
    }

    public void invertUndo() {
        if (this.m_undoBox != null) {
            this.m_undoBox.invertUndo();
        }
    }

    public void fixupFind() {
        if (this.m_findResults != null && this.m_findResults.entityCut()) {
            boolean state;
            ToolBarButton button = this.m_toolButton[PREV_FIND_BUTTON];
            boolean change = false;
            boolean bl = state = !this.m_findResults.atBeginning();
            if (button.isEnabled() != state) {
                button.setEnabled(state);
                change = true;
            }
            button = this.m_toolButton[NEXT_FIND_BUTTON];
            boolean bl2 = state = !this.m_findResults.atEnd();
            if (button.isEnabled() != state) {
                button.setEnabled(state);
                change = true;
            }
            if (change) {
                this.refillToolbar();
            }
        }
    }

    @Override
    public void diagramChanging(Diagram diagram) {
    }

    @Override
    public void diagramChanged(Diagram diagram, int signal) {
        if (this.m_findResults != null && signal == 44) {
            this.m_findResults.clear();
        }
    }

    @Override
    public void updateBegins() {
    }

    @Override
    public void updateEnds() {
    }

    @Override
    public void entityClassChanged(EntityClass ec, int signal) {
    }

    @Override
    public void relationClassChanged(RelationClass rc, int signal) {
    }

    @Override
    public void entityParentChanged(EntityInstance e, EntityInstance parent, int signal) {
        switch (signal) {
            case 12: 
            case 15: {
                this.fixupFind();
            }
        }
    }

    @Override
    public void relationParentChanged(RelationInstance ri, int signal) {
    }

    @Override
    public void entityInstanceChanged(EntityInstance e, int signal) {
    }

    @Override
    public void relationInstanceChanged(RelationInstance ri, int signal) {
    }

    @Override
    public void setPreferredSizeUndo(Vector edits, UndoableEdit lastEdit) {
        if (this.m_undoBox != null) {
            this.m_undoBox.setNewPreferredSize(edits, lastEdit);
        }
    }

    @Override
    public void undoHistoryChanged() {
        if (this.m_undoBox != null && this.m_undoBox.isActive()) {
            this.m_undoBox.fill();
        }
    }

    @Override
    public boolean processMetaKeyEvent(String name) {
        if (name != null) {
            String urlname = this.m_helpURL + "/action.html#" + Util.encodedURLname(name);
            this.showURL(urlname, 4);
            return true;
        }
        return false;
    }

    @Override
    public void processKeyEvent(int key, int modifiers, Object object) {
        if (key <= 90) {
            if (key >= 65) {
                if ((modifiers & 1) != 0) {
                    modifiers &= 0xFFFFFFFE;
                } else {
                    key += 32;
                }
            }
        } else if (key >= 112 && key <= 123 && (modifiers & 0xA) == 0) {
            key += 1024;
        }
        this.processKey(key, modifiers, object);
    }

    public void infoShown(LandscapeObject object) {
        if (LandscapeObject.g_infoShown != object) {
            LandscapeObject.g_infoShown = object;
            this.m_attributeBox.show(object);
        }
    }

    static {
        m_openFrames = 1;
        PREV_HISTORY_BUTTON = 13;
        NEXT_HISTORY_BUTTON = 14;
        PREV_FIND_BUTTON = 15;
        NEXT_FIND_BUTTON = 16;
        g_showSourceKeys = new int[]{104, 1139, 1140, 1141, 1142, 1143, 1144, 1145};
    }
}

