/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.EdgePoint;
import lsedit.ElidedInfo;
import lsedit.EntityInstance;
import lsedit.MoveModeHandler;
import lsedit.Options;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.Util;

class InElidedInfo
extends ElidedInfo {
    private EntityInstance m_dstEntity;
    private EdgePoint m_dst;
    int m_srcX;
    int m_srcY;

    @Override
    public void getBounds(Rectangle r) {
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        this.getBounds(this.m_srcX, this.m_srcY, (int)dstEntity.getEdgePointX(dst), (int)dstEntity.getEdgePointY(dst), r);
    }

    @Override
    public boolean contains(int x, int y) {
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        return InElidedInfo.nearLine(this.m_srcX, this.m_srcY, dstEntity.getEdgePointX(dst), dstEntity.getEdgePointY(dst), x, y);
    }

    @Override
    public void paintComponent(Graphics g, int shiftX, int shiftY) {
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        int srcX = this.m_srcX - shiftX;
        int srcY = this.m_srcY - shiftY;
        int dstX = (int)(dstEntity.getEdgePointX(dst) - (double)shiftX);
        int dstY = (int)(dstEntity.getEdgePointY(dst) - (double)shiftY);
        double fraction = Util.drawArrowHead(g, srcX, srcY, dstX, dstY, 1);
        dstX -= (int)((double)(dstX - srcX) * fraction);
        dstY -= (int)((double)(dstY - srcY) * fraction);
        Util.drawSegment(g, this.m_style, srcX, srcY, dstX, dstY);
    }

    public InElidedInfo(RelationComponent component) {
        this.m_component = component;
    }

    @Override
    public void setElidedInfo(EntityInstance srcEntity, EdgePoint srcPt, EntityInstance dstEntity, EdgePoint dstPt) {
        double dstX = dstEntity.getEdgePointX(dstPt);
        double dstY = dstEntity.getEdgePointY(dstPt);
        double dx = srcEntity.getEdgePointX(srcPt) - dstX;
        double dy = srcEntity.getEdgePointY(srcPt) - dstY;
        double df = Math.sqrt(dx * dx + dy * dy);
        double arrowLength = Options.getArrowLength();
        if (df == 0.0) {
            this.m_srcX = (int)(dstX + 2.0 * arrowLength);
            this.m_srcY = (int)(dstY + 2.0 * arrowLength);
        } else {
            this.m_srcX = (int)(dstX + dx * 2.0 * arrowLength / df);
            this.m_srcY = (int)(dstY + dy * 2.0 * arrowLength / df);
        }
        this.m_dstEntity = dstEntity;
        this.m_dst = dstPt;
    }

    @Override
    public boolean mouseOverEdgePoint(int x, int y, MoveModeHandler handler) {
        EntityInstance dstEntity = this.m_dstEntity;
        EdgePoint dst = this.m_dst;
        if (InElidedInfo.nearPoint(dstEntity.getEdgePointX(dst), dstEntity.getEdgePointY(dst), x, y)) {
            RelationInstance ri = this.m_component.getRelationInstance();
            handler.overEdgePointCallBack(dstEntity, ri, dst);
            return true;
        }
        return false;
    }

    @Override
    public void switchEdgePoint(EdgePoint oldPoint, EdgePoint newPoint) {
        if (this.m_dst == oldPoint) {
            this.m_dst = newPoint;
        }
    }

    public String toString() {
        return "In elided " + this.m_dstEntity.getLabel();
    }
}

