/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Font;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.Option;
import lsedit.Options;
import lsedit.SelectedElisions;

public class IconCache {
    private static final int m_initialCapacity = 200;
    private static final float m_loadFactor = 0.75f;
    private static Entry[] m_table = null;
    private static int m_count = 0;
    static Icon[] g_elisionCache = new Icon[256];
    private static int m_threshold = 150;

    public static int size() {
        return m_count;
    }

    public static boolean isEmpty() {
        return m_count == 0;
    }

    public static void clearElisionCache() {
        g_elisionCache = null;
    }

    public static void clear() {
        Entry[] tab = m_table;
        if (tab != null) {
            int index = tab.length;
            while (--index >= 0) {
                tab[index] = null;
            }
        }
        m_count = 0;
        IconCache.clearElisionCache();
    }

    protected static void rehash() {
        Entry[] oldMap = m_table;
        int oldCapacity = oldMap.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        m_threshold = (int)((float)newCapacity * 0.75f);
        m_table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.m_next;
                int index = (e.m_name.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.m_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    protected static void put(String name, Icon icon) {
        Entry[] table = m_table;
        if (m_count >= m_threshold) {
            IconCache.rehash();
            table = m_table;
        }
        int index = (name.hashCode() & Integer.MAX_VALUE) % table.length;
        table[index] = new Entry(name, icon, table[index]);
        ++m_count;
    }

    public static Icon lookup(String name) {
        Entry[] tab = m_table;
        if (tab != null) {
            int index = (name.hashCode() & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (name.compareTo(e.m_name) == 0) {
                    return e.m_value;
                }
                e = e.m_next;
            }
        }
        return null;
    }

    public static Icon get(String name, EntityClass entityClass) {
        File file;
        Entry[] tab = m_table;
        ImageIcon icon = null;
        if (tab == null) {
            m_table = tab = new Entry[200];
        }
        String name1 = name = name.replace('\\', '/');
        if (name.length() > 0) {
            file = new File(name);
            if (!file.isAbsolute()) {
                Option diagramOptions = Options.getDiagramOptions();
                String path = diagramOptions.getIconPath();
                Diagram diagram = null;
                String diagramDir = null;
                if (path != null && path.length() > 0) {
                    while (true) {
                        String path1;
                        if (path == null) {
                            return null;
                        }
                        int index = path.indexOf(59);
                        if (index < 0) {
                            path1 = path;
                            path = null;
                        } else {
                            path1 = path.substring(0, index);
                            path = path.substring(index + 1);
                        }
                        if ((path1 = path1.trim()).length() == 0) continue;
                        name1 = path1 + "/" + name;
                        if (name1.startsWith("./")) {
                            Object context;
                            if (diagram == null && (context = (diagram = entityClass.getDiagram()).getContext()) != null && context instanceof File) {
                                diagramDir = ((File)context).getParent();
                            }
                            if (diagramDir != null) {
                                name1 = diagramDir.replace('\\', '/') + "/" + name1.substring(2);
                            }
                        }
                        if ((file = new File(name1)).exists()) break;
                    }
                }
            }
            if (file.canRead()) {
                icon = new ImageIcon(name1);
                IconCache.put(name, icon);
            }
        }
        file = null;
        return icon;
    }

    public static Icon getElisionIcon(int elisions, String text) {
        Icon icon;
        if (g_elisionCache == null) {
            g_elisionCache = new Icon[64];
        }
        if ((icon = g_elisionCache[elisions &= 0x3F]) == null) {
            IconCache.g_elisionCache[elisions] = icon = new SelectedElisions(elisions | 0x40 | 0x80);
            ((JLabel)((Object)icon)).setText(text);
        }
        return icon;
    }

    public static void setElisionIconFont(Font font) {
        if (g_elisionCache != null) {
            int i = g_elisionCache.length;
            while (--i >= 0) {
                JLabel label = (JLabel)((Object)g_elisionCache[i]);
                if (label == null) continue;
                label.setFont(font);
            }
        }
    }

    static class Entry {
        public String m_name;
        public Icon m_value;
        public Entry m_next;

        protected Entry(String name, Icon icon, Entry next) {
            this.m_name = name;
            this.m_value = icon;
            this.m_next = next;
        }
    }
}

