/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;

class HiSimplex {
    static final boolean debug = false;

    HiSimplex() {
    }

    public static void dump_constraints(HiGraph node) {
        HiGraph child;
        HiArc arc;
        System.out.print(node + ":");
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            child = arc.to();
            System.out.print(" =" + arc.getMinlength() + "(" + arc.getWeight() + ")=>" + child);
        }
        e = node.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            child = arc.to();
            System.out.print(" -" + arc.getMinlength() + "(" + arc.getWeight() + ")->" + child);
        }
        System.out.print("\n");
        e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            child = arc.to();
            HiSimplex.dump_constraints(child);
        }
    }

    private static void destroy_span(HiGraph node) throws HiGraphException {
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            HiSimplex.destroy_span(child);
        }
        node.m_span.removeAllElements();
        node.m_span = null;
        node.m_back = null;
    }

    private static void dumpspan(HiGraph node) {
        HiArc arc;
        for (int i = 0; i < node.m_rank; ++i) {
            System.out.print(" ");
        }
        System.out.print("[rank=" + node.m_rank + " weight=" + node.m_weight + "]" + node.label());
        Enumeration e = node.m_span.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            System.out.print(" (cut=" + arc.cutValue() + ")" + arc);
        }
        System.out.print("\n");
        e = node.m_span.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            if (child == node) {
                child = arc.from();
            }
            HiSimplex.dumpspan(child);
        }
    }

    private static void dumpspantree(HiGraph node) {
        System.out.println("Dumping graph because of " + node);
        HiGraph root = node;
        while (root.m_parent != null) {
            root = root.m_parent.from();
        }
        root.dump();
        System.out.println("Dumping spanning tree");
        root = node;
        while (root.m_back != null) {
            if (root == root.m_back.from()) {
                root = root.m_back.to();
                continue;
            }
            root = root.m_back.from();
        }
        HiSimplex.dumpspan(root);
    }

    private static int prepareGraph(HiGraph node) {
        int nodes = 1;
        node.m_visited = 0;
        node.m_rank = 0;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            nodes += HiSimplex.prepareGraph(child);
        }
        return nodes;
    }

    private static void placeBelow(HiGraph node) throws HiGraphException {
        HiGraph other;
        HiArc arc;
        int i;
        Vector arcs = node.m_children;
        int size = arcs.size();
        for (i = 0; i < size; ++i) {
            arc = (HiArc)arcs.elementAt(i);
            other = arc.to();
            HiSimplex.placeBelow(other);
        }
        if (size == 0) {
            return;
        }
        arcs = node.m_out;
        size = arcs.size();
        for (i = 0; i < size; ++i) {
            HiArc arc1;
            arc = (HiArc)arcs.elementAt(i);
            if (arc.onSide()) continue;
            HiGraph ancestor = other = arc.to();
            while (ancestor != node && (arc1 = ancestor.m_parent) != null) {
                ancestor = arc1.from();
            }
            if (ancestor == node) continue;
            other.newInputArc(node.m_sink);
        }
    }

    private static void fixCycles(HiGraph node) throws HiGraphException {
        if (node.m_visited == 0) {
            HiArc arc;
            node.m_visited = 1;
            Vector children = node.m_children;
            int i = children.size();
            while (i > 0) {
                arc = (HiArc)children.elementAt(--i);
                HiSimplex.fixCycles(arc.to());
            }
            Vector out = node.m_out;
            i = out.size();
            while (i > 0) {
                arc = (HiArc)out.elementAt(--i);
                HiGraph to = arc.to();
                if (to.m_visited == 1) {
                    HiGraph.removeArc(out, arc);
                    HiGraph.removeArc(to.m_in, arc);
                    arc.reverse();
                    to.m_out.addElement(arc);
                    node.m_in.addElement(arc);
                    continue;
                }
                HiSimplex.fixCycles(to);
            }
            node.m_visited = 2;
        }
    }

    private static void countInputArcs(HiGraph node) {
        if (node.m_span == null) {
            node.m_span = new Vector();
        }
        node.m_inputs = (node.m_parent != null ? 1 : 0) + node.m_in.size();
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            HiSimplex.countInputArcs(child);
        }
    }

    private static int feasibleRank(HiGraph node, int tail, HiArc[] queue) {
        Enumeration e = node.m_children.elements();
        for (int i = 0; i < 2; ++i) {
            while (e.hasMoreElements()) {
                HiGraph other;
                HiArc arc = (HiArc)e.nextElement();
                HiGraph child = arc.to();
                int rank = node.m_rank + arc.getMinlength();
                if (rank > child.m_rank) {
                    child.m_rank = rank;
                }
                if (--child.m_inputs != 0) continue;
                if (rank == child.m_rank) {
                    other = node;
                } else {
                    Enumeration e1 = child.m_in.elements();
                    while (e1.hasMoreElements()) {
                        arc = (HiArc)e1.nextElement();
                        other = arc.from();
                        rank = other.m_rank + arc.getMinlength();
                        if (rank != child.m_rank) continue;
                    }
                    if (rank != child.m_rank) {
                        arc = child.m_parent;
                        other = arc.from();
                        rank = other.m_rank + arc.getMinlength();
                        if (rank != child.m_rank) {
                            System.out.println("Can't find tight arc for " + node + " " + child);
                        }
                    }
                }
                child.m_back = arc;
                other = arc.from();
                other.m_span.addElement(arc);
                queue[tail++] = arc;
            }
            e = node.m_out.elements();
        }
        return tail;
    }

    private static int isfeasible(HiGraph node) throws HiGraphException {
        int ret = 0;
        node.m_visited = 0;
        for (int i = 0; i < 2; ++i) {
            Enumeration e;
            Enumeration enumeration = e = i == 0 ? node.m_children.elements() : node.m_out.elements();
            while (e.hasMoreElements()) {
                HiArc arc = (HiArc)e.nextElement();
                HiGraph child = arc.to();
                int slack = child.m_rank - node.m_rank - arc.getMinlength();
                if (slack < 0) {
                    throw new HiGraphException("Graph no longer feasible on " + arc + " " + child.m_rank + "-" + node.m_rank + "<" + arc.getMinlength());
                }
                ret += slack * arc.getWeight();
                if (i != 0) continue;
                ret += HiSimplex.isfeasible(child);
            }
        }
        return ret;
    }

    private static void spantreevalid1(HiGraph node) throws HiGraphException {
        if (node.m_visited != 0) {
            throw new HiGraphException("Spanning tree is not a tree");
        }
        node.m_visited = 1;
        Enumeration e = node.m_span.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            HiGraph other = arc.from();
            if (child != node) {
                if (child.m_rank - other.m_rank != arc.getMinlength()) {
                    throw new HiGraphException("Spanning arc " + arc + " not tight " + child.m_rank + "-" + other.m_rank + "!=" + arc.getMinlength());
                }
            } else {
                other = child;
                child = arc.from();
                if (other.m_rank - child.m_rank != arc.getMinlength()) {
                    throw new HiGraphException("Spanning arc " + arc + " not tight " + other.m_rank + "-" + child.m_rank + "!=" + arc.getMinlength());
                }
            }
            if (child.m_postorder >= node.m_postorder || child.m_postorder < node.m_minbeneath) {
                throw new HiGraphException("Post order wrong");
            }
            if (other != node) {
                throw new HiGraphException("Spanning arc broken");
            }
            HiSimplex.spantreevalid1(child);
        }
    }

    private static void spantreevalid2(HiGraph node) throws HiGraphException {
        if (node.m_visited == 0) {
            throw new HiGraphException("Spanning tree never connected " + node.label());
        }
        node.m_visited = 0;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            HiSimplex.spantreevalid2(child);
        }
    }

    private static void isvalid(HiGraph root) throws HiGraphException {
        int slack = HiSimplex.isfeasible(root);
        HiGraph spanroot = root;
        while (spanroot.m_back != null) {
            spanroot = spanroot.m_back.from();
        }
        HiSimplex.spantreevalid1(spanroot);
        HiSimplex.spantreevalid2(root);
    }

    private static void computeWeights(HiGraph node) {
        int weight = 0;
        HiArc arc = node.m_parent;
        if (arc != null) {
            weight = arc.getWeight();
        }
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            weight -= arc.getWeight();
            HiGraph child = arc.to();
            HiSimplex.computeWeights(child);
        }
        e = node.m_in.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            weight += arc.getWeight();
            if (arc.from().m_out.contains(arc)) continue;
            System.out.println("Input arc " + arc + " broken when computing weights");
        }
        e = node.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            weight -= arc.getWeight();
            if (arc.to().m_in.contains(arc)) continue;
            System.out.println("Output arc " + arc + " broken when computing weights");
        }
        node.m_weight = weight;
    }

    private static void postorder(HiGraph node, int min) {
        HiArc arc;
        HiGraph down = null;
        int max = min;
        int cut = 0;
        node.m_minbeneath = min;
        Enumeration e = node.m_span.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            down = arc.to();
            int minlength = arc.getMinlength();
            if (down != node) {
                down.m_rank = node.m_rank + minlength;
            } else {
                down = arc.from();
                down.m_rank = node.m_rank - minlength;
            }
            HiSimplex.postorder(down, max);
            cut += arc.cutValue();
            max = down.m_postorder + 1;
        }
        node.m_postorder = max;
        cut += node.m_weight;
        arc = node.m_back;
        if (arc != null) {
            arc.cutValue(cut);
        }
    }

    private static HiArc alternativeEdge(HiArc old, int tail, HiArc[] path, int replace) throws HiGraphException {
        int start;
        boolean shift_down = true;
        HiArc ret = null;
        HiGraph root = old.to();
        HiGraph child = old.from();
        int maxslack = Integer.MAX_VALUE;
        if (root.m_postorder > child.m_postorder) {
            root = child;
            shift_down = false;
        }
        int minbeneath = root.m_minbeneath;
        int postorder = root.m_postorder;
        int head = start = replace;
        do {
            boolean node_under_root;
            HiArc arc = path[head];
            HiGraph node = arc.to();
            if (node.m_back != arc) {
                node = arc.from();
            }
            boolean bl = node_under_root = node.m_postorder >= minbeneath && node.m_postorder <= postorder;
            if (node_under_root ^ shift_down) {
                int slack;
                HiGraph parent;
                Enumeration e = node.m_in.elements();
                while (e.hasMoreElements()) {
                    arc = (HiArc)e.nextElement();
                    if (arc == old) continue;
                    parent = arc.from();
                    if (!((parent.m_postorder >= minbeneath && parent.m_postorder <= postorder) ^ node_under_root) || (slack = node.m_rank - parent.m_rank - arc.getMinlength()) >= maxslack) continue;
                    maxslack = slack;
                    ret = arc;
                }
                arc = node.m_parent;
                if (arc == null) {
                    throw new HiGraphException("AlternativeNodeEdge examining root?");
                }
                if (arc != old) {
                    parent = arc.from();
                    if ((parent.m_postorder >= minbeneath && parent.m_postorder <= postorder) ^ node_under_root && (slack = node.m_rank - parent.m_rank - arc.getMinlength()) < maxslack) {
                        maxslack = slack;
                        ret = arc;
                    }
                }
            }
            if (++head != tail) continue;
            head = 0;
        } while (head != start);
        return ret;
    }

    private static void updateSpanningTree(HiArc old, HiArc alternative) throws HiGraphException {
        HiGraph next;
        HiArc back;
        HiGraph node;
        HiGraph oldhead = old.from();
        HiGraph oldtail = old.to();
        if (oldhead.m_postorder > oldtail.m_postorder) {
            node = oldhead;
            oldhead = oldtail;
            oldtail = node;
        }
        HiGraph newhead = alternative.from();
        HiGraph newtail = alternative.to();
        if (newhead.m_postorder < oldhead.m_minbeneath || newhead.m_postorder > oldhead.m_postorder) {
            node = newhead;
            newhead = newtail;
            newtail = node;
        }
        if (newhead.m_postorder > oldhead.m_postorder || newhead.m_postorder < oldhead.m_minbeneath) {
            throw new HiGraphException("Alternative head " + newhead + " in " + alternative + " doesn't address disconnected component " + oldhead + " in " + old);
        }
        if (newtail.m_postorder <= oldhead.m_postorder && newtail.m_postorder >= oldhead.m_minbeneath) {
            throw new HiGraphException("Alternative tail " + newtail + " in " + alternative + " doesn't address connected component " + oldhead + " in " + old);
        }
        HiArc newback = alternative;
        HiGraph previous = newtail;
        node = newhead;
        while (node != oldtail) {
            back = node.m_back;
            if (back == null) {
                System.out.println("Back null!!!");
            }
            node.m_back = newback;
            previous.m_span.addElement(newback);
            next = back.from();
            if (next == node) {
                next = back.to();
            }
            HiGraph.removeArc(next.m_span, back);
            previous = node;
            newback = back;
            node = next;
        }
        int min = newhead.m_postorder;
        int max = newtail.m_postorder;
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        node = oldtail;
        while (node.m_minbeneath > min || node.m_postorder < max) {
            back = node.m_back;
            next = back.to();
            if (next == node) {
                next = back.from();
            }
            node = next;
        }
        HiSimplex.postorder(node, node.m_minbeneath);
    }

    static void simplex(HiGraph root, int maxcycles) throws HiGraphException {
        HiGraph node;
        int head;
        int nodes = HiSimplex.prepareGraph(root);
        HiArc[] path = new HiArc[nodes];
        if (root.m_sink != null) {
            HiSimplex.placeBelow(root);
        }
        HiSimplex.fixCycles(root);
        HiSimplex.countInputArcs(root);
        root.m_rank = 0;
        int tail = HiSimplex.feasibleRank(root, 0, path);
        for (head = 0; head < tail; ++head) {
            node = path[head].to();
            tail = HiSimplex.feasibleRank(node, tail, path);
        }
        HiSimplex.computeWeights(root);
        HiSimplex.postorder(root, 1);
        head = 0;
        int count = maxcycles;
        int replace = 0;
        if (tail != 0) {
            HiArc arc;
            for (count = maxcycles; count != 0; --count) {
                int start;
                head = start = replace;
                int worst = 0;
                do {
                    if (++head == tail) {
                        head = 0;
                    }
                    arc = path[head];
                    int cutvalue = arc.cutValue();
                    node = arc.to();
                    if (arc != node.m_back) {
                        cutvalue = 0 - cutvalue;
                    }
                    if (cutvalue >= worst) continue;
                    worst = cutvalue;
                    replace = head;
                } while (head != start);
                if (worst == 0) break;
                HiArc alternative = HiSimplex.alternativeEdge(path[replace], tail, path, replace);
                if (alternative == null) {
                    throw new HiGraphException("Simplex operation not yet optimal but no improvement found");
                }
                HiSimplex.updateSpanningTree(path[replace], alternative);
                path[replace] = alternative;
            }
            if (count == 0) {
                System.out.println("Unable to optimize ranking using " + maxcycles + " simplex improvements on a graph of " + nodes + " nodes");
            }
            for (head = 0; head < tail; ++head) {
                arc = path[head];
                path[head] = null;
            }
        }
        HiSimplex.destroy_span(root);
        path = null;
    }
}

