/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.RelationClass;
import lsedit.SimplexLayout;
import lsedit.SortVector;

class HiRow {
    HiRow() {
    }

    static HiGraph[][] buildBoard(HiGraph node) {
        HiGraph dst;
        int j;
        Vector outArcs;
        HiGraph child;
        HiArc arc;
        int i;
        int[] count = new int[node.m_sink_rank - node.m_rank + 1];
        int[] ranks = new int[node.m_sink_rank - node.m_rank + 1];
        Vector children = node.m_children;
        int size = children.size();
        boolean planar = true;
        for (i = 0; i < size; ++i) {
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            int n = child.m_rank - node.m_rank;
            count[n] = count[n] + 1;
            child.m_position = 0;
        }
        for (i = 0; i < size; ++i) {
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            if (child.m_object == null) continue;
            outArcs = child.m_out;
            j = outArcs.size();
            while (j > 0) {
                arc = (HiArc)outArcs.elementAt(--j);
                dst = arc.to();
                if (dst.m_object == null || dst.m_rank != child.m_rank || (arc = dst.m_parent) == null || arc.from() != node) continue;
                ++dst.m_position;
            }
        }
        i = 0;
        while (i < size) {
            HiArc firstArc;
            HiArc bestArc = firstArc = (HiArc)children.elementAt(i);
            HiGraph best = bestArc.to();
            int at = i;
            for (j = i + 1; j < size; ++j) {
                arc = (HiArc)children.elementAt(j);
                dst = arc.to();
                if (best.m_object != null && (dst.m_object == null || dst.m_rank > best.m_rank || dst.m_rank == best.m_rank && dst.m_position >= best.m_position)) continue;
                bestArc = arc;
                best = dst;
                at = j;
            }
            if (at != i) {
                children.set(at, firstArc);
                children.set(i, bestArc);
            }
            if (best.m_object == null) {
                ++i;
                continue;
            }
            int tail = i;
            while (i <= tail) {
                arc = (HiArc)children.elementAt(i);
                child = arc.to();
                outArcs = child.m_out;
                int arcs = outArcs.size();
                for (j = 0; j < arcs; ++j) {
                    HiGraph other;
                    arc = (HiArc)outArcs.elementAt(j);
                    dst = arc.to();
                    arc = dst.m_parent;
                    if (arc == null || arc.from() != node || dst.m_object == null) continue;
                    for (at = tail + 1; at < size && (other = (bestArc = (HiArc)children.elementAt(at)).to()) != dst; ++at) {
                    }
                    if (at == size) {
                        planar = false;
                        continue;
                    }
                    if (++tail == at) continue;
                    arc = (HiArc)children.elementAt(tail);
                    children.set(at, arc);
                    children.set(tail, bestArc);
                }
                ++i;
            }
        }
        j = 0;
        for (i = 0; i < count.length; ++i) {
            ranks[i] = j++;
            if (count[i] == 0) continue;
        }
        HiGraph[][] board = new HiGraph[j][];
        j = 0;
        for (i = 0; i < count.length; ++i) {
            if (count[i] == 0) continue;
            board[j++] = new HiGraph[count[i]];
            count[i] = 0;
        }
        for (i = 0; i < size; ++i) {
            int position;
            arc = (HiArc)children.elementAt(i);
            child = arc.to();
            int rank = ranks[child.m_rank - node.m_rank];
            child.m_position = position = count[rank];
            board[rank][position] = child;
            int n = rank;
            count[n] = count[n] + 1;
        }
        node.m_rowweight = planar ? 0.0 : 1.0;
        return board;
    }

    static void dumpRow(int number, HiGraph[] row) {
        System.out.print(number + ":");
        for (int j = 0; j < row.length; ++j) {
            System.out.print(row[j].m_position + ":" + row[j] + " ");
        }
        System.out.println("");
    }

    static void dumpBoard(HiGraph[][] board) {
        for (int i = 0; i < board.length; ++i) {
            HiRow.dumpRow(i, board[i]);
        }
    }

    private static void rowWeight(HiGraph higraph) {
        int in_size;
        HiGraph other;
        HiArc arc;
        int out_size;
        int weight = 0;
        Vector arcs = higraph.m_out;
        int i = out_size = arcs.size();
        while (i > 0) {
            arc = (HiArc)arcs.elementAt(--i);
            other = arc.to();
            weight += other.m_position;
        }
        arcs = higraph.m_in;
        i = in_size = arcs.size();
        while (i > 0) {
            arc = (HiArc)arcs.elementAt(--i);
            other = arc.from();
            weight += other.m_position;
        }
        higraph.m_rowweight = (in_size += out_size) == 0 ? -1.0 : (double)(weight += in_size) / (double)in_size;
    }

    private static boolean shake(HiGraph[] row) {
        HiGraph higraph;
        boolean ret = false;
        int i = row.length;
        while (i > 0) {
            higraph = row[--i];
            HiRow.rowWeight(higraph);
        }
        int position = row.length;
        block1: while (true) {
            double max = -2.0;
            i = row.length;
            while (i > 0) {
                higraph = row[--i];
                if (!(max < higraph.m_rowweight)) continue;
                max = higraph.m_rowweight;
            }
            i = 0;
            while (true) {
                if (i >= row.length) continue block1;
                higraph = row[i];
                if (higraph.m_rowweight == max) {
                    if (higraph.m_position != --position) {
                        higraph.m_position = position;
                        ret = true;
                    }
                    higraph.m_rowweight = -3.0;
                    if (position == 0) {
                        return ret;
                    }
                }
                ++i;
            }
            break;
        }
    }

    private static void designated(HiGraph[][] board, RelationClass rc) {
        HiGraph dst;
        int j;
        HiGraph[] row;
        int i;
        for (i = 0; i < board.length; ++i) {
            row = board[i];
            for (j = 0; j < row.length; ++j) {
                dst = row[j];
                dst.m_visited = 0;
            }
        }
        for (i = 0; i < board.length; ++i) {
            row = board[i];
            block3: for (j = 0; j < row.length; ++j) {
                dst = row[j];
                if (dst.m_visited != 0) continue;
                Enumeration en = dst.m_in.elements();
                while (en.hasMoreElements()) {
                    int position;
                    EntityInstance e;
                    EntityInstance e1;
                    HiArc arc = (HiArc)en.nextElement();
                    if (arc.getMinlength() != 0) continue;
                    HiGraph src = arc.from();
                    int rank = src.m_rank;
                    if (rank != dst.m_rank || src == dst || (e1 = src.m_object).getRelationTo(rc, e = dst.m_object) == null || dst.m_position == (position = src.m_position + 1)) continue;
                    for (int j1 = 0; j1 < row.length; ++j1) {
                        HiGraph other = row[j1];
                        if (other.m_position < position) continue;
                        ++other.m_position;
                    }
                    dst.m_position = position;
                    dst.m_visited = 1;
                    j = -1;
                    continue block3;
                }
            }
        }
    }

    private static boolean orderchildren(SimplexLayout options, HiGraph node) throws HiGraphException {
        int i;
        Vector children = node.m_children;
        int size = children.size();
        boolean ret = false;
        node.m_position = 0;
        if (size == 0) {
            return ret;
        }
        for (i = 0; i < size; ++i) {
            HiArc arc = (HiArc)children.elementAt(i);
            HiGraph child = arc.to();
            ret |= HiRow.orderchildren(options, child);
        }
        if (ret) {
            return ret;
        }
        if (node.dontReorder()) {
            return true;
        }
        HiGraph[][] board = HiRow.buildBoard(node);
        int cycles = options.crossing();
        if (node.m_rowweight != 0.0) {
            int to = board.length;
            int direction = 1;
            boolean improved = false;
            i = 0;
            while (true) {
                improved |= HiRow.shake(board[i]);
                if ((cycles -= to) < 0) break;
                if ((i += direction) >= 0 && i < to) continue;
                if (!improved) break;
                improved = false;
                direction = -direction;
                i += 2 * direction;
            }
        }
        RelationClass rc = options.getDesignatedClass();
        if (rc != null) {
            HiRow.designated(board, rc);
        }
        SortVector.byPosition(children);
        return true;
    }

    static void order(SimplexLayout options, HiGraph root) throws HiGraphException {
        HiRow.orderchildren(options, root);
    }
}

