/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraphException;

public class HiGraph {
    int m_width;
    int m_height;
    int m_xGap = -1;
    boolean m_horizontalArray = false;
    boolean m_dontReorder = false;
    boolean m_uniformDepth = false;
    boolean m_uniformWidth = false;
    boolean m_uniqueRank = false;
    Vector m_children = new Vector();
    HiArc m_parent = null;
    Vector m_out = new Vector();
    Vector m_in = new Vector();
    Vector m_self = new Vector();
    Vector m_hidden = null;
    int m_depth = 0;
    HiGraph m_duplicate;
    HiGraph m_sink = null;
    int m_sink_rank;
    int m_visited = 0;
    int m_inputs;
    int m_rank = 0;
    int m_weight;
    HiArc m_back = null;
    Vector m_span = null;
    int m_minbeneath;
    int m_postorder;
    int m_dummy_node = 0;
    static final int edgepointV = 1;
    static final int sinkV = 2;
    int m_position = 0;
    double m_rowweight = 0.0;
    int m_outside = 0;
    int m_x;
    int m_y;
    EntityInstance m_object;
    String m_label;

    public HiGraph(EntityInstance object, String label, int width, int height) {
        this.m_object = object;
        this.m_width = width;
        this.m_height = height;
        this.m_label = label;
    }

    public String toString() {
        return this.m_label;
    }

    public String label() {
        return this.m_label;
    }

    public int dummyNode() {
        return this.m_dummy_node;
    }

    public boolean edgePoint() {
        return this.m_dummy_node == 1;
    }

    public EntityInstance getReferencedObject() {
        return this.m_object;
    }

    public int x() {
        return this.m_x;
    }

    public void x(int value) {
        this.m_x = value;
    }

    public int y() {
        return this.m_y;
    }

    public void y(int value) {
        this.m_y = value;
    }

    public int width() {
        return this.m_width;
    }

    public void width(int width) {
        this.m_width = width;
    }

    public int height() {
        return this.m_height;
    }

    public void height(int value) {
        this.m_height = value;
    }

    public int depth() {
        return this.m_depth;
    }

    public int rank() {
        return this.m_rank;
    }

    public Vector children() {
        return this.m_children;
    }

    public Vector in() {
        return this.m_in;
    }

    public Vector out() {
        return this.m_out;
    }

    public void rank(int value) {
        this.m_rank = value;
    }

    void sinkrank(int value) {
        if (this.m_sink != null) {
            this.m_sink.m_rank = value;
        }
        this.m_sink_rank = value;
    }

    public HiGraph newChild(EntityInstance object, String label, int width, int height) {
        HiArc arc;
        HiGraph child = new HiGraph(object, label, width, height);
        child.m_parent = arc = new HiArc(this, child, true);
        child.m_rank = child.m_depth = this.m_depth + 1;
        this.m_children.addElement(arc);
        return child;
    }

    public HiGraph newChild(int type) {
        String label;
        switch (type) {
            case 1: {
                label = "edgepoint";
                break;
            }
            case 2: {
                label = "sinkpoint";
                break;
            }
            default: {
                label = "";
            }
        }
        HiGraph child = this.newChild(null, label, 0, 0);
        child.m_dummy_node = type;
        return child;
    }

    public HiGraph newChild() {
        HiGraph child = this.newChild(1);
        return child;
    }

    public void xGap(int value) {
        this.m_xGap = value;
    }

    public int xGap() {
        return this.m_xGap;
    }

    public void horizontalArray(boolean value) {
        this.m_horizontalArray = value;
    }

    public boolean horizontalArray() {
        return this.m_horizontalArray;
    }

    public void dontReorder(boolean value) {
        this.m_dontReorder = value;
    }

    public boolean dontReorder() {
        return this.m_dontReorder;
    }

    public void uniqueRank(boolean value) {
        this.m_uniqueRank = value;
    }

    public boolean uniqueRank() {
        return this.m_uniqueRank;
    }

    public void uniformDepth(boolean value) {
        this.m_uniformDepth = value;
    }

    public boolean uniformWidth() {
        return this.m_uniformWidth;
    }

    public void uniformWidth(boolean value) {
        this.m_uniformWidth = value;
    }

    public boolean uniformDepth() {
        return this.m_uniformDepth;
    }

    public HiArc newInputArc(HiGraph from) {
        HiArc arc = new HiArc(from, this);
        if (from == this) {
            this.m_self.addElement(arc);
        } else {
            from.m_out.addElement(arc);
            this.m_in.addElement(arc);
        }
        return arc;
    }

    void newInputArc(HiArc arc) {
        this.m_in.addElement(arc);
    }

    void newOutputArc(HiArc arc) {
        arc.from(this);
        this.m_out.addElement(arc);
    }

    public HiArc newOutputArc(HiGraph to) {
        return to.newInputArc(this);
    }

    static void removeArc(Vector arcs, HiArc arc) throws HiGraphException {
        if (arcs == null || arc == null || !arcs.removeElement(arc)) {
            String s = "Can't remove " + arc;
            if (arcs == null) {
                s = s + " from null vector";
            }
            if (arc != null) {
                for (int i = 0; i < 2; ++i) {
                    HiGraph node;
                    HiGraph hiGraph = node = i == 0 ? arc.from() : arc.to();
                    if (arcs == node.m_children) {
                        s = s + " from " + node + ".m_children";
                    }
                    if (arcs == node.m_in) {
                        s = s + " from " + node + ".m_in";
                    }
                    if (arcs == node.m_out) {
                        s = s + " from " + node + ".m_out";
                    }
                    if (arcs == node.m_self) {
                        s = s + " from " + node + ".m_self";
                    }
                    if (arcs != node.m_span) continue;
                    s = s + " from " + node + ".m_span";
                }
            }
            throw new HiGraphException(s);
        }
    }

    public HiArc locateInputArc(HiGraph from, boolean chain) {
        Vector v = from == this ? this.m_self : this.m_in;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph previous = arc.from();
            if (previous == from) {
                return arc;
            }
            if (!chain || previous.m_dummy_node == 0 || previous.locateInputArc(from, chain) == null) continue;
            return arc;
        }
        return null;
    }

    private void dispose_internal() throws HiGraphException {
        HiGraph other;
        HiArc arc;
        Enumeration e = this.m_in.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            other = arc.from();
            if (other == this || arc.to() != this) {
                throw new HiGraphException(this + " has an illegal input arc " + arc);
            }
            HiGraph.removeArc(other.m_out, arc);
        }
        e = this.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            other = arc.to();
            if (arc.from() != this || other == this) {
                throw new HiGraphException(this + " has an illegal output arc " + arc);
            }
            HiGraph.removeArc(other.m_in, arc);
        }
        this.m_in.removeAllElements();
        this.m_out.removeAllElements();
        this.m_self.removeAllElements();
        e = this.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            other = arc.to();
            other.dispose_internal();
        }
        this.m_children.removeAllElements();
        if (this.m_hidden != null) {
            this.m_hidden.removeAllElements();
            this.m_hidden = null;
        }
        this.m_in = null;
        this.m_out = null;
        this.m_self = null;
        this.m_parent = null;
        this.m_children = null;
    }

    public void dispose() throws HiGraphException {
        if (this.m_parent != null) {
            HiGraph parent = this.m_parent.from();
            if (!parent.m_children.removeElement(this.m_parent) && !parent.m_hidden.removeElement(this.m_parent)) {
                throw new HiGraphException("Can't disconnect " + this + " from " + parent);
            }
        }
        this.dispose_internal();
    }

    void removeDummy() throws HiGraphException {
        int size = this.m_children.size();
        int i = 0;
        while (i < size) {
            HiArc arc = (HiArc)this.m_children.elementAt(i);
            HiGraph child = arc.to();
            if (child.m_dummy_node == 1) {
                HiArc arc1 = (HiArc)child.m_in.elementAt(0);
                HiGraph from = arc1.from();
                HiArc arc2 = (HiArc)child.m_out.elementAt(0);
                arc2.from(from);
                from.m_out.removeElement(arc1);
                from.m_out.addElement(arc2);
                this.m_children.removeElementAt(i);
                --size;
                continue;
            }
            child.removeDummy();
            ++i;
        }
    }

    void orderByRank() {
        int children = this.m_children.size();
        for (int i = 0; i < children; ++i) {
            HiArc arc2;
            HiArc arc1 = (HiArc)this.m_children.elementAt(i);
            HiGraph child1 = arc1.to();
            int best = i;
            for (int j = i + 1; j < children; ++j) {
                arc2 = (HiArc)this.m_children.elementAt(j);
                HiGraph child2 = arc2.to();
                if (child2.m_rank >= child1.m_rank) continue;
                best = j;
                child1 = child2;
            }
            if (best == i) continue;
            arc1 = (HiArc)this.m_children.elementAt(i);
            arc2 = (HiArc)this.m_children.elementAt(best);
            this.m_children.setElementAt(arc1, best);
            this.m_children.setElementAt(arc2, i);
        }
    }

    public void describe() {
        HiArc arc;
        System.out.println("\nDescription of " + this.label());
        System.out.println("Depth=" + this.m_depth + " rank=" + this.m_rank + "-" + this.m_sink_rank + " position=" + this.m_position);
        System.out.println("x=" + this.m_x + " y=" + this.m_y + " width=" + this.m_width + " height=" + this.m_height);
        System.out.println(" Weight=" + this.m_weight + " outside=" + this.m_outside + " type=" + this.m_dummy_node);
        if (this.m_parent != null) {
            System.out.println("   Parent: " + this.m_parent);
        }
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            System.out.println("    Child: " + arc);
        }
        if (this.m_hidden != null) {
            e = this.m_hidden.elements();
            while (e.hasMoreElements()) {
                arc = (HiArc)e.nextElement();
                System.out.println("   Hidden: " + arc);
            }
        }
        e = this.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            System.out.println("   Arc to: " + arc);
        }
        e = this.m_in.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            System.out.println(" Arc from: " + arc);
        }
        e = this.m_self.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            System.out.println(" Self arc: " + arc);
        }
    }

    public void dump() {
        HiArc arc;
        String out = "";
        for (int indent = this.m_rank; indent > 0; --indent) {
            out = out + " ";
        }
        out = out + this.label() + "[rank=" + this.m_rank;
        if (this.m_rank != this.m_sink_rank) {
            out = out + "-" + this.m_sink_rank;
        }
        out = out + "/" + this.m_position + "/" + this.m_rank + "{" + this.m_x + "," + this.m_y + ":" + this.m_width + "," + this.m_height + "}]";
        if (this.m_back != null) {
            out = out + " back=" + this.m_back;
        }
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            if ((out = out + " " + arc).length() <= 70) continue;
            System.out.println(out);
            out = " ";
        }
        out = out + " | ";
        e = this.m_out.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            out = out + " " + arc;
        }
        out = out + " | ";
        e = this.m_in.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            out = out + " " + arc;
        }
        if (this.m_self.size() != 0) {
            out = out + " | ";
            e = this.m_self.elements();
            while (e.hasMoreElements()) {
                arc = (HiArc)e.nextElement();
                out = out + " " + arc;
            }
        }
        System.out.println(out);
        e = this.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            child.dump();
        }
    }

    private void duplicateNodes() {
        this.m_duplicate = new HiGraph(this.m_object, this.m_label, this.m_width, this.m_height);
        this.m_duplicate.m_depth = this.m_depth;
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            child.duplicateNodes();
        }
    }

    private void duplicateEdges() {
        HiArc arc;
        HiGraph to;
        HiGraph other;
        HiArc edge;
        HiGraph from = this.m_duplicate;
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            edge = (HiArc)e.nextElement();
            other = edge.to();
            to = other.m_duplicate;
            arc = new HiArc(from, to, true);
            from.m_children.addElement(arc);
            to.m_parent = arc;
            other.duplicateEdges();
        }
        e = this.m_out.elements();
        while (e.hasMoreElements()) {
            edge = (HiArc)e.nextElement();
            other = edge.to();
            to = other.m_duplicate;
            arc = new HiArc(from, to);
            from.m_out.addElement(arc);
            to.m_in.addElement(arc);
        }
        e = this.m_self.elements();
        while (e.hasMoreElements()) {
            edge = (HiArc)e.nextElement();
            arc = new HiArc(from, from);
            from.m_self.addElement(arc);
        }
    }

    private void clearReferences() {
        this.m_duplicate = null;
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            child.clearReferences();
        }
    }

    HiGraph duplicate() {
        this.duplicateNodes();
        this.duplicateEdges();
        HiGraph ret = this.m_duplicate;
        this.clearReferences();
        return ret;
    }

    void shift(int xdelta, int ydelta) {
        this.m_x += xdelta;
        this.m_y += ydelta;
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            child.shift(xdelta, ydelta);
        }
    }
}

