/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;

class HiChildren {
    static final boolean debug = false;

    HiChildren() {
    }

    private static void addDummyNodes(HiGraph node) throws HiGraphException {
        HiArc arc;
        node.m_visited = 0;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            HiChildren.addDummyNodes(child);
        }
        HiGraph parent = node.m_parent == null ? null : node.m_parent.from();
        int nodes = node.m_out.size();
        for (int i = 0; i < nodes; ++i) {
            int slack;
            arc = (HiArc)node.m_out.elementAt(i);
            HiGraph to = arc.to();
            if (to.m_parent == null || to.m_parent.from() != parent || (slack = to.m_rank - node.m_rank - 1) <= 0) continue;
            int minslack = node.m_sink_rank - node.m_rank;
            if (slack < minslack - 1 || arc.onSide()) {
                minslack = 0;
            }
            boolean reversed = arc.reversed();
            HiGraph dummy = null;
            while (slack > minslack) {
                dummy = parent.newChild();
                dummy.m_rank = node.m_rank + slack;
                dummy.sinkrank(dummy.m_rank);
                dummy.newOutputArc(arc);
                arc = new HiArc(node, dummy);
                arc.reverse(reversed);
                dummy.newInputArc(arc);
                --slack;
            }
            node.m_out.setElementAt(arc, i);
        }
    }

    private static void postorderlevel(HiGraph node) {
        int min = node.m_minbeneath;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            int beneath = child.m_postorder - child.m_minbeneath;
            child.m_minbeneath = min;
            child.m_postorder = min + beneath;
            min += beneath + 1;
        }
    }

    private static int postorder(HiGraph node, int min) {
        int max = min;
        node.m_minbeneath = min;
        Enumeration e = node.m_children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            max = HiChildren.postorder(child, max);
        }
        node.m_postorder = max;
        return max + 1;
    }

    private static void fillMatrix(HiGraph[] queue, int[][][] matrices) {
        for (int i = queue.length - 1; i >= 0; --i) {
            HiGraph node1 = queue[i];
            Enumeration e = node1.m_in.elements();
            block1: while (e.hasMoreElements()) {
                node1 = queue[i];
                HiArc arc = (HiArc)e.nextElement();
                HiGraph node2 = arc.from();
                while (true) {
                    int depth;
                    if ((depth = node1.m_depth) == node2.m_depth) {
                        int id1 = node1.m_position;
                        int id2 = node2.m_position;
                        if (id1 == id2) continue block1;
                        int[][] matrix = matrices[depth];
                        if (id2 < id1) {
                            int[] nArray = matrix[id1];
                            int n = id2;
                            nArray[n] = nArray[n] + 1;
                        } else {
                            int[] nArray = matrix[id2];
                            int n = id1;
                            nArray[n] = nArray[n] + 1;
                        }
                        node1 = node1.m_parent.from();
                        node2 = node2.m_parent.from();
                        continue;
                    }
                    if (node2.m_depth > depth) {
                        node2 = node2.m_parent.from();
                        continue;
                    }
                    node1 = node1.m_parent.from();
                }
            }
        }
    }

    private static void dumpMatrix(HiGraph[] queue, int[][][] matrices) {
        System.out.println("\nAdjacency matrix\n");
        for (int i = 0; i < matrices.length; ++i) {
            System.out.println("At depth " + i);
            int[][] matrix = matrices[i];
            for (int j = 0; j < matrix.length; ++j) {
                int[] row = matrix[j];
                for (int k = 0; k < row.length; ++k) {
                    System.out.print("\t" + row[k]);
                }
                System.out.print("\n");
            }
        }
    }

    private static int[][][] buildMatrices(HiGraph[] queue) {
        int j;
        int[][] matrix;
        int width;
        int i;
        int nodes = queue.length;
        int last = nodes - 1;
        HiGraph node = queue[last];
        int[][][] matrices = new int[node.m_depth + 1][][];
        int start = 0;
        node = queue[0];
        int last_depth = node.m_depth;
        for (i = 1; i < nodes; ++i) {
            node = queue[i];
            if (node.m_depth == last_depth) continue;
            width = i - start;
            matrix = new int[width][];
            matrices[last_depth] = matrix;
            for (j = 0; j < width; ++j) {
                matrix[j] = new int[j + 1];
            }
            start = i;
            last_depth = node.m_depth;
        }
        width = i - start;
        matrix = new int[width][];
        matrices[last_depth] = matrix;
        for (j = 0; j < width; ++j) {
            matrix[j] = new int[j + 1];
        }
        return matrices;
    }

    private static void computeOutside(HiGraph[] queue, int head, int[][][] matrices) {
        int end_level;
        HiGraph node1;
        HiGraph node = queue[head];
        Vector children = node.m_children;
        if (children.size() == 0) {
            return;
        }
        node = queue[head];
        int depth = node.m_depth;
        int lth = queue.length;
        for (int start_level = head + 1; start_level < lth; ++start_level) {
            node1 = queue[start_level];
            if (node1.m_depth == depth) continue;
            depth = node1.m_depth;
            break;
        }
        for (end_level = start_level; end_level < lth; ++end_level) {
            node1 = queue[end_level];
            if (node1.m_depth != depth) break;
        }
        int[][] matrix = matrices[depth];
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            HiArc arc = (HiArc)e.nextElement();
            HiGraph child = arc.to();
            int position = child.m_position;
            int outside = 0;
            for (int i = start_level; i < end_level; ++i) {
                HiGraph child1 = queue[i];
                HiGraph parent1 = child1.m_parent.from();
                if (parent1 == node) continue;
                int position1 = child1.m_position;
                int edges = position1 > position ? matrix[position1][position] : matrix[position][position1];
                if (parent1.m_postorder > node.m_postorder) {
                    outside += edges;
                    continue;
                }
                outside -= edges;
            }
            child.m_outside = outside;
        }
    }

    private static boolean reorder(HiGraph node, int[][][] matrices, int outside_bias) {
        int j;
        int val;
        int[] row;
        int position1;
        HiGraph child1;
        HiArc arc1;
        int i;
        Vector children = node.m_children;
        int size = children.size();
        boolean ret = false;
        for (i = 0; i < size; ++i) {
            arc1 = (HiArc)children.elementAt(i);
            child1 = arc1.to();
            if (child1.m_children.size() == 0) continue;
            ret = true;
            break;
        }
        if (!ret) {
            return ret;
        }
        ret = false;
        if (node.dontReorder()) {
            return ret;
        }
        int[][] matrix = matrices[node.m_depth + 1];
        for (i = 0; i < size; ++i) {
            arc1 = (HiArc)children.elementAt(i);
            child1 = arc1.to();
            position1 = child1.m_position;
            row = matrix[position1];
            val = child1.m_outside * outside_bias;
            for (j = 0; j < position1; ++j) {
                val += row[j];
            }
            row[position1] = val;
        }
        for (i = 0; i < size; ++i) {
            int position2;
            HiGraph child2;
            HiArc arc2;
            arc1 = (HiArc)children.elementAt(i);
            child1 = arc1.to();
            position1 = child1.m_position;
            int best = i;
            int min1 = matrix[position1][position1];
            for (j = i + 1; j < size; ++j) {
                arc2 = (HiArc)children.elementAt(j);
                child2 = arc2.to();
                position2 = child2.m_position;
                int min2 = matrix[position2][position2];
                if (min2 >= min1) continue;
                best = j;
                min1 = min2;
            }
            arc2 = (HiArc)children.elementAt(best);
            child2 = arc2.to();
            if (best != i) {
                children.setElementAt(arc2, i);
                children.setElementAt(arc1, best);
                ret = true;
            }
            position1 = child2.m_position;
            for (j = i + 1; j < size; ++j) {
                arc2 = (HiArc)children.elementAt(j);
                child2 = arc1.to();
                position2 = child2.m_position;
                row = matrix[position2];
                val = position1 < position2 ? row[position1] : matrix[position1][position2];
                int n = position2;
                row[n] = row[n] - (val << 1);
            }
        }
        return ret;
    }

    static void order(HiGraph root, int outside_bias) throws HiGraphException {
        HiGraph node;
        int head;
        HiChildren.addDummyNodes(root);
        int nodes = HiChildren.postorder(root, 1) - 1;
        HiGraph[] queue = new HiGraph[nodes];
        int tail = 0;
        queue[tail] = root;
        int position = 0;
        int last_depth = root.m_depth;
        root.m_position = 0;
        ++tail;
        for (head = 0; head < tail; ++head) {
            node = queue[head];
            if (node.m_depth != last_depth) {
                last_depth = node.m_depth;
                position = 0;
            }
            node.m_position = position++;
            Vector children = node.m_children;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                HiArc arc = (HiArc)children.elementAt(i);
                queue[tail++] = arc.to();
            }
        }
        int[][][] matrices = HiChildren.buildMatrices(queue);
        HiChildren.fillMatrix(queue, matrices);
        for (head = 0; head < tail; ++head) {
            HiChildren.computeOutside(queue, head, matrices);
            node = queue[head];
            if (!HiChildren.reorder(node, matrices, outside_bias)) continue;
            HiChildren.postorderlevel(node);
        }
    }
}

